/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import java.lang.reflect.Constructor;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExceptionConverter {
    public static FileSystemException generate(DavException cause) throws FileSystemException {
        String msg = cause.getMessage();
        if (cause.hasErrorCondition()) {
            try {
                Element error = cause.toXml(DomUtil.createDocument());
                if (DomUtil.matches((Node)error, (String)"error", (Namespace)DavConstants.NAMESPACE) && DomUtil.hasChildElement((Node)error, (String)"exception", null)) {
                    Element exc = DomUtil.getChildElement((Node)error, (String)"exception", null);
                    if (DomUtil.hasChildElement((Node)exc, (String)"message", null)) {
                        msg = DomUtil.getChildText((Element)exc, (String)"message", null);
                    }
                    if (DomUtil.hasChildElement((Node)exc, (String)"class", null)) {
                        Class<?> cl = Class.forName(DomUtil.getChildText((Element)exc, (String)"class", null));
                        Constructor<?> excConstr = cl.getConstructor(String.class);
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof FileSystemException) {
                            return (FileSystemException)o;
                        }
                        if (o instanceof Exception) {
                            return new FileSystemException(msg, (Throwable)((Exception)o));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        return new FileSystemException(msg);
    }

    private ExceptionConverter() {
    }
}

