/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.cxf.microprofile.client.cdi.RestClientBean;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

public class RestClientExtension
implements Extension {
    private Set<Class<?>> restClientClasses = new LinkedHashSet();
    private Set<Throwable> errors = new LinkedHashSet<Throwable>();

    public void findClients(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> pat) {
        Class restClient = pat.getAnnotatedType().getJavaClass();
        if (restClient.isInterface()) {
            this.restClientClasses.add(restClient);
            pat.veto();
        } else {
            this.errors.add(new IllegalArgumentException("The class " + restClient + " is not an interface"));
        }
    }

    public void registerClientBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.restClientClasses.stream().map(c -> new RestClientBean((Class<?>)c, beanManager)).forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
    }

    public void registerErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.errors.forEach(arg_0 -> ((AfterDeploymentValidation)afterDeploymentValidation).addDeploymentProblem(arg_0));
    }
}

