/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.xml.Parser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseConfigParser<T>
implements Parser<T> {
    private final Class<T> typeParameterClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private final Map<URI, URL> namespaces;

    public BaseConfigParser(Map<URI, URL> namespaces) {
        this.namespaces = Collections.unmodifiableMap(new LinkedHashMap<URI, URL>(namespaces));
        this.namespaces.keySet().forEach(Objects::requireNonNull);
        this.namespaces.values().forEach(Objects::requireNonNull);
    }

    @Override
    public Map<URI, Supplier<Source>> getSchema() {
        return this.namespaces.entrySet().stream().collect(BaseConfigParser.toLinkedHashMap(Map.Entry::getKey, e -> () -> {
            try {
                return new StreamSource(((URL)e.getValue()).openStream());
            }
            catch (IOException ex) {
                throw new XmlConfigurationException(ex);
            }
        }));
    }

    private T validateConfig(Object config) {
        try {
            return this.typeParameterClass.cast(Objects.requireNonNull(config, "Configuration must not be null."));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid configuration parameter passed.", e);
        }
    }

    @Override
    public final Element unparse(Document document, T config) {
        return this.safeUnparse(document, this.validateConfig(config));
    }

    protected abstract Element safeUnparse(Document var1, T var2);

    protected static <T, K, V> Collector<T, ?, LinkedHashMap<K, V>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }
}

