/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngineFactory;
import org.apache.cxf.transport.http.netty.server.ServerEngine;

public class NettyHttpDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpDestination.class);
    protected NettyHttpServerEngine engine;
    protected NettyHttpServerEngineFactory serverEngineFactory;
    protected ServletContext servletContext;
    protected ClassLoader loader;
    protected URL nurl;
    private boolean configFinalized;

    public NettyHttpDestination(Bus b, DestinationRegistry registry, EndpointInfo ei, NettyHttpServerEngineFactory serverEngineFactory) throws IOException {
        super(b, registry, ei, NettyHttpDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
        this.serverEngineFactory = serverEngineFactory;
        this.nurl = new URL(this.getAddress(this.endpointInfo));
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void retrieveEngine() throws IOException {
        this.engine = this.serverEngineFactory.retrieveNettyHttpServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createNettyHttpServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    private String getAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("netty://")) {
            address = address.substring(8);
        }
        return address;
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.getAddress(this.endpointInfo)).getPath();
    }

    protected void activate() {
        URL url;
        super.activate();
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        try {
            url = new URL(this.getAddress(this.endpointInfo));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addServant(url, new NettyHttpHandler(this, this.contextMatchOnExact()));
    }

    protected void deactivate() {
        super.deactivate();
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (context == null) {
            context = this.servletContext;
        }
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.flushBuffer();
            return;
        }
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.invoke(null, context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    protected void invokeComplete(ServletContext context, HttpServletRequest req, HttpServletResponse resp, Message m) throws IOException {
        resp.flushBuffer();
        super.invokeComplete(context, req, resp, m);
    }

    public ServerEngine getEngine() {
        return this.engine;
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        return (Message)req.getAttribute("cxf.continuation.message");
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

