/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.collections;

import io.netty.util.collection.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.persistence.Persister;

public class JournalHashMapProvider<K, V, C> {
    final Journal journal;
    final Persister<JournalHashMap.MapRecord<K, V>> persister;
    final LongObjectHashMap<JournalHashMap<K, V, C>> journalMaps = new LongObjectHashMap();
    final LongSupplier idSupplier;
    final byte recordType;
    final IOCriticalErrorListener ioExceptionListener;
    final Supplier<IOCompletion> ioCompletionSupplier;
    final LongFunction<C> contextProvider;

    public JournalHashMapProvider(LongSupplier idSupplier, Journal journal, AbstractHashMapPersister<K, V> persister, byte recordType, Supplier<IOCompletion> ioCompletionSupplier, LongFunction<C> contextProvider, IOCriticalErrorListener ioExceptionListener) {
        this.idSupplier = idSupplier;
        this.persister = persister;
        this.journal = journal;
        this.recordType = recordType;
        this.ioExceptionListener = ioExceptionListener;
        this.contextProvider = contextProvider;
        this.ioCompletionSupplier = ioCompletionSupplier;
    }

    public List<JournalHashMap<K, V, C>> getMaps() {
        ArrayList<JournalHashMap<K, V, C>> maps = new ArrayList<JournalHashMap<K, V, C>>();
        this.journalMaps.values().forEach(maps::add);
        return maps;
    }

    public void clear() {
        this.journalMaps.clear();
    }

    public void reload(RecordInfo recordInfo) {
        JournalHashMap.MapRecord mapRecord = (JournalHashMap.MapRecord)this.persister.decode(recordInfo.wrapData(), null, null);
        this.getMap(mapRecord.collectionID, null).reload(mapRecord);
    }

    public Iterator<JournalHashMap<K, V, C>> iterMaps() {
        return this.journalMaps.values().iterator();
    }

    public synchronized JournalHashMap<K, V, C> getMap(long collectionID, C context) {
        JournalHashMap<K, V, C> journalHashMap = (JournalHashMap<K, V, C>)this.journalMaps.get(collectionID);
        if (journalHashMap == null) {
            journalHashMap = new JournalHashMap<K, V, C>(collectionID, this.journal, this.idSupplier, this.persister, this.recordType, this.ioCompletionSupplier, this.contextProvider, this.ioExceptionListener).setContext(context);
            this.journalMaps.put(collectionID, journalHashMap);
        }
        return journalHashMap;
    }

    public JournalHashMap<K, V, C> getMap(long collectionID) {
        return this.getMap(collectionID, null);
    }
}

