/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Random;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;
import org.apache.wss4j.common.cache.EHCacheReplayCache;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.apache.wss4j.common.util.Loader;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHCacheTokenReplayCache
implements TokenReplayCache<String> {
    public static final String CACHE_KEY = "cxf.samlp.replay.cache";
    private static final Logger LOG = LoggerFactory.getLogger(EHCacheReplayCache.class);
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-ehcache.xml";
    private final Cache<String, EHCacheValue> cache;
    private final CacheManager cacheManager;

    public EHCacheTokenReplayCache() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(DEFAULT_CONFIG_URL, null);
    }

    public EHCacheTokenReplayCache(Bus bus) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public EHCacheTokenReplayCache(String configFile) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this(configFile, null);
    }

    public EHCacheTokenReplayCache(String configFile, Bus bus) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, EHCacheTokenReplayCache.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XmlConfiguration xmlConfig = new XmlConfiguration(this.getConfigFileURL(configFileURL));
        CacheConfigurationBuilder configurationBuilder = xmlConfig.newCacheConfigurationBuilderFromTemplate(CACHE_KEY, String.class, EHCacheValue.class);
        String diskKey = "cxf.samlp.replay.cache-" + Math.abs(new Random().nextInt());
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(CACHE_KEY, (Builder)configurationBuilder).with(CacheManagerBuilder.persistence((File)new File(System.getProperty("java.io.tmpdir"), diskKey))).build();
        this.cacheManager.init();
        this.cache = this.cacheManager.getCache(CACHE_KEY, String.class, EHCacheValue.class);
    }

    private URL getConfigFileURL(URL suppliedConfigFileURL) {
        if (suppliedConfigFileURL == null) {
            try {
                URL configFileURL = Loader.getResource((String)DEFAULT_CONFIG_URL);
                if (configFileURL == null) {
                    configFileURL = new URL(DEFAULT_CONFIG_URL);
                }
                return configFileURL;
            }
            catch (IOException e) {
                LOG.debug(e.getMessage());
            }
        }
        return suppliedConfigFileURL;
    }

    @Override
    public void putId(String identifier) {
        this.putId(identifier, (Instant)null);
    }

    @Override
    public void putId(String identifier, Instant expiry) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        this.cache.put((Object)identifier, (Object)new EHCacheValue(identifier, expiry));
    }

    @Override
    public boolean contains(String identifier) {
        if (this.cache == null) {
            return false;
        }
        EHCacheValue element = (EHCacheValue)this.cache.get((Object)identifier);
        return element != null;
    }

    @Override
    public synchronized void close() {
        if (this.cacheManager.getStatus() == Status.AVAILABLE) {
            this.cacheManager.removeCache(CACHE_KEY);
            this.cacheManager.close();
        }
    }
}

