/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;

public class PagedMessageImpl
implements PagedMessage {
    private byte[] largeMessageLazyData;
    private Message message;
    private long[] queueIDs;
    private long transactionID = 0L;
    private final int storedSize;
    private final StorageManager storageManager;
    private long pageNumber;
    private int messageNumber;

    public PagedMessageImpl(Message message, long[] queueIDs, long transactionID) {
        this(message, queueIDs);
        this.transactionID = transactionID;
    }

    public PagedMessageImpl(Message message, long[] queueIDs) {
        this.storageManager = null;
        this.queueIDs = queueIDs;
        this.message = message;
        this.message.setPaged();
        this.storedSize = 0;
        this.checkLargeMessage();
    }

    public PagedMessageImpl(int storedSize, StorageManager storageManager) {
        this.storageManager = storageManager;
        this.storedSize = storedSize;
    }

    @Override
    public long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public PagedMessageImpl setPageNumber(long pageNr) {
        this.pageNumber = pageNr;
        return this;
    }

    @Override
    public int getMessageNumber() {
        return this.messageNumber;
    }

    @Override
    public PagedMessageImpl setMessageNumber(int messageNr) {
        this.messageNumber = messageNr;
        return this;
    }

    @Override
    public int getStoredSize() {
        if (this.storedSize <= 0) {
            return this.getEncodeSize();
        }
        return this.storedSize;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public PagePosition newPositionObject() {
        return new PagePositionImpl(this.pageNumber, this.messageNumber);
    }

    @Override
    public void initMessage(StorageManager storage) {
        Message message;
        if (this.largeMessageLazyData != null) {
            LargeServerMessage lgMessage = storage.createCoreLargeMessage();
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])this.largeMessageLazyData);
            lgMessage = LargeMessagePersister.getInstance().decode(buffer, lgMessage, null);
            if (lgMessage.toMessage() instanceof LargeServerMessage) {
                ((LargeServerMessage)lgMessage.toMessage()).setStorageManager(storage);
            }
            lgMessage.toMessage().usageUp();
            lgMessage.setPaged();
            this.message = lgMessage.toMessage();
            this.message.setPaged();
            this.largeMessageLazyData = null;
            this.checkLargeMessage();
        } else if (this.message != null && (message = this.message) instanceof LargeServerMessage) {
            LargeServerMessage largeServerMessage = (LargeServerMessage)message;
            largeServerMessage.setStorageManager(this.storageManager);
        }
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public long[] getQueueIDs() {
        return this.queueIDs;
    }

    public static boolean isLargeMessage(ActiveMQBuffer buffer) {
        return LargeMessageType.isLargeMessage(buffer.getByte(buffer.readerIndex() + 8));
    }

    public void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        boolean isCoreLargeMessage = LargeMessageType.isCoreLargeMessageType(buffer.readByte());
        if (isCoreLargeMessage) {
            int largeMessageHeaderSize = buffer.readInt();
            if (this.storageManager == null) {
                this.largeMessageLazyData = new byte[largeMessageHeaderSize];
                buffer.readBytes(this.largeMessageLazyData);
            } else {
                this.message = this.storageManager.createCoreLargeMessage().toMessage();
                this.message.setPaged();
                LargeMessagePersister.getInstance().decode(buffer, (LargeServerMessage)this.message, null);
                ((LargeServerMessage)this.message).setStorageManager(this.storageManager);
                ((LargeServerMessage)this.message).toMessage().usageUp();
            }
        } else {
            this.message = MessagePersister.getInstance().decode(buffer, null, null, this.storageManager);
            if (this.message.isLargeMessage()) {
                this.message.usageUp();
            }
        }
        this.checkLargeMessage();
        int queueIDsSize = buffer.readInt();
        this.queueIDs = new long[queueIDsSize];
        for (int i = 0; i < queueIDsSize; ++i) {
            this.queueIDs[i] = buffer.readLong();
        }
    }

    private void checkLargeMessage() {
        if (this.message != null && this.message.isLargeMessage()) {
            ((RefCountMessage)this.message).disableErrorCheck();
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        byte largeMessageType = LargeMessageType.valueOf(this.message);
        buffer.writeByte(largeMessageType);
        if (LargeMessageType.isCoreLargeMessageType(largeMessageType)) {
            buffer.writeInt(LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)this.message));
            LargeMessagePersister.getInstance().encode(buffer, (LargeServerMessage)this.message);
        } else {
            this.message.getPersister().encode(buffer, (Object)this.message);
        }
        buffer.writeInt(this.queueIDs.length);
        for (long queueID : this.queueIDs) {
            buffer.writeLong(queueID);
        }
    }

    public int getEncodeSize() {
        if (LargeMessageType.isCoreLargeMessage(this.message)) {
            return 13 + LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)this.message) + 4 + this.queueIDs.length * 8;
        }
        return 9 + this.message.getPersister().getEncodeSize((Object)this.message) + 4 + this.queueIDs.length * 8;
    }

    public String toString() {
        return "PagedMessageImpl [queueIDs=" + Arrays.toString(this.queueIDs) + ", transactionID=" + this.transactionID + ", page=" + this.pageNumber + ", message=" + String.valueOf(this.message) + "]";
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.message.getPersistentSize();
    }

    private static final class LargeMessageType {
        private static final byte NONE = 0;
        private static final byte CORE = 1;
        private static final byte OLD_CORE = -1;
        private static final byte NOT_CORE = 2;

        private LargeMessageType() {
        }

        public static boolean isLargeMessage(byte encodedValue) {
            return switch (encodedValue) {
                case 0 -> false;
                case -1, 1, 2 -> true;
                default -> throw new IllegalStateException("This largeMessageType isn't supported: " + encodedValue);
            };
        }

        public static boolean isCoreLargeMessage(Message message) {
            return message.isLargeMessage() && message instanceof ICoreMessage;
        }

        public static boolean isCoreLargeMessageType(byte encodedValue) {
            return encodedValue == 1 || encodedValue == -1;
        }

        public static byte valueOf(Message message) {
            if (!message.isLargeMessage()) {
                return 0;
            }
            if (message instanceof ICoreMessage) {
                return 1;
            }
            return 2;
        }
    }
}

