/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.HttpUrlUtil;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;

public class JettyHTTPHandler
extends HttpServlet {
    private static final String METHOD_TRACE = "TRACE";
    protected JettyHTTPDestination jettyHTTPDestination;
    protected ServletContext servletContext;
    private String urlName;
    private boolean contextMatchExact;
    private Bus bus;

    public JettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        this.contextMatchExact = cmExact;
        this.jettyHTTPDestination = jhd;
    }

    public JettyHTTPHandler(Bus bus) {
        this.bus = bus;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
        if (this.jettyHTTPDestination != null) {
            this.jettyHTTPDestination.setServletContext(sc);
        }
    }

    public void setName(String name) {
        this.urlName = name;
    }

    public String getName() {
        return this.urlName;
    }

    public ServletContextHandler createContextHandler() {
        return new ServletContextHandler();
    }

    public Bus getBus() {
        return this.jettyHTTPDestination != null ? this.jettyHTTPDestination.getBus() : this.bus;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String target = ServletContextRequest.getServletContextRequest((ServletRequest)request).getDecodedPathInContext();
        if (request.getMethod().equals(METHOD_TRACE)) {
            response.setStatus(405);
        } else if (this.contextMatchExact) {
            if (target.equals(this.urlName)) {
                this.jettyHTTPDestination.doService(this.servletContext, request, response);
            }
        } else if (target.equals(this.urlName) || HttpUrlUtil.checkContextPath((String)this.urlName, (String)target)) {
            this.jettyHTTPDestination.doService(this.servletContext, request, response);
        }
    }
}

