/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.utils.JsonLoader;

public class Role
implements Serializable {
    public static final String SEND_PERMISSION = "send";
    public static final String CONSUME_PERMISSION = "consume";
    public static final String CREATE_DURABLE_QUEUE_PERMISSION = "createDurableQueue";
    public static final String DELETE_DURABLE_QUEUE_PERMISSION = "deleteDurableQueue";
    public static final String CREATE_NONDURABLE_QUEUE_PERMISSION = "createNonDurableQueue";
    public static final String DELETE_NONDURABLE_QUEUE_PERMISSION = "deleteNonDurableQueue";
    public static final String MANAGE_PERMISSION = "manage";
    public static final String BROWSE_PERMISSION = "browse";
    public static final String CREATE_ADDRESS_PERMISSION = "createAddress";
    public static final String DELETE_ADDRESS_PERMISSION = "deleteAddress";
    public static final String VIEW_PERMISSION = "view";
    public static final String EDIT_PERMISSION = "edit";
    private static final long serialVersionUID = 3560097227776448872L;
    protected String name;
    protected boolean send;
    protected boolean consume;
    protected boolean createAddress;
    protected boolean deleteAddress;
    protected boolean createDurableQueue;
    protected boolean deleteDurableQueue;
    protected boolean createNonDurableQueue;
    protected boolean deleteNonDurableQueue;
    protected boolean manage;
    protected boolean browse;
    protected boolean view;
    protected boolean edit;

    public JsonObject toJson() {
        return JsonLoader.createObjectBuilder().add("name", this.name).add(SEND_PERMISSION, this.send).add(CONSUME_PERMISSION, this.consume).add(CREATE_DURABLE_QUEUE_PERMISSION, this.createDurableQueue).add(DELETE_DURABLE_QUEUE_PERMISSION, this.deleteDurableQueue).add(CREATE_NONDURABLE_QUEUE_PERMISSION, this.createNonDurableQueue).add(DELETE_NONDURABLE_QUEUE_PERMISSION, this.deleteNonDurableQueue).add(MANAGE_PERMISSION, this.manage).add(BROWSE_PERMISSION, this.browse).add(CREATE_ADDRESS_PERMISSION, this.createAddress).add(DELETE_ADDRESS_PERMISSION, this.deleteAddress).add(VIEW_PERMISSION, this.view).add(EDIT_PERMISSION, this.edit).build();
    }

    public Role() {
    }

    @Deprecated(forRemoval=true)
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, consume);
    }

    @Deprecated(forRemoval=true)
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, browse, createDurableQueue || createNonDurableQueue, deleteDurableQueue || deleteNonDurableQueue, false, false);
    }

    @Deprecated(forRemoval=true)
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse, boolean createAddress, boolean deleteAddress) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, browse, createAddress, deleteAddress, false, false);
    }

    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse, boolean createAddress, boolean deleteAddress, boolean view, boolean edit) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.send = send;
        this.consume = consume;
        this.createAddress = createAddress;
        this.deleteAddress = deleteAddress;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
        this.browse = browse;
        this.view = view;
        this.edit = edit;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateAddress() {
        return this.createAddress;
    }

    public boolean isDeleteAddress() {
        return this.deleteAddress;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public boolean isManage() {
        return this.manage;
    }

    public boolean isBrowse() {
        return this.browse;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public boolean isView() {
        return this.view;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSend(boolean send) {
        this.send = send;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public void setCreateAddress(boolean createAddress) {
        this.createAddress = createAddress;
    }

    public void setDeleteAddress(boolean deleteAddress) {
        this.deleteAddress = deleteAddress;
    }

    public void setCreateDurableQueue(boolean createDurableQueue) {
        this.createDurableQueue = createDurableQueue;
    }

    public void setDeleteDurableQueue(boolean deleteDurableQueue) {
        this.deleteDurableQueue = deleteDurableQueue;
    }

    public void setCreateNonDurableQueue(boolean createNonDurableQueue) {
        this.createNonDurableQueue = createNonDurableQueue;
    }

    public void setDeleteNonDurableQueue(boolean deleteNonDurableQueue) {
        this.deleteNonDurableQueue = deleteNonDurableQueue;
    }

    public void setManage(boolean manage) {
        this.manage = manage;
    }

    public void setBrowse(boolean browse) {
        this.browse = browse;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public String toString() {
        StringBuilder stringReturn = new StringBuilder("Role {name=" + this.name + "; allows=[");
        if (this.send) {
            stringReturn.append(" send ");
        }
        if (this.consume) {
            stringReturn.append(" consume ");
        }
        if (this.createDurableQueue) {
            stringReturn.append(" createDurableQueue ");
        }
        if (this.deleteDurableQueue) {
            stringReturn.append(" deleteDurableQueue ");
        }
        if (this.createNonDurableQueue) {
            stringReturn.append(" createNonDurableQueue ");
        }
        if (this.deleteNonDurableQueue) {
            stringReturn.append(" deleteNonDurableQueue ");
        }
        if (this.manage) {
            stringReturn.append(" manage ");
        }
        if (this.browse) {
            stringReturn.append(" browse ");
        }
        if (this.createAddress) {
            stringReturn.append(" createAddress ");
        }
        if (this.deleteAddress) {
            stringReturn.append(" deleteAddress ");
        }
        if (this.view) {
            stringReturn.append(" view ");
        }
        if (this.edit) {
            stringReturn.append(" edit ");
        }
        stringReturn.append("]}");
        return stringReturn.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return Objects.equals(this.name, other.name) && this.send == other.send && this.consume == other.consume && this.createDurableQueue == other.createDurableQueue && this.createNonDurableQueue == other.createNonDurableQueue && this.deleteDurableQueue == other.deleteDurableQueue && this.deleteNonDurableQueue == other.deleteNonDurableQueue && this.manage == other.manage && this.browse == other.browse && this.createAddress == other.createAddress && this.deleteAddress == other.deleteAddress && this.view == other.view && this.edit == other.edit;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.send, this.consume, this.createDurableQueue, this.deleteDurableQueue, this.createNonDurableQueue, this.deleteNonDurableQueue, this.manage, this.browse, this.createAddress, this.deleteAddress, this.view, this.edit);
    }

    public void merge(Role other) {
        this.send = this.send || other.send;
        this.consume = this.consume || other.consume;
        this.createDurableQueue = this.createDurableQueue || other.createDurableQueue;
        this.deleteDurableQueue = this.deleteDurableQueue || other.deleteDurableQueue;
        this.createNonDurableQueue = this.createNonDurableQueue || other.createNonDurableQueue;
        this.deleteNonDurableQueue = this.deleteNonDurableQueue || other.deleteNonDurableQueue;
        this.manage = this.manage || other.manage;
        this.browse = this.browse || other.browse;
        this.createAddress = this.createAddress || other.createAddress;
        this.deleteAddress = this.deleteAddress || other.deleteAddress;
        this.view = this.view || other.view;
        this.edit = this.edit || other.edit;
    }
}

