/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.slf4j;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.daffodil.slf4j.DaffodilLogger$LoggerConfig$;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.AbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class DaffodilLogger
extends AbstractLogger {
    public final DaffodilLogger$LoggerConfig$ LoggerConfig$lzy1 = new DaffodilLogger$LoggerConfig$(this);
    private final ThreadLocal<LoggerConfig> perThreadLoggerConfig = new ThreadLocal<LoggerConfig>(){

        public LoggerConfig initialValue() {
            return null;
        }
    };

    public DaffodilLogger(String name) {
    }

    public final DaffodilLogger$LoggerConfig$ LoggerConfig() {
        return this.LoggerConfig$lzy1;
    }

    public void setThreadLoggerConfig(Level level, PrintStream stream) {
        LoggerConfig loggerConfig = this.LoggerConfig().apply(level, stream);
        this.perThreadLoggerConfig.set(loggerConfig);
    }

    public void removeThreadLoggerConfig() {
        this.perThreadLoggerConfig.remove();
    }

    public String getFullyQualifiedCallerName() {
        return null;
    }

    public void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) {
        LoggerConfig loggerConfig = this.perThreadLoggerConfig.get();
        if (loggerConfig != null) {
            Object[] objectArray;
            StringBuilder buf = new StringBuilder();
            String levelStr = level.toString().toLowerCase();
            buf.append('[');
            buf.append(levelStr);
            buf.append("] ");
            if (throwable != null) {
                if (arguments == null) {
                    objectArray = new Object[]{throwable};
                } else {
                    Object object = Predef$.MODULE$.refArrayOps(arguments);
                    objectArray = (Object[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)throwable, ClassTag$.MODULE$.apply(Object.class));
                }
            } else {
                objectArray = arguments;
            }
            Object[] fixedArgs = objectArray;
            String formattedMessage = MessageFormatter.basicArrayFormat((String)msg, (Object[])fixedArgs);
            buf.append(formattedMessage);
            loggerConfig.stream().println(buf.toString());
            loggerConfig.stream().flush();
            return;
        }
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    private boolean isLevelEnabled(Level level) {
        LoggerConfig loggerConfig = this.perThreadLoggerConfig.get();
        return loggerConfig != null && loggerConfig.level().toInt() <= level.toInt();
    }

    public class LoggerConfig
    implements Product,
    Serializable {
        private final Level level;
        private final PrintStream stream;
        private final /* synthetic */ DaffodilLogger $outer;

        public LoggerConfig(DaffodilLogger $outer, Level level, PrintStream stream) {
            this.level = level;
            this.stream = stream;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1838169867, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoggerConfig)) return false;
            if (((LoggerConfig)object).org$apache$daffodil$slf4j$DaffodilLogger$LoggerConfig$$$outer() != this.$outer) return false;
            LoggerConfig loggerConfig = (LoggerConfig)object;
            Level level = this.level();
            Level level2 = loggerConfig.level();
            if (level == null) {
                if (level2 != null) {
                    return false;
                }
            } else if (!level.equals(level2)) return false;
            PrintStream printStream = this.stream();
            PrintStream printStream2 = loggerConfig.stream();
            if (printStream == null) {
                if (printStream2 != null) {
                    return false;
                }
            } else if (!printStream.equals(printStream2)) return false;
            if (!loggerConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LoggerConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LoggerConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "level";
            }
            if (1 == n2) {
                return "stream";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Level level() {
            return this.level;
        }

        public PrintStream stream() {
            return this.stream;
        }

        public LoggerConfig copy(Level level, PrintStream stream) {
            return new LoggerConfig(this.$outer, level, stream);
        }

        public Level copy$default$1() {
            return this.level();
        }

        public PrintStream copy$default$2() {
            return this.stream();
        }

        public Level _1() {
            return this.level();
        }

        public PrintStream _2() {
            return this.stream();
        }

        public final /* synthetic */ DaffodilLogger org$apache$daffodil$slf4j$DaffodilLogger$LoggerConfig$$$outer() {
            return this.$outer;
        }
    }
}

