/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import java.util.Arrays;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.frequencies.ItemsState;
import org.apache.datasketches.hive.frequencies.UnionStringsSketchUDAF;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionStringsSketchUDAFTest {
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooFewInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void getEvaluatorTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongType() throws Exception {
        AbstractPrimitiveWritableObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void getEvaluatorWrongCategory() throws Exception {
        StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(binaryInspector));
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);
    }

    @Test
    public void iterateTerminatePartial() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            UnionStringsSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsState state = (ItemsState)eval.getNewAggregationBuffer();
            state.init(256);
            state.update((Object)"a");
            ItemsSketch sketch = new ItemsSketch(256);
            sketch.update((Object)"b");
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new BytesWritable(sketch.toByteArray(serDe))});
            BytesWritable bytes = (BytesWritable)eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), serDe);
            Assert.assertEquals((long)resultSketch.getStreamLength(), (long)2L);
            Assert.assertEquals((int)resultSketch.getNumActiveItems(), (int)2);
            Assert.assertEquals((long)resultSketch.getEstimate((Object)"a"), (long)1L);
            Assert.assertEquals((long)resultSketch.getEstimate((Object)"b"), (long)1L);
        }
    }

    @Test
    public void mergeTerminate() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new UnionStringsSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, inspectors);
            UnionStringsSketchUDAFTest.checkResultInspector(resultInspector);
            ItemsState state = (ItemsState)eval.getNewAggregationBuffer();
            state.init(256);
            state.update((Object)"a");
            ItemsSketch sketch = new ItemsSketch(256);
            sketch.update((Object)"b");
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, (Object)new BytesWritable(sketch.toByteArray(serDe)));
            BytesWritable bytes = (BytesWritable)eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            ItemsSketch resultSketch = ItemsSketch.getInstance((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)bytes), serDe);
            Assert.assertEquals((long)resultSketch.getStreamLength(), (long)2L);
            Assert.assertEquals((int)resultSketch.getNumActiveItems(), (int)2);
            Assert.assertEquals((long)resultSketch.getEstimate((Object)"a"), (long)1L);
            Assert.assertEquals((long)resultSketch.getEstimate((Object)"b"), (long)1L);
        }
    }

    private static void checkResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

