/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.kll.DataToSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void execWrongValueType() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)"a"));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void execNormalCase() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void execMixedNullCase() throws Exception {
        DataToSketch func = new DataToSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(null);
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void accumulator() throws Exception {
        DataToSketch func = new DataToSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(null);
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)4L);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void accumulatorCustomK() throws Exception {
        DataToSketch func = new DataToSketch("400");
        KllFloatsSketch sketch = DataToSketchTest.getSketch((DataByteArray)func.getValue());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicInitial() throws Exception {
        DataToSketch.Initial func = new DataToSketch.Initial();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple());
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertTrue((boolean)(resultTuple.get(0) instanceof DataBag));
        Assert.assertEquals((long)((DataBag)resultTuple.get(0)).size(), (long)1L);
    }

    @Test
    public void algebraicIntermediateNullInputTupleCustomK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).getConstructor(String.class).newInstance("400");
        Tuple resultTuple = (Tuple)func.exec(null);
        KllFloatsSketch sketch = DataToSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = DataToSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test
    public void algebraicIntermediateMixedNullCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        innerBag.add(null);
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void algebraicFinalNullInputTupleCustomK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).getConstructor(String.class).newInstance("400");
        DataByteArray result = (DataByteArray)func.exec(null);
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test
    public void algebraicFinalMixedNullCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)Float.valueOf(1.0f)));
        innerBag.add(null);
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicFinalWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new DataToSketch().getFinal()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    private static KllFloatsSketch getSketch(Tuple tuple) throws Exception {
        Assert.assertNotNull((Object)tuple);
        Assert.assertEquals((int)tuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)tuple.get(0);
        return DataToSketchTest.getSketch(bytes);
    }

    private static KllFloatsSketch getSketch(DataByteArray bytes) throws Exception {
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        return KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes.get()));
    }
}

