/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class Wrapper41Test
extends BaseJDBCTestCase {
    private static final String UNSUPPORTED_COERCION = "22005";
    private static final String BAD_FORMAT = "22018";
    private static final String BAD_DATETIME = "22007";
    private static final String VARIABLE_STRING = "XXXXX";
    public static final byte[] BINARY_VALUE = new byte[]{-34};
    static final long TIME_VALUE = 83342000L;
    static final long TIMESTAMP_VALUE = -229527385766L;
    private Class _byteArrayClass;
    private boolean _rowOfNulls;

    public Wrapper41Test(String name) {
        super(name);
    }

    protected void examineJDBC4_1extensions(Wrapper41 wrapper, boolean rowOfNulls) throws Exception {
        Wrapper41Test.println("Vetting a " + wrapper.getWrappedObject().getClass().getName() + ". rowOfNulls = " + rowOfNulls);
        this._byteArrayClass = Class.forName("[B");
        this._rowOfNulls = rowOfNulls;
        this.vetWrappedNull(wrapper);
        this.vetWrappedInteger(wrapper, 1, "BIGINTCOL");
        this.vetWrappedBlob(wrapper);
        this.vetWrappedBoolean(wrapper);
        this.vetWrappedString(wrapper, 4, "CHARCOL");
        this.vetWrappedBinary(wrapper, 5, "CHARFORBITDATACOL");
        this.vetWrappedClob(wrapper);
        this.vetWrappedDate(wrapper);
        this.vetWrappedFloatingPoint(wrapper, 8, "DOUBLECOL");
        this.vetWrappedFloatingPoint(wrapper, 9, "FLOATCOL");
        this.vetWrappedInteger(wrapper, 10, "INTCOL");
        this.vetWrappedString(wrapper, 11, "LONGVARCHARCOL");
        this.vetWrappedBinary(wrapper, 12, "LONGVARCHARFORBITDATACOL");
        this.vetWrappedInteger(wrapper, 13, "NUMERICCOL");
        this.vetWrappedFloatingPoint(wrapper, 14, "REALCOL");
        this.vetWrappedInteger(wrapper, 15, "SMALLINTCOL");
        this.vetWrappedTime(wrapper);
        this.vetWrappedTimestamp(wrapper);
        this.vetWrappedString(wrapper, 18, "VARCHARCOL");
        this.vetWrappedBinary(wrapper, 19, "VARCHARFORBITDATACOL");
    }

    private void vetWrappedNull(Wrapper41 wrapper) throws Exception {
        try {
            wrapper.getObject(1, (Class)null);
            Wrapper41Test.fail((String)"Did not expect to get a result for a null class type.");
        }
        catch (SQLException e) {
            Wrapper41Test.assertSQLState("Null type", UNSUPPORTED_COERCION, e);
        }
        if (wrapper.getWrappedObject() instanceof CallableStatement) {
            return;
        }
        try {
            wrapper.getObject("BIGINTCOL", (Class)null);
            Wrapper41Test.fail((String)"Did not expect to get a result for a null class type.");
        }
        catch (SQLException e) {
            Wrapper41Test.assertSQLState("Null type", UNSUPPORTED_COERCION, e);
        }
    }

    private void vetWrappedInteger(Wrapper41 wrapper, int colID, String colName) throws Exception {
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "1", new Class[]{String.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Number.class, Object.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "1.0", new Class[]{Float.class, Double.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetNoWrapper(wrapper, colID, colName, new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedBlob(Wrapper41 wrapper) throws Exception {
        this.vetWrapperOK(wrapper, 2, "BLOBCOL", this._rowOfNulls ? null : BINARY_VALUE, new Class[]{Blob.class, Object.class, this._byteArrayClass, String.class});
        this.vetNoWrapper(wrapper, 2, "BLOBCOL", new Class[]{BigDecimal.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class});
    }

    private void vetWrappedBoolean(Wrapper41 wrapper) throws Exception {
        this.vetWrapperOK(wrapper, 3, "BOOLEANCOL", this._rowOfNulls ? null : "true", new Class[]{String.class, Boolean.class, Object.class});
        this.vetWrapperOK(wrapper, 3, "BOOLEANCOL", this._rowOfNulls ? null : "1", new Class[]{BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class});
        this.vetWrapperOK(wrapper, 3, "BOOLEANCOL", this._rowOfNulls ? null : "1.0", new Class[]{Float.class, Double.class});
        this.vetNoWrapper(wrapper, 3, "BOOLEANCOL", new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedString(Wrapper41 wrapper, int colID, String colName) throws Exception {
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "a", new Class[]{String.class, Object.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetCoercionError(wrapper, colID, colName, new Class[]{BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class}, BAD_FORMAT);
        this.vetCoercionError(wrapper, colID, colName, new Class[]{Date.class, Time.class, Timestamp.class}, BAD_DATETIME);
        this.vetNoWrapper(wrapper, colID, colName, new Class[]{Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedBinary(Wrapper41 wrapper, int colID, String colName) throws Exception {
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "de", new Class[]{String.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : BINARY_VALUE, new Class[]{this._byteArrayClass, Object.class});
        this.vetNoWrapper(wrapper, colID, colName, new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedClob(Wrapper41 wrapper) throws Exception {
        this.vetWrapperOK(wrapper, 6, "CLOBCOL", this._rowOfNulls ? null : "abc", new Class[]{String.class, Clob.class, Object.class});
        this.vetNoWrapper(wrapper, 6, "CLOBCOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class, this._byteArrayClass});
    }

    private void vetWrappedDate(Wrapper41 wrapper) throws Exception {
        this.vetWrapperOK(wrapper, 7, "DATECOL", this._rowOfNulls ? null : "1994-02-23", new Class[]{String.class, Date.class, Object.class});
        this.vetWrapperOK(wrapper, 7, "DATECOL", this._rowOfNulls ? null : "1994-02-23 00:00:00.0", new Class[]{Timestamp.class});
        this.vetNoWrapper(wrapper, 7, "DATECOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Time.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedFloatingPoint(Wrapper41 wrapper, int colID, String colName) throws Exception {
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "1.0", new Class[]{String.class, Float.class, Double.class, BigDecimal.class, Number.class, Object.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "1", new Class[]{Byte.class, Short.class, Integer.class, Long.class});
        this.vetWrapperOK(wrapper, colID, colName, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetNoWrapper(wrapper, colID, colName, new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedTime(Wrapper41 wrapper) throws Exception {
        Time expectedTime = new Time(83342000L);
        this.vetWrapperOK(wrapper, 16, "TIMECOL", this._rowOfNulls ? null : expectedTime.toString(), new Class[]{String.class, Time.class, Object.class});
        this.vetWrapperOK(wrapper, 16, "TIMECOL", this._rowOfNulls ? null : Wrapper41Test.timeToTimestamp(expectedTime).toString(), new Class[]{Timestamp.class});
        this.vetNoWrapper(wrapper, 16, "TIMECOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedTimestamp(Wrapper41 wrapper) throws Exception {
        String expectedTimestamp = new Timestamp(-229527385766L).toString();
        this.vetWrapperOK(wrapper, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : expectedTimestamp, new Class[]{String.class, Timestamp.class, Object.class});
        String expectedTime = new Time(-229527385766L).toString();
        this.vetWrapperOK(wrapper, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : expectedTime, new Class[]{Time.class});
        String expectedDate = new Date(-229527385766L).toString();
        this.vetWrapperOK(wrapper, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : expectedDate, new Class[]{Date.class});
        this.vetNoWrapper(wrapper, 17, "TIMESTAMPCOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrapperOK(Wrapper41 wrapper, int colID, String colName, Object expectedValue, Class[] supportedCoercions) throws Exception {
        for (Class candidate : supportedCoercions) {
            this.vetCandidate(candidate, expectedValue, wrapper.getObject(colID, candidate));
            if (candidate == Blob.class || candidate == Clob.class) {
                return;
            }
            if (wrapper.getWrappedObject() instanceof CallableStatement) continue;
            this.vetCandidate(candidate, expectedValue, wrapper.getObject(colName, candidate));
        }
    }

    private void vetCandidate(Class<?> candidate, Object expectedValue, Object actualValue) throws Exception {
        String actualString;
        if (actualValue != null) {
            Wrapper41Test.assertTrue((String)candidate.getName(), (boolean)candidate.isAssignableFrom(actualValue.getClass()));
        }
        if (expectedValue == null) {
            Wrapper41Test.assertNull((Object)actualValue);
            return;
        }
        if (VARIABLE_STRING.equals(expectedValue)) {
            return;
        }
        if (actualValue instanceof Blob) {
            Blob blob = (Blob)actualValue;
            this.vetBytes((byte[])expectedValue, blob.getBytes(1L, (int)blob.length()));
            return;
        }
        if (actualValue instanceof byte[]) {
            this.vetBytes((byte[])expectedValue, (byte[])actualValue);
            return;
        }
        if (actualValue instanceof Clob) {
            Clob clob = (Clob)actualValue;
            actualString = clob.getSubString(1L, (int)clob.length());
        } else {
            actualString = actualValue.toString();
        }
        Wrapper41Test.assertEquals((String)candidate.getName(), (String)((String)expectedValue), (String)actualString);
    }

    private void vetBytes(byte[] expected, byte[] actual) throws Exception {
        int count = expected.length;
        Wrapper41Test.assertEquals((int)count, (int)actual.length);
        for (int i = 0; i < count; ++i) {
            Wrapper41Test.assertEquals((byte)expected[i], (byte)actual[i]);
        }
    }

    private void vetNoWrapper(Wrapper41 wrapper, int colID, String colName, Class[] unsupportedCoercions) throws Exception {
        this.vetCoercionError(wrapper, colID, colName, unsupportedCoercions, UNSUPPORTED_COERCION);
    }

    private void vetCoercionError(Wrapper41 wrapper, int colID, String colName, Class[] unsupportedCoercions, String expectedSQLState) throws Exception {
        if (this._rowOfNulls) {
            return;
        }
        for (Class candidate : unsupportedCoercions) {
            try {
                wrapper.getObject(colID, candidate);
                Wrapper41Test.fail((String)("Did not expect to get a " + candidate.getName()));
            }
            catch (SQLException e) {
                Wrapper41Test.assertSQLState(candidate.getName(), expectedSQLState, e);
            }
            if (candidate == Blob.class || candidate == Clob.class) {
                return;
            }
            if (wrapper.getWrappedObject() instanceof CallableStatement) {
                return;
            }
            try {
                wrapper.getObject(colName, candidate);
                Wrapper41Test.fail((String)("Did not expect to get a " + candidate.getName()));
            }
            catch (SQLException e) {
                Wrapper41Test.assertSQLState(candidate.getName(), expectedSQLState, e);
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection conn, String text) throws Exception {
        Wrapper41Test.println(text);
        PreparedStatement ps = conn.prepareStatement(text);
        return ps;
    }

    protected CallableStatement prepareCall(Connection conn, String text) throws Exception {
        Wrapper41Test.println(text);
        CallableStatement cs = conn.prepareCall(text);
        return cs;
    }

    private static Timestamp timeToTimestamp(Time time) {
        int[] timeFields;
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(time);
        Calendar tsCal = Calendar.getInstance();
        for (int field : timeFields = new int[]{11, 12, 13, 14}) {
            tsCal.set(field, timeCal.get(field));
        }
        return new Timestamp(tsCal.getTimeInMillis());
    }
}

