/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public class PrivilegedFileOpsForTests {
    public static long length(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        });
    }

    public static String getAbsolutePath(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() throws SecurityException {
                return file.getAbsolutePath();
            }
        });
    }

    public static URI toURI(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<URI>(){

            @Override
            public URI run() throws SecurityException {
                return file.toURI();
            }
        });
    }

    public static File createTempFile(final String prefix, final String suffix, final File directory) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile(prefix, suffix, directory);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    public static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
    }

    public static boolean exists(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public static boolean delete(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        });
    }

    public static boolean mkdir(final File dir) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return dir.mkdir();
            }
        });
    }

    public static boolean setReadable(final File file, final boolean readable, final boolean ownerOnly) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setReadable(readable, ownerOnly);
            }
        });
    }

    public static boolean setReadOnly(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setReadOnly();
            }
        });
    }

    public static FileReader getFileReader(final File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileReader>(){

                @Override
                public FileReader run() throws FileNotFoundException {
                    return new FileReader(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getCause();
        }
    }

    public static FileWriter getFileWriter(final File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                @Override
                public FileWriter run() throws IOException {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }

    public static File[] listFiles(File dir) {
        return AccessController.doPrivileged(() -> dir.listFiles());
    }

    public static void copy(final File source, final File target) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    PrivilegedFileOpsForTests.recursiveCopy(source, target);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private static void recursiveCopy(File source, File target) throws IOException {
        byte[] buf = new byte[32768];
        if (source.isFile()) {
            PrivilegedFileOpsForTests.copySingleFile(source, target, buf);
            return;
        }
        String[] list = source.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(source, list[i]);
                File targetEntry = new File(target, list[i]);
                if (entry.isDirectory()) {
                    PrivilegedFileOpsForTests.copy(entry, targetEntry);
                    continue;
                }
                PrivilegedFileOpsForTests.copySingleFile(entry, targetEntry, buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File source, File target, byte[] buf) throws IOException {
        File targetParent;
        if (buf == null) {
            buf = new byte[32768];
        }
        if ((targetParent = target.getParentFile()) != null && !targetParent.exists()) {
            target.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            int read;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return PrivilegedFileOpsForTests.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getCause();
        }
    }

    public static File[] persistentRecursiveDelete(final File dir) throws FileNotFoundException {
        if (!PrivilegedFileOpsForTests.exists(dir)) {
            throw new FileNotFoundException(PrivilegedFileOpsForTests.getAbsolutePath(dir));
        }
        final ArrayList notDeleted = new ArrayList();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PrivilegedFileOpsForTests.deleteRecursively(dir, notDeleted);
                return null;
            }
        });
        return notDeleted.toArray(new File[notDeleted.size()]);
    }

    private static boolean deleteRecursively(File dir, List<File> failedDeletes) {
        File[] files;
        boolean allDeleted = true;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    allDeleted &= PrivilegedFileOpsForTests.deleteRecursively(f, failedDeletes);
                    continue;
                }
                allDeleted &= PrivilegedFileOpsForTests.internalDelete(f, failedDeletes);
            }
        }
        return allDeleted &= PrivilegedFileOpsForTests.internalDelete(dir, failedDeletes);
    }

    private static boolean internalDelete(File f, List<File> failedDeletes) {
        boolean deleted = f.delete();
        if (!deleted) {
            failedDeletes.add(f);
        }
        return deleted;
    }

    public static String getFileInfo(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                if (!f.exists()) {
                    return "(non-existant)";
                }
                StringBuilder sb = new StringBuilder();
                sb.append("(isDir=").append(f.isDirectory()).append(", canRead=").append(f.canRead()).append(", canWrite=").append(f.canWrite()).append(", size=").append(f.length()).append(')');
                return sb.toString();
            }
        });
    }
}

