/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;

public class CollectNodesVisitor<T extends Visitable>
implements Visitor {
    private final List<T> nodeList = new ArrayList<T>();
    private final Class<T> nodeClass;
    private final Class<? extends Visitable> skipOverClass;

    public CollectNodesVisitor(Class<T> nodeClass) {
        this(nodeClass, null);
    }

    public CollectNodesVisitor(Class<T> nodeClass, Class<? extends Visitable> skipOverClass) {
        this.nodeClass = nodeClass;
        this.skipOverClass = skipOverClass;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) {
        if (this.nodeClass.isInstance(node)) {
            this.nodeList.add(this.nodeClass.cast(node));
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    public List<T> getList() {
        return this.nodeList;
    }
}

