/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.IndexValueRow;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.sanity.SanityManager;

class TemporaryRowHolderImpl
implements TemporaryRowHolder {
    public static final int DEFAULT_OVERFLOWTHRESHOLD = 5;
    protected static final int STATE_UNINIT = 0;
    protected static final int STATE_INSERT = 1;
    protected static final int STATE_DRAIN = 2;
    protected ExecRow[] rowArray;
    protected int lastArraySlot;
    private int numRowsIn;
    protected int state = 0;
    private long CID;
    private boolean conglomCreated;
    private ConglomerateController cc;
    private Properties properties;
    private ScanController scan;
    private ResultDescription resultDescription;
    Activation activation;
    private boolean isUniqueStream;
    private boolean isVirtualMemHeap;
    private boolean uniqueIndexCreated;
    private boolean positionIndexCreated;
    private long uniqueIndexConglomId;
    private long positionIndexConglomId;
    private ConglomerateController uniqueIndex_cc;
    private ConglomerateController positionIndex_cc;
    private DataValueDescriptor[] uniqueIndexRow = null;
    private DataValueDescriptor[] positionIndexRow = null;
    private RowLocation destRowLocation;
    private SQLLongint position_sqllong;

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription) {
        this(activation, properties, resultDescription, 5, false, false);
    }

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription, boolean isUniqueStream) {
        this(activation, properties, resultDescription, 1, isUniqueStream, false);
    }

    public TemporaryRowHolderImpl(Activation activation, Properties properties, ResultDescription resultDescription, int overflowToConglomThreshold, boolean isUniqueStream, boolean isVirtualMemHeap) {
        if (overflowToConglomThreshold <= 0) {
            SanityManager.THROWASSERT("It is assumed that the overflow threshold is > 0.  If you you need to change this you have to recode some of this class.");
        }
        this.activation = activation;
        this.properties = properties;
        this.resultDescription = resultDescription;
        this.isUniqueStream = isUniqueStream;
        this.isVirtualMemHeap = isVirtualMemHeap;
        this.rowArray = new ExecRow[overflowToConglomThreshold];
        this.lastArraySlot = -1;
    }

    private ExecRow cloneRow(ExecRow inputRow) {
        DataValueDescriptor[] cols = inputRow.getRowArray();
        int ncols = cols.length;
        ExecRow cloned = ((ValueRow)inputRow).cloneMe();
        for (int i = 0; i < ncols; ++i) {
            if (cols[i] == null) continue;
            cloned.setColumn(i + 1, cols[i].cloneHolder());
        }
        if (inputRow instanceof IndexValueRow) {
            return new IndexValueRow(cloned);
        }
        return cloned;
    }

    @Override
    public void insert(ExecRow inputRow) throws StandardException {
        if (!this.isUniqueStream && !this.isVirtualMemHeap) {
            SanityManager.ASSERT(this.state != 2, "you cannot insert rows after starting to drain");
        }
        if (!this.isVirtualMemHeap) {
            this.state = 1;
        }
        if (this.uniqueIndexCreated && this.isRowAlreadyExist(inputRow)) {
            return;
        }
        ++this.numRowsIn;
        if (this.lastArraySlot + 1 < this.rowArray.length) {
            this.rowArray[++this.lastArraySlot] = this.cloneRow(inputRow);
            if (!this.isUniqueStream) {
                return;
            }
        }
        if (!this.conglomCreated) {
            TransactionController tc = this.activation.getTransactionController();
            int[] collation_ids = null;
            this.CID = tc.createConglomerate("heap", inputRow.getRowArray(), null, collation_ids, this.properties, 3);
            this.conglomCreated = true;
            this.cc = tc.openConglomerate(this.CID, false, 4, 7, 5);
            if (this.isUniqueStream) {
                this.destRowLocation = this.cc.newRowLocationTemplate();
            }
        }
        int status = 0;
        if (this.isUniqueStream) {
            this.cc.insertAndFetchLocation(inputRow.getRowArray(), this.destRowLocation);
            this.insertToPositionIndex(this.numRowsIn - 1, this.destRowLocation);
            if (!this.uniqueIndexCreated) {
                this.isRowAlreadyExist(inputRow);
            }
        } else {
            status = this.cc.insert(inputRow.getRowArray());
            if (this.isVirtualMemHeap) {
                this.state = 1;
            }
        }
        if (status != 0) {
            SanityManager.THROWASSERT("got funky status (" + status + ") back from ConglomerateConstroller.insert()");
        }
    }

    private boolean isRowAlreadyExist(ExecRow inputRow) throws StandardException {
        DataValueDescriptor rlColumn = inputRow.getColumn(inputRow.nColumns());
        if (this.CID != 0L && rlColumn instanceof SQLRef) {
            RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
            if (!this.uniqueIndexCreated) {
                TransactionController tc = this.activation.getTransactionController();
                int numKeys = 2;
                this.uniqueIndexRow = new DataValueDescriptor[numKeys];
                this.uniqueIndexRow[0] = baseRowLocation;
                this.uniqueIndexRow[1] = baseRowLocation;
                Properties props = this.makeIndexProperties(this.uniqueIndexRow, this.CID);
                this.uniqueIndexConglomId = tc.createConglomerate("BTREE", this.uniqueIndexRow, null, null, props, 3);
                this.uniqueIndex_cc = tc.openConglomerate(this.uniqueIndexConglomId, false, 4, 7, 5);
                this.uniqueIndexCreated = true;
            }
            this.uniqueIndexRow[0] = baseRowLocation;
            this.uniqueIndexRow[1] = baseRowLocation;
            int status = this.uniqueIndex_cc.insert(this.uniqueIndexRow);
            if (status != 0) {
                if (status == 1) {
                    return true;
                }
                if (status != 0) {
                    SanityManager.THROWASSERT("got funky status (" + status + ") back from Unique Index insert()");
                }
            }
        }
        return false;
    }

    private void insertToPositionIndex(int position, RowLocation rl) throws StandardException {
        if (!this.positionIndexCreated) {
            TransactionController tc = this.activation.getTransactionController();
            int numKeys = 2;
            this.position_sqllong = new SQLLongint();
            this.positionIndexRow = new DataValueDescriptor[numKeys];
            this.positionIndexRow[0] = this.position_sqllong;
            this.positionIndexRow[1] = rl;
            Properties props = this.makeIndexProperties(this.positionIndexRow, this.CID);
            this.positionIndexConglomId = tc.createConglomerate("BTREE", this.positionIndexRow, null, null, props, 3);
            this.positionIndex_cc = tc.openConglomerate(this.positionIndexConglomId, false, 4, 7, 5);
            this.positionIndexCreated = true;
        }
        this.position_sqllong.setValue(position);
        this.positionIndexRow[0] = this.position_sqllong;
        this.positionIndexRow[1] = rl;
        this.positionIndex_cc.insert(this.positionIndexRow);
    }

    @Override
    public CursorResultSet getResultSet() {
        this.state = 2;
        TransactionController tc = this.activation.getTransactionController();
        if (this.isUniqueStream) {
            return new TemporaryRowHolderResultSet(tc, this.rowArray, this.resultDescription, this.isVirtualMemHeap, true, this.positionIndexConglomId, this);
        }
        return new TemporaryRowHolderResultSet(tc, this.rowArray, this.resultDescription, this.isVirtualMemHeap, this);
    }

    public void truncate() throws StandardException {
        this.close();
        SanityManager.ASSERT(this.lastArraySlot == -1);
        SanityManager.ASSERT(this.state == 0);
        SanityManager.ASSERT(!this.conglomCreated);
        SanityManager.ASSERT(this.CID == 0L);
        for (int i = 0; i < this.rowArray.length; ++i) {
            this.rowArray[i] = null;
        }
        this.numRowsIn = 0;
    }

    @Override
    public long getTemporaryConglomId() {
        SanityManager.ASSERT(this.CID == 0L && !this.conglomCreated || this.CID < 0L && this.conglomCreated);
        return this.CID;
    }

    @Override
    public long getPositionIndexConglomId() {
        return this.positionIndexConglomId;
    }

    private Properties makeIndexProperties(DataValueDescriptor[] indexRowArray, long conglomId) throws StandardException {
        int nCols = indexRowArray.length;
        Properties props = new Properties();
        props.put("allowDuplicates", "false");
        props.put("nKeyFields", String.valueOf(nCols));
        props.put("nUniqueColumns", String.valueOf(nCols - 1));
        props.put("rowLocationColumn", String.valueOf(nCols - 1));
        props.put("baseConglomerateId", String.valueOf(conglomId));
        return props;
    }

    @Override
    public void setRowHolderTypeToUniqueStream() {
        this.isUniqueStream = true;
    }

    @Override
    public void close() throws StandardException {
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.cc != null) {
            this.cc.close();
            this.cc = null;
        }
        if (this.uniqueIndex_cc != null) {
            this.uniqueIndex_cc.close();
            this.uniqueIndex_cc = null;
        }
        if (this.positionIndex_cc != null) {
            this.positionIndex_cc.close();
            this.positionIndex_cc = null;
        }
        TransactionController tc = this.activation.getTransactionController();
        if (this.uniqueIndexCreated) {
            tc.dropConglomerate(this.uniqueIndexConglomId);
            this.uniqueIndexCreated = false;
        }
        if (this.positionIndexCreated) {
            tc.dropConglomerate(this.positionIndexConglomId);
            this.positionIndexCreated = false;
        }
        if (this.conglomCreated) {
            tc.dropConglomerate(this.CID);
            this.conglomCreated = false;
            this.CID = 0L;
        } else {
            SanityManager.ASSERT(this.CID == 0L, "CID(" + this.CID + ")==0");
        }
        this.state = 0;
        this.lastArraySlot = -1;
    }
}

