/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.lucene.analysis.Analyzer;

public class LuceneCoarseAuthorizationTest
extends GeneratedColumnsHelper {
    private static final String RUTH = "RUTH";
    private static final String READ_ONLY_USER = "READONLYUSER";
    private static final String READ_WRITE_USER = "READWRITEUSER";
    private static final String[] LEGAL_USERS = new String[]{"RUTH", "READONLYUSER", "READWRITEUSER"};
    public static final String ENGLISH_ANALYZER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer";
    public static final String STANDARD_ANALYZER = "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer' )";
    private static final String UPDATE_POEMS_INDEX = "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getStandardAnalyzer' )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";
    private static final String ILLEGAL_FOR_READONLY = "25502";

    public LuceneCoarseAuthorizationTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneCoarseAuthorizationTest.class);
        Test unsecureTest = SecurityManagerSetup.noSecurityManager((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication(unsecureTest, LEGAL_USERS, "LuceneCoarsePermissions");
        DatabasePropertyTestSetup coarseTest = new DatabasePropertyTestSetup(authenticatedTest, LuceneCoarseAuthorizationTest.makeProperties());
        TestSetup singleUseTest = TestConfiguration.singleUseDatabaseDecorator((Test)coarseTest);
        return singleUseTest;
    }

    private static Properties makeProperties() {
        Properties props = new Properties();
        props.setProperty("derby.database.fullAccessUsers", "RUTH,READWRITEUSER");
        props.setProperty("derby.database.readOnlyAccessUsers", READ_ONLY_USER);
        return props;
    }

    public void test_001_basic() throws Exception {
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection readOnlyConnection = this.openUserConnection(READ_ONLY_USER);
        Connection readWriteConnection = this.openUserConnection(READ_WRITE_USER);
        LuceneCoarseAuthorizationTest.createSchema(ruthConnection);
        this.expectExecutionError(readOnlyConnection, ILLEGAL_FOR_READONLY, LOAD_TOOL);
        this.goodStatement(readWriteConnection, LOAD_TOOL);
        this.expectExecutionError(readOnlyConnection, ILLEGAL_FOR_READONLY, INDEX_POEMS);
        this.goodStatement(readWriteConnection, INDEX_POEMS);
        String readPoemsIndex = "select p.originalAuthor, i.score\nfrom ruth.poems p, table ( ruth.poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        String[][] defaultPoemResults = new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}};
        this.assertResults(readOnlyConnection, readPoemsIndex, defaultPoemResults, false);
        this.assertResults(readWriteConnection, readPoemsIndex, defaultPoemResults, false);
        String listIndexes = "select schemaName, tableName, columnName, indexDescriptorMaker from table( LuceneSupport.listIndexes() ) l";
        String[][] defaultIndexList = new String[][]{{RUTH, "POEMS", "POEMTEXT", ENGLISH_ANALYZER}};
        this.assertResults(readOnlyConnection, listIndexes, defaultIndexList, false);
        this.assertResults(readWriteConnection, listIndexes, defaultIndexList, false);
        this.expectExecutionError(readOnlyConnection, ILLEGAL_FOR_READONLY, UPDATE_POEMS_INDEX);
        this.goodStatement(readWriteConnection, UPDATE_POEMS_INDEX);
        String[][] standardPoemResults = new String[][]{{"Walt Whitman", "0.3304931"}, {"John Milton", "0.2832798"}};
        this.assertResults(readOnlyConnection, readPoemsIndex, standardPoemResults, false);
        this.assertResults(readWriteConnection, readPoemsIndex, standardPoemResults, false);
        String[][] standardIndexList = new String[][]{{RUTH, "POEMS", "POEMTEXT", STANDARD_ANALYZER}};
        this.assertResults(readOnlyConnection, listIndexes, standardIndexList, false);
        this.assertResults(readWriteConnection, listIndexes, standardIndexList, false);
        this.expectExecutionError(readOnlyConnection, ILLEGAL_FOR_READONLY, DROP_POEMS_INDEX);
        this.goodStatement(readWriteConnection, DROP_POEMS_INDEX);
        this.expectExecutionError(readOnlyConnection, ILLEGAL_FOR_READONLY, UNLOAD_TOOL);
        this.goodStatement(readWriteConnection, UNLOAD_TOOL);
        LuceneCoarseAuthorizationTest.dropSchema(ruthConnection);
    }

    public static LuceneIndexDescriptor getEnglishAnalyzer() throws Exception {
        return new EnglishIndexDescriptor();
    }

    public static LuceneIndexDescriptor getStandardAnalyzer() throws Exception {
        return new StandardIndexDescriptor();
    }

    public static void createSchema(Connection conn) throws Exception {
        LuceneCoarseAuthorizationTest.createPoemsTable(conn);
    }

    public static void dropSchema(Connection conn) throws Exception {
        conn.prepareStatement("drop table poems").execute();
    }

    public static void createPoemsTable(Connection conn) throws Exception {
        conn.prepareStatement("create table poems\n(\n    poemID int,\n    versionStamp int not null,\n    originalAuthor       varchar( 50 ),\n    lastEditor           varchar( 50 ),\n    poemText            clob,\n    constraint poemsKey primary key( poemID, versionStamp )\n)\n").execute();
        PreparedStatement ps = conn.prepareStatement("insert into poems values ( ?, ?, ?, ?, ? )");
        int poemID = 1;
        int versionStamp = 1;
        ps.setInt(1, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Geoffrey Chaucer");
        ps.setString(4, "Geoffrey Chaucer");
        ps.setString(5, "Whan that Aprill, with his shoures soote The droghte of March hath perced to the roote And bathed every veyne in swich licour, Of which vertu engendred is the flour;");
        ps.executeUpdate();
        ps.setInt(1, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Andrew Marvell");
        ps.setString(4, "Andrew Marvell");
        ps.setString(5, "Had we but world enough, and time, This coyness, lady, were no crime.");
        ps.executeUpdate();
        ps.setInt(1, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "John Milton");
        ps.setString(4, "John Milton");
        ps.setString(5, "From morn to noon he fell, from noon to dewy eve, a summers day, and with the setting sun dropped from the ze4ith like a falling star on Lemnos, the Aegean isle");
        ps.executeUpdate();
        ps.setInt(1, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Lord Byron");
        ps.setString(4, "Lord Byron");
        ps.setString(5, "The Assyrian came down like the wolf on the fold, And his cohorts were gleaming in purple and gold; And the sheen of their spears was like stars on the sea, When the blue wave rolls nightly on deep Galilee.");
        ps.executeUpdate();
        ps.setInt(1, poemID++);
        ps.setInt(2, versionStamp++);
        ps.setString(3, "Walt Whitman");
        ps.setString(4, "Walt Whitman");
        ps.setString(5, "When lilacs last in the dooryard bloomd, And the great star early droopd in the western sky in the night, I mournd, and yet shall mourn with ever-returning spring.");
        ps.executeUpdate();
        ps.close();
    }

    public static class StandardIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.standardAnalyzer();
        }
    }

    public static class EnglishIndexDescriptor
    extends LuceneUtils.DefaultIndexDescriptor {
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.getAnalyzerForLocale((Locale)Locale.US);
        }
    }
}

