/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.dump;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;
import org.apache.derby.impl.services.jce.JCECipherFactoryBuilder;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.vti.VTITemplate;

public class DataFileVTI
extends VTITemplate {
    public static final String SYSSCHEMAS_SIGNATURE = "( schemaID char(36), schemaname varchar(128), authorizationid varchar(128) )";
    public static final String SYSSCHEMAS_CONGLOMERATE_NAME = "cc0.dat";
    public static final String SYSTABLES_SIGNATURE = "( tableid char(36), tablename varchar(128), tabletype char(1), schemaid char(36), lockgranularity char(1) )";
    public static final String SYSTABLES_CONGLOMERATE_NAME = "c60.dat";
    public static final String SYS_SCHEMA_ID = "8000000d-00d0-fd77-3ed8-000a0a0b1900";
    public static final String SYSUSERS_SIGNATURE = "( username  varchar( 128 ), hashingscheme  varchar( 32672 ), password  varchar( 32672 ), lastmodified timestamp )";
    public static final String SYSUSERS_CONGLOMERATE_NAME = "c470.dat";
    public static final String PROPERTIES_SIGNATURE = "( keyname serializable, payload serializable )";
    public static final String PROPERTIES_CONGLOMERATE_NAME = "c10.dat";
    private static final String COMPILATION_DB = "dfv_compilation_db";
    private static final String DUMMY_TABLE_NAME = "dfv_dummy";
    private static final long READ_ALL_PAGES = -1L;
    public static final int CHECKSUM_SIZE = 8;
    public static final int SMALL_SLOT_SIZE = 2;
    public static final int LARGE_SLOT_SIZE = 4;
    public static final byte RECORD_HAS_FIRST_FIELD = 4;
    private DataFile _dataFile;
    private boolean _opened = false;
    private ArrayList<DataValueDescriptor[]> _rows;
    private int _rowIdx;
    private boolean _lastColumnWasNull;
    private Calendar _defaultCalendar = Calendar.getInstance();

    private DataFileVTI(String string, String string2, String string3, String string4) throws Exception {
        Connection connection = this.getCompilerConnection();
        DataTypeDescriptor[] dataTypeDescriptorArray = this.getTypeSignature(connection, string3);
        this._dataFile = new DataFile(new File(string), string2, string4, dataTypeDescriptorArray);
    }

    public DataFileVTI(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this(string, string2, string3, string4);
        this.authenticate(string, string4, string5, string6);
    }

    private Connection getCompilerConnection() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:derby:memory:dfv_compilation_db;create=true");
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from sys.sysaliases where alias = 'SERIALIZABLE'");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        if (!bl) {
            connection.prepareStatement("create type serializable external name 'java.io.Serializable' language java").execute();
        }
        return connection;
    }

    private DataTypeDescriptor[] getTypeSignature(Connection connection, String string) throws Exception {
        String string2 = "create table dfv_dummy" + string;
        String string3 = "drop table dfv_dummy";
        try {
            connection.prepareStatement(string2).execute();
        }
        catch (SQLException sQLException) {
            throw new Exception("Illegal table signature: " + string, sQLException);
        }
        String string4 = "select c.columndatatype, c.columnnumber\nfrom sys.syscolumns c, sys.systables t\nwhere c.referenceid = t.tableid\nand t.tablename = ?\norder by c.columnnumber";
        PreparedStatement preparedStatement = connection.prepareStatement(string4);
        preparedStatement.setString(1, DUMMY_TABLE_NAME.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<DataTypeDescriptor> arrayList = new ArrayList<DataTypeDescriptor>();
        while (resultSet.next()) {
            arrayList.add(DataTypeDescriptor.getType((TypeDescriptor)((TypeDescriptor)resultSet.getObject(1))));
        }
        resultSet.close();
        preparedStatement.close();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[arrayList.size()];
        arrayList.toArray(dataTypeDescriptorArray);
        connection.prepareStatement(string3).execute();
        return dataTypeDescriptorArray;
    }

    private static void skipBytes(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.skipBytes(n);
        if (n2 != n) {
            throw new IOException("Expected to skip " + n + " bytes but only skipped " + n2 + " bytes.");
        }
    }

    private static byte[] decryptPage(CipherProvider cipherProvider, byte[] byArray) throws IOException {
        try {
            int n = byArray.length;
            byte[] byArray2 = new byte[n];
            int n2 = cipherProvider.decrypt(byArray, 0, n, byArray2, 0);
            if (n2 != n) {
                throw new IOException("Expected to decrypt " + n + " bytes but actually decrypted " + n2 + " bytes.");
            }
            System.arraycopy(byArray2, 8, byArray, 0, n - 8);
            System.arraycopy(byArray2, 0, byArray, n - 8, 8);
            return byArray;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private void authenticate(String string, String string2, String string3, String string4) throws Exception {
        this.vetDBO(string, string2, string3);
        if (this.vetNative(string, string2, string3, string4)) {
            return;
        }
        this.vetRawAuthentication(string, string2, string3, string4);
    }

    private void vetDBO(String string, String string2, String string3) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (string3 != null) {
            String string4 = StringUtil.normalizeSQLIdentifier((String)string3);
            DataFileVTI dataFileVTI = new DataFileVTI(string, SYSSCHEMAS_CONGLOMERATE_NAME, SYSSCHEMAS_SIGNATURE, string2);
            while (dataFileVTI.next()) {
                if (!"SYSIBM".equals(dataFileVTI.getString(2))) continue;
                bl2 = true;
                if (!dataFileVTI.getString(3).equals(string4)) break;
                bl = true;
                break;
            }
            dataFileVTI.close();
        }
        if (!bl2) {
            throw new Exception("Could not read database at " + string + ". Maybe it is encrypted and the wrong encryption key was supplied.");
        }
        if (!bl) {
            throw new Exception(string3 + " is not the owner of the database at " + string);
        }
    }

    private boolean vetNative(String string, String string2, String string3, String string4) throws Exception {
        String string5 = StringUtil.normalizeSQLIdentifier((String)string3);
        DataFileVTI dataFileVTI = new DataFileVTI(string, SYSTABLES_CONGLOMERATE_NAME, SYSTABLES_SIGNATURE, string2);
        boolean bl = false;
        while (dataFileVTI.next()) {
            if (!SYS_SCHEMA_ID.equals(dataFileVTI.getString(4)) || !"SYSUSERS".equals(dataFileVTI.getString(2))) continue;
            bl = true;
            break;
        }
        dataFileVTI.close();
        if (!bl) {
            return false;
        }
        DataFileVTI dataFileVTI2 = new DataFileVTI(string, SYSUSERS_CONGLOMERATE_NAME, SYSUSERS_SIGNATURE, string2);
        boolean bl2 = false;
        boolean bl3 = false;
        while (dataFileVTI2.next()) {
            bl2 = true;
            if (!dataFileVTI2.getString(1).equals(string5)) continue;
            String string6 = dataFileVTI2.getString(2);
            String string7 = dataFileVTI2.getString(3);
            PasswordHasher passwordHasher = new PasswordHasher(string6);
            String string8 = passwordHasher.hashPasswordIntoString(string5, string4);
            bl3 = string7.equals(string8);
            break;
        }
        dataFileVTI2.close();
        if (!bl2) {
            return false;
        }
        if (bl3) {
            return true;
        }
        throw new Exception("Bad NATIVE credentials.");
    }

    private void vetRawAuthentication(String string, String string2, String string3, String string4) throws Exception {
        Properties properties = this.readDatabaseProperties(string, string2);
        String string5 = properties.getProperty("derby.connection.requireAuthentication");
        if (!Boolean.valueOf(string5).booleanValue()) {
            return;
        }
        String string6 = properties.getProperty("derby.authentication.provider");
        if (string6 == null) {
            return;
        }
        boolean bl = StringUtil.SQLEqualsIgnoreCase((String)string6, (String)"LDAP") ? this.vetLDAP(properties, string, string3, string4) : (StringUtil.SQLEqualsIgnoreCase((String)string6, (String)"BUILTIN") ? this.vetBuiltin(properties, string3, string4) : this.vetCustom(string6, string, string3, string4));
        if (!bl) {
            throw new Exception("Authentication failed using provider " + string6);
        }
    }

    private boolean vetLDAP(Properties properties, String string, String string2, String string3) throws Exception {
        LDAPService lDAPService = new LDAPService(properties);
        lDAPService.boot(false, properties);
        Properties properties2 = new Properties();
        properties2.setProperty("user", string2);
        properties2.setProperty("password", string3);
        return lDAPService.authenticate(string, properties2);
    }

    private boolean vetBuiltin(Properties properties, String string, String string2) throws Exception {
        String string3 = "derby.user.".concat(string);
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            PasswordHasher passwordHasher = new PasswordHasher(string4);
            string2 = passwordHasher.hashAndEncode(string, string2);
        } else {
            string4 = DataFileVTI.getSystemProperty(string3);
        }
        return string4 != null && string4.equals(string2);
    }

    private boolean vetCustom(String string, String string2, String string3, String string4) throws Exception {
        Class<?> clazz = Class.forName(string);
        UserAuthenticator userAuthenticator = (UserAuthenticator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        return userAuthenticator.authenticateUser(string3, string4, string2, new Properties());
    }

    private static String getSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    private Properties readDatabaseProperties(String string, String string2) throws Exception {
        Properties properties = new Properties();
        DataFileVTI dataFileVTI = new DataFileVTI(string, PROPERTIES_CONGLOMERATE_NAME, PROPERTIES_SIGNATURE, string2);
        while (dataFileVTI.next()) {
            int n = 1;
            Object object = dataFileVTI.getObject(n++);
            Object object2 = dataFileVTI.getObject(n++);
            properties.put(object, object2);
        }
        dataFileVTI.close();
        return properties;
    }

    public static DataFileVTI dataFileVTI(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        return new DataFileVTI(string, string2, string3, string4, string5, string6);
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }

    public boolean next() throws SQLException {
        if (this._dataFile == null) {
            return false;
        }
        try {
            if (!this._opened) {
                this._dataFile.openFile();
                this._opened = true;
                this.readNextPage();
            }
            while (this._rows != null) {
                ++this._rowIdx;
                if (this._rowIdx < this._rows.size()) {
                    return true;
                }
                this.readNextPage();
            }
            this.close();
            return false;
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw this.wrap(throwable);
        }
    }

    private void readNextPage() throws Exception {
        this._rows = this._dataFile.readNextPage();
        this._rowIdx = -1;
    }

    public SQLWarning getWarnings() {
        SQLWarning sQLWarning = null;
        ArrayList<SQLWarning> arrayList = this._dataFile.getWarnings();
        if (arrayList != null && arrayList.size() > 0) {
            sQLWarning = arrayList.get(0);
            SQLWarning sQLWarning2 = null;
            for (SQLWarning sQLWarning3 : arrayList) {
                if (sQLWarning2 != null) {
                    sQLWarning2.setNextWarning(sQLWarning3);
                }
                sQLWarning2 = sQLWarning3;
            }
        }
        return sQLWarning;
    }

    public void close() throws SQLException {
        try {
            if (this._dataFile != null) {
                this._dataFile.closeFile();
            }
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
        finally {
            this._dataFile = null;
            this._rows = null;
        }
    }

    public ResultSetMetaData getMetaData() {
        return null;
    }

    private DataValueDescriptor getRawColumn(int n) {
        DataValueDescriptor dataValueDescriptor = this._rows.get(this._rowIdx)[n - 1];
        this._lastColumnWasNull = dataValueDescriptor.isNull();
        return dataValueDescriptor;
    }

    public boolean wasNull() {
        return this._lastColumnWasNull;
    }

    public String getString(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getString();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getBoolean();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getByte();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public short getShort(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getShort();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getInt();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getLong();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getFloat();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getDouble();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getBytes();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getDate(this._defaultCalendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getTime(this._defaultCalendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getTimestamp(this._defaultCalendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            return this.getRawColumn(n).getObject();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return (BigDecimal)this.getRawColumn(n).getObject();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            return this.getRawColumn(n).getDate(calendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            return this.getRawColumn(n).getTime(calendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            return this.getRawColumn(n).getTimestamp(calendar);
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return (Blob)this.getRawColumn(n).getObject();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return (Clob)this.getRawColumn(n).getObject();
        }
        catch (Throwable throwable) {
            throw this.wrap(throwable);
        }
    }

    public static final class WrapperInputStream
    extends InputStream {
        private InputStream _wrapped;
        private long _bytesRead;

        public WrapperInputStream(InputStream inputStream) {
            this._wrapped = inputStream;
            this._bytesRead = 0L;
        }

        @Override
        public int read() throws IOException {
            int n = this._wrapped.read();
            if (n >= 0) {
                ++this._bytesRead;
            }
            return n;
        }

        public long getBytesRead() {
            return this._bytesRead;
        }
    }

    public static class OverflowStream
    extends InputStream {
        RandomAccessFile _raf;
        private CipherProvider _decryptionEngine;
        private SlotReader _slotReader;
        private byte[] _currentPageData;
        private long _overflowPage;
        private int _overflowID;
        private ArrayInputStream _pageStream;
        private MemByteHolder _bytes;

        public OverflowStream(RandomAccessFile randomAccessFile, CipherProvider cipherProvider, SlotReader slotReader) {
            this._raf = randomAccessFile;
            this._decryptionEngine = cipherProvider;
            this._slotReader = slotReader;
            this._pageStream = new ArrayInputStream();
            this._bytes = new MemByteHolder(this._slotReader.pageSize());
            this._currentPageData = new byte[this._slotReader.pageSize()];
        }

        public OverflowStream init(long l, int n) throws IOException {
            this._overflowPage = l;
            this._overflowID = n;
            this._bytes.clear();
            this.readExtents();
            return this;
        }

        @Override
        public int read() throws IOException {
            int n = this._bytes.read();
            if (n < 0) {
                this._bytes.clear();
            }
            return n;
        }

        private void readExtents() throws IOException {
            while (this._overflowPage >= 0L) {
                this.readNextExtent();
            }
            this._bytes.startReading();
        }

        private void readNextExtent() throws IOException {
            this._raf.seek(this._overflowPage * (long)this._slotReader.pageSize());
            this._raf.readFully(this._currentPageData);
            if (this._decryptionEngine != null) {
                this._currentPageData = DataFileVTI.decryptPage(this._decryptionEngine, this._currentPageData);
            }
            this._pageStream.setData(this._currentPageData);
            PageHeader pageHeader = PageHeader.readPageHeader(this._currentPageData);
            int n = pageHeader.getSlotsInUse();
            int n2 = this.findRecordById(this._overflowID, 0, n);
            StoredRecordHeader storedRecordHeader = this._slotReader.getRecordHeader(n2, this._currentPageData);
            int n3 = this._slotReader.getRecordOffset(n2, this._currentPageData);
            int n4 = storedRecordHeader.getNumberFields();
            this._pageStream.setPosition(n3 + storedRecordHeader.size());
            int n5 = StoredFieldHeader.readStatus((ObjectInput)this._pageStream);
            int n6 = StoredFieldHeader.readFieldDataLength((ObjectInput)this._pageStream, (int)n5, (int)this._slotReader.slotFieldSize());
            this._bytes.write((InputStream)this._pageStream, (long)n6);
            if (n4 == 1) {
                this._overflowPage = -1L;
                this._overflowID = -1;
            } else {
                int n7 = n5;
                n5 = StoredFieldHeader.readStatus((ObjectInput)this._pageStream);
                n6 = StoredFieldHeader.readFieldDataLength((ObjectInput)this._pageStream, (int)n5, (int)this._slotReader.slotFieldSize());
                if (!StoredFieldHeader.isOverflow((int)n5)) {
                    throw new IOException("Corrupt overflow chain on page " + this._overflowPage);
                }
                this._overflowPage = CompressedNumber.readLong((InputStream)this._pageStream);
                this._overflowID = CompressedNumber.readInt((InputStream)this._pageStream);
            }
        }

        private int findRecordById(int n, int n2, int n3) {
            if (n2 == 0) {
                n2 = n - 6;
            }
            if (n2 > 0 && n2 < n3 && n == this._slotReader.getRecordHeader(n2, this._currentPageData).getId()) {
                return n2;
            }
            for (int i = 0; i < n3; ++i) {
                if (n != this._slotReader.getRecordHeader(i, this._currentPageData).getId()) continue;
                return i;
            }
            return -1;
        }
    }

    public static class SlotReader {
        private int _pageSize;
        private int _slotTableOffsetToFirstEntry;
        private int _slotTableOffsetToFirstRecordLengthField;
        private int _slotTableOffsetToFirstReservedSpaceField;
        private int _slotFieldSize;
        private int _slotEntrySize;

        public SlotReader(int n) {
            this._pageSize = n;
            this._slotFieldSize = this.calculateSlotFieldSize(this._pageSize);
            this._slotEntrySize = 3 * this._slotFieldSize;
            this._slotTableOffsetToFirstEntry = this._pageSize - 8 - this._slotEntrySize;
            this._slotTableOffsetToFirstRecordLengthField = this._slotTableOffsetToFirstEntry + this._slotFieldSize;
            this._slotTableOffsetToFirstReservedSpaceField = this._slotTableOffsetToFirstEntry + 2 * this._slotFieldSize;
        }

        public int slotFieldSize() {
            return this._slotFieldSize;
        }

        public int pageSize() {
            return this._pageSize;
        }

        public int getRecordOffset(int n, byte[] byArray) {
            byte[] byArray2 = byArray;
            int n2 = this._slotTableOffsetToFirstEntry - n * this._slotEntrySize;
            return this._slotFieldSize == 2 ? (byArray2[n2++] & 0xFF) << 8 | byArray2[n2] & 0xFF : (byArray2[n2++] & 0xFF) << 24 | (byArray2[n2++] & 0xFF) << 16 | (byArray2[n2++] & 0xFF) << 8 | byArray2[n2] & 0xFF;
        }

        private StoredRecordHeader getRecordHeader(int n, byte[] byArray) {
            return new StoredRecordHeader(byArray, this.getRecordOffset(n, byArray));
        }

        private int calculateSlotFieldSize(int n) {
            if (n < 65536) {
                return 2;
            }
            return 4;
        }
    }

    public static final class PageHeader {
        private boolean _isOverFlowPage;
        private byte _pageStatus;
        private long _pageVersion;
        private int _slotsInUse;
        private int _nextRecordID;
        private int _pageGeneration;
        private int _previousGeneration;
        private long _beforeImagePageLocation;
        private int _deletedRowCount;

        private PageHeader(DataInputStream dataInputStream) throws IOException {
            this._isOverFlowPage = dataInputStream.readBoolean();
            this._pageStatus = dataInputStream.readByte();
            this._pageVersion = dataInputStream.readLong();
            this._slotsInUse = dataInputStream.readUnsignedShort();
            this._nextRecordID = dataInputStream.readInt();
            this._pageGeneration = dataInputStream.readInt();
            this._previousGeneration = dataInputStream.readInt();
            this._beforeImagePageLocation = dataInputStream.readLong();
            this._deletedRowCount = dataInputStream.readUnsignedShort();
            DataFileVTI.skipBytes(dataInputStream, 22);
        }

        public boolean isOverFlowPage() {
            return this._isOverFlowPage;
        }

        public byte getPageStatus() {
            return this._pageStatus;
        }

        public long getPageVersion() {
            return this._pageVersion;
        }

        public int getSlotsInUse() {
            return this._slotsInUse;
        }

        public int getNextRecordID() {
            return this._nextRecordID;
        }

        public int getPageGeneration() {
            return this._pageGeneration;
        }

        public int getPreviousGeneration() {
            return this._previousGeneration;
        }

        public long getBeforeImagePageLocation() {
            return this._beforeImagePageLocation;
        }

        public int getDeletedRowCount() {
            return this._deletedRowCount;
        }

        public static PageHeader readPageHeader(byte[] byArray) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = PageHeader.readPageFormatableID(dataInputStream);
            return PageHeader.readPageHeader(dataInputStream);
        }

        public static PageHeader readPageHeader(DataInputStream dataInputStream) throws IOException {
            PageHeader pageHeader = new PageHeader(dataInputStream);
            return pageHeader;
        }

        public static int readPageFormatableID(DataInputStream dataInputStream) throws IOException {
            int n = FormatIdUtil.readFormatIdInteger((DataInput)dataInputStream);
            DataFileVTI.skipBytes(dataInputStream, 2);
            return n;
        }
    }

    public static final class DataFile {
        private File _dbDirectory;
        private File _file;
        private DataTypeDescriptor[] _rowSignature;
        private CipherProvider _decryptionEngine;
        private FileInputStream _fis;
        private DataInputStream _dais;
        private long _pageCount;
        private byte[] _pageData;
        private int _pageSize;
        private SlotReader _slotReader;
        private OverflowStream _overflowStream;
        private ArrayList<SQLWarning> _warnings;

        public DataFile(File file, String string, String string2, DataTypeDescriptor[] dataTypeDescriptorArray) throws Exception {
            this._dbDirectory = file;
            this._file = new File(new File(this._dbDirectory, "seg0"), string);
            this._rowSignature = dataTypeDescriptorArray;
            this._decryptionEngine = this.makeDecryptionEngine(string2);
        }

        private CipherProvider makeDecryptionEngine(String string) throws Exception {
            if (string == null) {
                return null;
            }
            File file = new File(this._dbDirectory, "service.properties");
            Properties properties = this.unpackEncryptionProperties(string);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
            fileInputStream = new JCECipherFactoryBuilder().createCipherFactory(false, properties, false);
            return fileInputStream.createNewCipher(2);
        }

        private Properties unpackEncryptionProperties(String string) {
            String[] stringArray;
            Properties properties = new Properties();
            for (String string2 : stringArray = string.split(";")) {
                int n = string2.indexOf("=");
                if (n <= 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, string2.length());
                properties.setProperty(string3, string4);
            }
            return properties;
        }

        public void openFile() throws Exception {
            this._pageCount = 0L;
            this._fis = new FileInputStream(this._file);
            WrapperInputStream wrapperInputStream = new WrapperInputStream(this._fis);
            this._dais = new DataInputStream(wrapperInputStream);
            this.readFileHeader();
            this.skipToPageEnd(wrapperInputStream);
        }

        public void closeFile() throws Exception {
            this._dais.close();
            this._fis.close();
        }

        public ArrayList<SQLWarning> getWarnings() {
            try {
                ArrayList<SQLWarning> arrayList = this._warnings;
                return arrayList;
            }
            finally {
                this._warnings = null;
            }
        }

        private void addWarning(String string, Throwable throwable) {
            if (this._warnings == null) {
                this._warnings = new ArrayList();
            }
            this._warnings.add(new SQLWarning(string, throwable));
        }

        private void readFileHeader() throws Exception {
            this.readAllocPage(this._dais, PageHeader.readPageFormatableID(this._dais));
            ++this._pageCount;
        }

        private void skipToPageEnd(WrapperInputStream wrapperInputStream) throws Exception {
            int n = this.getRemainingBytesOnPage(wrapperInputStream);
            DataInputStream dataInputStream = new DataInputStream(wrapperInputStream);
            if (n != 0) {
                DataFileVTI.skipBytes(dataInputStream, n);
            }
        }

        private int getRemainingBytesOnPage(WrapperInputStream wrapperInputStream) {
            long l = this.currentOffsetIntoPage(wrapperInputStream);
            int n = l == 0L ? 0 : (int)((long)this._pageSize - l);
            return n;
        }

        private int currentOffsetIntoPage(WrapperInputStream wrapperInputStream) {
            return (int)(wrapperInputStream.getBytesRead() % (long)this._pageSize);
        }

        public ArrayList<DataValueDescriptor[]> readNextPage() {
            this._pageData = new byte[this._pageSize];
            try {
                this._dais.readFully(this._pageData);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof EOFException)) {
                    this.addWarning(this.formatThrowable(throwable, true), throwable);
                }
                return null;
            }
            try {
                return this.readNonHeaderPage();
            }
            catch (Throwable throwable) {
                this.addWarning(this.formatThrowable(throwable, false), throwable);
                return this.makeEmptyRowList();
            }
        }

        private ArrayList<DataValueDescriptor[]> readNonHeaderPage() throws Exception {
            ArrayList<DataValueDescriptor[]> arrayList;
            if (this._decryptionEngine != null) {
                this._pageData = DataFileVTI.decryptPage(this._decryptionEngine, this._pageData);
            }
            WrapperInputStream wrapperInputStream = new WrapperInputStream(new ByteArrayInputStream(this._pageData));
            DataInputStream dataInputStream = new DataInputStream(wrapperInputStream);
            int n = PageHeader.readPageFormatableID(dataInputStream);
            switch (n) {
                case 118: {
                    arrayList = this.readAllocPage(dataInputStream, n);
                    break;
                }
                case 117: {
                    arrayList = this.formatRows();
                    break;
                }
                default: {
                    throw new IOException("Unknown page formatable ID: " + n);
                }
            }
            ++this._pageCount;
            return arrayList;
        }

        private ArrayList<DataValueDescriptor[]> readAllocPage(DataInputStream dataInputStream, int n) throws Exception {
            if (n != 118) {
                throw new IOException("File header should start with formatable id 118 but instead starts with formatable id " + n);
            }
            PageHeader.readPageHeader(dataInputStream);
            long l = dataInputStream.readLong();
            long l2 = dataInputStream.readLong();
            DataFileVTI.skipBytes(dataInputStream, 32);
            byte by = dataInputStream.readByte();
            if (by > 0) {
                this.readContainerInfo(dataInputStream, by);
            }
            return new ArrayList<DataValueDescriptor[]>();
        }

        private void readContainerInfo(DataInputStream dataInputStream, byte by) throws Exception {
            int n = dataInputStream.readInt();
            if (n != 116) {
                throw new IOException("Container info should start with formatable id 116 but instead starts with formatable id " + n);
            }
            int n2 = dataInputStream.readInt();
            this._pageSize = dataInputStream.readInt();
            this._slotReader = new SlotReader(this._pageSize);
        }

        private ArrayList<DataValueDescriptor[]> formatRows() throws Exception {
            PageHeader pageHeader = PageHeader.readPageHeader(this._pageData);
            ArrayInputStream arrayInputStream = new ArrayInputStream(this._pageData);
            int n = pageHeader.getSlotsInUse();
            ArrayList<DataValueDescriptor[]> arrayList = this.makeEmptyRowList();
            if (pageHeader.isOverFlowPage()) {
                return arrayList;
            }
            for (int i = 0; i < n; ++i) {
                byte by = this._pageData[this._slotReader.getRecordOffset(i, this._pageData)];
                StoredRecordHeader storedRecordHeader = this._slotReader.getRecordHeader(i, this._pageData);
                int n2 = this._slotReader.getRecordOffset(i, this._pageData);
                if (storedRecordHeader.isDeleted()) continue;
                int n3 = storedRecordHeader.getNumberFields();
                arrayInputStream.setPosition(n2 += storedRecordHeader.size());
                if (n3 <= 0) continue;
                DataValueDescriptor[] dataValueDescriptorArray = this.makeEmptyRow();
                boolean bl = true;
                for (int j = 0; j < n3; ++j) {
                    int n4 = StoredFieldHeader.readStatus((ObjectInput)arrayInputStream);
                    int n5 = StoredFieldHeader.readFieldDataLength((ObjectInput)arrayInputStream, (int)n4, (int)this._slotReader.slotFieldSize());
                    int n6 = arrayInputStream.getPosition();
                    if (n5 < 0) continue;
                    if (StoredFieldHeader.isOverflow((int)n4)) {
                        int n7;
                        long l;
                        if (j == 0 && n5 != 3) {
                            n2 = arrayInputStream.getPosition() + n5;
                            l = CompressedNumber.readLong((DataInput)arrayInputStream);
                            n7 = CompressedNumber.readInt((DataInput)arrayInputStream);
                            this.printIrregularity("questionable long column");
                            arrayInputStream.setPosition(n2);
                            continue;
                        }
                        l = CompressedNumber.readLong((DataInput)arrayInputStream);
                        n7 = CompressedNumber.readInt((DataInput)arrayInputStream);
                        this.readOverflowField(i, j, n6, n5, dataValueDescriptorArray[j], l, n7);
                        continue;
                    }
                    if (n5 > 0) {
                        if (this.recordHasFirstField(by) && (n3 == 1 || n3 != this._rowSignature.length)) {
                            bl = false;
                        } else {
                            try {
                                this.readField(i, j, n6, n5, dataValueDescriptorArray[j]);
                            }
                            catch (Throwable throwable) {
                                bl = false;
                            }
                        }
                    }
                    n2 = arrayInputStream.getPosition() + n5;
                    arrayInputStream.setPosition(n2);
                }
                if (!bl) continue;
                arrayList.add(dataValueDescriptorArray);
            }
            return arrayList;
        }

        private DataValueDescriptor[] makeEmptyRow() throws Exception {
            int n = this._rowSignature.length;
            DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
            for (int i = 0; i < n; ++i) {
                dataValueDescriptorArray[i] = this._rowSignature[i].getNull();
            }
            return dataValueDescriptorArray;
        }

        private ArrayList<DataValueDescriptor[]> makeEmptyRowList() {
            return new ArrayList<DataValueDescriptor[]>();
        }

        private boolean recordHasFirstField(byte by) {
            return (by & 4) != 0;
        }

        private void readField(int n, int n2, int n3, int n4, DataValueDescriptor dataValueDescriptor) throws Exception {
            try {
                byte[] byArray = new byte[n4];
                System.arraycopy(this._pageData, n3, byArray, 0, n4);
                ArrayInputStream arrayInputStream = new ArrayInputStream(byArray);
                dataValueDescriptor.readExternalFromArray(arrayInputStream);
            }
            catch (Exception exception) {
                this.formatFieldWarning(n, n2, n3, n4, dataValueDescriptor, exception);
            }
        }

        private void readOverflowField(int n, int n2, int n3, int n4, DataValueDescriptor dataValueDescriptor, long l, int n5) throws Exception {
            try {
                OverflowStream overflowStream = this.getOverflowStream().init(l, n5);
                FormatIdInputStream formatIdInputStream = new FormatIdInputStream((InputStream)overflowStream);
                if (dataValueDescriptor instanceof StreamStorable) {
                    ((StreamStorable)dataValueDescriptor).setStream((InputStream)formatIdInputStream);
                } else {
                    dataValueDescriptor.readExternal((ObjectInput)formatIdInputStream);
                }
            }
            catch (Exception exception) {
                this.formatFieldWarning(n, n2, n3, n4, dataValueDescriptor, exception);
            }
        }

        private OverflowStream getOverflowStream() throws IOException {
            if (this._overflowStream == null) {
                this._overflowStream = new OverflowStream(new RandomAccessFile(this._file, "r"), this._decryptionEngine, this._slotReader);
            }
            return this._overflowStream;
        }

        private void formatFieldWarning(int n, int n2, int n3, int n4, DataValueDescriptor dataValueDescriptor, Throwable throwable) {
            String string = "Error reading field data. Offset = " + n3 + ", length = " + n4 + ", datatype = " + this._rowSignature[n2].getSQLstring() + ": " + this.getFieldCoordinates(n, n2) + ": " + this.formatThrowable(throwable, false);
            this.addWarning(string, throwable);
        }

        private String getFieldCoordinates(int n, int n2) {
            return "Field " + n2 + " in record " + n + this.getPageCoordinates();
        }

        private String getPageCoordinates() {
            return " on page " + this._pageCount + " in file " + this._file.getName();
        }

        private String formatThrowable(Throwable throwable, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(throwable.getClass().getName() + ": " + throwable.getMessage());
            if (bl) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                stringBuilder.append(stringWriter.toString());
            }
            return stringBuilder.toString();
        }

        private void println(String string) {
            System.out.println(string);
        }

        private void printIrregularity(String string) {
        }
    }

    public static final class LDAPService
    extends JNDIAuthenticationService {
        private Properties _dbProperties;

        public LDAPService(Properties properties) {
            this._dbProperties = properties;
        }

        public String getProperty(String string) {
            return this._dbProperties.getProperty(string);
        }
    }
}

