/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SURTest
extends SURBaseTest {
    public SURTest(String string) {
        super(string);
    }

    public void testConcurrencyModeWarning1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 order by a");
        SQLWarning sQLWarning = resultSet.getWarnings();
        SURTest.assertEquals((String)"Expected resultset to be read only", (int)1007, (int)resultSet.getConcurrency());
        this.assertWarning(sQLWarning, "01J06");
        this.scrollForward(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testConcurrencyModeWarning2() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 as table1,t1 as table2 where table1.a=table2.a");
        SQLWarning sQLWarning = resultSet.getWarnings();
        SURTest.assertEquals((String)"Expected resultset to be read only", (int)1007, (int)resultSet.getConcurrency());
        this.assertWarning(sQLWarning, "01J06");
        this.scrollForward(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testForUpdateException1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        try {
            String string = "select * from t1 order by a for update";
            statement.setCursorName(this.getNextCursorName());
            ResultSet resultSet = statement.executeQuery(string);
            SURTest.assertTrue((String)("Expected query '" + string + "' to fail"), (boolean)false);
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)"Unexpected SQLState", (String)"42Y90", (String)sQLException.getSQLState());
        }
        this.rollback();
        statement.close();
    }

    public void testForUpdateException2() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        try {
            String string = "select * from t1 as table1,t1 as table2 where table1.a=table2.a for update";
            statement.setCursorName(this.getNextCursorName());
            ResultSet resultSet = statement.executeQuery(string);
            SURTest.assertTrue((String)("Expected query '" + string + "' to fail"), (boolean)false);
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)"Unexpected SQLState", (String)"42Y90", (String)sQLException.getSQLState());
        }
        this.rollback();
        statement.close();
    }

    public void testForwardOnlyReadOnly1() throws SQLException {
        Statement statement = this.createStatement(1003, 1007);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet1() throws SQLException {
        Statement statement = this.createStatement(1003, 1007);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        this.assertFailOnUpdate(resultSet);
        statement.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet2() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 order by id");
        resultSet.next();
        this.assertFailOnUpdate(resultSet);
        statement.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet3() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 for read only");
        resultSet.next();
        this.assertFailOnUpdate(resultSet);
        statement.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet4() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1 for read only");
        resultSet.next();
        this.verifyTuple(resultSet);
        this.assertFailOnUpdate(resultSet);
        statement.close();
    }

    public void testFailOnUpdateOfReadOnlyResultSet5() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1 for read only");
        resultSet.next();
        this.verifyTuple(resultSet);
        this.assertFailOnUpdate(resultSet);
        statement.close();
    }

    public void testCursorStateAfterCommit1() throws SQLException {
        this.testCursorStateAfterCommit(false, 1003);
    }

    public void testCursorStateAfterCommit2() throws SQLException {
        this.testCursorStateAfterCommit(false, 1004);
    }

    public void testCursorStateAfterCommit3() throws SQLException {
        this.testCursorStateAfterCommit(true, 1003);
    }

    public void testCursorStateAfterCommit4() throws SQLException {
        this.testCursorStateAfterCommit(true, 1004);
    }

    private void testCursorStateAfterCommit(boolean bl, int n) throws SQLException {
        Statement statement = this.createStatement(n, 1008);
        String string = this.getNextCursorName();
        statement.setCursorName(string);
        ResultSet resultSet = statement.executeQuery("select a from t1");
        if (n == 1003) {
            for (int i = 0; i < 5; ++i) {
                resultSet.next();
            }
        } else {
            resultSet.absolute(5);
        }
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("update t1 set a=? where current of " + string);
        try {
            if (bl) {
                preparedStatement.setInt(1, -1);
                preparedStatement.executeUpdate();
                SURTest.fail((String)"Expected exception to be thrown on positioned update since cursor is not positioned");
            } else {
                resultSet.updateInt(1, -1);
                resultSet.updateRow();
                SURTest.fail((String)"Expected exception to be thrown on updateRow() since cursor is not positioned");
            }
        }
        catch (SQLException sQLException) {
            SURTest.assertSQLState("Unexpected SQLState when updating row after commit", "24000", sQLException);
        }
        if (n == 1003) {
            resultSet.next();
        } else {
            resultSet.relative(0);
        }
        if (bl) {
            preparedStatement.setInt(1, -1);
            preparedStatement.executeUpdate();
        } else {
            resultSet.updateInt(1, -1);
            resultSet.updateRow();
        }
        statement.close();
        preparedStatement.close();
    }

    public void testMultiUpdateRow1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.absolute(5);
        int n = resultSet.getInt(2);
        int n2 = resultSet.getInt(3);
        resultSet.updateInt(2, -2222);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-2222, (int)resultSet.getInt(2));
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)n, (int)resultSet.getInt(2));
        resultSet.updateInt(2, -2222);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-2222, (int)resultSet.getInt(2));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false before updateRow", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        resultSet.updateRow();
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow", (boolean)resultSet.rowUpdated());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)-2222, (int)resultSet.getInt(2));
        resultSet.updateInt(3, -3333);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-3333, (int)resultSet.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)-2222, (int)resultSet.getInt(2));
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)n2, (int)resultSet.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow after cancelRowUpdated", (int)-2222, (int)resultSet.getInt(2));
        resultSet.updateInt(3, -3333);
        resultSet.updateRow();
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateInt", (int)-3333, (int)resultSet.getInt(3));
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)-2222, (int)resultSet.getInt(2));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)-3333, (int)resultSet.getInt(3));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow and cancelRowUpdates", (boolean)resultSet.rowUpdated());
        resultSet.close();
        statement.close();
    }

    public void testMultiUpdateRow2() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.absolute(5);
        int n = resultSet.getInt(2);
        int n2 = resultSet.getInt(3);
        resultSet.updateNull(2);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)resultSet.getInt(2));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)resultSet.wasNull());
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)n, (int)resultSet.getInt(2));
        resultSet.updateNull(2);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)resultSet.getInt(2));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)resultSet.wasNull());
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false before updateRow", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        resultSet.updateRow();
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow", (boolean)resultSet.rowUpdated());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)0, (int)resultSet.getInt(2));
        resultSet.updateNull(3);
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)resultSet.getInt(3));
        SURTest.assertTrue((String)"Expected wasNull to be true after updateNull", (boolean)resultSet.wasNull());
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow", (int)0, (int)resultSet.getInt(2));
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected updateXXX to have no effect after cancelRowUpdated", (int)n2, (int)resultSet.getInt(3));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previous updateRow after cancelRowUpdated", (int)0, (int)resultSet.getInt(2));
        resultSet.updateNull(3);
        resultSet.updateRow();
        SURTest.assertEquals((String)"Expected the resultset to be updated after updateNull", (int)0, (int)resultSet.getInt(3));
        resultSet.cancelRowUpdates();
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)0, (int)resultSet.getInt(2));
        SURTest.assertEquals((String)"Expected the resultset detect the updates of previousupdateRow after cancelRowUpdates", (int)0, (int)resultSet.getInt(3));
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be true after updateRow and cancelRowUpdates", (boolean)resultSet.rowUpdated());
        resultSet.close();
        statement.close();
    }

    public void testCursorOperationConflictWarning1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        this.createStatement().executeUpdate("delete from t1 where id=" + resultSet.getString("ID"));
        int n = resultSet.getInt(2);
        resultSet.updateInt(2, -3333);
        resultSet.updateRow();
        SQLWarning sQLWarning = resultSet.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)n, (int)resultSet.getInt(2));
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!resultSet.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        resultSet.clearWarnings();
        resultSet.deleteRow();
        sQLWarning = resultSet.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        resultSet.relative(0);
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!resultSet.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)n, (int)resultSet.getInt(2));
        resultSet.close();
        statement.close();
    }

    public void testCursorOperationConflictWarning2() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        this.createStatement().executeUpdate("delete from t1 where id=" + resultSet.getString("ID"));
        int n = resultSet.getInt(2);
        Statement statement2 = this.createStatement();
        int n2 = statement2.executeUpdate("update t1 set A=-3333 where current of " + resultSet.getCursorName());
        resultSet.relative(0);
        SQLWarning sQLWarning = statement2.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!resultSet.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)n, (int)resultSet.getInt(2));
        SURTest.assertEquals((String)"Expected update count to be 0", (int)0, (int)n2);
        Statement statement3 = this.createStatement();
        n2 = statement3.executeUpdate("delete from t1 where current of " + resultSet.getCursorName());
        resultSet.relative(0);
        sQLWarning = statement3.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        SURTest.assertTrue((String)"Expected rs.rowUpdated() to be false", (!resultSet.rowUpdated() ? 1 : 0) != 0);
        SURTest.assertTrue((String)"Expected rs.rowDeleted() to be false", (!resultSet.rowDeleted() ? 1 : 0) != 0);
        SURTest.assertEquals((String)"Did not expect the resultset to be updated", (int)n, (int)resultSet.getInt(2));
        SURTest.assertEquals((String)"Expected update count to be 0", (int)0, (int)n2);
        resultSet.close();
        statement.close();
        statement2.close();
        statement3.close();
    }

    public void testIndexedUpdateCursor1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1");
        SURTest.assertTrue((String)"Expected to get a tuple on rs.next()", (boolean)resultSet.next());
        this.verifyTuple(resultSet);
        this.updateTuple(resultSet);
        statement.close();
    }

    public void testIndexedUpdateCursor2() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1 for update");
        SURTest.assertTrue((String)"Expected to get a tuple on rs.next()", (boolean)resultSet.next());
        this.verifyTuple(resultSet);
        this.updateTuple(resultSet);
        statement.close();
    }

    public void testInsertRowWithScrollCursor() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        int n = resultSet.getRow();
        resultSet.beforeFirst();
        resultSet.next();
        int n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.next();
        SURTest.assertEquals((String)("CurrentPosition should be " + (n2 + 1)), (int)resultSet.getRow(), (int)(n2 + 1));
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.relative(2);
        SURTest.assertEquals((String)("CurrentPosition should be " + (n2 + 2)), (int)resultSet.getRow(), (int)(n2 + 2));
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.absolute(6);
        SURTest.assertEquals((String)"CurrentPosition should be 6", (int)resultSet.getRow(), (int)6);
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.previous();
        SURTest.assertEquals((String)("CurrentPosition should be " + (n2 - 1)), (int)resultSet.getRow(), (int)(n2 - 1));
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.first();
        SURTest.assertEquals((String)"CurrentPosition should be 1", (int)resultSet.getRow(), (int)1);
        SURTest.assertTrue((String)"isFirst() should return true", (boolean)resultSet.isFirst());
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.last();
        SURTest.assertEquals((String)("CurrentPosition should be " + n), (int)resultSet.getRow(), (int)n);
        SURTest.assertTrue((String)"isLast() should return true", (boolean)resultSet.isLast());
        resultSet.deleteRow();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.beforeFirst();
        SURTest.assertTrue((String)"isBeforeFirst() should return true", (boolean)resultSet.isBeforeFirst());
        resultSet.next();
        SURTest.assertEquals((String)"CurrentPosition should be 1", (int)resultSet.getRow(), (int)1);
        SURTest.assertTrue((String)"isFirst() should return true", (boolean)resultSet.isFirst());
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.afterLast();
        SURTest.assertTrue((String)"isAfterLast() should return true", (boolean)resultSet.isAfterLast());
        resultSet.previous();
        SURTest.assertEquals((String)("CurrentPosition should be " + n), (int)resultSet.getRow(), (int)n);
        SURTest.assertTrue((String)"isLast() should return true", (boolean)resultSet.isLast());
        resultSet.previous();
        n2 = resultSet.getRow();
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, n2 + 1000);
        resultSet.insertRow();
        resultSet.moveToCurrentRow();
        SURTest.assertEquals((String)("CurrentPosition should be " + n2), (int)resultSet.getRow(), (int)n2);
        try {
            resultSet.moveToInsertRow();
            resultSet.updateInt(1, n2 + 2000);
            resultSet.updateRow();
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)"Expected exception", (String)sQLException.getSQLState().substring(0, 5), (String)"24000");
        }
        try {
            resultSet.moveToInsertRow();
            resultSet.updateInt(1, n2 + 2000);
            resultSet.deleteRow();
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)"Expected exception", (String)sQLException.getSQLState().substring(0, 5), (String)"24000");
        }
        try {
            resultSet.moveToCurrentRow();
            resultSet.updateInt(1, n2 + 2000);
            resultSet.insertRow();
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)"Expected exception", (String)sQLException.getSQLState().substring(0, 5), (String)"XJ086");
        }
        resultSet.close();
        statement.close();
    }

    public void testIndexedScrollInsensitiveUpdateCursorWithoutForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1 or a=2");
        resultSet.next();
        resultSet.next();
        resultSet.previous();
        this.verifyTuple(resultSet);
        this.updateTuple(resultSet);
        statement.close();
    }

    public void testIndexedScrollInsensitiveUpdateCursorWithForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 where a=1 or a=2 for update");
        resultSet.next();
        resultSet.next();
        resultSet.previous();
        this.verifyTuple(resultSet);
        this.updateTuple(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testPrimaryKeyUpdate1() throws SQLException {
        int n;
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        resultSet.next();
        while (resultSet.previous()) {
            int n2 = resultSet.getInt(1);
            if (n2 % 2 != 0) continue;
            n = -n2;
            resultSet.updateInt(1, n);
            resultSet.updateRow();
        }
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where id=?");
        for (n = 0; n < this.recordCount; ++n) {
            int n3 = n % 2 == 0 ? -n : n;
            preparedStatement.setInt(1, n3);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)resultSet2.next());
            SURTest.println("T1: Read Tuple:(" + resultSet2.getInt(1) + "," + resultSet2.getInt(2) + "," + resultSet2.getInt(3) + ")");
            SURTest.assertEquals((String)"Unexpected value of id", (int)n3, (int)resultSet2.getInt(1));
            SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next returned another row", (!resultSet2.next() ? 1 : 0) != 0);
        }
        statement.close();
        preparedStatement.close();
    }

    public void testOtherPrimaryKeyUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        int n = resultSet.getInt(1);
        PreparedStatement preparedStatement = this.prepareStatement("update t1 set id = ? where id= ?");
        preparedStatement.setInt(1, -n);
        preparedStatement.setInt(2, n);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)preparedStatement.executeUpdate());
        resultSet.updateInt(2, -555);
        resultSet.updateInt(3, -777);
        resultSet.updateRow();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from t1 where id=?");
        preparedStatement2.setInt(1, -n);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)resultSet2.next());
        SURTest.println("T1: Read Tuple:(" + resultSet2.getInt(1) + "," + resultSet2.getInt(2) + "," + resultSet2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected a=-555", (int)-555, (int)resultSet2.getInt(2));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)resultSet2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!resultSet2.next() ? 1 : 0) != 0);
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testOtherAndOwnPrimaryKeyUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        int n = resultSet.getInt(1);
        PreparedStatement preparedStatement = this.prepareStatement("update t1 set id = ? where id= ?");
        preparedStatement.setInt(1, -n);
        preparedStatement.setInt(2, n);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)preparedStatement.executeUpdate());
        resultSet.updateInt(1, n * 10);
        resultSet.updateInt(2, -555);
        resultSet.updateInt(3, -777);
        resultSet.updateRow();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from t1 where id=?");
        preparedStatement2.setInt(1, n * 10);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)resultSet2.next());
        SURTest.println("T1: Read Tuple:(" + resultSet2.getInt(1) + "," + resultSet2.getInt(2) + "," + resultSet2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected a=-555", (int)-555, (int)resultSet2.getInt(2));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)resultSet2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!resultSet2.next() ? 1 : 0) != 0);
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testMultipleKeyUpdates() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        int n = resultSet.getInt(1);
        PreparedStatement preparedStatement = statement.getConnection().prepareStatement("update t1 set id = ? where id= ?");
        preparedStatement.setInt(1, -n);
        preparedStatement.setInt(2, n);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)preparedStatement.executeUpdate());
        preparedStatement.close();
        resultSet.updateInt(1, n * 10);
        resultSet.updateInt(2, -555);
        resultSet.updateInt(3, -777);
        resultSet.updateRow();
        resultSet.first();
        resultSet.last();
        for (int i = 0; i < 10; ++i) {
            resultSet.first();
            resultSet.last();
            resultSet.next();
            resultSet.previous();
            resultSet.updateInt(1, n * 10 + i);
            resultSet.updateInt(2, -555 - i);
            resultSet.updateInt(3, -777 - i);
            resultSet.updateRow();
        }
        resultSet.close();
        statement.close();
    }

    public void testSecondaryIndexKeyUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        resultSet.next();
        int n = 0;
        while (resultSet.previous()) {
            resultSet.updateInt(2, n--);
            resultSet.updateRow();
        }
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where a=?");
        for (int i = 0; i < this.recordCount; ++i) {
            int n2 = -i;
            preparedStatement.setInt(1, n2);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)resultSet2.next());
            SURTest.println("T1: Read Tuple:(" + resultSet2.getInt(1) + "," + resultSet2.getInt(2) + "," + resultSet2.getInt(3) + ")");
            SURTest.assertEquals((String)"Unexpected value of id", (int)n2, (int)resultSet2.getInt(2));
            SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next returned another row", (!resultSet2.next() ? 1 : 0) != 0);
        }
        statement.close();
        preparedStatement.close();
    }

    public void testOtherSecondaryKeyUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.last();
        int n = resultSet.getInt(2);
        PreparedStatement preparedStatement = this.prepareStatement("update t1 set a = ? where a= ?");
        preparedStatement.setInt(1, -n);
        preparedStatement.setInt(2, n);
        SURTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)preparedStatement.executeUpdate());
        resultSet.updateInt(1, -555);
        resultSet.updateInt(3, -777);
        resultSet.updateRow();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from t1 where a=?");
        preparedStatement2.setInt(1, -n);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        SURTest.assertTrue((String)"Expected query to have 1 row", (boolean)resultSet2.next());
        SURTest.println("T1: Read Tuple:(" + resultSet2.getInt(1) + "," + resultSet2.getInt(2) + "," + resultSet2.getInt(3) + ")");
        SURTest.assertEquals((String)"Expected id=-555", (int)-555, (int)resultSet2.getInt(1));
        SURTest.assertEquals((String)"Expected b=-777", (int)-777, (int)resultSet2.getInt(3));
        SURTest.assertTrue((String)"Did not expect more than 1 row, however rs2.next() returned another row", (!resultSet2.next() ? 1 : 0) != 0);
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testScrollInsensitiveReadOnly1() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        this.scrollBackward(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testForwardOnlyConcurUpdatableWithForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testForwardOnlyConcurUpdatableWithoutForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testPositionedUpdateWithoutForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("MYCURSOR");
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForwardAndUpdatePositioned(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testPositionedUpdateWithForUpdate1() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdatePositioned(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testScrollablePositionedUpdateWithForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        statement.setCursorName("MYCURSOR");
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.previous();
        resultSet.next();
        SURTest.assertEquals((String)"Expecting to be on the same row after previous() + next() ", (int)n, (int)resultSet.getInt(1));
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((String)"Expecting to be on the same row after next() + previous()", (int)n, (int)resultSet.getInt(1));
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        SURTest.println(resultSet.getCursorName());
        PreparedStatement preparedStatement = this.prepareStatement("update T1 set a=?,b=? where current of " + resultSet.getCursorName());
        preparedStatement.setInt(1, 666);
        preparedStatement.setInt(2, 777);
        preparedStatement.executeUpdate();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((String)"Expected to be on the same row after next() + previous()", (int)n, (int)resultSet.getInt(1));
        SURTest.assertEquals((String)"Expected row to be updated by own change,  however did not get updated value for column a", (int)666, (int)resultSet.getInt(2));
        SURTest.assertEquals((String)"Expected row to be updated by own change, however did not get updated value for column b", (int)777, (int)resultSet.getInt(3));
        resultSet.close();
        statement.setCursorName(this.getNextCursorName());
        resultSet = statement.executeQuery("select * from t1 order by b");
        while (resultSet.next()) {
            if (resultSet.getInt(1) == n) {
                SURTest.assertEquals((String)("Expected row with primary key = " + n + " to be updated"), (int)666, (int)resultSet.getInt(2));
                SURTest.assertEquals((String)("Expected row with primary key = " + n + " to be updated"), (int)777, (int)resultSet.getInt(3));
                continue;
            }
            SURTest.println("Got tuple (" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + "," + resultSet.getString(4) + ")");
        }
        statement.close();
        preparedStatement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        this.scrollForwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate2() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        SURTest.assertEquals((String)"Invalid resultset concurrency on statement", (int)1008, (int)statement.getResultSetConcurrency());
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        SURTest.assertEquals((String)"Invalid resultset concurrency on resultset", (int)1008, (int)resultSet.getConcurrency());
        this.scrollForward(resultSet);
        this.scrollBackwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    private void testScrollInsensistiveConurUpdatable3(ResultSet resultSet) throws SQLException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        while (resultSet.next()) {
        }
        while (resultSet.previous()) {
            n5 = resultSet.getInt(1);
            n4 = resultSet.getInt(2);
            n3 = n4 - 17 - n5;
            n2 = 1000;
            n = n3 + n2 + 17;
            resultSet.updateInt(1, n2);
            resultSet.updateInt(2, n);
            resultSet.updateRow();
            SURTest.assertEquals((String)"Expected a to be 1000", (int)1000, (int)resultSet.getInt(1));
        }
        n5 = 0;
        while (resultSet.next()) {
            n4 = resultSet.getInt(1);
            SURTest.assertEquals((String)("Incorrect row updated for row " + ++n5), (int)1000, (int)n4);
        }
        SURTest.assertEquals((String)"Expected count to be the same as number of records", (int)this.recordCount, (int)n5);
        while (resultSet.previous()) {
            n4 = resultSet.getInt(1);
            SURTest.assertEquals((String)("Incorrect row updated for row " + --n5), (int)1000, (int)n4);
        }
        resultSet.close();
        Statement statement = this.createStatement(1003, 1007);
        statement.setCursorName(this.getNextCursorName());
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            n3 = resultSet.getInt(1);
            n2 = resultSet.getInt(2);
            n = resultSet.getInt(3);
            SURTest.println("Updated tuple:" + n3 + "," + n2 + "," + n);
        }
        statement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithForUpdate3() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select a,b from t1 for update");
        this.testScrollInsensistiveConurUpdatable3(resultSet);
        statement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate1() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate2() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        this.scrollBackwardAndUpdate(resultSet);
        resultSet.close();
        statement.close();
    }

    public void testScrollInsensitiveConcurUpdatableWithoutForUpdate3() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select a,b from t1");
        this.testScrollInsensistiveConurUpdatable3(resultSet);
        statement.close();
    }

    public void testForUpdateWithColumnList() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select c from t1 for update of c");
        resultSet.next();
        resultSet.updateString(1, "foobar");
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((String)"foobar", (String)resultSet.getString(1));
        resultSet.close();
        resultSet = statement.executeQuery("select id from t1 for update of id");
        resultSet.next();
        resultSet.updateInt(1, 20);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select * from t1 for update of id");
        resultSet.next();
        resultSet.updateInt(1, 20);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * from t1 for update of c");
        resultSet.next();
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        resultSet.updateString(4, "foobar");
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)n, (int)resultSet.getInt(1));
        SURTest.assertEquals((int)n2, (int)resultSet.getInt(2));
        SURTest.assertEquals((int)n3, (int)resultSet.getInt(3));
        SURTest.assertEquals((String)"foobar", (String)resultSet.getString(4));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * from t1 for update of id,a,b,c");
        resultSet.next();
        resultSet.updateInt(1, -20);
        resultSet.updateInt(2, 20);
        resultSet.updateInt(3, 21);
        resultSet.updateString(4, "foobar");
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)-20, (int)resultSet.getInt(1));
        SURTest.assertEquals((int)20, (int)resultSet.getInt(2));
        SURTest.assertEquals((int)21, (int)resultSet.getInt(3));
        SURTest.assertEquals((String)"foobar", (String)resultSet.getString(4));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * from t1 for update of id, a,b,c");
        resultSet.next();
        resultSet.updateInt(1, 20);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT id from t1 for update of id, c");
        String string = resultSet.getCursorName();
        resultSet.next();
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("update t1 set c='foobar' where current of " + string);
        statement2.close();
        resultSet.next();
        resultSet.previous();
        resultSet.getInt(1);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT id from t1 for update");
        string = resultSet.getCursorName();
        resultSet.next();
        statement2 = this.createStatement();
        statement2.executeUpdate("update t1 set c='foobar' where current of " + string);
        statement2.close();
        resultSet.next();
        resultSet.previous();
        resultSet.getInt(1);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT id,a,id from t1");
        resultSet.next();
        resultSet.updateInt(1, 20);
        resultSet.updateRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        SURTest.assertEquals((int)20, (int)resultSet.getInt(3));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT id,a,id from t1 for update of id");
        resultSet.next();
        try {
            resultSet.updateInt(3, 20);
            SURTest.fail((String)"should fail");
        }
        catch (SQLException sQLException) {
            String string2 = SURTest.usingEmbedded() ? "42X31" : "XJ124";
            SURTest.assertSQLState(string2, sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT id,a,id from t1 for update");
        resultSet.next();
        resultSet.updateInt(3, 20);
        resultSet.updateRow();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        SURTest.assertEquals((int)20, (int)resultSet.getInt(3));
        resultSet.next();
        resultSet.previous();
        SURTest.assertEquals((int)20, (int)resultSet.getInt(1));
        SURTest.assertEquals((int)20, (int)resultSet.getInt(3));
        resultSet.close();
        statement.close();
    }

    private void checkDetectabilityCallsOutsideRow(ResultSet resultSet, String string) {
        boolean bl;
        try {
            bl = resultSet.rowUpdated();
            SURTest.fail((String)("rowUpdated while " + string + " did not throw exception: " + bl));
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)sQLException.getSQLState(), (String)"24000");
        }
        try {
            bl = resultSet.rowDeleted();
            SURTest.fail((String)("rowdeleted while " + string + " did not throw exception: " + bl));
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)sQLException.getSQLState(), (String)"24000");
        }
        try {
            bl = resultSet.rowInserted();
            SURTest.fail((String)("rowInserted while " + string + " did not throw exception: " + bl));
        }
        catch (SQLException sQLException) {
            SURTest.assertEquals((String)sQLException.getSQLState(), (String)"24000");
        }
    }

    public void testRowUpdatedAndRowDeleted() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        statement.setCursorName(this.getNextCursorName());
        ResultSet resultSet = statement.executeQuery("select a,b from t1");
        resultSet.next();
        resultSet.updateInt(1, resultSet.getInt(1) + 2 * this.recordCount);
        resultSet.updateRow();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)resultSet.rowUpdated());
        resultSet.deleteRow();
        resultSet.next();
        resultSet.previous();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)resultSet.rowUpdated());
        SURTest.assertTrue((String)"Expected rowDeleted() to return true", (boolean)resultSet.rowDeleted());
        resultSet.next();
        SURTest.assertFalse((String)"Expected rowUpdated() to return false", (boolean)resultSet.rowUpdated());
        SURTest.assertFalse((String)"Expected rowDeleted() to return false", (boolean)resultSet.rowDeleted());
        resultSet.previous();
        SURTest.assertTrue((String)"Expected rowUpdated() to return true", (boolean)resultSet.rowUpdated());
        SURTest.assertTrue((String)"Expected rowDeleted() to return true", (boolean)resultSet.rowDeleted());
        resultSet.close();
        statement.close();
    }

    public void testDetectabilityExceptions() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.checkDetectabilityCallsOutsideRow(resultSet, "before positioning");
        resultSet.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on insertRow before positioning");
        resultSet.next();
        resultSet.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on insertRow");
        resultSet.moveToCurrentRow();
        resultSet.beforeFirst();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on beforeFirst row");
        resultSet.afterLast();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on afterLast row");
        resultSet.first();
        resultSet.deleteRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "after deleteRow");
        resultSet.last();
        resultSet.deleteRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "after deleteRow of last row");
        resultSet.close();
        statement.close();
        statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("select * from t1");
        this.checkDetectabilityCallsOutsideRow(resultSet, "before FO positioning");
        resultSet.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on insertRow before FO positioning");
        resultSet.next();
        resultSet.moveToInsertRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "on FO insertRow");
        resultSet.next();
        resultSet.updateInt(2, 666);
        resultSet.updateRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "after FO updateRow");
        resultSet.next();
        resultSet.deleteRow();
        this.checkDetectabilityCallsOutsideRow(resultSet, "after FO deleteRow");
        while (resultSet.next()) {
        }
        this.checkDetectabilityCallsOutsideRow(resultSet, "after FO emptied out");
        resultSet.close();
        statement.close();
    }

    public void testDowngradeToScrollReadOnly() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1 order by b");
        this.assertWarning(resultSet.getWarnings(), "01J06");
        resultSet.next();
        resultSet.next();
        resultSet.previous();
        resultSet.relative(1);
        resultSet.absolute(3);
        resultSet.relative(-1);
        resultSet.first();
        resultSet.last();
        resultSet.beforeFirst();
        resultSet.afterLast();
        resultSet.close();
        statement.close();
    }

    private final String getNextCursorName() {
        return "MYCURSOR";
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SURTest");
        baseTestSuite.addTest(SURTest.baseSuite("SURTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(SURTest.baseSuite("SURTest:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        for (SURDataModelSetup.SURDataModel sURDataModel : SURDataModelSetup.SURDataModel.values()) {
            BaseTestSuite baseTestSuite2 = new BaseTestSuite(SURTest.class);
            SURDataModelSetup sURDataModelSetup = new SURDataModelSetup((Test)baseTestSuite2, sURDataModel);
            baseTestSuite.addTest((Test)sURDataModelSetup);
        }
        return baseTestSuite;
    }
}

