/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.ClasspathSetup;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.LoginTimeoutTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class DatabaseClassLoadingTest
extends BaseJDBCTestCase {
    public DatabaseClassLoadingTest(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        BaseTestSuite baseTestSuite;
        Object object = baseTestSuite = new BaseTestSuite("DatabaseClassLoadingTest");
        if (JDBC.vmSupportsJDBC3()) {
            String[] stringArray = new String[]{"testJarHandling", "testWithNoInstalledJars", "testWithNoClasspath", "testSetClasspath", "testAddContact", "testGetResource", "testAlterTable", "testClassPathRollback", "testReplaceJar", "testReplacedClass", "testSecondJar", "testSignedJar", "testCreateDatabaseJar", "testHackedJarReplacedClass", "testInvalidJar", "testRemoveJar", "testLoadJavaClassIndirectly", "testLoadJavaClassDirectly", "testLoadJavaClassDirectly2", "testLoadJavaClassDirectly3", "testLoadDerbyClassIndirectly", "testIndirectLoading", "testTableFunctionInJar", "testUDAInJar", "test_5352"};
            for (int i = 0; i < stringArray.length; ++i) {
                baseTestSuite.addTest((Test)new DatabaseClassLoadingTest(stringArray[i]));
            }
            baseTestSuite.addTest((Test)new DatabaseClassLoadingTest("testDatabaseInJar"));
            if (ClasspathSetup.supportsClose()) {
                baseTestSuite.addTest((Test)new ClasspathSetup((Test)new DatabaseClassLoadingTest("testDatabaseInClasspath"), SupportFilesSetup.getReadOnlyURL("dclt.jar")));
            }
            baseTestSuite.addTest(SecurityManagerSetup.noSecurityManager((Test)new DatabaseClassLoadingTest("testClassLoadOrdering")));
            baseTestSuite.addTest(DatabaseClassLoadingTest.loginTimeoutSuite());
            object = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/lang/dcl_emc1.jar", "functionTests/tests/lang/dcl_emcaddon.jar", "functionTests/tests/lang/dcl_emc2.jar", "functionTests/tests/lang/dcl_emc2s.jar", "functionTests/tests/lang/dcl_emc2sm.jar", "functionTests/tests/lang/dcl_emc2l.jar", "functionTests/tests/lang/dcl_java.jar", "functionTests/tests/lang/dcl_ot1.jar", "functionTests/tests/lang/dcl_ot2.jar", "functionTests/tests/lang/dcl_ot3.jar", "functionTests/tests/lang/dcl_id.jar", "functionTests/tests/lang/dummy_vti.jar", "functionTests/tests/lang/median_uda.jar"});
        }
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create schema emc");
                statement.executeUpdate("create schema \"emcAddOn\"");
                statement.executeUpdate("create table emc.contacts (id int primary key, e_mail varchar(30))");
                statement.executeUpdate("create procedure EMC.ADDCONTACT(id INT, e_mail VARCHAR(30)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.databaseclassloader.emc.addContact' language java parameter style java");
                statement.executeUpdate("create function EMC.GETARTICLE(path VARCHAR(60)) RETURNS VARCHAR(256) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.emc.getArticle' language java parameter style java");
                statement.executeUpdate("CREATE FUNCTION EMC.GETSIGNERS(CLASS_NAME VARCHAR(256)) RETURNS VARCHAR(60) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.databaseclassloader.emc.getSigners'");
                statement.executeUpdate("CREATE FUNCTION \"emcAddOn\".VALIDCONTACT(E_MAIL VARCHAR(30)) RETURNS SMALLINT READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.databaseclassloader.addon.vendor.util.valid'");
            }
        };
    }

    private static Test loginTimeoutSuite() throws Exception {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Class loading with login timeout");
        baseTestSuite.addTest((Test)new DatabaseClassLoadingTest("testLoginTimeoutNotInClasspath"));
        if (ClasspathSetup.supportsClose()) {
            baseTestSuite.addTest((Test)new ClasspathSetup((Test)new DatabaseClassLoadingTest("testLoginTimeoutInClasspath"), SupportFilesSetup.getReadOnlyURL("dclt.jar")));
        }
        baseTestSuite.addTest((Test)new DatabaseClassLoadingTest("testLoginTimeoutNotInClasspath"));
        return new LoginTimeoutTestSetup((Test)baseTestSuite, 100);
    }

    public void testWithNoInstalledJars() throws SQLException {
        try {
            this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            DatabaseClassLoadingTest.fail((String)"prepareCall on procedure with path to class");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("42X51", sQLException);
        }
        try {
            this.prepareStatement("VALUES EMC.GETARTICLE(?)");
            DatabaseClassLoadingTest.fail((String)"prepareCall on function with path to class");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("42X51", sQLException);
        }
    }

    public void testJarHandling() throws SQLException, MalformedURLException {
        this.installJar("dcl_emc1.jar", "EMC.MAIL_APP_JHT");
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP_JHT");
        this.removeJar("EMC.MAIL_APP_JHT");
    }

    public void testWithNoClasspath() throws SQLException, MalformedURLException {
        this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
        this.testWithNoInstalledJars();
    }

    public void testSetClasspath() throws SQLException {
        this.setDBClasspath("EMC.MAIL_APP");
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 0);
        callableStatement.setString(2, "now@classpathchange.com");
        callableStatement.executeUpdate();
        callableStatement.close();
        this.derby2035Workaround();
    }

    public void testAddContact() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 1);
        callableStatement.setString(2, "bill@ruletheworld.com");
        callableStatement.executeUpdate();
        callableStatement.setInt(1, 2);
        callableStatement.setString(2, "penguin@antartic.com");
        callableStatement.executeUpdate();
        callableStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT id, e_mail from EMC.CONTACTS ORDER BY 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0", "now@classpathchange.com"}, {"1", "bill@ruletheworld.com"}, {"2", "penguin@antartic.com"}});
        statement.close();
    }

    public void testGetResource() throws SQLException {
        DatabaseClassLoadingTest.getResourceTests(this.getConnection());
    }

    private static void getResourceTests(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES EMC.GETARTICLE(?)");
        preparedStatement.setString(1, "graduate.txt");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "The Apache Foundation has released the first version of the open-source Derby database, which also gained support from Sun Microsystems.");
        preparedStatement.setString(1, "/article/release.txt");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "The Apache Derby development community is pleased to announce its first release after graduating from the Apache Incubator, Apache Derby 10.1.1.0.");
        preparedStatement.setString(1, "barney.txt");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "/article/fred.txt");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "emc.class");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "/org/apache/derbyTesting/databaseclassloader/emc.class");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
    }

    public void testAlterTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("ALTER TABLE EMC.CONTACTS ADD COLUMN OK SMALLINT");
        JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}});
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 3);
        callableStatement.setString(2, "big@blue.com");
        callableStatement.executeUpdate();
        callableStatement.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}});
        statement.close();
    }

    public void testClassPathRollback() throws SQLException, MalformedURLException {
        this.getConnection().setAutoCommit(false);
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP");
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 99);
        callableStatement.setString(2, "wormspam@soil.com");
        callableStatement.executeUpdate();
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS WHERE ID = 99"), new String[][]{{"99", "wormspam@soil.com", "0"}});
        this.rollback();
        this.getConnection().setAutoCommit(true);
        callableStatement.executeUpdate();
        callableStatement.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS WHERE ID = 99"), new String[][]{{"99", "wormspam@soil.com", null}});
        statement.executeUpdate("DELETE FROM EMC.CONTACTS WHERE ID = 99");
        statement.close();
    }

    public void testReplaceJar() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP");
    }

    public void testReplacedClass() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        callableStatement.setInt(1, 4);
        callableStatement.setString(2, "spammer@ripoff.com");
        callableStatement.executeUpdate();
        callableStatement.setInt(1, 5);
        callableStatement.setString(2, "open@source.org");
        callableStatement.executeUpdate();
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
        statement.close();
    }

    public void testSecondJar() throws SQLException, MalformedURLException {
        this.installJar("dcl_emcaddon.jar", "\"emcAddOn\".\"MailAddOn\"");
        this.setDBClasspath("EMC.MAIL_APP:\"emcAddOn\".\"MailAddOn\"");
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT E_MAIL, \"emcAddOn\".VALIDCONTACT(E_MAIL) FROM EMC.CONTACTS ORDER BY 1"), new String[][]{{"big@blue.com", "0"}, {"bill@ruletheworld.com", "0"}, {"now@classpathchange.com", "0"}, {"open@source.org", "1"}, {"penguin@antartic.com", "0"}, {"spammer@ripoff.com", "0"}});
        statement.close();
    }

    public void testSignedJar() throws SQLException, MalformedURLException {
        PreparedStatement preparedStatement = this.prepareStatement("VALUES EMC.GETSIGNERS(?)");
        preparedStatement.setString(1, "org.apache.derbyTesting.databaseclassloader.emc");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        this.replaceJar("dcl_emc2s.jar", "EMC.MAIL_APP");
        preparedStatement.close();
        DatabaseClassLoadingTest.signersTests(this.getConnection());
    }

    private static void signersTests(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES EMC.GETSIGNERS(?)");
        preparedStatement.setString(1, "org.apache.derbyTesting.databaseclassloader.emc");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "CN=EMC CTO, OU=EMC APP, O=Easy Mail Company, C=US");
        preparedStatement.setString(1, "org.apache.derbyTesting.databaseclassloader.addon.vendor.util");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.close();
    }

    public void testHackedJarReplacedClass() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2sm.jar", "EMC.MAIL_APP");
        try {
            CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            callableStatement.setInt(1, 99);
            callableStatement.setString(2, "spamking@cracker.org");
            callableStatement.executeUpdate();
            callableStatement.close();
            DatabaseClassLoadingTest.fail((String)"procedure call worked on hacked jar");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("Class load should fail due to invalid signature", "42X51", sQLException);
        }
    }

    public void testInvalidJar() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2l.jar", "EMC.MAIL_APP");
        try {
            CallableStatement callableStatement = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            callableStatement.setInt(1, 999);
            callableStatement.setString(2, "spamking2@cracker.org");
            callableStatement.executeUpdate();
            callableStatement.close();
            DatabaseClassLoadingTest.fail((String)"procedure call worked on invalid jar");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("Class load should fail due to invalid jar", "42X51", sQLException);
        }
    }

    public void testRemoveJar() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        callableStatement.setString(1, "EMC.MAIL_APP");
        try {
            callableStatement.executeUpdate();
            DatabaseClassLoadingTest.fail((String)"REMOVE_JAR on jar in derby.database.classpath worked");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("X0X07", sQLException);
        }
        this.setDBClasspath("\"emcAddOn\".\"MailAddOn\"");
        this.testWithNoInstalledJars();
        callableStatement.executeUpdate();
        this.testWithNoInstalledJars();
        this.setDBClasspath(null);
        callableStatement.setString(1, "\"emcAddOn\".\"MailAddOn\"");
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    public void testCreateDatabaseJar() throws Exception {
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        callableStatement.executeUpdate();
        callableStatement.close();
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT(?)");
        final File file = SupportFilesSetup.getReadWrite("dbreadonly");
        callableStatement.setString(1, file.getPath());
        callableStatement.executeUpdate();
        callableStatement.close();
        final String string = this.getTestConfiguration().getDefaultDatabaseName();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                DatabaseClassLoadingTest.createArchive("dclt.jar", new File(file, string), "dbro");
                return null;
            }
        });
    }

    public void testDatabaseInJar() throws SQLException {
        File file = SupportFilesSetup.getReadOnly("dclt.jar");
        String string = "jar:(" + PrivilegedFileOpsForTests.getAbsolutePath(file) + ")dbro";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        DatabaseClassLoadingTest.readOnlyTest(dataSource);
    }

    public void testDatabaseInClasspath() throws SQLException {
        String string = "classpath:dbro";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        DatabaseClassLoadingTest.readOnlyTest(dataSource);
    }

    public void testLoadJavaClassIndirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("org.apache.derbyTesting.databaseclassloader.cracker.C1.simple", "38000");
    }

    public void testLoadJavaClassDirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("java.sql.J1.simple", "XJ001");
    }

    public void testLoadJavaClassDirectly2() throws SQLException, MalformedURLException {
        this.loadJavaClass("java.derby99.J2.simple", "XJ001");
    }

    public void testLoadJavaClassDirectly3() throws SQLException, MalformedURLException {
        this.loadJavaClass("javax.derby99.J3.simple", "XJ001");
    }

    public void testLoadDerbyClassIndirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("org.apache.derbyTesting.databaseclassloader.cracker.C1.derby", "38000");
    }

    private void loadJavaClass(String string, String string2) throws SQLException, MalformedURLException {
        String string3 = "EMC.MY_JAVA";
        this.installJar("dcl_java.jar", string3);
        this.setDBClasspath(string3);
        Statement statement = this.createStatement();
        statement.execute("CREATE PROCEDURE C1() LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME '" + string + "'");
        try {
            statement.execute("CALL C1()");
            DatabaseClassLoadingTest.fail((String)"Call to procedure loading java class from installed jar");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState(string2, sQLException);
        }
        statement.execute("DROP PROCEDURE C1");
        statement.close();
        this.setDBClasspath(null);
        this.removeJar(string3);
    }

    private static void readOnlyTest(DataSource dataSource) throws SQLException {
        try {
            Connection connection = dataSource.getConnection();
            Statement statement = connection.createStatement();
            JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
            JDBC.assertFullResultSet(statement.executeQuery("SELECT id, e_mail, \"emcAddOn\".VALIDCONTACT(e_mail) from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", "0"}, {"1", "bill@ruletheworld.com", "0"}, {"2", "penguin@antartic.com", "0"}, {"3", "big@blue.com", "0"}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
            DatabaseClassLoadingTest.assertStatementError("25502", statement, "INSERT INTO EMC.CONTACTS values(3, 'no@is_read_only.gov', NULL)");
            DatabaseClassLoadingTest.assertStatementError("25502", statement, "CALL EMC.ADDCONTACT(3, 'really@is_read_only.gov')");
            DatabaseClassLoadingTest.getResourceTests(connection);
            if (!DatabaseClassLoadingTest.isJava5()) {
                DatabaseClassLoadingTest.signersTests(connection);
            }
            connection.setAutoCommit(false);
            JDBC.assertDrainResults(statement.executeQuery("select * from EMC.CONTACTS WITH RR"));
            JDBC.assertFullResultSet(statement.executeQuery("select TYPE, MODE, TABLENAME from syscs_diag.lock_table"), new String[][]{{"TABLE", "S", "CONTACTS"}});
            statement.close();
            connection.rollback();
            connection.setAutoCommit(true);
            connection.close();
        }
        finally {
            JDBCDataSource.shutdownDatabase(dataSource);
        }
    }

    public void testClassLoadOrdering() throws SQLException, MalformedURLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SCHEMA OT");
        statement.execute("create function OT.WHICH_LOADER1(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest1.whichLoader' language java parameter style java");
        statement.execute("create function OT.WHICH_LOADER2(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest2.whichLoader' language java parameter style java");
        statement.execute("create function OT.WHICH_LOADER3(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest3.whichLoader' language java parameter style java");
        this.installJar("dcl_ot1.jar", "OT.OT1");
        this.installJar("dcl_ot2.jar", "OT.OT2");
        this.installJar("dcl_ot3.jar", "OT.OT3");
        this.checkLoading("123");
        this.checkLoading("132");
        this.checkLoading("213");
        this.checkLoading("231");
        this.checkLoading("321");
        this.checkLoading("312");
        statement.close();
    }

    private void checkLoading(String string) throws SQLException {
        this.setDBClasspath("OT.OT1:OT.OT2:OT.OT3");
        PreparedStatement preparedStatement = this.prepareStatement("VALUES OT.WHICH_LOADER" + string.charAt(0) + "(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("VALUES OT.WHICH_LOADER" + string.charAt(1) + "(?)");
        PreparedStatement preparedStatement3 = this.prepareStatement("VALUES OT.WHICH_LOADER" + string.charAt(2) + "(?)");
        this.checkCorrectLoader("OrderTest1", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderTest2", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderTest3", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderLoad1", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderLoad2", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderLoad3", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderObject1", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderObject2", preparedStatement, preparedStatement2, preparedStatement3);
        this.checkCorrectLoader("OrderObject3", preparedStatement, preparedStatement2, preparedStatement3);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        this.setDBClasspath(null);
    }

    private void checkCorrectLoader(String object, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3) throws SQLException {
        object = "org.apache.derbyTesting.databaseclassloader.ot." + (String)object;
        String string = "\"OT\".\"OT" + ((String)object).charAt(((String)object).length() - 1) + "\"";
        preparedStatement.setString(1, (String)object);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        preparedStatement2.setString(1, (String)object);
        JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), string);
        preparedStatement3.setString(1, (String)object);
        JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), string);
    }

    public void testIndirectLoading() throws SQLException, MalformedURLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE SCHEMA ID");
        this.installJar("dcl_id.jar", "ID.IDCODE");
        this.setDBClasspath("ID.IDCODE");
        statement.execute("CREATE PROCEDURE ID.SETDB(pkey VARCHAR(256), pvalue VARCHAR(256)) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.id.IndirectLoad.setDB' language java parameter style java");
        CallableStatement callableStatement = this.prepareCall("CALL ID.SETDB(?, ?)");
        callableStatement.close();
        this.setDBClasspath(null);
        statement.close();
    }

    public void testTableFunctionInJar() throws SQLException, MalformedURLException {
        String string = "EMC.DUMMY_VTI";
        this.installJar("dummy_vti.jar", string);
        this.setDBClasspath(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create function reciprocal( original double ) returns double\nlanguage java\nparameter style java\nno sql\nexternal name 'DummyVTI.reciprocal'");
        statement.executeUpdate("create function dummyVTI()\nreturns table( tablename varchar( 128 ) )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nreads sql data\nexternal name 'DummyVTI.dummyVTI'\n");
        statement.executeUpdate("create function dummyVTI2()\nreturns table( tablename varchar( 128 ) )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nreads sql data\nexternal name 'MissingClass.dummyVTI'\n");
        JDBC.assertFullResultSet(statement.executeQuery("values ( reciprocal( 2.0 ) )"), new String[][]{{"0.5"}});
        JDBC.assertFullResultSet(statement.executeQuery("select * from table( dummyVTI() ) s where tablename='SYSTABLES'"), new String[][]{{"SYSTABLES"}});
        try {
            statement.executeQuery("select * from table( dummyVTI2() ) s where tablename='SYSTABLES'");
            DatabaseClassLoadingTest.fail((String)"Should have seen a ClassNotFoundException.");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("XJ001", sQLException);
        }
        statement.executeUpdate("drop function dummyVTI2\n");
        this.setDBClasspath(null);
        statement.close();
    }

    public void testUDAInJar() throws SQLException, MalformedURLException {
        String string = "EMC.MEDIAN_UDA";
        this.installJar("median_uda.jar", string);
        this.setDBClasspath(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create derby aggregate intMedian for int external name 'Median'\n");
        statement.executeUpdate("create derby aggregate missingAggregate for int external name 'MissingAggregate'\n");
        statement.execute("create table intValues( a int, b int )");
        statement.execute("insert into intValues values ( 1, 1 ), ( 1, 10 ), ( 1, 100 ), ( 1, 1000 ), ( 2, 5 ), ( 2, 50 ), ( 2, 500 ), ( 2, 5000 )");
        JDBC.assertFullResultSet(statement.executeQuery("select intMedian( b ) from intValues"), new String[][]{{"100"}});
        JDBC.assertFullResultSet(statement.executeQuery("select a, intMedian( b ) from intValues group by a"), new String[][]{{"1", "100"}, {"2", "500"}});
        try {
            statement.executeQuery("select missingAggregate( b ) from intValues");
            DatabaseClassLoadingTest.fail((String)"Should have seen a ClassNotFoundException.");
        }
        catch (SQLException sQLException) {
            DatabaseClassLoadingTest.assertSQLState("XJ001", sQLException);
        }
        statement.executeUpdate("drop derby aggregate missingAggregate restrict");
        this.setDBClasspath(null);
        statement.close();
    }

    public void test_5352() throws SQLException, MalformedURLException {
        String string = "EMC.DUMMY_VTI2";
        this.installJar("dummy_vti.jar", string);
        this.setDBClasspath(string);
        Statement statement = this.createStatement();
        statement.executeUpdate("create function dummyVTI2( allowsRestriction boolean )\nreturns table( a int )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nno sql\nexternal name 'DummyVTI2.dummyVTI2'\n");
        JDBC.assertFullResultSet(statement.executeQuery("select * from table( dummyVTI2( true ) ) s where a = 1"), new String[][]{{"1"}});
        DatabaseClassLoadingTest.assertStatementError("XYZZY", statement, "select * from table( dummyVTI2( false ) ) s where a = 1");
        statement.executeUpdate("drop function dummyVTI2\n");
        this.setDBClasspath(null);
        statement.close();
    }

    public void testLoginTimeoutNotInClasspath() throws SQLException {
        this.checkConnectionToClasspathDB(false);
    }

    public void testLoginTimeoutInClasspath() throws SQLException {
        this.checkConnectionToClasspathDB(true);
    }

    private void checkConnectionToClasspathDB(boolean bl) {
        String string = "classpath:dbro";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        try {
            dataSource.getConnection().close();
            DatabaseClassLoadingTest.assertTrue((String)"Could connect to database when it was not in the classpath", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (bl) {
                DatabaseClassLoadingTest.fail("Could not connect to the database", sQLException);
            }
            DatabaseClassLoadingTest.assertSQLState("XJ004", sQLException);
        }
        if (bl) {
            JDBCDataSource.shutdownDatabase(dataSource);
        }
    }

    private void installJar(String string, String string2) throws SQLException, MalformedURLException {
        URL uRL = SupportFilesSetup.getReadOnlyURL(string);
        DatabaseClassLoadingTest.assertNotNull((String)string, (Object)uRL);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, string2);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void replaceJar(String string, String string2) throws SQLException, MalformedURLException {
        URL uRL = SupportFilesSetup.getReadOnlyURL(string);
        DatabaseClassLoadingTest.assertNotNull((String)string, (Object)uRL);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.REPLACE_JAR(?, ?)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, string2);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void removeJar(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        callableStatement.setString(1, string);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void setDBClasspath(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.classpath', ?)");
        callableStatement.setString(1, string);
        callableStatement.executeUpdate();
        callableStatement.close();
    }

    private void derby2035Workaround() throws SQLException {
        this.getConnection().close();
        this.getTestConfiguration().shutdownDatabase();
    }

    private static void createArchive(String string, File file, String string2) throws Exception {
        DatabaseClassLoadingTest.assertTrue((boolean)file.isDirectory());
        File file2 = SupportFilesSetup.getReadOnly(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        DatabaseClassLoadingTest.addEntries(zipOutputStream, file, string2, file.getPath().length());
        zipOutputStream.close();
    }

    static void addEntries(ZipOutputStream zipOutputStream, File file, String string, int n) throws Exception {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                DatabaseClassLoadingTest.addEntries(zipOutputStream, file2, string, n);
                continue;
            }
            DatabaseClassLoadingTest.addFile(zipOutputStream, file2, string, n);
        }
    }

    private static void addFile(ZipOutputStream zipOutputStream, File file, String string, int n) throws IOException {
        int n2;
        String string2 = file.getPath().replace(File.separatorChar, '/');
        string2 = string2.substring(n);
        string2 = string.concat(string2);
        ZipEntry zipEntry = new ZipEntry(string2);
        zipEntry.setTime(file.lastModified());
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[4096];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while ((n2 = bufferedInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n2);
        }
        bufferedInputStream.close();
        zipOutputStream.closeEntry();
    }
}

