/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class StalePlansTest
extends BaseJDBCTestCase {
    private static final int STALE_PLAN_CHECK_INTERVAL = 10;

    public StalePlansTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.language.stalePlanCheckInterval", String.valueOf(10));
        properties.setProperty("derby.storage.indexStats.auto", "false");
        DatabasePropertyTestSetup databasePropertyTestSetup = new DatabasePropertyTestSetup((Test)new BaseTestSuite(StalePlansTest.class), properties, true);
        return new CleanDatabaseTestSetup((Test)databasePropertyTestSetup);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (c1 int, c2 int, c3 varchar(255))");
        statement.executeUpdate("create index idx on t (c1)");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("drop table t");
        this.commit();
        super.tearDown();
    }

    private void flushRowCount(Statement statement) throws SQLException {
        statement.execute("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
    }

    public void testStalePlanCheckIntervalOutOfRange() throws SQLException {
        Statement statement = this.createStatement();
        StalePlansTest.assertStatementError("XCY00", statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.language.stalePlanCheckInterval', '2')");
        statement.close();
    }

    public void testStalePlansOnSmallTable() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 100);
        preparedStatement.setString(3, Formatters.padString("abc", 255));
        preparedStatement.executeUpdate();
        this.commit();
        this.flushRowCount(statement);
        PreparedStatement preparedStatement2 = this.prepareStatement("select count(c1 + c2) from t where c1 = 1");
        String[][] stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(preparedStatement2.executeQuery(), stringArray);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexScan());
        for (n = 0; n < 11; ++n) {
            JDBC.assertFullResultSet(preparedStatement2.executeQuery(), stringArray);
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexScan());
        this.commit();
        preparedStatement.setInt(2, 100);
        for (n = 2; n <= 10; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.flushRowCount(statement);
        for (n = 0; n < 11; ++n) {
            JDBC.assertFullResultSet(preparedStatement2.executeQuery(), stringArray);
        }
        JDBC.assertFullResultSet(preparedStatement2.executeQuery(), stringArray);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexScan());
        this.commit();
        statement.executeUpdate("delete from t where c1 >= 2");
        for (n = 0; n < 11; ++n) {
            JDBC.assertFullResultSet(preparedStatement2.executeQuery(), stringArray);
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexScan());
        statement.close();
        preparedStatement2.close();
        preparedStatement.close();
    }

    public void testStalePlansOnLargeTable() throws SQLException {
        int n;
        int n2;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setString(3, Formatters.padString("abc", 255));
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into t select c1+?, c2+?, c3 from t");
        for (int i = 1; i <= 512; i *= 2) {
            preparedStatement2.setInt(1, i);
            preparedStatement2.setInt(2, i);
            preparedStatement2.executeUpdate();
        }
        this.commit();
        this.flushRowCount(statement);
        PreparedStatement preparedStatement3 = this.prepareStatement("select count(c1 + c2) from t where c1 = 1");
        String[][] stringArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(preparedStatement3.executeQuery(), stringArray);
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexScan());
        this.commit();
        for (n2 = 1025; n2 <= 1250; ++n2) {
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n2);
            preparedStatement.executeUpdate();
        }
        this.commit();
        statement.executeUpdate("update t set c1 = 1 where c1 > 0");
        this.flushRowCount(statement);
        for (n2 = 0; n2 < 11; ++n2) {
            JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "1250");
        }
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        if (!runtimeStatisticsParser.usedTableScan()) {
            StalePlansTest.fail((String)("Expected table scan. Full plan:\n" + runtimeStatisticsParser.toString()));
        }
        statement.executeUpdate("insert into t select c1,c2,c3 from t where c1<128");
        this.flushRowCount(statement);
        for (n = 0; n < 11; ++n) {
            JDBC.assertSingleValueResultSet(preparedStatement3.executeQuery(), "2500");
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedTableScan());
        statement.executeUpdate("update t set c1 = c2");
        statement.executeUpdate("insert into t select c1, c2, c3 from t");
        this.flushRowCount(statement);
        for (n = 0; n < 11; ++n) {
            JDBC.assertFullResultSet(preparedStatement3.executeQuery(), new String[][]{{"4"}});
        }
        StalePlansTest.assertTrue((boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedIndexRowToBaseRow());
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    public void testDerby6724() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table d6724_t(x int)");
        statement.execute("create trigger d6724_tr after insert on d6724_t values 1");
        statement.execute("insert into d6724_t values 1");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d6724_t select * from d6724_t");
        for (int i = 0; i < 11; ++i) {
            StalePlansTest.assertUpdateCount(preparedStatement, 1 << i);
        }
        this.rollback();
    }
}

