/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.BigDecimalHandler;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdatableResultSetTest
extends BaseJDBCTestCase {
    private static String[] allUpdateXXXNames = new String[]{"updateShort", "updateInt", "updateLong", "updateBigDecimal", "updateFloat", "updateDouble", "updateString", "updateAsciiStream", "updateCharacterStream", "updateByte", "updateBytes", "updateBinaryStream", "updateClob", "updateDate", "updateTime", "updateTimestamp", "updateBlob", "updateBoolean", "updateNull", "updateArray", "updateRef"};
    private static String[] allSQLTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL(10,5)", "REAL", "DOUBLE", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(2) FOR BIT DATA", "VARCHAR(2) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "CLOB(1k)", "DATE", "TIME", "TIMESTAMP", "BLOB(1k)"};
    private static String[] ColumnNames = new String[]{"SMALLINTCOL", "INTEGERCOL", "BIGINTCOL", "DECIMALCOL", "REALCOL", "DOUBLECOL", "CHARCOL", "VARCHARCOL", "LONGVARCHARCOL", "CHARFORBITCOL", "VARCHARFORBITCOL", "LVARCHARFORBITCOL", "CLOBCOL", "DATECOL", "TIMECOL", "TIMESTAMPCOL", "BLOBCOL"};
    private static String[][] SQLData = new String[][]{{"11", "22"}, {"111", "1111"}, {"22", "222"}, {"3.3", "3.33"}, {"4.4", "4.44"}, {"5.5", "5.55"}, {"'1992-01-06'", "'1992'"}, {"'1992-01-07'", "'1992'"}, {"'1992-01-08'", "'1992'"}, {"X'10'", "X'10aa'"}, {"X'10'", "X'10bb'"}, {"X'10'", "X'10cc'"}, {"'13'", "'14'"}, {"'2000-01-01'", "'2000-01-01'"}, {"'15:30:20'", "'15:30:20'"}, {"'2000-01-01 15:30:20'", "'2000-01-01 15:30:20'"}, {"X'1020'", "X'10203040'"}};
    public static final String[][] updateXXXRulesTableForEmbedded = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "XCL12", "22005", "22005", "XCL12", "XCL12", "XCL12", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22005", "22005", "PASS", "PASS", "PASS", "22005", "PASS", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "22005", "PASS", "XCL12", "XCL12", "XCL12", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "PASS", "XCL12", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22007", "22005", "22005", "XCL12", "XCL12", "22005", "22005", "PASS", "XCL12", "PASS", "22005", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "22005", "22005", "XCL12", "PASS", "PASS", "22005", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "0A000", "0A000"}};
    public static final String[][] updateXXXRulesTableForNetworkClient = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "0A000", "0A000"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "0A000", "0A000"}};
    public static final String[][] updateObjectRulesTableForNetworkClient = new String[][]{{"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "22018", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "PASS", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12", "PASS", "XCL12", "XCL12"}, {"XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "PASS", "XCL12", "XCL12", "XCL12", "XCL12", "PASS", "XCL12", "PASS", "XCL12", "XCL12"}};

    public UpdatableResultSetTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("UpdatableResultSetTest");
        BaseTestSuite baseTestSuite2 = UpdatableResultSetTest.baseSuite("UpdatableResultSetTest:embedded");
        BaseTestSuite baseTestSuite3 = UpdatableResultSetTest.baseSuite("UpdatableResultSetTest:client");
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite2.addTest((Test)new UpdatableResultSetTest("xTestInsertRowAfterCommit"));
            baseTestSuite3.addTest((Test)new UpdatableResultSetTest("xTestInsertRowAfterCommit"));
        }
        baseTestSuite.addTest((Test)new CleanDatabaseTestSetup((Test)baseTestSuite2));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new CleanDatabaseTestSetup((Test)baseTestSuite3)));
        return baseTestSuite;
    }

    private static BaseTestSuite baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(UpdatableResultSetTest.class);
        return baseTestSuite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    public void testScrollSensitiveResultSet() throws SQLException {
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1005, 1008);
        String string = UpdatableResultSetTest.usingEmbedded() ? "01J02" : "01J10";
        UpdatableResultSetTest.assertEquals((String)"FAIL - Should get warning on Downgrade", (String)string, (String)this.getConnection().getWarnings().getSQLState());
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set type should be scroll insensitive", (int)1004, (int)statement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)statement.getResultSetConcurrency());
    }

    public void testUpdateDeleteRowOnReadOnlyResultSet() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)resultSet.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateDeleteRowOnReadOnlyResultSetWithForUpdate() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t1 FOR UPDATE");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)resultSet.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateDeleteRowOnReadOnlyResultSetWithoutForUpdate() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)resultSet.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateDeleteRowOnUpdatableResultSetWithForReadOnly() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1 FOR READ ONLY");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be read only", (int)1007, (int)resultSet.getConcurrency());
        UpdatableResultSetTest.assertEquals((String)"FAIL - FAIL - Should get warning on Downgrade", (String)"01J06", (String)resultSet.getWarnings().getSQLState());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this is a read only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateDeleteRowNotOnRow() throws SQLException {
        String string;
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)resultSet.getConcurrency());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed, not on a row");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed, not on a row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        while (resultSet.next()) {
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed, positioned after last row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed, positioned after last row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateDeleteRowOnClosedResultSet() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertEquals((String)"FAIL - Result set concurrency should be updatable", (int)1008, (int)resultSet.getConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.close();
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because this result set is closed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
            UpdatableResultSetTest.assertTrue((sQLException.getMessage().indexOf("deleteRow") > 0 ? 1 : 0) != 0);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because this result set is closed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
            UpdatableResultSetTest.assertTrue((sQLException.getMessage().indexOf("updateRow") > 0 ? 1 : 0) != 0);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdatableResultSetOnSysTable() throws SQLException {
        try {
            ResultSet resultSet = this.createStatement().executeQuery("SELECT * FROM sys.systables FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset on a system table should have failed because system tables can't be updated by a user");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42Y90", sQLException);
        }
    }

    public void testUpdatableResultSetOnView() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement();
        statement.executeUpdate("create view v1 as select * from t1");
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM v1 FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset on a view should have failed because Derby does not support updates to views yet");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42Y90", sQLException);
        }
        statement.executeUpdate("drop view v1");
        statement.close();
    }

    public void testUpdatableResultSetOnJoin() throws SQLException {
        this.createTableT1();
        this.createTableT2();
        Statement statement = this.createStatement(1003, 1008);
        try {
            ResultSet resultSet = statement.executeQuery("SELECT c1 FROM t1,t2 where t1.c1 = t2.c21 FOR UPDATE");
            UpdatableResultSetTest.fail((String)"FAIL - trying to open an updatable resultset should have failed because updatable resultset donot support join in the select query");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42Y90", sQLException);
        }
    }

    public void testDropTableWithUpatableResultSet() throws SQLException {
        String string;
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 123);
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("drop table t1");
            UpdatableResultSetTest.fail((String)"FAIL - drop table should have failed because the updatable resultset is still open");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("X0X95", sQLException);
        }
        statement2.close();
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - resultset should have been closed at this point and updateRow should have failed");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "XCL16" : "24000";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - resultset should have been closed at this point and deleteRow should have failed");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "XCL16" : "24000";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.executeUpdate("DROP TABLE T1");
        statement.close();
    }

    public void testForeignKeyConstraintFailureOnDeleteRow() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableWithPrimaryKey();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM tableWithPrimaryKey FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it will cause foreign key constraint failure");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("23503", sQLException);
        }
        try {
            resultSet.next();
            if (UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.fail((String)"FAIL - next should have failed because foreign key constraint failure resulted in a runtime rollback");
            }
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertFalse((String)"FAIL - Network client should not fail due to DERBY-160", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
        }
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM tableWithPrimaryKey"), objectArray, true);
        statement.executeUpdate("DROP TABLE tableWithConstraint");
        statement.executeUpdate("DROP TABLE tableWithPrimaryKey");
        statement.close();
    }

    public void testForeignKeyConstraintFailureOnUpdateRow() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableWithPrimaryKey();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 FROM tableWithPrimaryKey FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 11);
        resultSet.updateInt(2, 22);
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because it will cause foreign key constraint failure");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("23503", sQLException);
        }
        try {
            resultSet.next();
            if (UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.fail((String)"FAIL - next should have failed because foreign key constraint failure resulted in a runtime rollback");
            }
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertFalse((String)"FAIL - Network client should not fail due to DERBY-160", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
        }
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM tableWithPrimaryKey"), objectArray, true);
        statement.executeUpdate("DROP TABLE tableWithConstraint");
        statement.executeUpdate("DROP TABLE tableWithPrimaryKey");
        statement.close();
    }

    public void testUpdateXXXOnColumnNotFromTable() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT 1, 2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.updateInt(1, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateInt should have failed because it is trying to update a column that does not correspond to column in base table");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "XJ084" : "XJ124";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXOnOutOfRangeColumn() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            UpdatableResultSetTest.println("There are only 2 columns in the select list and we are trying to send updateXXX on column position 3");
            resultSet.updateInt(3, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateInt should have failed because there are only 2 columns in the select list");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL14", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testResultSetNotPositionedAfterDeleteRow() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)statement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)statement.getResultSetConcurrency());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        String string = resultSet.getString(2);
        resultSet.deleteRow();
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - result set not positioned on a row, rs.getInt(1) should have failed");
        }
        catch (SQLException sQLException) {
            String string2 = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string2, sQLException);
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testResultSetNotPositionedAfterUpdateRow() throws SQLException {
        String string;
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        resultSet.updateInt(1, 234);
        UpdatableResultSetTest.assertEquals((String)"FAIL - column should have updated value", (int)234, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - value of column 2 should not have changed", (String)"aa", (String)resultSet.getString(2).trim());
        UpdatableResultSetTest.println("now updateRow on the row");
        resultSet.updateRow();
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - result set not positioned on a row, rs.getInt(1) should have failed");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateString(2, "234");
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"234", "aa"}, {"2", "234"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testPositionedDeleteOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)statement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)statement.getResultSetConcurrency());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        String string = resultSet.getString(2);
        PreparedStatement preparedStatement = this.prepareStatement("DELETE FROM T1 WHERE CURRENT OF " + resultSet.getCursorName());
        preparedStatement.executeUpdate();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value on deleted row", (int)n, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value on deleted row", (String)string, (String)resultSet.getString(2));
        try {
            preparedStatement.executeUpdate();
            UpdatableResultSetTest.fail((String)"FAIL - positioned delete should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        preparedStatement.executeUpdate();
        resultSet.close();
        preparedStatement.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testPositionedUpdateOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        this.getConnection().clearWarnings();
        Statement statement = this.createStatement(1003, 1008);
        JDBC.assertNoWarnings(this.getConnection().getWarnings());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        String string = resultSet.getString(2);
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE T1 SET C1=?, C2=? WHERE CURRENT OF " + resultSet.getCursorName());
        preparedStatement.setInt(1, 2345);
        preparedStatement.setString(2, "UUU");
        preparedStatement.executeUpdate();
        UpdatableResultSetTest.assertEquals((String)"FAIL - column 1 should have the original value", (int)n, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - column 2 should have the original value", (String)string, (String)resultSet.getString(2));
        try {
            resultSet.refreshRow();
            UpdatableResultSetTest.fail((String)"FAIL - refreshRow not implemented for this type of result set");
        }
        catch (SQLException sQLException) {
            String string2 = UpdatableResultSetTest.usingEmbedded() ? "0A000" : "XJ125";
            UpdatableResultSetTest.assertSQLState(string2, sQLException);
        }
        preparedStatement.setInt(1, 2345);
        preparedStatement.setString(2, "UUU");
        preparedStatement.executeUpdate();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        preparedStatement.setInt(1, resultSet.getInt(1));
        preparedStatement.setString(2, "abc");
        preparedStatement.executeUpdate();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"2345", "UUU"}, {"2", "abc"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
        preparedStatement.close();
    }

    public void testUpdatableResultsetNoColumnInColumnList() throws SQLException {
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select count(*) from t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)3, (int)n);
        resultSet = statement.executeQuery("SELECT 1, 2 FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.assertTrue((String)"FAIL - should have failed in network server", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - should not fail on embedded", (!UpdatableResultSetTest.usingEmbedded() ? 1 : 0) != 0);
            UpdatableResultSetTest.assertSQLState("42X01", sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        int n2 = resultSet.getInt(1);
        if (UpdatableResultSetTest.usingEmbedded()) {
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)(n - 1), (int)n2);
        } else {
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)n, (int)n2);
        }
        resultSet.close();
        statement.execute("DROP TABLE T1");
        statement.close();
    }

    public void testDeleteRowWithPreparedStatement() throws SQLException {
        String string;
        this.createTableT1();
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where c1 > ?", 1003, 1008);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)preparedStatement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)preparedStatement.getResultSetConcurrency());
        preparedStatement.setInt(1, 0);
        ResultSet resultSet = preparedStatement.executeQuery();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        resultSet.deleteRow();
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on a row, can not get column");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it can't be called more than once on the same row");
        }
        catch (SQLException sQLException) {
            string = "24000";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - first column should not be 0", (resultSet.getInt(1) == 0 ? 1 : 0) != 0);
        resultSet.deleteRow();
        resultSet.close();
        preparedStatement.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), objectArray, true);
    }

    public void testUpdateXXXWithPreparedStatement() throws SQLException {
        String string;
        this.createTableT1();
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where c1>? for update", 1003, 1008);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)preparedStatement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)preparedStatement.getResultSetConcurrency());
        preparedStatement.setInt(1, 0);
        ResultSet resultSet = preparedStatement.executeQuery();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        resultSet.updateInt(1, 5);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 5", (int)5, (int)resultSet.getInt(1));
        resultSet.updateRow();
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on a row, can not get column");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.updateInt(1, 0);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX should have failed because resultset is not positioned on a row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because resultset is not positioned on a row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.cancelRowUpdates();
            UpdatableResultSetTest.fail((String)"FAIL - cancelRowUpdates should have failed because the resultset is not positioned on a row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        resultSet.cancelRowUpdates();
        resultSet.close();
        preparedStatement.close();
        Object[][] objectArray = new String[][]{{"5", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), objectArray, true);
    }

    public void testCallableStatementWithUpdatableResultSet() throws SQLException {
        String string;
        this.createTableT1();
        CallableStatement callableStatement = this.prepareCall("select * from t1", 1003, 1008);
        ResultSet resultSet = callableStatement.executeQuery();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set type", (int)1003, (int)callableStatement.getResultSetType());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong result set concurrency", (int)1008, (int)callableStatement.getResultSetConcurrency());
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - not on row, can not get value");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have failed because it can't be called more than once on the same row");
        }
        catch (SQLException sQLException) {
            string = "24000";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        resultSet.deleteRow();
        resultSet.close();
        callableStatement.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(this.createStatement().executeQuery("SELECT * FROM t1"), objectArray, true);
    }

    public void testUpdatableResultSetWithoutSelectingPrimaryKey() throws SQLException {
        this.createTableT3();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c32 FROM t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"2", "123"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3"), objectArray, true);
        statement.close();
    }

    public void testRowDeleted() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for ownDeletesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)databaseMetaData.ownDeletesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for othersDeletesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)true, (boolean)databaseMetaData.othersDeletesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for deletesAreDetected(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)databaseMetaData.deletesAreDetected(1003));
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - rs.rowDeleted() should always return false for this type of result set", (boolean)resultSet.rowDeleted());
        resultSet.deleteRow();
        resultSet.close();
        statement.close();
    }

    public void testRowUpdated() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for ownUpdatesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)databaseMetaData.ownUpdatesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for othersUpdatesAreVisible(ResultSet.TYPE_FORWARD_ONLY)", (boolean)true, (boolean)databaseMetaData.othersUpdatesAreVisible(1003));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong values for updatesAreDetected(ResultSet.TYPE_FORWARD_ONLY)", (boolean)false, (boolean)databaseMetaData.updatesAreDetected(1003));
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - statement should return a row", (boolean)resultSet.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - rs.rowUpdated() should always return false for this type of result set", (boolean)resultSet.rowUpdated());
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowOnTempTable() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t2 values(21, 1)");
        statement.executeUpdate("insert into SESSION.t2 values(22, 1)");
        UpdatableResultSetTest.println("following rows in temp table before deleteRow");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t2");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)21, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)resultSet.getInt(2));
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)22, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)resultSet.getInt(2));
        resultSet.close();
        resultSet = statement.executeQuery("select c21 from session.t2 for update");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertFalse((String)"FAIL - Column c21 should not be 0", (resultSet.getInt(1) == 0 ? 1 : 0) != 0);
        resultSet.deleteRow();
        UpdatableResultSetTest.println("As expected, no rows in temp table after deleteRow");
        resultSet.close();
        resultSet = statement.executeQuery("select * from SESSION.t2");
        UpdatableResultSetTest.assertFalse((String)"FAIL - all rows were deleted, rs.next() should return false", (boolean)resultSet.next());
        resultSet.close();
        statement.executeUpdate("DROP TABLE SESSION.t2");
        statement.close();
    }

    public void testUpdateRowOnTempTable() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged");
        statement.executeUpdate("insert into SESSION.t3 values(21, 1)");
        statement.executeUpdate("insert into SESSION.t3 values(22, 1)");
        UpdatableResultSetTest.println("following rows in temp table before deleteRow");
        ResultSet resultSet = statement.executeQuery("select * from SESSION.t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)21, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)resultSet.getInt(2));
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)22, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)resultSet.getInt(2));
        resultSet.close();
        resultSet = statement.executeQuery("select c31 from session.t3");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        resultSet.close();
        int n = 0;
        resultSet = statement.executeQuery("select * from SESSION.t3");
        while (resultSet.next()) {
            ++n;
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)123, (int)resultSet.getInt(1));
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c21", (int)1, (int)resultSet.getInt(2));
        }
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)2, (int)n);
        resultSet.close();
        statement.executeUpdate("DROP TABLE SESSION.t3");
        statement.close();
    }

    public void testDeleteRowWithSetCursorName() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("CURSORNOUPDATe");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        try {
            statement.setCursorName("CURSORNOUPDATE1");
            UpdatableResultSetTest.assertTrue((String)"FAIL - expected exception in network client", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException sQLException) {
            if (!UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.assertSQLState("X0X95", sQLException);
            }
            throw sQLException;
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateRowWithSetCursorName() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        statement.setCursorName("CURSORNOUPDATe");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateLong(1, 123L);
        try {
            statement.setCursorName("CURSORNOUPDATE1");
            UpdatableResultSetTest.assertTrue((String)"FAIL - expected exception in network client", (boolean)UpdatableResultSetTest.usingEmbedded());
        }
        catch (SQLException sQLException) {
            if (!UpdatableResultSetTest.usingEmbedded()) {
                UpdatableResultSetTest.assertSQLState("X0X95", sQLException);
            }
            throw sQLException;
        }
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"123", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testDeleteRowWithCorrelationForTableName() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testDeleteRowWithCorrelationForColumnName() throws SQLException {
        ResultSet resultSet;
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        try {
            resultSet = statement.executeQuery("SELECT c1 as col1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42X42", sQLException);
        }
        resultSet = statement.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 11);
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"11", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateXXXOnReadOnlyColumn() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString on readonly column should have failed");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateRowWithCorrelationOnTableAndColumn() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 11);
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"11", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateXXXOnReadOnlyColumnWithCorrelationName() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 as col2 FROM t1 abcde FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString on readonly column should have failed");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
    }

    public void testUpdateRowWithTableAndColumnAlias_d1773() throws SQLException {
        ResultSet resultSet;
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        try {
            resultSet = statement.executeQuery("SELECT * from t1 as abcde(a1,a2) for update of c1");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42Y90", sQLException);
        }
        try {
            resultSet = statement.executeQuery("SELECT * from t1 as abcde(a1,a2) for update");
            UpdatableResultSetTest.fail((String)"FAIL - executeQuery should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("42Y90", sQLException);
        }
        resultSet = statement.executeQuery("select * from t1 as a(a1,a2)");
        resultSet.next();
        try {
            resultSet.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT c1 as a1, c2 as a2 from t1 as abcde");
        resultSet.next();
        try {
            resultSet.updateString(2, "bbbb");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT c1 as a1, c2 from t1 as abcde for update of c2");
        resultSet.next();
        resultSet.updateString(2, "bbbb");
        try {
            resultSet.updateString(1, "aaaa");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT c1 as a1, c2 from t1 as abcde for update");
        resultSet.next();
        resultSet.updateString(2, "bbbb");
        try {
            resultSet.updateString(1, "aaaa");
            UpdatableResultSetTest.fail((String)"FAIL - updateString should have failed");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState(UpdatableResultSetTest.usingDerbyNetClient() ? "XJ124" : "42X31", sQLException);
        }
        resultSet.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), (Object[][])new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}}, true);
        statement.close();
    }

    public void testTwoResultSetsDeletingSameRow() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        Statement statement2 = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        ResultSet resultSet2 = statement2.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet2.next());
        UpdatableResultSetTest.println("delete using first resultset");
        resultSet.deleteRow();
        try {
            resultSet2.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - delete using second resultset succedded? ");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet2.next());
        resultSet2.deleteRow();
        resultSet.close();
        resultSet2.close();
        Object[][] objectArray = new String[][]{{"3", "cc"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.close();
        statement2.close();
    }

    public void testSetFetchSizeOnUpdatableResultSet() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.setFetchSize(200);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE of c1");
        Statement statement2 = this.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        while (resultSet2.next()) {
            if (!resultSet2.getString(1).startsWith("Fetch Size")) continue;
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong fetch size", (String)"Fetch Size = 1", (String)resultSet2.getString(1));
        }
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong fetch size for updatable cursor", (int)200, (int)statement.getFetchSize());
        resultSet.close();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        statement.close();
    }

    public void testDeleteRowWithDeleteTrigger() throws SQLException {
        this.createTable0WithTrigger();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain no rows", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM table0WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain one row", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowWithUpdateTrigger() throws SQLException {
        this.createTable0WithTrigger();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain no rows", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)resultSet.getInt(1));
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - table shoud contain one row", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowWithTriggerChangingRS() throws SQLException {
        this.createTable1WithTrigger();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM table1WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because delete trigger deleted all the rows");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from table1WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowWithTriggerChangingRS() throws SQLException {
        this.createTable1WithTrigger();
        Statement statement = this.createStatement(1003, 1008);
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from table2WithTriggers"), objectArray, true);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM table2WithTriggers where c1>1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c1", (int)2, (int)resultSet.getInt(1));
        resultSet.updateLong(2, 2L);
        resultSet.updateRow();
        try {
            UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)resultSet.next());
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because update trigger made all the rows not qualify for the resultset");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM table2WithTriggers");
        Object[][] objectArray2 = new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray2, true);
        statement.close();
    }

    public void testDeleteRowSelfReferential() throws SQLException {
        this.createSelfReferencingTable();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from selfReferencingT1");
        Object[][] objectArray = new String[][]{{"e1", null}, {"e2", "e1"}, {"e3", "e2"}, {"e4", "e3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM selfReferencingT1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column1", (String)"e1", (String)resultSet.getString(1));
        resultSet.deleteRow();
        UpdatableResultSetTest.assertFalse((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - there should have be no more rows in the resultset at this point because of the delete cascade");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "42X30";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from selfReferencingT1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowSelfReferential() throws SQLException {
        this.createSelfReferencingTable();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from selfReferencingT2");
        Object[][] objectArray = new String[][]{{"e1", null}, {"e2", "e1"}, {"e3", "e2"}, {"e4", "e3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM selfReferencingT2 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column1", (String)"e1", (String)resultSet.getString(1));
        resultSet.updateString(1, "e2");
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - this update should have caused violation of foreign key constraint");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("23503", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testDropTableWithUpdatableCursorOnIt() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("drop table t1");
            UpdatableResultSetTest.fail((String)"FAIL - drop table should have failed because the updatable resultset is still open");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("X0X95", sQLException);
        }
        statement2.close();
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM t1");
        Object[][] objectArray = new String[][]{{"2", "bb"}, {"3", "cc"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testDeleteRowAndRollbackWithTriggers() throws SQLException {
        this.createTable0WithTrigger();
        this.commit();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)4, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM table0WithTriggers FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        UpdatableResultSetTest.println("now try to delete row and make sure that trigger got fired");
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)3, (int)resultSet.getInt(1));
        resultSet.close();
        this.rollback();
        resultSet = statement.executeQuery("select count(*) from deleteTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)4, (int)resultSet.getInt(1));
        resultSet.close();
        statement.executeUpdate("drop table table0WithTriggers");
        statement.executeUpdate("drop table deleteTriggerInsertIntoThisTable");
        statement.executeUpdate("drop table updateTriggerInsertIntoThisTable");
        statement.close();
        this.commit();
    }

    public void testUpdateRowAndRollbackWithTriggers() throws SQLException {
        this.createTable0WithTrigger();
        this.commit();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM table0WithTriggers");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        UpdatableResultSetTest.println("now try to update row and make sure that trigger got fired");
        resultSet.updateLong(1, 123L);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        Object[][] objectArray = new String[][]{{"123", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        resultSet = statement.executeQuery("select * from table0WithTriggers");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        this.rollback();
        resultSet = statement.executeQuery("select count(*) from updateTriggerInsertIntoThisTable");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong row count", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        Object[][] objectArray2 = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        resultSet = statement.executeQuery("select * from table0WithTriggers");
        JDBC.assertFullResultSet(resultSet, objectArray2, true);
        resultSet.close();
        statement.executeUpdate("drop table table0WithTriggers");
        statement.executeUpdate("drop table deleteTriggerInsertIntoThisTable");
        statement.executeUpdate("drop table updateTriggerInsertIntoThisTable");
        statement.close();
        this.commit();
    }

    public void testResultSetPositionedBeforeNextAfterDeleteRow() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        try {
            resultSet.getString(1);
            UpdatableResultSetTest.fail((String)"FAIL - getString should have failed, result set not positioned");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testCancelRowUpdatesOnReadOnlyRS() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        try {
            resultSet.cancelRowUpdates();
            UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because cancelRowUpdates is being called on a read-only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowOnReadOnlyRS() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because updateRow is being called on a read-only resultset");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXOnReadOnlyRS() throws SQLException {
        this.createAllDatatypesTable();
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        for (int i = 1; i <= allUpdateXXXNames.length; ++i) {
            UpdatableResultSetTest.println("\nTest " + allUpdateXXXNames[i - 1] + " on a readonly resultset");
            for (int j = 1; j <= 2; ++j) {
                ResultSet resultSet = statement.executeQuery("SELECT * FROM AllDataTypesForTestingTable");
                resultSet.next();
                ResultSet resultSet2 = statement2.executeQuery("SELECT * FROM AllDataTypesNewValuesData");
                resultSet2.next();
                if (j == 1) {
                    UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[i - 1]);
                } else {
                    UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[i - 1]);
                }
                try {
                    if (i == 1) {
                        if (j == 1) {
                            resultSet.updateShort(1, resultSet2.getShort(i));
                        } else {
                            resultSet.updateShort(ColumnNames[0], resultSet2.getShort(i));
                        }
                    } else if (i == 2) {
                        if (j == 1) {
                            resultSet.updateInt(1, resultSet2.getInt(i));
                        } else {
                            resultSet.updateInt(ColumnNames[0], resultSet2.getInt(i));
                        }
                    } else if (i == 3) {
                        if (j == 1) {
                            resultSet.updateLong(1, resultSet2.getLong(i));
                        } else {
                            resultSet.updateLong(ColumnNames[0], resultSet2.getLong(i));
                        }
                    } else if (i == 4) {
                        if (j == 1) {
                            BigDecimalHandler.updateBigDecimalString(resultSet, 1, BigDecimalHandler.getBigDecimalString(resultSet2, i));
                        } else {
                            BigDecimalHandler.updateBigDecimalString(resultSet, ColumnNames[0], BigDecimalHandler.getBigDecimalString(resultSet2, i));
                        }
                    } else if (i == 5) {
                        if (j == 1) {
                            resultSet.updateFloat(1, resultSet2.getFloat(i));
                        } else {
                            resultSet.updateFloat(ColumnNames[0], resultSet2.getFloat(i));
                        }
                    } else if (i == 6) {
                        if (j == 1) {
                            resultSet.updateDouble(1, resultSet2.getDouble(i));
                        } else {
                            resultSet.updateDouble(ColumnNames[0], resultSet2.getDouble(i));
                        }
                    } else if (i == 7) {
                        if (j == 1) {
                            resultSet.updateString(1, resultSet2.getString(i));
                        } else {
                            resultSet.updateString(ColumnNames[0], resultSet2.getString(i));
                        }
                    } else if (i == 8) {
                        if (j == 1) {
                            resultSet.updateAsciiStream(1, resultSet2.getAsciiStream(i), 4);
                        } else {
                            resultSet.updateAsciiStream(ColumnNames[0], resultSet2.getAsciiStream(i), 4);
                        }
                    } else if (i == 9) {
                        if (j == 1) {
                            resultSet.updateCharacterStream(1, resultSet2.getCharacterStream(i), 4);
                        } else {
                            resultSet.updateCharacterStream(ColumnNames[0], resultSet2.getCharacterStream(i), 4);
                        }
                    } else if (i == 10) {
                        if (j == 1) {
                            resultSet.updateByte(1, resultSet2.getByte(1));
                        } else {
                            resultSet.updateByte(ColumnNames[0], resultSet2.getByte(1));
                        }
                    } else if (i == 11) {
                        if (j == 1) {
                            resultSet.updateBytes(1, resultSet2.getBytes(i));
                        } else {
                            resultSet.updateBytes(ColumnNames[0], resultSet2.getBytes(i));
                        }
                    } else if (i == 12) {
                        if (j == 1) {
                            resultSet.updateBinaryStream(1, resultSet2.getBinaryStream(i), 2);
                        } else {
                            resultSet.updateBinaryStream(ColumnNames[0], resultSet2.getBinaryStream(i), 2);
                        }
                    } else if (i == 13) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (j == 1) {
                            resultSet.updateClob(1, resultSet2.getClob(i));
                        } else {
                            resultSet.updateClob(ColumnNames[0], resultSet2.getClob(i));
                        }
                    } else if (i == 14) {
                        if (j == 1) {
                            resultSet.updateDate(1, resultSet2.getDate(i));
                        } else {
                            resultSet.updateDate(ColumnNames[0], resultSet2.getDate(i));
                        }
                    } else if (i == 15) {
                        if (j == 1) {
                            resultSet.updateTime(1, resultSet2.getTime(i));
                        } else {
                            resultSet.updateTime(ColumnNames[0], resultSet2.getTime(i));
                        }
                    } else if (i == 16) {
                        if (j == 1) {
                            resultSet.updateTimestamp(1, resultSet2.getTimestamp(i));
                        } else {
                            resultSet.updateTimestamp(ColumnNames[0], resultSet2.getTimestamp(i));
                        }
                    } else if (i == 17) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (j == 1) {
                            resultSet.updateBlob(1, resultSet2.getBlob(i));
                        } else {
                            resultSet.updateBlob(ColumnNames[0], resultSet2.getBlob(i));
                        }
                    } else if (i == 18) {
                        if (j == 1) {
                            resultSet.updateBoolean(1, resultSet2.getBoolean(1));
                        } else {
                            resultSet.updateBoolean(ColumnNames[0], resultSet2.getBoolean(1));
                        }
                    } else if (i == 19) {
                        if (j == 1) {
                            resultSet.updateNull(1);
                        } else {
                            resultSet.updateNull(ColumnNames[0]);
                        }
                    } else if (i == 20) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (j == 1) {
                            resultSet.updateArray(1, null);
                        } else {
                            resultSet.updateArray(ColumnNames[0], null);
                        }
                    } else if (i == 21) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        if (j == 1) {
                            resultSet.updateRef(1, null);
                        } else {
                            resultSet.updateRef(ColumnNames[0], null);
                        }
                    }
                    UpdatableResultSetTest.fail((String)"FAIL - should not have reached here because updateXXX is being called on a read-only resultset");
                    return;
                }
                catch (SQLException sQLException) {
                    if (i == 20 || i == 21) {
                        UpdatableResultSetTest.assertSQLState("FAIL - unexpected exception on " + allUpdateXXXNames[i - 1], "0A000", sQLException);
                    }
                    resultSet.close();
                    resultSet2.close();
                }
            }
        }
        statement.close();
        statement2.close();
    }

    public void testUpdateXXXWithAllDatatypes() throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int i = 1; i <= allSQLTypes.length; ++i) {
            this.rollback();
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[i - 1]);
            for (int j = 1; j <= allUpdateXXXNames.length; ++j) {
                if (JDBC.vmSupportsJSR169() && j == 4) continue;
                UpdatableResultSetTest.println("Testing " + allUpdateXXXNames[j - 1] + " on SQL type " + allSQLTypes[i - 1]);
                this.runTestUpdateXXXWithAllDatatypes(preparedStatement, preparedStatement2, i, j);
            }
        }
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesForTestingTable");
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesNewValuesData");
        this.commit();
    }

    private void runTestUpdateXXXWithAllDatatypes(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2) throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        int n3 = n2;
        for (int i = 1; i <= 2; ++i) {
            if (i == 1) {
                UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[n2 - 1]);
            } else {
                UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[n2 - 1]);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            try {
                if (n2 == 1) {
                    if (i == 1) {
                        resultSet.updateShort(n, resultSet2.getShort(n2));
                    } else {
                        resultSet.updateShort(ColumnNames[n - 1], resultSet2.getShort(n2));
                    }
                } else if (n2 == 2) {
                    if (i == 1) {
                        resultSet.updateInt(n, resultSet2.getInt(n2));
                    } else {
                        resultSet.updateInt(ColumnNames[n - 1], resultSet2.getInt(n2));
                    }
                } else if (n2 == 3) {
                    if (i == 1) {
                        resultSet.updateLong(n, resultSet2.getLong(n2));
                    } else {
                        resultSet.updateLong(ColumnNames[n - 1], resultSet2.getLong(n2));
                    }
                } else if (n2 == 4) {
                    if (!JDBC.vmSupportsJSR169()) {
                        if (i == 1) {
                            resultSet.updateBigDecimal(n, resultSet2.getBigDecimal(n2));
                        } else {
                            resultSet.updateBigDecimal(ColumnNames[n - 1], resultSet2.getBigDecimal(n2));
                        }
                    }
                } else if (n2 == 5) {
                    if (i == 1) {
                        resultSet.updateFloat(n, resultSet2.getFloat(n2));
                    } else {
                        resultSet.updateFloat(ColumnNames[n - 1], resultSet2.getFloat(n2));
                    }
                } else if (n2 == 6) {
                    if (i == 1) {
                        resultSet.updateDouble(n, resultSet2.getDouble(n2));
                    } else {
                        resultSet.updateDouble(ColumnNames[n - 1], resultSet2.getDouble(n2));
                    }
                } else if (n2 == 7) {
                    if (i == 1) {
                        resultSet.updateString(n, resultSet2.getString(n2));
                    } else {
                        resultSet.updateString(ColumnNames[n - 1], resultSet2.getString(n2));
                    }
                } else if (n2 == 8) {
                    if (i == 1) {
                        resultSet.updateAsciiStream(n, resultSet2.getAsciiStream(n2), 4);
                    } else {
                        resultSet.updateAsciiStream(ColumnNames[n - 1], resultSet2.getAsciiStream(n2), 4);
                    }
                } else if (n2 == 9) {
                    if (i == 1) {
                        resultSet.updateCharacterStream(n, resultSet2.getCharacterStream(n2), 4);
                    } else {
                        resultSet.updateCharacterStream(ColumnNames[n - 1], resultSet2.getCharacterStream(n2), 4);
                    }
                } else if (n2 == 10) {
                    n3 = 1;
                    if (i == 1) {
                        resultSet.updateByte(n, resultSet2.getByte(n3));
                    } else {
                        resultSet.updateByte(ColumnNames[n - 1], resultSet2.getByte(n3));
                    }
                } else if (n2 == 11) {
                    if (i == 1) {
                        resultSet.updateBytes(n, resultSet2.getBytes(n2));
                    } else {
                        resultSet.updateBytes(ColumnNames[n - 1], resultSet2.getBytes(n2));
                    }
                } else if (n2 == 12) {
                    if (i == 1) {
                        resultSet.updateBinaryStream(n, resultSet2.getBinaryStream(n2), 2);
                    } else {
                        resultSet.updateBinaryStream(ColumnNames[n - 1], resultSet2.getBinaryStream(n2), 2);
                    }
                } else if (n2 == 13) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateClob(n, resultSet2.getClob(n2));
                    } else {
                        resultSet.updateClob(ColumnNames[n - 1], resultSet2.getClob(n2));
                    }
                } else if (n2 == 14) {
                    if (i == 1) {
                        resultSet.updateDate(n, resultSet2.getDate(n2));
                    } else {
                        resultSet.updateDate(ColumnNames[n - 1], resultSet2.getDate(n2));
                    }
                } else if (n2 == 15) {
                    if (i == 1) {
                        resultSet.updateTime(n, resultSet2.getTime(n2));
                    } else {
                        resultSet.updateTime(ColumnNames[n - 1], resultSet2.getTime(n2));
                    }
                } else if (n2 == 16) {
                    if (i == 1) {
                        resultSet.updateTimestamp(n, resultSet2.getTimestamp(n2));
                    } else {
                        resultSet.updateTimestamp(ColumnNames[n - 1], resultSet2.getTimestamp(n2));
                    }
                } else if (n2 == 17) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateBlob(n, resultSet2.getBlob(n2));
                    } else {
                        resultSet.updateBlob(ColumnNames[n - 1], resultSet2.getBlob(n2));
                    }
                } else if (n2 == 18) {
                    if (i == 1) {
                        resultSet.updateBoolean(n, resultSet2.getBoolean(1));
                    } else {
                        resultSet.updateBoolean(ColumnNames[n - 1], resultSet2.getBoolean(1));
                    }
                } else if (n2 == 19) {
                    if (i == 1) {
                        resultSet.updateNull(n);
                    } else {
                        resultSet.updateNull(ColumnNames[n - 1]);
                    }
                } else if (n2 == 20) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateArray(n, null);
                    } else {
                        resultSet.updateArray(ColumnNames[n - 1], null);
                    }
                } else if (n2 == 21) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateRef(n, null);
                    } else {
                        resultSet.updateRef(ColumnNames[n - 1], null);
                    }
                }
                resultSet.updateRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateXXXRulesTableForNetworkClient[n - 1][n2 - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[n - 1][n2 - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAILURE : We shouldn't reach here. The test should have failed earlier on updateXXX or updateRow call");
                    return;
                }
                this.verifyData(n, n3);
                this.resetData();
            }
            catch (SQLException sQLException) {
                if (UpdatableResultSetTest.usingDerbyNetClient()) {
                    UpdatableResultSetTest.assertSQLState("Error using " + allUpdateXXXNames[n2 - 1] + " on column type " + allSQLTypes[n - 1], updateXXXRulesTableForNetworkClient[n - 1][n2 - 1], sQLException);
                } else {
                    UpdatableResultSetTest.assertSQLState("Error using " + allUpdateXXXNames[n2 - 1] + " on column type " + allSQLTypes[n - 1], updateXXXRulesTableForEmbedded[n - 1][n2 - 1], sQLException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (n == 14 || n == 15 || n == 16) {
                    UpdatableResultSetTest.assertEquals((String)"Should be updateString", (int)7, (int)n3);
                }
                throw illegalArgumentException;
            }
            resultSet.close();
            resultSet2.close();
        }
    }

    public void testUpdateObjectWithAllDatatypes() throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int i = 1; i <= allSQLTypes.length; ++i) {
            this.rollback();
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[i - 1]);
            for (int j = 1; j <= allUpdateXXXNames.length; ++j) {
                if (JDBC.vmSupportsJSR169() && j == 4) continue;
                UpdatableResultSetTest.println("  Testing " + allUpdateXXXNames[j - 1] + " on SQL type " + allSQLTypes[i - 1]);
                this.runTestUpdateObjectWithAllDatatypes(preparedStatement, preparedStatement2, i, j);
            }
        }
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesForTestingTable");
        this.createStatement().executeUpdate("DROP TABLE AllDataTypesNewValuesData");
        this.commit();
    }

    private void runTestUpdateObjectWithAllDatatypes(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2) throws SQLException, IllegalArgumentException, UnsupportedEncodingException {
        for (int i = 1; i <= 2; ++i) {
            String string = i == 1 ? "  updateObject with column position &" : "  updateObject with column name &";
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            try {
                if (n2 == 1) {
                    UpdatableResultSetTest.println(string + " Short object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)resultSet2.getShort(n2));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getShort(n2));
                    }
                } else if (n2 == 2) {
                    UpdatableResultSetTest.println(string + " Integer object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)resultSet2.getInt(n2));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getInt(n2));
                    }
                } else if (n2 == 3) {
                    UpdatableResultSetTest.println(string + " Long object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)resultSet2.getLong(n2));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getLong(n2));
                    }
                } else if (n2 == 4) {
                    if (!JDBC.vmSupportsJSR169()) {
                        UpdatableResultSetTest.println(string + " BigDecimal object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getBigDecimal(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getBigDecimal(n2));
                        }
                    }
                } else if (n2 == 5) {
                    UpdatableResultSetTest.println(string + " Float object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)Float.valueOf(resultSet2.getFloat(n2)));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)Float.valueOf(resultSet2.getFloat(n2)));
                    }
                } else if (n2 == 6) {
                    UpdatableResultSetTest.println(string + " Double object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)resultSet2.getDouble(n2));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getDouble(n2));
                    }
                } else if (n2 == 7) {
                    UpdatableResultSetTest.println(string + " String object as parameters");
                    if (i == 1) {
                        resultSet.updateObject(n, (Object)resultSet2.getString(n2));
                    } else {
                        resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getString(n2));
                    }
                } else {
                    if (n2 == 8 || n2 == 12 || n2 == 9 || n2 == 10) continue;
                    if (n2 == 11) {
                        UpdatableResultSetTest.println(string + " bytes[] array as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getBytes(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getBytes(n2));
                        }
                    } else if (n2 == 13) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        UpdatableResultSetTest.println(string + " Clob object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getClob(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getClob(n2));
                        }
                    } else if (n2 == 14) {
                        UpdatableResultSetTest.println(string + " Date object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getDate(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getDate(n2));
                        }
                    } else if (n2 == 15) {
                        UpdatableResultSetTest.println(string + " Time object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getTime(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getTime(n2));
                        }
                    } else if (n2 == 16) {
                        UpdatableResultSetTest.println(string + " TimeStamp object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getTimestamp(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getTimestamp(n2));
                        }
                    } else if (n2 == 17) {
                        if (!JDBC.vmSupportsJDBC3()) continue;
                        UpdatableResultSetTest.println(string + " Blob object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getBlob(n2));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getBlob(n2));
                        }
                    } else if (n2 == 18) {
                        UpdatableResultSetTest.println(string + " Boolean object as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, (Object)resultSet2.getBoolean(1));
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], (Object)resultSet2.getBoolean(1));
                        }
                    } else if (n2 == 19) {
                        UpdatableResultSetTest.println(string + " null as parameters");
                        if (i == 1) {
                            resultSet.updateObject(n, null);
                        } else {
                            resultSet.updateObject(ColumnNames[n - 1], null);
                        }
                    } else if (n2 == 20 || n2 == 21) continue;
                }
                resultSet.updateRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateObjectRulesTableForNetworkClient[n - 1][n2 - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[n - 1][n2 - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAIL - We shouldn't reach here. The test should have failed earlier on updateXXX or updateRow call.");
                }
                if (n != 7 && n != 8 && n != 9 || n2 != 13) {
                    this.verifyData(n, n2);
                }
                this.resetData();
            }
            catch (SQLException sQLException) {
                if (UpdatableResultSetTest.usingEmbedded()) {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForEmbedded[n - 1][n2 - 1], sQLException);
                } else {
                    UpdatableResultSetTest.assertSQLState(updateObjectRulesTableForNetworkClient[n - 1][n2 - 1], sQLException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (n == 14 || n == 15 || n == 16) {
                    UpdatableResultSetTest.assertEquals((String)"FAIL - wrong updateXXX function", (int)7, (int)n2);
                }
                throw illegalArgumentException;
            }
            resultSet.close();
            resultSet2.close();
        }
    }

    public void testUpdateXXXWithCancelRowUpdates() throws SQLException {
        this.createAllDatatypesTable();
        Statement statement = this.createStatement(1003, 1008);
        Statement statement2 = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE");
        resultSet.next();
        ResultSet resultSet2 = statement2.executeQuery("SELECT * FROM AllDataTypesNewValuesData");
        resultSet2.next();
        short s = resultSet.getShort(1);
        resultSet.updateShort(1, resultSet2.getShort(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)resultSet2.getShort(1), (short)resultSet.getShort(1));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)s, (short)resultSet.getShort(1));
        int n = resultSet.getInt(2);
        resultSet.updateInt(2, resultSet2.getInt(2));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (int)resultSet2.getInt(2), (int)resultSet.getInt(2));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (int)n, (int)resultSet.getInt(2));
        long l = resultSet.getLong(3);
        resultSet.updateLong(3, resultSet2.getLong(3));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (long)resultSet2.getLong(3), (long)resultSet.getLong(3));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (long)l, (long)resultSet.getLong(3));
        String string = BigDecimalHandler.getBigDecimalString(resultSet, 4);
        BigDecimalHandler.updateBigDecimalString(resultSet, 4, BigDecimalHandler.getBigDecimalString(resultSet2, 4));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)BigDecimalHandler.getBigDecimalString(resultSet2, 4), (String)BigDecimalHandler.getBigDecimalString(resultSet, 4));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)string, (String)BigDecimalHandler.getBigDecimalString(resultSet, 4));
        float f = resultSet.getFloat(5);
        resultSet.updateFloat(5, resultSet2.getFloat(5));
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + resultSet2.getFloat(5) + " but was " + resultSet.getFloat(5)), (resultSet2.getFloat(5) == resultSet.getFloat(5) ? 1 : 0) != 0);
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + f + " but was " + resultSet.getFloat(5)), (f == resultSet.getFloat(5) ? 1 : 0) != 0);
        UpdatableResultSetTest.println("  updateDouble and then cancelRowUpdates");
        double d = resultSet.getDouble(6);
        resultSet.updateDouble(6, resultSet2.getDouble(6));
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + resultSet2.getDouble(6) + " but was " + resultSet.getDouble(6)), (resultSet2.getDouble(6) == resultSet.getDouble(6) ? 1 : 0) != 0);
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value returned by getXXX method expected " + d + " but was " + resultSet.getDouble(6)), (d == resultSet.getDouble(6) ? 1 : 0) != 0);
        String string2 = resultSet.getString(7);
        resultSet.updateString(7, resultSet2.getString(7));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)resultSet2.getString(7), (String)resultSet.getString(7));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)string2, (String)resultSet.getString(7));
        string2 = resultSet.getString(8);
        resultSet.updateAsciiStream(8, resultSet2.getAsciiStream(8), 4);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)resultSet.getString(8).equals(resultSet2.getString(8)));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)resultSet.getString(8).equals(string2));
        string2 = resultSet.getString(9);
        resultSet.updateCharacterStream(9, resultSet2.getCharacterStream(9), 4);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)resultSet.getString(9).equals(resultSet2.getString(9)));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)resultSet.getString(9).equals(string2));
        s = resultSet.getShort(1);
        resultSet.updateByte(1, resultSet2.getByte(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)resultSet2.getShort(1), (short)resultSet.getShort(1));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (short)s, (short)resultSet.getShort(1));
        byte[] byArray = resultSet.getBytes(11);
        resultSet.updateBytes(11, resultSet2.getBytes(11));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(11), resultSet2.getBytes(11)));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(11), byArray));
        byArray = resultSet.getBytes(12);
        resultSet.updateBinaryStream(12, resultSet2.getBinaryStream(12), 2);
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(12), resultSet2.getBytes(12)));
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(12), byArray));
        Date date = resultSet.getDate(14);
        resultSet.updateDate(14, resultSet2.getDate(14));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (resultSet.getDate(14).compareTo(resultSet2.getDate(14)) == 0 ? 1 : 0) != 0);
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (resultSet.getDate(14).compareTo(date) == 0 ? 1 : 0) != 0);
        Time time = resultSet.getTime(15);
        resultSet.updateTime(15, resultSet2.getTime(15));
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (resultSet.getTime(15).compareTo(resultSet2.getTime(15)) == 0 ? 1 : 0) != 0);
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (resultSet.getTime(15).compareTo(time) == 0 ? 1 : 0) != 0);
        Timestamp timestamp = resultSet.getTimestamp(16);
        resultSet.updateTimestamp(16, resultSet2.getTimestamp(16));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)resultSet2.getTimestamp(16).toString(), (String)resultSet.getTimestamp(16).toString());
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)timestamp.toString(), (String)resultSet.getTimestamp(16).toString());
        if (UpdatableResultSetTest.usingEmbedded() && JDBC.vmSupportsJDBC3()) {
            UpdatableResultSetTest.println("  updateClob and then cancelRowUpdates");
            String string3 = resultSet.getString(13);
            String string4 = resultSet2.getString(13);
            resultSet.updateClob(13, resultSet2.getClob(13));
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)string4, (String)resultSet.getString(13));
            resultSet.cancelRowUpdates();
            UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value returned by getXXX method", (String)string3, (String)resultSet.getString(13));
            UpdatableResultSetTest.println("  updateBlob and then cancelRowUpdates");
            byArray = resultSet.getBytes(17);
            byte[] byArray2 = resultSet2.getBytes(17);
            resultSet.updateBlob(17, resultSet2.getBlob(17));
            UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(17), byArray2));
            resultSet.cancelRowUpdates();
            UpdatableResultSetTest.assertTrue((String)"FAIL - wrong value returned by getXXX method", (boolean)Arrays.equals(resultSet.getBytes(17), byArray));
        }
        resultSet.close();
        resultSet2.close();
        statement.close();
        statement2.close();
    }

    public void testCancelRowUpdatesAndDeleteRow() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 before updateInt", (int)1, (int)resultSet.getInt(1));
        resultSet.updateInt(1, 234);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 before updateInt", (int)234, (int)resultSet.getInt(1));
        UpdatableResultSetTest.println("now cancelRowUpdates on the row");
        resultSet.cancelRowUpdates();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1 after cancelRowUpdates", (int)1, (int)resultSet.getInt(1));
        resultSet.deleteRow();
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - updateRow should have failed because ResultSet is not positioned on a row");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        UpdatableResultSetTest.println("Position the ResultSet with next()");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.println("Should be able to updateRow() on the current row now");
        resultSet.updateString(2, "234");
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"2", "234"}, {"3", "cc"}};
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testCancelRowUpdatesWithoutUpdateXXX() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.cancelRowUpdates();
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowWithoutUpdateXXX() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateRow();
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXAndDeleteRow() throws SQLException {
        String string;
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 1234);
        resultSet.updateString(2, "aaaaa");
        resultSet.deleteRow();
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.updateInt(1, 2345);
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        try {
            resultSet.getInt(1);
            UpdatableResultSetTest.fail((String)"FAIL - deleteRow should have moved the ResultSet to right before the next row");
        }
        catch (SQLException sQLException) {
            string = UpdatableResultSetTest.usingEmbedded() ? "24000" : "XJ121";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXAndMoveNext() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        UpdatableResultSetTest.println("  Issue updateInt to change the column's value to 2345");
        resultSet.updateInt(1, 2345);
        resultSet.next();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("select * from t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testMultipleUpdateXXXAndUpdateRow() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column 1", (int)1, (int)resultSet.getInt(1));
        resultSet.updateInt(1, 2345);
        resultSet.updateInt(1, 9999);
        resultSet.updateString(2, "xxxxxxx");
        UpdatableResultSetTest.println("  Now issue updateRow");
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"9999", "xxxxxxx"}, {"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXOnTableColumn() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT 1, 2, c1, c2 FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(3, 22);
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"22", "aa"}, {"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testCaseSensitiveTableAndColumnName() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("create table \"t1\" (\"c11\" int, c12 int)");
        statement.executeUpdate("insert into \"t1\" values(1, 2), (2,3)");
        ResultSet resultSet = statement.executeQuery("SELECT \"c11\", \"C12\" FROM \"t1\" FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 11);
        resultSet.updateInt(2, 22);
        resultSet.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("SELECT \"c11\", \"C12\" FROM \"t1\" FOR UPDATE");
        Object[][] objectArray = new String[][]{{"11", "22"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testTableAndColumnNameWithSpaces() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("create table \" t 11 \" (\" c 111 \" int, c112 int)");
        statement.executeUpdate("insert into \" t 11 \" values(1, 2), (2,3)");
        ResultSet resultSet = statement.executeQuery("SELECT \" c 111 \", \"C112\" FROM \" t 11 \" ");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, 11);
        resultSet.updateInt(2, 22);
        resultSet.updateRow();
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        resultSet.close();
        resultSet = statement.executeQuery("SELECT \" c 111 \", \"C112\" FROM \" t 11 \" ");
        Object[][] objectArray = new String[][]{{"11", "22"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXNotForUpdateColumns() throws SQLException {
        this.createTableT1();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT c1, c2 FROM t1 FOR UPDATE of c1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        try {
            resultSet.updateInt(2, 22);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX methods should fail when the column is not in the FOR UPDATE clause");
        }
        catch (SQLException sQLException) {
            String string = UpdatableResultSetTest.usingEmbedded() ? "42X31" : "XJ124";
            UpdatableResultSetTest.assertSQLState(string, sQLException);
        }
        resultSet.updateRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        resultSet = statement.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateTableDifferentSchema() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        this.createTableT1();
        statement.executeUpdate("create schema s2");
        statement.executeUpdate("create table s2.t1 (c1s2t1 int, c2s2t1 smallint, c3s2t2 double)");
        statement.executeUpdate("insert into s2.t1 values(1,2,2.2),(1,3,3.3)");
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        Object[][] objectArray2 = new String[][]{{"1", "2", "2.2"}, {"1", "3", "3.3"}};
        resultSet = statement.executeQuery("select * from s2.t1");
        JDBC.assertFullResultSet(resultSet, objectArray2, true);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM s2.t1 FOR UPDATE");
        resultSet.next();
        resultSet.updateInt(2, 1);
        resultSet.updateRow();
        resultSet.next();
        resultSet.updateInt(2, 1);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM t1");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        Object[][] objectArray3 = new String[][]{{"1", "1", "2.2"}, {"1", "1", "3.3"}};
        resultSet = statement.executeQuery("select * from s2.t1");
        JDBC.assertFullResultSet(resultSet, objectArray3, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowDeleteRowDoNotCommit() throws SQLException {
        int n;
        this.getConnection().setAutoCommit(true);
        this.createTableT1();
        this.commit();
        Object[][] objectArray = new String[][]{{"1", "aa"}, {"2", "bb"}, {"3", "cc"}};
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.deleteRow();
        this.rollback();
        resultSet.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.updateInt(1, -resultSet.getInt(1));
        resultSet.updateRow();
        this.rollback();
        resultSet.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM t1");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n2 = resultSet.getInt(1);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        for (n = 0; n < n2; ++n) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        }
        resultSet.deleteRow();
        this.rollback();
        resultSet.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        resultSet = statement.executeQuery("SELECT * FROM t1 FOR UPDATE");
        for (n = 0; n < n2; ++n) {
            UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        }
        resultSet.updateInt(1, -resultSet.getInt(1));
        resultSet.updateRow();
        this.rollback();
        resultSet.close();
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM t1"), objectArray, true);
        statement.executeUpdate("DROP TABLE t1");
        statement.close();
        this.commit();
    }

    public void testInsertRow() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 5);
        resultSet.updateInt(2, 5);
        resultSet.insertRow();
        int n3 = resultSet.getInt(1);
        int n4 = resultSet.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)5, (int)n3);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)5, (int)n4);
        resultSet.moveToCurrentRow();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)n, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)n2, (int)resultSet.getInt(2));
        resultSet.moveToCurrentRow();
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)n, (int)resultSet.getInt(1));
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)n2, (int)resultSet.getInt(2));
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 6);
        resultSet.updateInt(2, 4);
        n3 = resultSet.getInt(1);
        n4 = resultSet.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)6, (int)n3);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)4, (int)n4);
        resultSet.moveToInsertRow();
        n3 = resultSet.getInt(1);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c41", (int)0, (int)n3);
        UpdatableResultSetTest.assertTrue((String)"FAIL - value should be undefined when moving to insertRow", (boolean)resultSet.wasNull());
        n4 = resultSet.getInt(2);
        UpdatableResultSetTest.assertEquals((String)"FAIL - wrong value for column c42", (int)0, (int)n4);
        UpdatableResultSetTest.assertTrue((String)"FAIL - value should be undefined when moving to insertRow", (boolean)resultSet.wasNull());
        resultSet.moveToInsertRow();
        resultSet.updateInt(2, 7);
        try {
            resultSet.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - should have failed can not insert NULL into not null column");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("23502", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testUpdateRowDeleteRowFromInsertRow() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 6);
        resultSet.updateInt(2, 6);
        try {
            resultSet.updateRow();
            UpdatableResultSetTest.fail((String)"FAIL - can not call updateRow from insertRow");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        try {
            resultSet.deleteRow();
            UpdatableResultSetTest.fail((String)"FAIL - can not call deleteRow from insertRow");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("24000", sQLException);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testInsertRowFromCurrentRow() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToCurrentRow();
        try {
            resultSet.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insert row not allowed from current row");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ086", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testInsertRowFromDifferentPositions() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet = statement.executeQuery("SELECT * FROM t4 WHERE c41 <= 5");
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 1000);
        resultSet.updateInt(2, 1000);
        resultSet.insertRow();
        while (resultSet.next()) {
            int n = resultSet.getInt(1);
            int n2 = resultSet.getInt(2);
            resultSet.moveToInsertRow();
            resultSet.updateInt(1, n + 100);
            resultSet.updateInt(2, n2 + 100);
            resultSet.insertRow();
        }
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 2000);
        resultSet.updateInt(2, 2000);
        resultSet.insertRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"1000", "1000"}, {"101", "101"}, {"102", "102"}, {"103", "103"}, {"104", "104"}, {"2000", "2000"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testInsertRowWithNullColumn() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 7);
        resultSet.insertRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"7", null}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void xTestInsertRowAfterCommit() throws SQLException {
        this.createTableT4();
        this.getConnection().setHoldability(1);
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 8);
        resultSet.updateInt(2, 8);
        this.commit();
        resultSet.insertRow();
        resultSet.close();
        statement.close();
        this.getConnection().setHoldability(2);
        statement = this.createStatement(1003, 1008);
        resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 82);
        resultSet.updateInt(2, 82);
        this.commit();
        try {
            resultSet.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - result set is not holdable and should be closed after commit");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
            UpdatableResultSetTest.assertTrue((sQLException.getMessage().indexOf("insertRow") > 0 ? 1 : 0) != 0);
        }
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"8", "8"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.executeUpdate("DROP TABLE t4");
        statement.close();
        this.commit();
    }

    public void testInsertRowAfterClose() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 9);
        resultSet.updateInt(2, 9);
        resultSet.close();
        try {
            resultSet.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insertRow can not be called on closed RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet.moveToCurrentRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToCurrentRow can not be called on closed RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
        }
        try {
            resultSet.moveToInsertRow();
            UpdatableResultSetTest.fail((String)"FAIL: moveToInsertRow can not be called on closed RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XCL16", sQLException);
        }
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testInsertRowWithDefaultValue() throws SQLException {
        this.createTableT5();
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t5");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.insertRow();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"0", null}};
        resultSet = statement.executeQuery("SELECT * FROM t5");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.close();
    }

    public void testRollbackWithAutoCommit() throws SQLException {
        this.createTableT4();
        this.getConnection().setAutoCommit(true);
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        UpdatableResultSetTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        resultSet.moveToInsertRow();
        resultSet.updateInt(1, 4000);
        resultSet.updateInt(2, 4000);
        resultSet.insertRow();
        this.rollback();
        resultSet.close();
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        resultSet = statement.executeQuery("SELECT * FROM t4");
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet.close();
        statement.executeUpdate("DROP TABLE t4");
        statement.close();
        this.commit();
    }

    public void testInsertRowReadOnlyRS() throws SQLException {
        this.createTableT4();
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t4");
        try {
            resultSet.moveToInsertRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToInsertRow can not be called on read-only RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.updateInt(1, 5000);
            UpdatableResultSetTest.fail((String)"FAIL - updateXXX not allowed on read-only RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.insertRow();
            UpdatableResultSetTest.fail((String)"FAIL - insertRow not allowed on read-only RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        try {
            resultSet.moveToCurrentRow();
            UpdatableResultSetTest.fail((String)"FAIL - moveToCurrentRow can not be called on read-only RS");
        }
        catch (SQLException sQLException) {
            UpdatableResultSetTest.assertSQLState("XJ083", sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void testUpdateXXXAllDataTypesInsertRow() throws SQLException, UnsupportedEncodingException {
        this.createAllDatatypesTable();
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM AllDataTypesForTestingTable");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM AllDataTypesForTestingTable FOR UPDATE", 1003, 1008);
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM AllDataTypesNewValuesData");
        for (int i = 1; i <= allSQLTypes.length; ++i) {
            UpdatableResultSetTest.println("Next datatype to test is " + allSQLTypes[i - 1]);
            for (int j = 1; j <= allUpdateXXXNames.length; ++j) {
                UpdatableResultSetTest.println("  Testing " + allUpdateXXXNames[j - 1] + " on SQL type " + allSQLTypes[i - 1]);
                this.runTestUpdateXXXAllDataTypesInsertRow(preparedStatement, preparedStatement2, i, j);
            }
        }
    }

    private void runTestUpdateXXXAllDataTypesInsertRow(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, int n, int n2) throws SQLException, UnsupportedEncodingException {
        Statement statement = this.createStatement();
        int n3 = n2;
        for (int i = 1; i <= 2; ++i) {
            if (i == 1) {
                UpdatableResultSetTest.println("Using column position as first parameter to " + allUpdateXXXNames[n2 - 1]);
            } else {
                UpdatableResultSetTest.println("Using column name as first parameter to " + allUpdateXXXNames[n2 - 1]);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.moveToInsertRow();
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            try {
                if (n2 == 1) {
                    if (i == 1) {
                        resultSet.updateShort(n, resultSet2.getShort(n2));
                    } else {
                        resultSet.updateShort(ColumnNames[n - 1], resultSet2.getShort(n2));
                    }
                } else if (n2 == 2) {
                    if (i == 1) {
                        resultSet.updateInt(n, resultSet2.getInt(n2));
                    } else {
                        resultSet.updateInt(ColumnNames[n - 1], resultSet2.getInt(n2));
                    }
                } else if (n2 == 3) {
                    if (i == 1) {
                        resultSet.updateLong(n, resultSet2.getLong(n2));
                    } else {
                        resultSet.updateLong(ColumnNames[n - 1], resultSet2.getLong(n2));
                    }
                } else if (n2 == 4) {
                    if (JDBC.vmSupportsJSR169()) continue;
                    if (i == 1) {
                        resultSet.updateBigDecimal(n, resultSet2.getBigDecimal(n2));
                    } else {
                        resultSet.updateBigDecimal(ColumnNames[n - 1], resultSet2.getBigDecimal(n2));
                    }
                } else if (n2 == 5) {
                    if (i == 1) {
                        resultSet.updateFloat(n, resultSet2.getFloat(n2));
                    } else {
                        resultSet.updateFloat(ColumnNames[n - 1], resultSet2.getFloat(n2));
                    }
                } else if (n2 == 6) {
                    if (i == 1) {
                        resultSet.updateDouble(n, resultSet2.getDouble(n2));
                    } else {
                        resultSet.updateDouble(ColumnNames[n - 1], resultSet2.getDouble(n2));
                    }
                } else if (n2 == 7) {
                    if (i == 1) {
                        resultSet.updateString(n, resultSet2.getString(n2));
                    } else {
                        resultSet.updateString(ColumnNames[n - 1], resultSet2.getString(n2));
                    }
                } else if (n2 == 8) {
                    if (i == 1) {
                        resultSet.updateAsciiStream(n, resultSet2.getAsciiStream(n2), 4);
                    } else {
                        resultSet.updateAsciiStream(ColumnNames[n - 1], resultSet2.getAsciiStream(n2), 4);
                    }
                } else if (n2 == 9) {
                    if (i == 1) {
                        resultSet.updateCharacterStream(n, resultSet2.getCharacterStream(n2), 4);
                    } else {
                        resultSet.updateCharacterStream(ColumnNames[n - 1], resultSet2.getCharacterStream(n2), 4);
                    }
                } else if (n2 == 10) {
                    n3 = 1;
                    if (i == 1) {
                        resultSet.updateByte(n, resultSet2.getByte(n3));
                    } else {
                        resultSet.updateByte(ColumnNames[n - 1], resultSet2.getByte(n3));
                    }
                } else if (n2 == 11) {
                    if (i == 1) {
                        resultSet.updateBytes(n, resultSet2.getBytes(n2));
                    } else {
                        resultSet.updateBytes(ColumnNames[n - 1], resultSet2.getBytes(n2));
                    }
                } else if (n2 == 12) {
                    if (i == 1) {
                        resultSet.updateBinaryStream(n, resultSet2.getBinaryStream(n2), 2);
                    } else {
                        resultSet.updateBinaryStream(ColumnNames[n - 1], resultSet2.getBinaryStream(n2), 2);
                    }
                } else if (n2 == 13) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateClob(n, resultSet2.getClob(n2));
                    } else {
                        resultSet.updateClob(ColumnNames[n - 1], resultSet2.getClob(n2));
                    }
                } else if (n2 == 14) {
                    if (i == 1) {
                        resultSet.updateDate(n, resultSet2.getDate(n2));
                    } else {
                        resultSet.updateDate(ColumnNames[n - 1], resultSet2.getDate(n2));
                    }
                } else if (n2 == 15) {
                    if (i == 1) {
                        resultSet.updateTime(n, resultSet2.getTime(n2));
                    } else {
                        resultSet.updateTime(ColumnNames[n - 1], resultSet2.getTime(n2));
                    }
                } else if (n2 == 16) {
                    if (i == 1) {
                        resultSet.updateTimestamp(n, resultSet2.getTimestamp(n2));
                    } else {
                        resultSet.updateTimestamp(ColumnNames[n - 1], resultSet2.getTimestamp(n2));
                    }
                } else if (n2 == 17) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateBlob(n, resultSet2.getBlob(n2));
                    } else {
                        resultSet.updateBlob(ColumnNames[n - 1], resultSet2.getBlob(n2));
                    }
                } else if (n2 == 18) {
                    if (i == 1) {
                        resultSet.updateBoolean(n, resultSet2.getBoolean(1));
                    } else {
                        resultSet.updateBoolean(ColumnNames[n - 1], resultSet2.getBoolean(1));
                    }
                } else if (n2 == 19) {
                    if (i == 1) {
                        resultSet.updateNull(n);
                    } else {
                        resultSet.updateNull(ColumnNames[n - 1]);
                    }
                } else if (n2 == 20) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateArray(n, null);
                    } else {
                        resultSet.updateArray(ColumnNames[n - 1], null);
                    }
                } else if (n2 == 21) {
                    if (!JDBC.vmSupportsJDBC3()) continue;
                    if (i == 1) {
                        resultSet.updateRef(n, null);
                    } else {
                        resultSet.updateRef(ColumnNames[n - 1], null);
                    }
                }
                resultSet.insertRow();
                if (UpdatableResultSetTest.usingDerbyNetClient() && !updateXXXRulesTableForNetworkClient[n - 1][n2 - 1].equals("PASS") || UpdatableResultSetTest.usingEmbedded() && !updateXXXRulesTableForEmbedded[n - 1][n2 - 1].equals("PASS")) {
                    UpdatableResultSetTest.fail((String)"FAIL - We shouldn't reach here. The test should have failed earlier on updateXXX or insertRow call");
                    return;
                }
                this.verifyData(n, n3);
                statement.executeUpdate("DELETE FROM AllDataTypesForTestingTable");
            }
            catch (SQLException sQLException) {
                if (UpdatableResultSetTest.usingEmbedded()) {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForEmbedded[n - 1][n2 - 1], sQLException);
                } else {
                    UpdatableResultSetTest.assertSQLState(updateXXXRulesTableForNetworkClient[n - 1][n2 - 1], sQLException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (n == 14 || n == 15 || n == 16) {
                    UpdatableResultSetTest.assertEquals((String)"FAIL - exception expected for updateString", (int)7, (int)n3);
                }
                throw illegalArgumentException;
            }
            resultSet.close();
            resultSet2.close();
        }
        this.closeStatement(statement);
    }

    private void createTableT1() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1 (c1 int, c2 char(20))");
        statement.executeUpdate("insert into t1 values (1,'aa'), (2,'bb'), (3,'cc')");
        statement.close();
    }

    private void createTableT2() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t2 (c21 int, c22 int)");
        statement.executeUpdate("insert into t2 values (1,1), (2, 2), (3, 3), (4, 4)");
        statement.close();
    }

    private void createTableT3() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t3 (c31 int not null primary key, c32 smallint)");
        statement.executeUpdate("insert into t3 values (1,1), (2, 2), (3, 3), (4, 4)");
        statement.close();
    }

    private void createTableT4() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t4 (c41 int not null primary key, c42 int)");
        statement.executeUpdate("insert into t4 values (1,1), (2,2), (3,3), (4, 4)");
        statement.close();
    }

    private void createTableT5() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t5 (c51 int not null default 0, c52 int)");
        statement.executeUpdate("insert into t5 values (1,1), (2,2), (3,3), (4, 4)");
        statement.close();
    }

    private void createTableWithPrimaryKey() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tableWithPrimaryKey (c1 int not null, c2 int not null, constraint pk primary key(c1,c2))");
        statement.executeUpdate("create table tableWithConstraint (c1 int, c2 int, constraint fk foreign key(c1,c2) references tableWithPrimaryKey)");
        statement.executeUpdate("insert into tableWithPrimaryKey values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.executeUpdate("insert into tableWithConstraint values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.close();
    }

    private void createTable0WithTrigger() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table table0WithTriggers (c1 int, c2 bigint)");
        statement.executeUpdate("create table deleteTriggerInsertIntoThisTable (c1 int)");
        statement.executeUpdate("create table updateTriggerInsertIntoThisTable (c1 int)");
        statement.executeUpdate("create trigger tr1 after delete on table0WithTriggers for each statement insert into deleteTriggerInsertIntoThisTable values (1)");
        statement.executeUpdate("create trigger tr2 after update on table0WithTriggers for each statement insert into updateTriggerInsertIntoThisTable values (1)");
        statement.executeUpdate("insert into table0WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.close();
    }

    private void createTable1WithTrigger() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table table1WithTriggers (c1 int, c2 bigint)");
        statement.executeUpdate("create trigger tr3 after delete on table1WithTriggers referencing old as old for each row delete from table1WithTriggers where c1=old.c1+1 or c1=old.c1-1");
        statement.executeUpdate("create table table2WithTriggers (c1 int, c2 bigint)");
        statement.executeUpdate("create trigger tr4 after update of c2 on table2WithTriggers for each statement update table2WithTriggers set c1=1");
        statement.executeUpdate("insert into table1WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.executeUpdate("insert into table2WithTriggers values (1, 1), (2, 2), (3, 3), (4, 4)");
        statement.close();
    }

    private void createSelfReferencingTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table selfReferencingT1 (c1 char(2) not null, c2 char(2), constraint selfReferencingT1 primary key(c1), constraint manages1 foreign key(c2) references selfReferencingT1(c1) on delete cascade)");
        statement.executeUpdate("create table selfReferencingT2 (c1 char(2) not null, c2 char(2), constraint selfReferencingT2 primary key(c1), constraint manages2 foreign key(c2) references selfReferencingT2(c1) on update restrict)");
        statement.executeUpdate("insert into selfReferencingT1 values ('e1', null), ('e2', 'e1'), ('e3', 'e2'), ('e4', 'e3')");
        statement.executeUpdate("insert into selfReferencingT2 values ('e1', null), ('e2', 'e1'), ('e3', 'e2'), ('e4', 'e3')");
        statement.close();
    }

    private void createAllDatatypesTable() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        StringBuffer stringBuffer = new StringBuffer("create table AllDataTypesForTestingTable (");
        StringBuffer stringBuffer2 = new StringBuffer("create table AllDataTypesNewValuesData (");
        for (n = 0; n < allSQLTypes.length - 1; ++n) {
            stringBuffer.append(ColumnNames[n] + " " + allSQLTypes[n] + ",");
            stringBuffer2.append(ColumnNames[n] + " " + allSQLTypes[n] + ",");
        }
        stringBuffer.append(ColumnNames[allSQLTypes.length - 1] + " " + allSQLTypes[allSQLTypes.length - 1] + ")");
        stringBuffer2.append(ColumnNames[allSQLTypes.length - 1] + " " + allSQLTypes[allSQLTypes.length - 1] + ")");
        statement.executeUpdate(stringBuffer.toString());
        statement.executeUpdate(stringBuffer2.toString());
        stringBuffer = new StringBuffer("insert into AllDataTypesForTestingTable values(");
        stringBuffer2 = new StringBuffer("insert into AllDataTypesNewValuesData values(");
        for (n = 0; n < allSQLTypes.length - 1; ++n) {
            stringBuffer.append(SQLData[n][0] + ",");
            stringBuffer2.append(SQLData[n][1] + ",");
        }
        stringBuffer.append("cast(" + SQLData[allSQLTypes.length - 1][0] + " as BLOB(1K)))");
        stringBuffer2.append("cast(" + SQLData[allSQLTypes.length - 1][1] + " as BLOB(1K)))");
        statement.executeUpdate(stringBuffer.toString());
        statement.executeUpdate(stringBuffer2.toString());
        statement.close();
    }

    private void verifyData(int n, int n2) throws SQLException, UnsupportedEncodingException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from AllDataTypesNewValuesData");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from AllDataTypesForTestingTable");
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet2.next();
        if (n2 == 18) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (boolean)resultSet2.getBoolean(n), (boolean)resultSet.getBoolean(1));
        } else if (n2 == 19) {
            UpdatableResultSetTest.assertNull((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (Object)resultSet2.getObject(n));
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (boolean)resultSet2.wasNull());
        } else if (n == 1) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (short)resultSet.getShort(n2), (short)resultSet2.getShort(n));
        } else if (n == 2) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (int)resultSet.getInt(n2), (int)resultSet2.getInt(n));
        } else if (n == 3) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (long)resultSet.getLong(n2), (long)resultSet2.getLong(n));
        } else if (n == 4) {
            if (!JDBC.vmSupportsJSR169()) {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + resultSet2.getBigDecimal(n)), (resultSet2.getBigDecimal(n).doubleValue() == resultSet.getBigDecimal(n2).doubleValue() ? 1 : 0) != 0);
            }
        } else if (n == 5) {
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (resultSet2.getFloat(n) == resultSet.getFloat(n2) ? 1 : 0) != 0);
        } else if (n == 6) {
            Double d = resultSet2.getDouble(n);
            Double d2 = resultSet.getDouble(n2);
            if (n2 == 5) {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (d.floatValue() == d2.floatValue() ? 1 : 0) != 0);
            } else {
                UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (d.doubleValue() == d2.doubleValue() ? 1 : 0) != 0);
            }
        } else if (n == 7 || n == 8 || n == 9) {
            if (n2 == 11) {
                String string = new String(resultSet.getBytes(n2), "UTF-16BE").trim();
                UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (String)string, (String)resultSet2.getString(n).trim());
            } else {
                UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (String)resultSet.getString(n2).trim(), (String)resultSet2.getString(n).trim());
            }
        } else if (n == 10 || n == 11 || n == 12) {
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (boolean)Arrays.equals(resultSet2.getBytes(n), resultSet.getBytes(n2)));
        } else if (n == 13 && JDBC.vmSupportsJDBC3()) {
            Clob clob = resultSet2.getClob(n);
            int n3 = (int)clob.length();
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (String)resultSet.getString(n2).trim(), (String)clob.getSubString(1L, n3).trim());
        } else if (n == 14) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (Object)resultSet.getDate(n2), (Object)resultSet2.getDate(n));
        } else if (n == 15) {
            UpdatableResultSetTest.assertEquals("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1], resultSet.getTime(n2), resultSet2.getTime(n));
        } else if (n == 16) {
            UpdatableResultSetTest.assertEquals((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (Object)resultSet.getTimestamp(n2), (Object)resultSet2.getTimestamp(n));
        } else if (n == 17 && JDBC.vmSupportsJDBC3()) {
            Blob blob = resultSet2.getBlob(n);
            long l = blob.length();
            UpdatableResultSetTest.assertTrue((String)("FAIL - wrong value on " + allSQLTypes[n - 1] + " using " + allUpdateXXXNames[n2 - 1]), (boolean)Arrays.equals(blob.getBytes(1L, (int)l), resultSet.getBytes(n2)));
        }
        resultSet2.close();
        resultSet.close();
        this.closeStatement(preparedStatement2);
        this.closeStatement(preparedStatement);
    }

    private void resetData() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from AllDataTypesForTestingTable");
        StringBuffer stringBuffer = new StringBuffer("insert into AllDataTypesForTestingTable values(");
        for (int i = 0; i < allSQLTypes.length - 1; ++i) {
            stringBuffer.append(SQLData[i][0] + ",");
        }
        stringBuffer.append("cast(" + SQLData[allSQLTypes.length - 1][0] + " as BLOB(1K)))");
        statement.executeUpdate(stringBuffer.toString());
        this.closeStatement(statement);
    }
}

