/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ViewsTest
extends BaseJDBCTestCase {
    public ViewsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("views Test");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(ViewsTest.class));
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void test_DERBY6185() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table mytbl1 (name clob(10K))");
        statement.executeUpdate("insert into mytbl1 values ('Col1'),('Col2')");
        statement.executeUpdate("create table mytbl2 (name clob(10K))");
        statement.executeUpdate("insert into mytbl2 values ('Col1'),('Col2')");
        statement.executeUpdate("create view myview (name) as select t1.name from mytbl1 t1 union all select t2.name from mytbl2 t2");
        resultSet = statement.executeQuery("select name from mytbl1 where name LIKE 'Col1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}});
        PreparedStatement preparedStatement = this.prepareStatement("select name from mytbl1 where name LIKE ?");
        preparedStatement.setString(1, "Col1");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}});
        resultSet = statement.executeQuery("select name from myview where name LIKE 'Col1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}, {"Col1"}});
        preparedStatement = this.prepareStatement("select name from myview where name LIKE ?");
        preparedStatement.setString(1, "Col1");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}, {"Col1"}});
        resultSet = statement.executeQuery("select name from (select name from mytbl1 t1 union all select t2.name from mytbl2 t2) as s where name like 'Col1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}, {"Col1"}});
        preparedStatement = this.prepareStatement("select name from (select name from mytbl1 t1 union all select t2.name from mytbl2 t2) as s where name like ?");
        preparedStatement.setString(1, "Col1");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Col1"}, {"Col1"}});
    }

    public void test_views() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(false);
        statement.executeUpdate("create table t1(i int, s smallint, f float, dp double precision)");
        statement.executeUpdate(" create table t2(i int, s smallint, f float, dp double precision)");
        statement.executeUpdate(" create table insert_test (f float)");
        statement.executeUpdate("create view sv1 (s_was_i, dp_was_s, i_was_f, f_was_dp) as select * from t1");
        statement.executeUpdate(" create view sv2 as select * from t1");
        statement.executeUpdate(" create view sv3 as select dp, f from t1 where i = s");
        statement.executeUpdate(" create view sv4(i) as values 1, 2, 3");
        statement.executeUpdate(" create view sv5 (c1) as select * from sv4");
        statement.executeUpdate(" create view cv1 (t1_i, t2_s, t1_f, t2_dp) as select t1.i, t2.s, t1.f, t2.dp from t1, t2 where t1.i between t2.s and t2.i");
        statement.executeUpdate(" create view cv2 as select * from sv1, sv3 where dp = f_was_dp");
        statement.executeUpdate(" create view cv3(i,s,f,dp) as select i, s, f, dp from sv2 union select dp_was_s, s_was_i, f_was_dp, i_was_f from sv1");
        statement.executeUpdate(" create view cv4 (distinct_i) as select distinct i from t1");
        statement.executeUpdate(" create view cv5(i,s) as select * from (select i, s from cv3 where i = s) xyz");
        statement.executeUpdate(" create view cv6 (c1, c2) as select a.c1 as x, b.c1 as y from sv5 a, sv5 b where a.c1 <> b.c1");
        statement.executeUpdate(" create view cv7 as select t.i, v.c1 from t1 t, cv6 v where t.i = v.c1");
        statement.executeUpdate(" create view cv8(col1, col2) as select 'Column 1',  'Value = ' || cast(c1 as char(5)) from cv7 where 1 in (select i from sv5)");
        statement.executeUpdate("insert into t1 values (1, 1, 1.0, 1.0)");
        statement.executeUpdate(" insert into t1 values (1, 2, 3.0, 4.0)");
        statement.executeUpdate(" insert into t1 values (8, 7, 6.0, 5.0)");
        statement.executeUpdate(" insert into t2 values (1, 1, 1.0, 1.0)");
        statement.executeUpdate(" insert into t2 values (1, 2, 3.0, 4.0)");
        statement.executeUpdate(" insert into t2 values (8, 7, 6.0, 5.0)");
        ViewsTest.assertStatementError("42X98", statement, "create view vneg as select * from t1 where i = ?");
        ViewsTest.assertStatementError("X0Y16", statement, "drop view t1");
        ViewsTest.assertStatementError("42Y62", statement, "drop table sv1");
        ViewsTest.assertStatementError("X0Y32", statement, "create view sv1(i) as values 1");
        ViewsTest.assertStatementError("X0Y32", statement, " create table sv1 (c1 int)");
        ViewsTest.assertStatementError("X0Y32", statement, " create view t1(i) as values 1");
        ViewsTest.assertStatementError("X0X05", statement, "drop view notexists");
        ViewsTest.assertStatementError("42Y13", statement, "create view shouldntwork (c1, c2, c1) as select i, s, f from t1");
        ViewsTest.assertStatementError("42X56", statement, "create view shouldntwork (c1, c2, c3) as select i, s from t1");
        ViewsTest.assertStatementError("42X56", statement, " create view shouldntwork (c1, c2, c3) as select i, s, f, dp from t1");
        ViewsTest.assertStatementError(new String[]{"X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0Y23"}, statement, "drop table t1");
        ViewsTest.assertStatementError("X0Y23", statement, " drop table t2");
        ViewsTest.assertStatementError(new String[]{"X0Y23", "X0Y23", "X0Y23"}, statement, "drop view sv1");
        ViewsTest.assertStatementError("X0Y23", statement, " drop view sv3");
        PreparedStatement preparedStatement = this.prepareStatement("select * from cv8");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        ViewsTest.assertStatementError("X0X95", statement, " drop view cv8");
        ViewsTest.assertStatementErrorUnordered(new String[]{"X0Y23", "X0Y23", "X0Y23", "X0X95"}, statement, " drop view sv5");
        ViewsTest.assertStatementErrorUnordered(new String[]{"X0Y23", "X0Y23", "X0Y23", "X0Y23", "X0X95"}, statement, " drop view sv4");
        resultSet2.close();
        preparedStatement.close();
        ViewsTest.assertStatementError("42Y24", statement, "insert into sv1 values 1");
        ViewsTest.assertStatementError("42Y24", statement, " delete from sv1");
        ViewsTest.assertStatementError("42Y24", statement, " update sv1 set s_was_i = 0");
        try {
            this.prepareStatement("select * from sv1 for update of s_was_i");
            ViewsTest.fail((String)"statement ps_c2 should not have succeeded");
        }
        catch (SQLException sQLException) {
            ViewsTest.assertSQLState("42Y90", sQLException);
        }
        ViewsTest.assertStatementError("42Y62", statement, "create index i1 on sv2(i)");
        resultSet = statement.executeQuery("select * from sv1");
        String[] stringArray = new String[]{"S_WAS_I", "DP_WAS_S", "I_WAS_F", "F_WAS_DP"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1", "1.0", "1.0"}, {"1", "2", "3.0", "4.0"}, {"8", "7", "6.0", "5.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from sv2");
        stringArray = new String[]{"I", "S", "F", "DP"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1.0", "1.0"}, {"1", "2", "3.0", "4.0"}, {"8", "7", "6.0", "5.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from sv3");
        stringArray = new String[]{"DP", "F"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1.0", "1.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from sv4");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from sv5");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv1");
        stringArray = new String[]{"T1_I", "T2_S", "T1_F", "T2_DP"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1.0", "1.0"}, {"1", "1", "3.0", "1.0"}, {"8", "7", "6.0", "5.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv2");
        stringArray = new String[]{"S_WAS_I", "DP_WAS_S", "I_WAS_F", "F_WAS_DP", "DP", "F"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1.0", "1.0", "1.0", "1.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv3");
        stringArray = new String[]{"I", "S", "F", "DP"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1.0", "1.0"}, {"1", "2", "3.0", "4.0"}, {"2", "1", "4.0", "3.0"}, {"7", "8", "5.0", "6.0"}, {"8", "7", "6.0", "5.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv4 order by 1");
        stringArray = new String[]{"DISTINCT_I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv5");
        stringArray = new String[]{"I", "S"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv6");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2"}, {"1", "3"}, {"2", "1"}, {"2", "3"}, {"3", "1"}, {"3", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv7");
        stringArray = new String[]{"I", "C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"1", "1"}, {"1", "1"}, {"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from cv8");
        stringArray = new String[]{"COL1", "COL2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Column 1", "Value = 1"}, {"Column 1", "Value = 1"}, {"Column 1", "Value = 1"}, {"Column 1", "Value = 1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (select * from cv3) x order by 1,2");
        stringArray = new String[]{"I", "S", "F", "DP"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1", "1.0", "1.0"}, {"1", "2", "3.0", "4.0"}, {"2", "1", "4.0", "3.0"}, {"7", "8", "5.0", "6.0"}, {"8", "7", "6.0", "5.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (select * from cv4) x order by 1");
        stringArray = new String[]{"DISTINCT_I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"8"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from (select * from cv5) x");
        stringArray = new String[]{"I", "S"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create index i on t1(i)");
        statement.executeUpdate(" drop index i");
        resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where CAST(tabletype AS CHAR(1)) = 'S' and CAST(tablename AS VARCHAR(128)) != 'SYSDUMMY1' order by tablename");
        stringArray = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"SYSALIASES", "1"}, {"SYSCHECKS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSCOLUMNS", "1"}, {"SYSCONGLOMERATES", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSDEPENDS", "1"}, {"SYSFILES", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSKEYS", "1"}, {"SYSPERMS", "1"}, {"SYSROLES", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSSEQUENCES", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSTABLES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSUSERS", "1"}, {"SYSVIEWS", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("insert into insert_test select * from sv5");
        resultSet = statement.executeQuery(" select * from insert_test");
        stringArray = new String[]{"F"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1.0"}, {"2.0"}, {"3.0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop view cv8");
        statement.executeUpdate(" drop view cv7");
        statement.executeUpdate(" drop view cv6");
        statement.executeUpdate(" drop view cv5");
        statement.executeUpdate(" drop view cv4");
        statement.executeUpdate(" drop view cv3");
        statement.executeUpdate(" drop view cv2");
        statement.executeUpdate(" drop view cv1");
        statement.executeUpdate(" drop view sv5");
        statement.executeUpdate(" drop view sv4");
        statement.executeUpdate(" drop view sv3");
        statement.executeUpdate(" drop view sv2");
        statement.executeUpdate(" drop view sv1");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate(" drop table t2");
        statement.executeUpdate(" drop table insert_test");
        resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where CAST(tabletype as CHAR(1)) = 'S' and CAST(tablename  as VARCHAR(128)) != 'SYSDUMMY1' order by tablename");
        stringArray = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"SYSALIASES", "1"}, {"SYSCHECKS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSCOLUMNS", "1"}, {"SYSCONGLOMERATES", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSDEPENDS", "1"}, {"SYSFILES", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSKEYS", "1"}, {"SYSPERMS", "1"}, {"SYSROLES", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSSEQUENCES", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSTABLES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSUSERS", "1"}, {"SYSVIEWS", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("CREATE TABLE orgtable ( name VARCHAR(255), supervisorname VARCHAR(255), jobtitle VARCHAR(255) )");
        statement.executeUpdate(" CREATE VIEW orgview AS SELECT name, supervisorname, jobtitle FROM orgtable");
        resultSet = statement.executeQuery(" SELECT name,jobtitle FROM orgview WHERE name IN (SELECT supervisorname FROM orgview WHERE name LIKE 'WYATT%')");
        stringArray = new String[]{"NAME", "JOBTITLE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate(" drop view orgview");
        statement.executeUpdate(" drop table orgtable");
        this.getConnection().setAutoCommit(true);
        statement.executeUpdate("CREATE SCHEMA TEST_SCHEMA");
        statement.executeUpdate(" CREATE TABLE TEST_SCHEMA.T1 (TABLE_COLUMN LONG VARCHAR)");
        statement.executeUpdate(" CREATE VIEW TEST_SCHEMA.V1 AS SELECT TABLE_COLUMN AS VIEW_COLUMN FROM TEST_SCHEMA.T1");
        statement.executeUpdate(" DROP VIEW TEST_SCHEMA.V1");
        statement.executeUpdate(" DROP TABLE TEST_SCHEMA.T1");
        statement.executeUpdate(" DROP SCHEMA TEST_SCHEMA RESTRICT");
        statement.executeUpdate("CREATE SCHEMA TEST_SCHEMA");
        statement.executeUpdate(" CREATE TABLE TEST_SCHEMA.T1 (TABLE_COLUMN LONG VARCHAR)");
        statement.executeUpdate(" CREATE VIEW TEST_SCHEMA.V1 AS SELECT TABLE_COLUMN AS VIEW_COLUMN FROM TEST_SCHEMA.T1");
        statement.executeUpdate(" DROP VIEW TEST_SCHEMA.V1");
        statement.executeUpdate(" DROP TABLE TEST_SCHEMA.T1");
        statement.executeUpdate(" DROP SCHEMA TEST_SCHEMA RESTRICT");
        ViewsTest.assertStatementError("42X07", statement, "CREATE VIEW v1(c1) AS VALUES NULL");
        statement.executeUpdate("create table o (name varchar(20), ord int)");
        statement.executeUpdate(" create table a (ord int, amount int)");
        statement.executeUpdate(" create view v1 (vx, vy) as select name, sum(ord) from o where ord > 0 group by name, ord");
        statement.executeUpdate(" create view v2 (vx, vy) as select name, sum(ord) from o where ord > 0 group by name, ord having ord <= ANY (select ord from a)");
        statement.executeUpdate(" drop view v2");
        statement.executeUpdate(" drop view v1");
        statement.executeUpdate(" drop table a");
        statement.executeUpdate(" drop table o");
        this.getConnection().rollback();
        statement.close();
    }

    public void testSelectViewFromOtherSchemaWithNoDefaultSchema() throws SQLException {
        Connection connection = this.openDefaultConnection("joe", "joepass");
        Statement statement = connection.createStatement();
        statement.execute("create table mytable(a int)");
        statement.execute("insert into mytable values (99)");
        statement.execute("create view myview as select * from mytable");
        statement.close();
        connection.close();
        Connection connection2 = this.openDefaultConnection("bill", "billpass");
        Statement statement2 = connection2.createStatement();
        ResultSet resultSet = statement2.executeQuery("SELECT * FROM JOE.MYVIEW");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"99"}});
        statement2.executeUpdate("drop view joe.myview");
        statement2.executeUpdate("drop table joe.mytable");
        statement2.close();
        connection2.close();
    }

    public void testViewMetaDataWithGeneratedColumnsDerby4230() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table A (id integer, data varchar(20), data2 integer)");
        statement.executeUpdate("insert into A values (3, 'G', 5), (23, 'G', 4), (5, 'F', 1), (2, 'H', 4), (1, 'F', 5)");
        statement.executeUpdate("create view V (data, num) as select data, data2 + 2 from A group by data, data2");
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, "V", null);
        String[][] stringArray = new String[][]{{"", "APP", "V", "DATA", "12", "VARCHAR", "20", null, null, null, "1", "", null, null, null, "40", "1", "YES", null, null, null, null, "NO", "NO", null}, {"", "APP", "V", "NUM", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "2", "YES", null, null, null, null, "NO", "NO", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        ResultSet resultSet2 = statement.executeQuery("SELECT * FROM V");
        JDBC.assertColumnNames(resultSet2, "DATA", "NUM");
        JDBC.assertColumnTypes(resultSet2, new int[]{12, 4});
        JDBC.assertNullability(resultSet2, new boolean[]{true, true});
        String[][] stringArray2 = new String[][]{{"F", "3"}, {"F", "7"}, {"G", "6"}, {"G", "7"}, {"H", "6"}};
        JDBC.assertFullResultSet(resultSet2, stringArray2);
        statement.executeUpdate("DROP VIEW V");
        statement.executeUpdate("DROP TABLE A");
    }

    public void testViewMetaDataWithCorrelationNameAndDerivedColumnList_3478() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1 (i int, j int)");
        statement.executeUpdate("insert into t1 values (1, 1), (1, -1),                       (2, 2), (3, -3), (4, 4)");
        statement.executeUpdate("create view v1 as select j, i from t1");
        statement.executeUpdate("create view v2 (x,y,z) as select j, i, i+j from t1");
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, "V1", null);
        String[][] stringArray = new String[][]{{"", "APP", "V1", "J", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}, {"", "APP", "V1", "I", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "2", "YES", null, null, null, null, "NO", "NO", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        stringArray = new String[][]{{"", "APP", "V2", "X", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}, {"", "APP", "V2", "Y", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "2", "YES", null, null, null, null, "NO", "NO", null}, {"", "APP", "V2", "Z", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "3", "YES", null, null, null, null, "NO", "NO", null}};
        resultSet = databaseMetaData.getColumns(null, null, "V2", null);
        JDBC.assertFullResultSet(resultSet, stringArray);
        ResultSet resultSet2 = statement.executeQuery("select * from v1 x(a,b)");
        JDBC.assertColumnNames(resultSet2, "A", "B");
        JDBC.assertColumnTypes(resultSet2, new int[]{4, 4});
        JDBC.assertNullability(resultSet2, new boolean[]{true, true});
        String[][] stringArray2 = new String[][]{{"1", "1"}, {"-1", "1"}, {"2", "2"}, {"-3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(resultSet2, stringArray2);
        resultSet2 = statement.executeQuery("select * from v2 as x(a,b,d)");
        JDBC.assertColumnNames(resultSet2, "A", "B", "D");
        JDBC.assertColumnTypes(resultSet2, new int[]{4, 4, 4});
        JDBC.assertNullability(resultSet2, new boolean[]{true, true, true});
        stringArray2 = new String[][]{{"1", "1", "2"}, {"-1", "1", "0"}, {"2", "2", "4"}, {"-3", "3", "0"}, {"4", "4", "8"}};
        JDBC.assertFullResultSet(resultSet2, stringArray2);
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop view v2");
        statement.executeUpdate("drop table t1");
    }
}

