/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.Hashtable;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerMBeanTest
extends MBeanTest {
    public NetworkServerMBeanTest(String string) {
        super(string);
    }

    public static Test suite() {
        return MBeanTest.suite(NetworkServerMBeanTest.class, "NetworkServerMBeanTest");
    }

    private ObjectName getNetworkServerMBeanObjectName() throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", "NetworkServer");
        return this.getDerbyMBeanName(hashtable);
    }

    public void testAttributeAccumulatedConnectionCount() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "AccumulatedConnectionCount");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeActiveConnectionCount() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "ActiveConnectionCount");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeBytesReceived() throws Exception {
        Long l = (Long)this.getAttribute(this.getNetworkServerMBeanObjectName(), "BytesReceived");
        NetworkServerMBeanTest.assertNotNull((Object)l);
        NetworkServerMBeanTest.assertTrue((l >= 0L ? 1 : 0) != 0);
    }

    public void testAttributeBytesReceivedPerSecond() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "BytesReceivedPerSecond");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeBytesSent() throws Exception {
        Long l = (Long)this.getAttribute(this.getNetworkServerMBeanObjectName(), "BytesSent");
        NetworkServerMBeanTest.assertNotNull((Object)l);
        NetworkServerMBeanTest.assertTrue((l >= 0L ? 1 : 0) != 0);
    }

    public void testAttributeBytesSentPerSecond() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "BytesSentPerSecond");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeConnectionCount() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "ConnectionCount");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeConnectionThreadPoolSize() throws Exception {
        Integer n = (Integer)this.getAttribute(this.getNetworkServerMBeanObjectName(), "ConnectionThreadPoolSize");
        NetworkServerMBeanTest.assertNotNull((Object)n);
        NetworkServerMBeanTest.assertTrue((n >= 0 ? 1 : 0) != 0);
    }

    public void testAttributeDrdaHost() throws Exception {
        String string = TestConfiguration.getCurrent().getHostName();
        if (string.equals("localhost") || string.equals("127.0.0.1") || string.equals(" 0:0:0:0:0:0:0:1")) {
            String string2 = (String)this.getAttribute(this.getNetworkServerMBeanObjectName(), "DrdaHost");
            NetworkServerMBeanTest.assertNotNull((Object)string2);
            NetworkServerMBeanTest.assertTrue((String)("mbeanHost = " + string2 + " (not localhost, 127.0.0.1, or  0:0:0:0:0:0:0:1)"), (string2.equals("localhost") || string2.equals("127.0.0.1") || string2.equals("0:0:0:0:0:0:0:1") ? 1 : 0) != 0);
        } else {
            this.assertStringAttribute(string, this.getNetworkServerMBeanObjectName(), "DrdaHost");
        }
    }

    public void testDrdaKeepAlive() throws Exception {
        this.assertBooleanAttribute(true, this.getNetworkServerMBeanObjectName(), "DrdaKeepAlive");
    }

    public void testAttributeDrdaMaxThreads() throws Exception {
        this.assertIntAttribute(0, this.getNetworkServerMBeanObjectName(), "DrdaMaxThreads");
    }

    public void testAttributeDrdaPortNumber() throws Exception {
        this.assertIntAttribute(TestConfiguration.getCurrent().getPort(), this.getNetworkServerMBeanObjectName(), "DrdaPortNumber");
    }

    public void testAttributeDrdaSecurityMechanism() throws Exception {
        this.assertStringAttribute("", this.getNetworkServerMBeanObjectName(), "DrdaSecurityMechanism");
    }

    public void testAttributeDrdaSslMode() throws Exception {
        this.assertStringAttribute("off", this.getNetworkServerMBeanObjectName(), "DrdaSslMode");
    }

    public void testAttributeDrdaStreamOutBufferSize() throws Exception {
        this.assertIntAttribute(0, this.getNetworkServerMBeanObjectName(), "DrdaStreamOutBufferSize");
    }

    public void testAttributeDrdaTimeSlice() throws Exception {
        this.assertIntAttribute(0, this.getNetworkServerMBeanObjectName(), "DrdaTimeSlice");
    }

    public void testAttributeDrdaTraceAll() throws Exception {
        this.assertBooleanAttribute(false, this.getNetworkServerMBeanObjectName(), "DrdaTraceAll");
    }

    public void testAttributeDrdaTraceDirectory() throws Exception {
        this.checkStringAttributeValue(this.getNetworkServerMBeanObjectName(), "DrdaTraceDirectory");
    }

    public void testAttributeStartTime() throws Exception {
        this.checkLongAttributeValue(this.getNetworkServerMBeanObjectName(), "StartTime");
    }

    public void testAttributeUptime() throws Exception {
        this.checkLongAttributeValue(this.getNetworkServerMBeanObjectName(), "Uptime");
    }

    public void testAttributeWaitingConnectionCount() throws Exception {
        this.assertIntAttribute(0, this.getNetworkServerMBeanObjectName(), "WaitingConnectionCount");
    }

    public void testOperationPing() throws Exception {
        if (TestConfiguration.loadingFromJars()) {
            NetworkServerMBeanTest.println("testOperationPing: Won't invoke the ping operation since the code has been loaded from the jars.");
            return;
        }
        this.invokeOperation(this.getNetworkServerMBeanObjectName(), "ping");
    }
}

