/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class Derby4577Test
extends StoreBaseTest {
    public Derby4577Test(String string) {
        super(string);
    }

    public void testDERBY_4577() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testBadUpdate VALUES(?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("UPDATE testBadUpdate set value = ? where id = ?");
        byte[] byArray = new byte[1];
        for (n = 0; n < 3; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
        }
        this.commit();
        byArray = new byte[32000];
        preparedStatement.setInt(1, 3);
        preparedStatement.setBytes(2, byArray);
        preparedStatement.executeUpdate();
        byArray = new byte[4000];
        for (n = 0; n < 3; ++n) {
            preparedStatement2.setBytes(1, byArray);
            preparedStatement2.setInt(2, n);
            preparedStatement2.executeUpdate();
        }
        this.commit();
        byArray = new byte[32566];
        preparedStatement2.setBytes(1, byArray);
        preparedStatement2.setInt(2, 3);
        preparedStatement2.executeUpdate();
        this.commit();
        byArray = new byte[60000];
        preparedStatement2.setBytes(1, byArray);
        preparedStatement2.setInt(2, 0);
        preparedStatement2.executeUpdate();
        this.commit();
        byArray = new byte[32500];
        preparedStatement2.setBytes(1, byArray);
        preparedStatement2.setInt(2, 1);
        preparedStatement2.executeUpdate();
        this.commit();
        byArray = new byte[32646];
        preparedStatement2.setBytes(1, byArray);
        preparedStatement2.setInt(2, 2);
        preparedStatement2.executeUpdate();
        this.commit();
        byArray = new byte[120000];
        preparedStatement2.setBytes(1, byArray);
        preparedStatement2.setInt(2, 0);
        preparedStatement2.executeUpdate();
        this.commit();
        statement.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void testSmallRow1() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO testSmallRow1 VALUES(?)");
        preparedStatement.setString(1, "a");
        for (int i = 0; i < 4000; ++i) {
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        this.commit();
        statement.executeUpdate("CREATE INDEX idx1 on testSmallRow1(id)");
        ResultSet resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW1')");
        Object[][] objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("CREATE INDEX idx2 on testSmallRow2(id)");
        preparedStatement = this.prepareStatement("INSERT INTO testSmallRow2 VALUES(?)");
        preparedStatement.setString(1, "a");
        for (n = 0; n < 4000; ++n) {
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        this.commit();
        resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW2')");
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("CREATE INDEX idx3 on testSmallRow3(id)");
        preparedStatement = this.prepareStatement("INSERT INTO testSmallRow3 VALUES(?, ?)");
        preparedStatement.setString(1, null);
        for (n = 0; n < 100; ++n) {
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
        }
        this.commit();
        statement.executeUpdate("UPDATE testSmallRow3 set id = null where id2 > 1");
        statement.executeUpdate("DELETE from testSmallRow3 where id2 = 40 or id2 = 41 or id2 = 80 or id2 = 81");
        this.commit();
        preparedStatement.setString(1, null);
        for (n = 101; n < 600; ++n) {
            preparedStatement.executeUpdate();
            preparedStatement.setInt(2, n);
        }
        preparedStatement.close();
        this.commit();
        resultSet = statement.executeQuery("VALUES SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'TESTSMALLROW3')");
        objectArray = new String[][]{{"1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.close();
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby4577Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                statement.executeUpdate("CREATE TABLE testBadUpdate (id int, value blob(1M))");
                statement.executeUpdate("CREATE TABLE testSmallRow1 (id char(1))");
                statement.executeUpdate("CREATE TABLE testSmallRow2 (id char(1))");
                statement.executeUpdate("CREATE TABLE testSmallRow3 (id char(20), id2 int)");
                connection.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby4577Test");
        baseTestSuite.addTest(Derby4577Test.baseSuite("Derby4577Test:embedded"));
        return baseTestSuite;
    }
}

