/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.derby.shared.common.info.ProductVersionHolder;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeClassLoader;

public class Version
implements Comparable<Version> {
    public static final Version V_10_3_0_0 = new Version(10, 3, 0, 0);
    private static final int EXPECTED_LEG_COUNT = 4;
    private int[] _legs;
    private String _key;
    private String _branchID;
    private static HashMap<String, ClassLoader> _classLoaders = new HashMap();

    public Version(int n, int n2, int n3, int n4) {
        this(new int[]{n, n2, n3, n4});
    }

    public Version(int[] nArray) {
        this.constructorMinion(nArray);
    }

    public Version(ProductVersionHolder productVersionHolder) {
        this.constructorMinion(this.getLegs(productVersionHolder));
    }

    private void constructorMinion(int[] nArray) {
        int n;
        if (nArray == null) {
            nArray = new int[]{};
        }
        if ((n = nArray.length) != 4) {
            throw new IllegalArgumentException("Expected 4 legs but only saw " + n);
        }
        this._legs = new int[n];
        for (int i = 0; i < n; ++i) {
            this._legs[i] = nArray[i];
        }
        this.makeKey();
    }

    private int[] getLegs(ProductVersionHolder productVersionHolder) {
        int[] nArray = new int[4];
        int n = 0;
        nArray[n++] = productVersionHolder.getMajorVersion();
        nArray[n++] = productVersionHolder.getMinorVersion();
        nArray[n++] = productVersionHolder.getMaintVersion() / 1000000;
        nArray[n++] = productVersionHolder.getMaintVersion() % 1000000;
        return nArray;
    }

    public String toString() {
        return this._key;
    }

    public String getBranchID() {
        if (this._branchID == null) {
            this._branchID = Integer.toString(this._legs[0]) + "." + Integer.toString(this._legs[1]);
        }
        return this._branchID;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = _classLoaders.get(this._key);
        if (classLoader != null) {
            return classLoader;
        }
        this.addClassLoader();
        return _classLoaders.get(this._key);
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        for (int i = 0; i < 4; ++i) {
            int n = this._legs[i] - version._legs[i];
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.compareTo((Version)object) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void addClassLoader() {
        ClassLoader classLoader = UpgradeClassLoader.makeClassLoader(this._legs);
        _classLoaders.put(this._key, classLoader);
    }

    private void makeKey() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._legs.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this._legs[i]);
        }
        this._key = stringBuffer.toString();
    }

    public static final class Trajectory
    implements Comparable {
        private Version[] _versions;

        public Trajectory(ArrayList<Version> arrayList) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            Version[] versionArray = new Version[arrayList.size()];
            arrayList.toArray(versionArray);
            this.constructorMinion(versionArray);
        }

        public Trajectory(Version[] versionArray) {
            if (versionArray == null) {
                versionArray = new Version[]{};
            }
            this.constructorMinion(versionArray);
        }

        private void constructorMinion(Version[] versionArray) {
            int n = versionArray.length;
            this._versions = new Version[n];
            for (int i = 0; i < n; ++i) {
                this._versions[i] = versionArray[i];
            }
        }

        public Trajectory sort() {
            Arrays.sort(this._versions);
            return this;
        }

        public int getVersionCount() {
            return this._versions.length;
        }

        public Version getVersion(int n) {
            return this._versions[n];
        }

        public Version getEndingVersion() {
            return this.getVersion(this.getVersionCount() - 1);
        }

        public boolean startsAt(Version version) {
            return this.getVersion(0).equals(version);
        }

        public boolean startsAt(String string) {
            return this.getVersion(0).getBranchID().equals(string);
        }

        public boolean contains(Version version) {
            int n = this.getVersionCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getVersion(i).equals(version)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(String string) {
            int n = this.getVersionCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getVersion(i).getBranchID().equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean endsAt(Version version) {
            return this.getVersion(this.getVersionCount() - 1).equals(version);
        }

        public boolean endsAt(String string) {
            return this.getVersion(this.getVersionCount() - 1).getBranchID().equals(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this._versions.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(" -> ");
                }
                stringBuffer.append(this._versions[i].toString());
            }
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            int n;
            if (object == null) {
                return -1;
            }
            if (!(object instanceof Trajectory)) {
                return -1;
            }
            Trajectory trajectory = (Trajectory)object;
            int n2 = this.getVersionCount();
            int n3 = n2 < (n = trajectory.getVersionCount()) ? n2 : n;
            for (int i = 0; i < n3; ++i) {
                int n4 = this.getVersion(i).compareTo(trajectory.getVersion(i));
                if (n4 == 0) continue;
                return n4;
            }
            return n2 - n;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

