/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import java.util.Vector;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.services.T_Serviceable;

public class T_DaemonService
extends T_MultiThreadedIterations {
    private static DaemonService testDaemon;
    private static Random random;
    private Vector<T_Serviceable> serviceRecord = new Vector(9, 1);

    public T_DaemonService() {
        random = new Random();
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.daemon.DaemonFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        DaemonFactory daemonFactory;
        try {
            daemonFactory = (DaemonFactory)T_DaemonService.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (daemonFactory == null) {
            throw T_Fail.testFailMsg("cannot find daemon factory org.apache.derby.iapi.services.daemon.DaemonFactory");
        }
        try {
            testDaemon = daemonFactory.createNewDaemon("testDaemon");
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (testDaemon == null) {
            throw T_Fail.testFailMsg("cannot create new Daemon Service");
        }
    }

    @Override
    protected void joinSetupTest() throws T_Fail {
        if (testDaemon == null) {
            throw T_Fail.testFailMsg("test deamon not set");
        }
    }

    @Override
    protected T_MultiThreadedIterations newTestObject() {
        return new T_DaemonService();
    }

    @Override
    protected void runTestSet() throws T_Fail {
        this.serviceRecord.clear();
        try {
            this.T01(testDaemon);
            this.T02(testDaemon);
            this.T03(testDaemon);
            this.t_checkStatus(testDaemon);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
    }

    private void T01(DaemonService daemonService) throws T_Fail, StandardException {
        T_Serviceable t_Serviceable = new T_Serviceable(false);
        this.serviceRecord.addElement(t_Serviceable);
        int n = daemonService.subscribe((Serviceable)t_Serviceable, false);
        t_Serviceable.setClientNumber(n);
        T_Serviceable t_Serviceable2 = new T_Serviceable(true);
        this.serviceRecord.addElement(t_Serviceable2);
        int n2 = daemonService.subscribe((Serviceable)t_Serviceable2, true);
        t_Serviceable2.setClientNumber(n2);
        daemonService.serviceNow(n2);
        t_Serviceable2.t_wait(1);
        this.randomSleep();
        t_Serviceable.t_wait(1);
        t_Serviceable2.t_check(1);
        this.PASS("T01");
        this.randomSleep();
    }

    private void T02(DaemonService daemonService) throws T_Fail, StandardException {
        int n = 10;
        T_Serviceable t_Serviceable = new T_Serviceable(1);
        this.serviceRecord.addElement(t_Serviceable);
        daemonService.enqueue((Serviceable)t_Serviceable, true);
        T_Serviceable t_Serviceable2 = new T_Serviceable(n);
        this.serviceRecord.addElement(t_Serviceable2);
        daemonService.enqueue((Serviceable)t_Serviceable2, true);
        T_Serviceable t_Serviceable3 = new T_Serviceable(1);
        this.serviceRecord.addElement(t_Serviceable3);
        daemonService.enqueue((Serviceable)t_Serviceable3, false);
        T_Serviceable t_Serviceable4 = new T_Serviceable(n);
        this.serviceRecord.addElement(t_Serviceable4);
        daemonService.enqueue((Serviceable)t_Serviceable4, false);
        this.randomSleep();
        t_Serviceable.t_wait(1);
        t_Serviceable2.t_wait(1);
        t_Serviceable3.t_wait(1);
        t_Serviceable4.t_wait(1);
        t_Serviceable2.t_wait(n);
        t_Serviceable4.t_wait(n);
        t_Serviceable.t_check(1);
        t_Serviceable3.t_check(1);
        this.PASS("T02");
        this.randomSleep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void T03(DaemonService daemonService) throws T_Fail, StandardException {
        int n;
        T_Serviceable t_Serviceable = new T_Serviceable(false);
        this.serviceRecord.addElement(t_Serviceable);
        int n2 = daemonService.subscribe((Serviceable)t_Serviceable, false);
        T_Serviceable t_Serviceable2 = new T_Serviceable(1);
        this.serviceRecord.addElement(t_Serviceable2);
        daemonService.enqueue((Serviceable)t_Serviceable2, false);
        daemonService.enqueue((Serviceable)t_Serviceable2, false);
        daemonService.enqueue((Serviceable)t_Serviceable2, false);
        daemonService.enqueue((Serviceable)t_Serviceable2, false);
        daemonService.enqueue((Serviceable)t_Serviceable2, false);
        T_Serviceable t_Serviceable3 = new T_Serviceable(false);
        this.serviceRecord.addElement(t_Serviceable3);
        int n3 = daemonService.subscribe((Serviceable)t_Serviceable3, false);
        int n4 = daemonService.subscribe((Serviceable)t_Serviceable3, false);
        t_Serviceable3.setClientNumber(n4);
        daemonService.unsubscribe(n2);
        daemonService.unsubscribe(n3);
        T_Serviceable t_Serviceable4 = t_Serviceable;
        synchronized (t_Serviceable4) {
            n = t_Serviceable.timesServiced;
        }
        daemonService.serviceNow(n2);
        this.randomSleep();
        t_Serviceable2.t_wait(5);
        daemonService.serviceNow(n2);
        t_Serviceable3.t_wait(3);
        daemonService.serviceNow(n2);
        t_Serviceable4 = t_Serviceable;
        synchronized (t_Serviceable4) {
            int n5 = t_Serviceable.timesServiced - n;
            T_Fail.T_ASSERT(n5 == 0 || n5 == 1, "unsubscribed continue to get serviced");
            t_Serviceable.timesServiced = 0;
        }
        n2 = daemonService.subscribe((Serviceable)t_Serviceable, false);
        t_Serviceable.setClientNumber(n2);
        daemonService.serviceNow(n2);
        t_Serviceable.t_wait(1);
        t_Serviceable2.t_check(5);
        this.PASS("T03");
        this.randomSleep();
    }

    private void t_checkStatus(DaemonService daemonService) throws T_Fail {
        for (int i = 0; i < this.serviceRecord.size(); ++i) {
            T_Serviceable t_Serviceable = this.serviceRecord.elementAt(i);
            if (t_Serviceable == null) continue;
            if (t_Serviceable.subscribed) {
                if (t_Serviceable.onDemandOnly) {
                    t_Serviceable.t_check(1);
                } else {
                    t_Serviceable.t_wait(10);
                }
                daemonService.unsubscribe(t_Serviceable.getClientNumber());
                continue;
            }
            t_Serviceable.t_wait(t_Serviceable.timesRequeue);
        }
        this.PASS("T_CheckStatus");
    }

    private void randomSleep() throws StandardException {
        if (this.getNumThreads() > 1) {
            int n = random.nextInt() % 100;
            if (n < 0) {
                n = -n;
            }
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                throw StandardException.interrupt((InterruptedException)interruptedException);
            }
        }
    }

    private static Object startSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule((String)string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException((Throwable)privilegedActionException);
        }
    }
}

