/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.derby.iapi.services.cache.ClassSizeCatalog;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ClassSize {
    public static final int refSize;
    private static final int objectOverhead = 2;
    private static final int booleanSize = 4;
    private static final int charSize = 4;
    private static final int shortSize = 4;
    private static final int intSize = 4;
    private static final int longSize = 8;
    private static final int floatSize = 4;
    private static final int doubleSize = 8;
    private static final int minObjectSize;
    private static boolean dummyCatalog;
    static boolean noGuess;
    static boolean unitTest;
    private static final int[] wildGuess;

    public static void setDummyCatalog() {
        dummyCatalog = true;
    }

    public static int getRefSize() {
        return refSize;
    }

    public static int getIntSize() {
        return 4;
    }

    public static int[] getSizeCoefficients(Class cl) {
        int[] coeff = new int[]{0, 2};
        while (null != cl) {
            Field[] field = cl.getDeclaredFields();
            if (null != field) {
                for (int i = 0; i < field.length; ++i) {
                    if (Modifier.isStatic(field[i].getModifiers())) continue;
                    Class<?> fieldClass = field[i].getType();
                    if (fieldClass.isArray() || !fieldClass.isPrimitive()) {
                        coeff[1] = coeff[1] + 1;
                        continue;
                    }
                    String name = fieldClass.getName();
                    if (name.equals("int") || name.equals("I")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("long") || name.equals("J")) {
                        coeff[0] = coeff[0] + 8;
                        continue;
                    }
                    if (name.equals("boolean") || name.equals("Z")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("short") || name.equals("S")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("byte") || name.equals("B")) {
                        coeff[0] = coeff[0] + 1;
                        continue;
                    }
                    if (name.equals("char") || name.equals("C")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("float") || name.equals("F")) {
                        coeff[0] = coeff[0] + 4;
                        continue;
                    }
                    if (name.equals("double") || name.equals("D")) {
                        coeff[0] = coeff[0] + 8;
                        continue;
                    }
                    coeff[1] = coeff[1] + 1;
                }
            }
            cl = cl.getSuperclass();
        }
        return coeff;
    }

    public static int estimateBaseFromCoefficients(int[] coeff) {
        int size = coeff[0] + coeff[1] * refSize;
        size = (size + 7) / 8;
        return (size *= 8) < minObjectSize ? minObjectSize : size;
    }

    public static int estimateBaseFromCatalog(Class cls) {
        return ClassSize.estimateBaseFromCatalog(cls, false);
    }

    private static int estimateBaseFromCatalog(Class<?> cls, boolean addToCatalog) {
        if (dummyCatalog) {
            return 0;
        }
        ClassSizeCatalog catalog = ClassSizeCatalog.getInstance();
        SanityManager.ASSERT(catalog != null, "The class size catalog could not be initialized.");
        int[] coeff = (int[])catalog.get(cls.getName());
        if (coeff == null) {
            try {
                coeff = ClassSize.getSizeCoefficients(cls);
            }
            catch (Throwable t) {
                if (noGuess) {
                    return -2;
                }
                coeff = wildGuess;
            }
            if (addToCatalog) {
                catalog.put(cls.getName(), coeff);
            }
        }
        return ClassSize.estimateBaseFromCoefficients(coeff);
    }

    public static int estimateAndCatalogBase(Class cls) {
        return ClassSize.estimateBaseFromCatalog(cls, true);
    }

    public static int estimateBase(Class cl) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(cl));
    }

    public static int estimateArrayOverhead() {
        return minObjectSize;
    }

    public static int estimateHashEntrySize() {
        return 2 + 3 * refSize;
    }

    public static int estimateMemoryUsage(String str) {
        if (null == str) {
            return 0;
        }
        return 2 * str.length();
    }

    private static final int fetchRefSizeFromSystemProperties() {
        String dataModel = ClassSize.getSystemProperty("sun.arch.data.model");
        try {
            return Integer.parseInt(dataModel) / 8;
        }
        catch (NumberFormatException numberFormatException) {
            String arch = ClassSize.getSystemProperty("os.arch");
            if (arch != null) {
                String[] b32 = new String[]{"i386", "x86", "sparc"};
                if (Arrays.asList(b32).contains(arch)) {
                    return 4;
                }
                String[] b64 = new String[]{"amd64", "x86_64", "sparcv9"};
                if (Arrays.asList(b64).contains(arch)) {
                    return 8;
                }
            }
            SanityManager.DEBUG_PRINT("REFSIZE", "Bitness undetermined, sun.arch.data.model='" + dataModel + "', os.arch='" + arch + "'");
            return -1;
        }
    }

    private static final String getSystemProperty(final String propName) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propName, null);
                }
            });
        }
        catch (SecurityException se) {
            return null;
        }
    }

    static {
        dummyCatalog = false;
        noGuess = false;
        unitTest = false;
        wildGuess = new int[]{0, 16};
        int tmpRefSize = ClassSize.fetchRefSizeFromSystemProperties();
        if (tmpRefSize < 4) {
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            runtime.runFinalization();
            long memBase = runtime.totalMemory() - runtime.freeMemory();
            Object[] junk = new Object[10000];
            runtime.gc();
            runtime.runFinalization();
            long memUsed = runtime.totalMemory() - runtime.freeMemory() - memBase;
            int sz = (int)((memUsed + (long)(junk.length / 2)) / (long)junk.length);
            tmpRefSize = 4 > sz ? 4 : sz;
        }
        refSize = tmpRefSize;
        minObjectSize = 4 * refSize;
    }
}

