/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.UpdateLoader;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private UpdateLoader applicationLoader;

    DatabaseClasses() {
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.classInspector = this.makeClassInspector(this);
        String classpath = null;
        if (startParams != null) {
            classpath = startParams.getProperty("derby.__rt.database.classpath");
        }
        if (classpath != null) {
            this.applicationLoader = new UpdateLoader(classpath, this, true, true);
        }
    }

    @Override
    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
    }

    protected ClassInspector makeClassInspector(DatabaseClasses dc) {
        return new ClassInspector(dc);
    }

    @Override
    public final GeneratedClass loadGeneratedClass(String fullyQualifiedName, ByteArray classDump) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(fullyQualifiedName, classDump);
        }
        catch (LinkageError le) {
            DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, le);
            throw StandardException.newException("XBCM1.S", le, fullyQualifiedName);
        }
        catch (VirtualMachineError vme) {
            DatabaseClasses.WriteClassFile(fullyQualifiedName, classDump, vme);
            throw vme;
        }
    }

    private static void WriteClassFile(String fullyQualifiedName, ByteArray bytecode, Throwable t) {
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        String filename = fullyQualifiedName.substring(lastDot + 1, fullyQualifiedName.length()).concat(".class");
        Object env = DatabaseClasses.getMonitor().getEnvironment();
        File dir = env instanceof File ? (File)env : null;
        final File classFile = new File(dir, filename);
        HeaderPrintWriter errorStream = Monitor.getStream();
        try {
            FileOutputStream fis;
            try {
                fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws IOException {
                        return new FileOutputStream(classFile);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getCause();
            }
            fis.write(bytecode.getArray(), bytecode.getOffset(), bytecode.getLength());
            fis.flush();
            if (t != null) {
                errorStream.printlnWithHeader(MessageService.getTextMessage("C000", fullyQualifiedName, classFile, t));
            }
            fis.close();
        }
        catch (IOException e) {
            SanityManager.THROWASSERT("Unable to write .class file", e);
        }
    }

    @Override
    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    @Override
    public final Class loadApplicationClass(String className) throws ClassNotFoundException {
        Throwable loadError;
        if (className.startsWith("org.apache.derby.")) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            try {
                return this.loadClassNotInDatabaseJar(className);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.applicationLoader == null) {
                    throw cnfe;
                }
                Class c = this.applicationLoader.loadClass(className, true);
                if (c == null) {
                    throw cnfe;
                }
                return c;
            }
        }
        catch (SecurityException se) {
            loadError = se;
        }
        catch (LinkageError le) {
            loadError = le;
        }
        throw new ClassNotFoundException(className + " : " + loadError.getMessage());
    }

    abstract Class loadClassNotInDatabaseJar(String var1) throws ClassNotFoundException;

    @Override
    public final Class loadApplicationClass(ObjectStreamClass classDescriptor) throws ClassNotFoundException {
        return this.loadApplicationClass(classDescriptor.getName());
    }

    @Override
    public boolean isApplicationClass(Class theClass) {
        return theClass.getClassLoader() instanceof JarLoader;
    }

    @Override
    public void notifyModifyJar(boolean reload) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(reload);
        }
    }

    @Override
    public void notifyModifyClasspath(String classpath) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(classpath);
        }
    }

    @Override
    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

