/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.EncryptContainerOperation;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EncryptOrDecryptData
implements PrivilegedAction<Boolean> {
    private BaseDataFileFactory dataFactory;
    private StorageFactory storageFactory;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_RENAME_ACTION = 3;
    private int actionCode;
    private StorageFile actionStorageFile;
    private StorageFile actionDestStorageFile;

    public EncryptOrDecryptData(BaseDataFileFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.storageFactory = dataFactory.getStorageFactory();
    }

    public void decryptAllContainers(RawTransaction t) throws StandardException {
        this.encryptOrDecryptAllContainers(t, false);
    }

    public void encryptAllContainers(RawTransaction t) throws StandardException {
        this.encryptOrDecryptAllContainers(t, true);
    }

    private void encryptOrDecryptAllContainers(RawTransaction t, boolean doEncrypt) throws StandardException {
        String[] files = this.dataFactory.getContainerNames();
        if (files != null) {
            long segmentId = 0L;
            for (int f = files.length - 1; f >= 0; --f) {
                long containerId;
                try {
                    containerId = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                }
                catch (Throwable th) {
                    continue;
                }
                ContainerKey ckey = new ContainerKey(segmentId, containerId);
                this.encryptOrDecryptContainer(t, ckey, doEncrypt);
            }
        } else {
            SanityManager.THROWASSERT((doEncrypt ? "encryption" : "decryption") + " process is unable to read container names in seg0");
        }
    }

    private void encryptOrDecryptContainer(RawTransaction t, ContainerKey ckey, boolean doEncrypt) throws StandardException {
        StorageFile oldFile;
        StorageFile currentFile;
        LockingPolicy cl = t.newLockingPolicy(2, 5, true);
        SanityManager.ASSERT(cl != null);
        RawContainerHandle containerHdl = (RawContainerHandle)t.openContainer(ckey, cl, 4);
        SanityManager.ASSERT(containerHdl != null);
        EncryptContainerOperation lop = new EncryptContainerOperation(containerHdl);
        t.logAndDo(lop);
        this.dataFactory.flush(t.getLastLogInstant());
        String newFilePath = this.getFilePath(ckey, false);
        StorageFile newFile = this.storageFactory.newStorageFile(newFilePath);
        containerHdl.encryptOrDecryptContainer(newFilePath, doEncrypt);
        containerHdl.close();
        if (!this.dataFactory.getPageCache().discard(ckey)) {
            SanityManager.THROWASSERT("unable to discard pages releated to container " + ckey + " from the page cache");
        }
        if (!this.dataFactory.getContainerCache().discard(ckey)) {
            SanityManager.THROWASSERT("unable to discard a container " + ckey + " from the container cache");
        }
        if (!this.privRename(currentFile = this.dataFactory.getContainerPath(ckey, false), oldFile = this.getFile(ckey, true))) {
            throw StandardException.newException("XSRS4.S", currentFile, oldFile);
        }
        if (!this.privRename(newFile, currentFile)) {
            throw StandardException.newException("XSRS4.S", newFile, currentFile);
        }
    }

    private StorageFile getFile(ContainerKey containerId, boolean old) {
        return this.storageFactory.newStorageFile(this.getFilePath(containerId, old));
    }

    private String getFilePath(ContainerKey containerId, boolean old) {
        StringBuffer sb = new StringBuffer("seg");
        sb.append(containerId.getSegmentId());
        sb.append(this.storageFactory.getSeparator());
        sb.append(old ? (char)'o' : 'n');
        sb.append(Long.toHexString(containerId.getContainerId()));
        sb.append(".dat");
        return sb.toString();
    }

    private boolean isOldContainerFile(String fileName) {
        return fileName.startsWith("o") && fileName.endsWith(".dat");
    }

    private StorageFile getFile(String ctrFileName) {
        long segmentId = 0L;
        StringBuffer sb = new StringBuffer("seg");
        sb.append(segmentId);
        sb.append(this.storageFactory.getSeparator());
        sb.append(ctrFileName);
        return this.storageFactory.newStorageFile(sb.toString());
    }

    void restoreContainer(ContainerKey containerId) throws StandardException {
        if (!this.dataFactory.getContainerCache().discard(containerId)) {
            SanityManager.THROWASSERT("unable to discard  container from cache:" + containerId);
        }
        StorageFile currentFile = this.dataFactory.getContainerPath(containerId, false);
        StorageFile oldFile = this.getFile(containerId, true);
        StorageFile newFile = this.getFile(containerId, false);
        if (this.privExists(oldFile)) {
            if (this.privExists(currentFile) && !this.privRename(currentFile, newFile)) {
                throw StandardException.newException("XSRS4.S", currentFile, newFile);
            }
            if (!this.privRename(oldFile, currentFile)) {
                throw StandardException.newException("XSRS4.S", oldFile, currentFile);
            }
        }
        if (this.privExists(newFile) && !this.privDelete(newFile)) {
            throw StandardException.newException("XBM0R.D", newFile);
        }
    }

    public void removeOldVersionOfContainers() throws StandardException {
        String[] files = this.dataFactory.getContainerNames();
        if (files != null) {
            for (int i = files.length - 1; i >= 0; --i) {
                StorageFile oldFile;
                if (!this.isOldContainerFile(files[i]) || this.privDelete(oldFile = this.getFile(files[i]))) continue;
                throw StandardException.newException("XSDFJ.S", oldFile);
            }
        }
    }

    private synchronized boolean privExists(StorageFile file) {
        this.actionCode = 1;
        this.actionStorageFile = file;
        Boolean ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return ret;
    }

    private synchronized boolean privDelete(StorageFile file) {
        this.actionCode = 2;
        this.actionStorageFile = file;
        Boolean ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        return ret;
    }

    private synchronized boolean privRename(StorageFile fromFile, StorageFile destFile) {
        this.actionCode = 3;
        this.actionStorageFile = fromFile;
        this.actionDestStorageFile = destFile;
        Boolean ret = AccessController.doPrivileged(this);
        this.actionStorageFile = null;
        this.actionDestStorageFile = null;
        return ret;
    }

    @Override
    public Boolean run() {
        switch (this.actionCode) {
            case 1: {
                return this.actionStorageFile.exists();
            }
            case 2: {
                return this.actionStorageFile.delete();
            }
            case 3: {
                return this.actionStorageFile.renameTo(this.actionDestStorageFile);
            }
        }
        return null;
    }
}

