/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.Connection;
import junit.framework.Test;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneSupportPermsTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LuceneJarLoadingTest
extends GeneratedColumnsHelper {
    private static final String DB_NAME = "lucenejarloadingdb";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String POLICY_FILE = "org/apache/derbyTesting/functionTests/tests/lang/luceneSupport.policy";
    private static final String EXTERNAL_JAR_NAME = "myLuceneClasses.jar";
    private static final String INTERNAL_JAR_NAME = "TEST_DBO.myLuceneClasses";
    private static final String[] SUPPORT_FILES = new String[]{"functionTests/tests/lang/myLuceneClasses.jar"};
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String MY_ANALYZER = "MyAnalyzer.makeMyIndexDescriptor";
    private static final String INDEX_TEXT_TABLE = "call LuceneSupport.createIndex( 'ruth', 'textTable', 'textCol', 'MyAnalyzer.makeMyIndexDescriptor' )";
    private static final String DROP_TEXT_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'textTable', 'textCol' )";
    private static final String READ_TEXT_INDEX = "select * from table\n(\n  ruth.textTable__textCol\n  (\n    'one two three four five six seven eight nine ten',\n    100, null\n  )\n) t\n";
    private static final String[][] READ_TEXT_RESULT = new String[][]{{"10", "9", "2.2791052"}, {"9", "8", "1.6305782"}, {"8", "7", "1.1616905"}, {"7", "6", "0.97469425"}, {"6", "5", "0.6597747"}, {"5", "4", "0.49575216"}, {"4", "3", "0.33803377"}, {"3", "2", "0.17799875"}, {"2", "1", "0.09289266"}, {"1", "0", "0.035006654"}};
    private static final String GOOD_SHUTDOWN = "08006";

    public LuceneJarLoadingTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(LuceneJarLoadingTest.class);
        SecurityManagerSetup secureTest = new SecurityManagerSetup((Test)suite, POLICY_FILE);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)secureTest, LEGAL_USERS, "LuceneJarLoadingPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecoratorSingleUse(authenticatedTest, DB_NAME, true);
        SupportFilesSetup supportFilesTest = new SupportFilesSetup(authorizedTest, SUPPORT_FILES);
        return supportFilesTest;
    }

    public void test_001_basic() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.goodStatement(dboConnection, "create table dummyJustToCreateSchema( a int )");
        URL jar = SupportFilesSetup.getReadOnlyURL(EXTERNAL_JAR_NAME);
        this.goodStatement(dboConnection, "call sqlj.install_jar( '" + jar.toExternalForm() + "', 'TEST_DBO.myLuceneClasses', 0 )");
        this.goodStatement(dboConnection, "call syscs_util.syscs_set_database_property( 'derby.database.classpath', 'TEST_DBO.myLuceneClasses' )");
        LuceneSupportPermsTest.loadTestTable(ruthConnection);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(ruthConnection, INDEX_TEXT_TABLE);
        this.assertResults(ruthConnection, READ_TEXT_INDEX, READ_TEXT_RESULT, false);
        this.goodStatement(ruthConnection, DROP_TEXT_INDEX);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
        LuceneSupportPermsTest.unloadTestTable(ruthConnection);
    }

    public void test_002_apiPackage() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        this.goodStatement(dboConnection, "create type LuceneVersion external name 'org.apache.lucene.util.Version' language java");
        this.goodStatement(dboConnection, "create function getLuceneVersion() returns LuceneVersion\nlanguage java parameter style java no sql\nexternal name 'org.apache.derby.optional.api.LuceneUtils.currentVersion'\n");
        this.assertResults(dboConnection, "values getLuceneVersion()", new String[][]{{LuceneUtils.currentVersion().toString()}}, false);
        this.goodStatement(dboConnection, "drop function getLuceneVersion");
        this.goodStatement(dboConnection, "drop type LuceneVersion restrict");
    }
}

