/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class VetJigsawTest
extends BaseJDBCTestCase {
    private static final String[] JAR_FILES = new String[]{"derby.jar", "derbyclient.jar", "derbynet.jar", "derbyoptionaltools.jar", "derbyrun.jar", "derbyshared.jar", "derbytools.jar", "derbyTesting.jar"};

    public VetJigsawTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite baseTest = new BaseTestSuite(VetJigsawTest.class, "VetJigsawTest");
        CleanDatabaseTestSetup cleanDatabaseWrapper = new CleanDatabaseTestSetup((Test)baseTest);
        Test noSecurityWrapper = SecurityManagerSetup.noSecurityManager((Test)cleanDatabaseWrapper);
        return noSecurityWrapper;
    }

    public void test_jarContents() throws Exception {
        String className = "org.apache.derby.impl.jdbc.EmbedConnection";
        URL derbyURL = SecurityManagerSetup.getURL("org.apache.derby.impl.jdbc.EmbedConnection");
        String derbyJarFileName = derbyURL.toURI().getPath();
        String jarFileDirectory = derbyJarFileName.substring(0, derbyJarFileName.indexOf("derby.jar"));
        String result = null;
        try (Connection conn = this.getConnection();){
            this.loadJarFileContents(conn, jarFileDirectory);
            result = this.vetContents();
        }
        if (result != null && result.length() != 0) {
            VetJigsawTest.fail((String)("Jar files overlap!\n" + result));
        }
    }

    private void loadJarFileContents(Connection conn, String jarFileDirectory) throws Exception {
        this.goodStatement(conn, "create function zipFile(zipFileName varchar( 32672 ))\nreturns table\n(\n      name   varchar( 100 ),\n      directory varchar( 32672 ),\n      comment varchar( 100 ),\n      crc varchar(100),\n      size bigint,\n      modification_time timestamp\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ZipFileTableFunction.zipFile'\n");
        this.goodStatement(conn, "create table zipPackages\n(\n  packageName varchar(32672),\n  zipFileName varchar(32672),\n  primary key (packageName, zipFileName)\n)\n");
        this.goodStatement(conn, "create table zipClasses\n(\n  packageName varchar(32672),\n  zipFileName varchar(32672),\n  className varchar(32672),\n  primary key (packageName, zipFileName, className)\n)\n");
        for (String jarFileName : JAR_FILES) {
            this.loadJarFile(conn, jarFileDirectory, jarFileName);
        }
    }

    private void loadJarFile(Connection conn, String jarFileDirectory, String jarFileName) throws Exception {
        String fullJarFileName = jarFileDirectory + jarFileName;
        this.goodStatement(conn, "insert into zipPackages\n  select distinct directory, '" + fullJarFileName + "'\n  from table(zipfile('" + fullJarFileName + "')) t\n");
        this.goodStatement(conn, "insert into zipClasses\n  select directory, '" + fullJarFileName + "', name\n  from table(zipFile('" + fullJarFileName + "')) t\n  where name like '%.class' and name <> 'module-info.class'");
    }

    private String vetContents() throws Exception {
        String packageCounts = "select packageName, count(packageName) instanceCount\nfrom zipPackages\nwhere packageName not like 'META-INF%'\ngroup by packageName\nhaving count(packageName) > 1\n";
        StringBuilder buffer = new StringBuilder();
        try (PreparedStatement ps = this.prepareStatement(packageCounts);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String packageName = rs.getString(1);
                this.examinePackage(buffer, packageName);
            }
        }
        return buffer.toString();
    }

    private void examinePackage(StringBuilder buffer, String packageName) throws Exception {
        String packageContents = "select zipFileName, className\nfrom zipClasses\nwhere packageName = '" + packageName + "'\norder by zipFileName, className\n";
        StringBuffer localBuffer = new StringBuffer();
        int zipsWithClasses = 0;
        try (PreparedStatement ps = this.prepareStatement(packageContents);){
            Object lastZipFileName = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String zipFileName = rs.getString(1);
                    String className = rs.getString(2);
                    if (lastZipFileName != null && !zipFileName.equals(lastZipFileName)) {
                        ++zipsWithClasses;
                    }
                    localBuffer.append("    ").append(zipFileName).append("\t").append(className).append("\n");
                }
            }
        }
        if (zipsWithClasses > 1) {
            buffer.append(packageName + " straddles more than one jar file:\n").append(localBuffer.toString()).append("\n");
        }
    }
}

