/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.crypto;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public class T_Cipher
extends T_Generic {
    private static final String testService = "CipherText";
    CipherProvider enEngine;
    CipherProvider deEngine;
    Key secretKey;
    byte[] IV;
    CipherFactory factory;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.crypto.CipherFactoryBuilder";
    }

    protected String getAlgorithm() {
        return "DES/CBC/NoPadding";
    }

    protected String getProvider() {
        String testProvider = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("testEncryptionProvider");
            }
        });
        if (testProvider != null) {
            return testProvider;
        }
        return null;
    }

    @Override
    public void runTests() throws T_Fail {
        File testFile = new File("extinout/T_Cipher.data");
        this.deleteFile(testFile);
        String bootPassword = "a secret, don't tell anyone";
        try {
            RandomAccessFile file = new RandomAccessFile(testFile, "rw");
            this.setupCiphers(bootPassword);
            int patternLength = 8192;
            byte[] pattern = new byte[patternLength];
            for (int i = 0; i < patternLength; ++i) {
                pattern[i] = (byte)(i & 0xFF);
            }
            this.test(pattern, 0, 8, file);
            this.test(pattern, 8, 8, file);
            this.test(pattern, 1, 16, file);
            this.test(pattern, 0, patternLength, file);
            this.test(pattern, 0, patternLength / 2, file);
            this.test(pattern, 1, patternLength / 2, file);
            this.test(pattern, 2, patternLength / 2, file);
            this.test(pattern, 3, patternLength / 2, file);
            file.seek(0L);
            this.check(pattern, 0, 8, file);
            this.check(pattern, 8, 8, file);
            this.check(pattern, 1, 16, file);
            this.check(pattern, 0, patternLength, file);
            this.check(pattern, 0, patternLength / 2, file);
            this.check(pattern, 1, patternLength / 2, file);
            this.check(pattern, 2, patternLength / 2, file);
            this.check(pattern, 3, patternLength / 2, file);
            this.REPORT("starting random test");
            file.seek(32 + patternLength);
            this.check(pattern, 0, patternLength / 2, file);
            file.seek(32L);
            this.check(pattern, 0, patternLength, file);
            file.seek(32 + 2 * patternLength);
            this.check(pattern, 2, patternLength / 2, file);
            file.seek(0L);
            this.check(pattern, 0, 8, file);
            file.seek(16L);
            this.check(pattern, 1, 16, file);
            file.seek(32 + 2 * patternLength + patternLength / 2);
            this.check(pattern, 3, patternLength / 2, file);
            file.seek(8L);
            this.check(pattern, 8, 8, file);
            file.seek(32 + patternLength + patternLength / 2);
            this.check(pattern, 1, patternLength / 2, file);
            file.close();
        }
        catch (StandardException se) {
            se.printStackTrace(System.out);
            throw T_Fail.exceptionFail(se);
        }
        catch (IOException ioe) {
            throw T_Fail.exceptionFail(ioe);
        }
        this.PASS("T_Cipher");
    }

    protected void setupCiphers(String bootPassword) throws T_Fail, StandardException {
        Properties props = new Properties();
        props.put("encryptionAlgorithm", this.getAlgorithm());
        String provider = this.getProvider();
        if (provider != null) {
            props.put("encryptionProvider", this.getProvider());
        }
        props.put("bootPassword", bootPassword);
        this.REPORT("encryption algorithm used : " + this.getAlgorithm());
        this.REPORT("encryption provider used : " + provider);
        CipherFactoryBuilder cb = (CipherFactoryBuilder)T_Cipher.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
        this.factory = cb.createCipherFactory(true, props, false);
        if (this.factory == null) {
            throw T_Fail.testFailMsg("cannot find Cipher factory ");
        }
        this.enEngine = this.factory.createNewCipher(1);
        this.deEngine = this.factory.createNewCipher(2);
        if (this.enEngine == null) {
            throw T_Fail.testFailMsg("cannot create encryption engine");
        }
        if (this.deEngine == null) {
            throw T_Fail.testFailMsg("cannot create decryption engine");
        }
    }

    protected void test(byte[] cleartext, int offset, int length, RandomAccessFile outfile) throws T_Fail, StandardException, IOException {
        byte[] ciphertext = new byte[length];
        System.arraycopy(cleartext, offset, ciphertext, 0, length);
        if (this.enEngine.encrypt(ciphertext, 0, length, ciphertext, 0) != length) {
            throw T_Fail.testFailMsg("encrypted text length != length");
        }
        if (this.byteArrayIdentical(ciphertext, cleartext, offset, length)) {
            throw T_Fail.testFailMsg("encryption just made a copy of the clear text");
        }
        outfile.write(ciphertext);
        this.deEngine.decrypt(ciphertext, 0, length, ciphertext, 0);
        if (!this.byteArrayIdentical(ciphertext, cleartext, offset, length)) {
            throw T_Fail.testFailMsg("decryption did not yield the same clear text");
        }
    }

    protected void check(byte[] cleartext, int offset, int length, RandomAccessFile infile) throws IOException, T_Fail, StandardException {
        byte[] ciphertext = new byte[length];
        infile.read(ciphertext);
        if (this.deEngine.decrypt(ciphertext, 0, length, ciphertext, 0) != length) {
            throw T_Fail.testFailMsg("decrypted text length != length");
        }
        if (!this.byteArrayIdentical(ciphertext, cleartext, offset, length)) {
            throw T_Fail.testFailMsg("decryption did not yield the same clear text");
        }
    }

    protected boolean byteArrayIdentical(byte[] compare, byte[] original, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (compare[i] == original[offset + i]) continue;
            return false;
        }
        return true;
    }

    private void deleteFile(final File f) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (f.exists()) {
                    f.delete();
                }
                return null;
            }
        });
    }

    private static Object startSystemModule(final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule((String)factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

