/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.conglomerate.TemplateRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.QualifierUtil;
import org.apache.derbyTesting.unitTests.store.T_SecondaryIndexRow;

public class T_QualifierTest {
    private String init_conglomerate_type;
    private Properties init_properties;
    private boolean init_temporary;
    private HeaderPrintWriter init_out;
    private int init_order = 3;
    public static final int ORDER_FORWARD = 1;
    public static final int ORDER_BACKWARD = 2;
    public static final int ORDER_NONE = 3;
    public static final int ORDER_DESC = 4;

    public T_QualifierTest(String conglomerate_type, Properties properties, boolean temporary, HeaderPrintWriter out, int order) {
        this.init_conglomerate_type = conglomerate_type;
        this.init_properties = properties;
        this.init_temporary = temporary;
        this.init_out = out;
        this.init_order = order;
    }

    private static HashSet<Long> create_hash_set(int expect_key, int expect_numrows, int order) {
        HashSet<Long> set = new HashSet<Long>(10, 0.8f);
        int key_val = expect_key;
        for (int i = 0; i < expect_numrows; ++i) {
            set.add(Long.valueOf(key_val));
            if (order == 4) {
                --key_val;
                continue;
            }
            ++key_val;
        }
        return set;
    }

    private static int flip_scan_op(int op) {
        int ret_op = -42;
        if (op == 1) {
            ret_op = -1;
        } else if (op == -1) {
            ret_op = 1;
        }
        return ret_op;
    }

    public static boolean t_scan(TransactionController tc, long conglomid, DataValueDescriptor[] init_scan_template, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int lowest_expect_key, int order) throws StandardException, T_Fail {
        boolean ret_val = T_QualifierTest.t_scanNext(tc, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchNext(tc, conglomid, init_scan_template, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchNextPartial(tc, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchHashtable(tc, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchNextGroup(tc, 1, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchNextGroup(tc, 2, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        ret_val = T_QualifierTest.t_scanFetchNextGroup(tc, 1000, conglomid, fetch_template, start_key, start_op, qualifier, stop_key, stop_op, expect_numrows, lowest_expect_key, order);
        if (!ret_val) {
            return ret_val;
        }
        return ret_val;
    }

    private static boolean t_scanNext(TransactionController tc, long conglomid, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int input_expect_key, int order) throws StandardException, T_Fail {
        HashSet<Long> set = null;
        boolean ordered = order == 1 || order == 4;
        int expect_key = input_expect_key;
        if (!ordered) {
            set = T_QualifierTest.create_hash_set(input_expect_key, expect_numrows, order);
        }
        ScanController scan = tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op);
        long key = -42L;
        int numrows = 0;
        while (scan.next()) {
            scan.fetch(fetch_template);
            key = ((SQLLongint)fetch_template[2]).getLong();
            if (ordered) {
                if (key != (long)expect_key) {
                    return T_QualifierTest.fail("(t_scanNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
                }
                expect_key = order == 4 ? --expect_key : ++expect_key;
            } else if (!set.remove(key)) {
                return T_QualifierTest.fail("(t_scanNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
            }
            ++numrows;
        }
        scan.close();
        if (numrows != expect_numrows) {
            return T_QualifierTest.fail("(t_scanNext) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNext(TransactionController tc, long conglomid, DataValueDescriptor[] init_scan_template, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int input_expect_key, int order) throws StandardException, T_Fail {
        boolean ordered;
        HashSet<Long> set = null;
        boolean bl = ordered = order == 1 || order == 4;
        if (!ordered) {
            set = T_QualifierTest.create_hash_set(input_expect_key, expect_numrows, order);
        }
        ScanController scan = tc.openScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op);
        int expect_key = input_expect_key;
        long key = -42L;
        long numrows = 0L;
        while (scan.fetchNext(fetch_template)) {
            scan.fetch(init_scan_template);
            for (int i = 0; i < init_scan_template.length; ++i) {
                if (fetch_template[i].compare(init_scan_template[i]) == 0) continue;
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + fetch_template[i] + ")but got (" + init_scan_template[i] + ").");
            }
            key = ((SQLLongint)init_scan_template[2]).getLong();
            if (ordered) {
                if (key != (long)expect_key) {
                    return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
                }
                expect_key = order == 4 ? --expect_key : ++expect_key;
            } else if (!set.remove(key)) {
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
            }
            ++numrows;
        }
        scan.close();
        if (numrows != (long)expect_numrows) {
            return T_QualifierTest.fail("(t_scanFetchNext) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNextGroup(TransactionController tc, int group_size, long conglomid, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int input_expect_key, int order) throws StandardException, T_Fail {
        boolean ordered;
        HashSet<Long> set = null;
        boolean bl = ordered = order == 1 || order == 4;
        if (!ordered) {
            set = T_QualifierTest.create_hash_set(input_expect_key, expect_numrows, order);
        }
        GroupFetchScanController scan = tc.openGroupFetchScan(conglomid, false, 0, 6, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op);
        DataValueDescriptor[][] row_array = new DataValueDescriptor[group_size][];
        row_array[0] = TemplateRow.newRow((DataValueDescriptor[])fetch_template);
        int expect_key = input_expect_key;
        long key = -42L;
        long numrows = 0L;
        int group_row_count = 0;
        while ((group_row_count = scan.fetchNextGroup((DataValueDescriptor[][])row_array, (RowLocation[])null)) != 0) {
            for (int i = 0; i < group_row_count; ++i) {
                key = ((SQLLongint)row_array[i][2]).getLong();
                if (ordered) {
                    if (key != (long)expect_key) {
                        return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong key, expect (" + expect_key + ")but got (" + key + "). num rows = " + numrows);
                    }
                    expect_key = order == 4 ? --expect_key : ++expect_key;
                } else if (!set.remove(key)) {
                    return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong key, expected (" + expect_key + ")but got (" + key + ").");
                }
                ++numrows;
            }
        }
        scan.close();
        if (numrows != (long)expect_numrows) {
            return T_QualifierTest.fail("(t_scanFetchNextGroup-forward) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchNextPartial(TransactionController tc, long conglomid, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int input_expect_key, int order) throws StandardException, T_Fail {
        int i;
        HashSet<Long> set = null;
        boolean ordered = order == 1 || order == 4;
        FormatableBitSet fetch_row_validColumns = RowUtil.getQualifierBitSet((Qualifier[][])qualifier);
        fetch_row_validColumns.grow(3);
        fetch_row_validColumns.set(2);
        if (start_key != null) {
            for (i = 0; i < start_key.length; ++i) {
                fetch_row_validColumns.set(i);
            }
        }
        if (stop_key != null) {
            for (i = 0; i < stop_key.length; ++i) {
                fetch_row_validColumns.set(i);
            }
        }
        SQLLongint key_column = (SQLLongint)fetch_template[2];
        if (!ordered) {
            set = T_QualifierTest.create_hash_set(input_expect_key, expect_numrows, order);
        }
        ScanController scan = tc.openScan(conglomid, false, 0, 6, 5, fetch_row_validColumns, start_key, start_op, qualifier, stop_key, stop_op);
        int expect_key = input_expect_key;
        long key = -42L;
        long key2 = -42L;
        long numrows = 0L;
        while (scan.fetchNext(fetch_template)) {
            key = key_column.getLong();
            key_column.setValue(-42);
            scan.fetch(fetch_template);
            key2 = key_column.getLong();
            if (ordered) {
                if (key != (long)expect_key || key2 != (long)expect_key) {
                    return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
                }
                expect_key = order == 4 ? --expect_key : ++expect_key;
            } else if (!set.remove(key)) {
                return T_QualifierTest.fail("(t_scanFetchNext) wrong key, expected (" + expect_key + ")but got (" + key + ").");
            }
            ++numrows;
        }
        scan.close();
        if (numrows != (long)expect_numrows) {
            return T_QualifierTest.fail("(t_scanFetchNext) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    public static boolean t_scanFetchHashtable(TransactionController tc, long conglomid, DataValueDescriptor[] fetch_template, DataValueDescriptor[] start_key, int start_op, Qualifier[][] qualifier, DataValueDescriptor[] stop_key, int stop_op, int expect_numrows, int input_expect_key, int order) throws StandardException, T_Fail {
        HashSet<Long> set = null;
        long numrows = 0L;
        boolean ordered = order == 1 || order == 4;
        set = T_QualifierTest.create_hash_set(input_expect_key, expect_numrows, order);
        int[] keyColumns = new int[]{0};
        BackingStoreHashtable result_set = tc.createBackingStoreHashtableFromScan(conglomid, 0, 7, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op, -1L, keyColumns, false, -1L, -1L, -1, -1.0f, false, false, false, false);
        Enumeration e = result_set.elements();
        while (e.hasMoreElements()) {
            long key;
            DataValueDescriptor[] row = null;
            Object obj = e.nextElement();
            if (obj instanceof DataValueDescriptor[]) {
                row = (DataValueDescriptor[])obj;
                key = ((SQLLongint)row[2]).getLong();
                if (!set.remove(key)) {
                    return T_QualifierTest.fail("(t_scanFetchHashtable-obj) wrong key, expected (" + input_expect_key + ")but got (" + key + ").");
                }
                ++numrows;
                continue;
            }
            if (obj instanceof List) {
                List row_vect = (List)obj;
                for (int i = 0; i < row_vect.size(); ++i) {
                    row = (DataValueDescriptor[])row_vect.get(i);
                    key = ((SQLLongint)row[2]).getLong();
                    if (!set.remove(key)) {
                        return T_QualifierTest.fail("(t_scanFetchHashtable-vector) wrong key, expected (" + input_expect_key + ")but got (" + key + ").");
                    }
                    ++numrows;
                }
                continue;
            }
            return T_QualifierTest.fail("(t_scanFetchHashtable) got bad type for data: " + obj);
        }
        if (numrows != (long)expect_numrows) {
            return T_QualifierTest.fail("(t_scanFetchHashtable) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        result_set.close();
        keyColumns[0] = 2;
        result_set = tc.createBackingStoreHashtableFromScan(conglomid, 0, 7, 5, (FormatableBitSet)null, start_key, start_op, qualifier, stop_key, stop_op, -1L, keyColumns, false, -1L, -1L, -1, -1.0f, false, false, false, false);
        for (numrows = 0L; numrows < (long)expect_numrows; ++numrows) {
            long exp_key = order == 4 ? (long)input_expect_key - numrows : (long)input_expect_key + numrows;
            Object removed_obj = result_set.remove((Object)new SQLLongint(exp_key));
            if (removed_obj != null) continue;
            T_QualifierTest.fail("(t_scanFetchHashtable-2-vector) wrong key, expected (" + exp_key + ")but did not find it.");
        }
        if (numrows != (long)expect_numrows) {
            return T_QualifierTest.fail("(t_scanFetchHashtable-2) wrong number of rows. Expected " + expect_numrows + " rows, but got " + numrows + "rows.");
        }
        return true;
    }

    public boolean t_testqual(TransactionController tc) throws StandardException, T_Fail {
        long conglomid;
        long base_conglomid;
        boolean ret_val = true;
        DataValueDescriptor[] openscan_template = null;
        DataValueDescriptor[] fetch_template = null;
        DataValueDescriptor[] base_row = null;
        T_SecondaryIndexRow index_row = null;
        long value = -1L;
        long[] col1 = new long[]{1L, 3L, 4L, 4L, 4L, 5L, 5L, 5L, 6L, 7L, 9L};
        long[] col2 = new long[]{1L, 1L, 2L, 4L, 6L, 2L, 4L, 6L, 1L, 1L, 1L};
        long[] col3 = new long[]{11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L};
        ConglomerateController base_cc = null;
        ConglomerateController index_cc = null;
        RowLocation base_rowloc = null;
        base_row = TemplateRow.newU8Row((int)3);
        if (this.init_conglomerate_type.compareTo("BTREE") == 0) {
            base_conglomid = tc.createConglomerate("heap", base_row, null, null, null, 0);
            index_row = new T_SecondaryIndexRow();
            base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
            base_rowloc = base_cc.newRowLocationTemplate();
            index_row.init(base_row, base_rowloc, 4);
            long index_conglomid = tc.createConglomerate(this.init_conglomerate_type, index_row.getRow(), null, null, this.init_properties, this.init_temporary ? 1 : 0);
            index_cc = tc.openConglomerate(index_conglomid, false, 4, 6, 5);
            conglomid = index_conglomid;
            openscan_template = index_row.getRow();
            T_SecondaryIndexRow fetch_index_row = new T_SecondaryIndexRow();
            fetch_index_row.init(TemplateRow.newU8Row((int)3), base_cc.newRowLocationTemplate(), 4);
            fetch_template = fetch_index_row.getRow();
        } else {
            base_conglomid = tc.createConglomerate(this.init_conglomerate_type, base_row, null, null, this.init_properties, this.init_temporary ? 1 : 0);
            base_cc = tc.openConglomerate(base_conglomid, false, 4, 6, 5);
            base_rowloc = base_cc.newRowLocationTemplate();
            conglomid = base_conglomid;
            openscan_template = base_row;
            fetch_template = TemplateRow.newU8Row((int)3);
        }
        for (int i = col1.length - 1; i >= 0; --i) {
            ((SQLLongint)base_row[0]).setValue(col1[i]);
            ((SQLLongint)base_row[1]).setValue(col2[i]);
            ((SQLLongint)base_row[2]).setValue(col3[i]);
            base_cc.insertAndFetchLocation(base_row, base_rowloc);
            if (this.init_conglomerate_type.compareTo("BTREE") != 0) continue;
            index_cc.insert(index_row.getRow());
        }
        tc.commit();
        SQLLongint qual_col1 = new SQLLongint(-1L);
        SQLLongint qual_col2 = new SQLLongint(-1L);
        SQLLongint qual_col3 = new SQLLongint(-1L);
        SQLLongint qual_col4 = new SQLLongint(-1L);
        SQLLongint qual_col5 = new SQLLongint(-1L);
        SQLLongint qual_col6 = new SQLLongint(-1L);
        SQLLongint qual_col7 = new SQLLongint(-1L);
        this.progress("qual scan (x = 5)");
        qual_col1.setValue(5);
        Qualifier[][] q1 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q1, null, 0, 3, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x > 5)");
        qual_col1.setValue(5);
        Qualifier[][] q2 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 3, true, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q2, null, 0, 3, 19, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x >= 5)");
        qual_col1.setValue(5);
        Qualifier[][] q3 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 1, true, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q3, null, 0, 6, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x <= 5)");
        qual_col1.setValue(5);
        Qualifier[][] q4 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q4, null, 0, 8, 11, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x < 5)");
        qual_col1.setValue(5);
        Qualifier[][] q5 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 1, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q5, null, 0, 5, 11, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x >= 5 and x <= 7)");
        qual_col1.setValue(5);
        qual_col2.setValue(7);
        Qualifier[][] q6 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 1, true, true, true), new QualifierUtil(0, (DataValueDescriptor)qual_col2, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q6, null, 0, 5, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x >= 5 and x <= 7)");
        qual_col1.setValue(5);
        qual_col2.setValue(7);
        Qualifier[][] q6_2 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 1, true, true, true)}, {new QualifierUtil(0, (DataValueDescriptor)qual_col2, 3, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q6_2, null, 0, 5, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 5 and y > 2)");
        qual_col1.setValue(5);
        qual_col2.setValue(2);
        Qualifier[][] q7 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)qual_col2, 3, true, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q7, null, 0, 2, 17, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 5 and y >= 2)");
        qual_col1.setValue(5);
        qual_col2.setValue(2);
        Qualifier[][] q8 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)qual_col2, 1, true, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q8, null, 0, 3, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 5 and y < 5)");
        qual_col1.setValue(5);
        qual_col2.setValue(5);
        Qualifier[][] q9 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true), new QualifierUtil(1, (DataValueDescriptor)qual_col1, 1, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q9, null, 0, 2, 16, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 2)");
        qual_col1.setValue(2);
        Qualifier[][] q10 = new Qualifier[][]{{new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true)}};
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q10, null, 0, 0, 0, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x >= 5) or (y = 6)");
        qual_col1.setValue(5);
        qual_col2.setValue(6);
        Qualifier[][] q11 = new Qualifier[][]{new Qualifier[0], new Qualifier[2]};
        q11[1][0] = new QualifierUtil(0, (DataValueDescriptor)qual_col1, 5, false, true, true);
        q11[1][1] = new QualifierUtil(1, (DataValueDescriptor)qual_col2, 2, false, true, true);
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q11, null, 0, 7, 15, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 1 or y = 1 or y = 6) and (x > 5 or y = 1) and (x = 9 or x = 7)");
        qual_col1.setValue(1);
        qual_col2.setValue(1);
        qual_col3.setValue(6);
        qual_col4.setValue(5);
        qual_col5.setValue(1);
        qual_col6.setValue(9);
        qual_col7.setValue(7);
        Qualifier[][] q12 = new Qualifier[][]{new Qualifier[0], new Qualifier[3], new Qualifier[2], new Qualifier[2]};
        q12[1][0] = new QualifierUtil(0, (DataValueDescriptor)qual_col1, 2, false, true, true);
        q12[1][1] = new QualifierUtil(1, (DataValueDescriptor)qual_col2, 2, false, true, true);
        q12[1][2] = new QualifierUtil(1, (DataValueDescriptor)qual_col3, 2, false, true, true);
        q12[2][0] = new QualifierUtil(0, (DataValueDescriptor)qual_col4, 4, false, true, true);
        q12[2][1] = new QualifierUtil(1, (DataValueDescriptor)qual_col5, 2, false, true, true);
        q12[3][0] = new QualifierUtil(0, (DataValueDescriptor)qual_col6, 2, false, true, true);
        q12[3][1] = new QualifierUtil(0, (DataValueDescriptor)qual_col7, 2, false, true, true);
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q12, null, 0, 2, 20, this.init_order)) {
            ret_val = false;
        }
        this.progress("qual scan (x = 1 or x = 4 or x= 9) and (y = 4 or y = 1) and (z = 15 or z = 14)");
        qual_col1.setValue(4);
        qual_col2.setValue(1);
        qual_col3.setValue(1);
        qual_col4.setValue(4);
        qual_col5.setValue(9);
        qual_col6.setValue(15);
        qual_col7.setValue(14);
        Qualifier[][] q13 = new Qualifier[][]{new Qualifier[0], new Qualifier[2], new Qualifier[3], new Qualifier[2]};
        q13[1][0] = new QualifierUtil(1, (DataValueDescriptor)qual_col1, 2, false, true, true);
        q13[1][1] = new QualifierUtil(1, (DataValueDescriptor)qual_col2, 2, false, true, true);
        q13[2][0] = new QualifierUtil(0, (DataValueDescriptor)qual_col4, 2, false, true, true);
        q13[2][1] = new QualifierUtil(0, (DataValueDescriptor)qual_col5, 2, false, true, true);
        q13[2][2] = new QualifierUtil(0, (DataValueDescriptor)qual_col3, 2, false, true, true);
        q13[3][0] = new QualifierUtil(2, (DataValueDescriptor)qual_col6, 2, false, true, true);
        q13[3][1] = new QualifierUtil(2, (DataValueDescriptor)qual_col7, 2, false, true, true);
        if (!T_QualifierTest.t_scan(tc, conglomid, openscan_template, fetch_template, null, 0, q13, null, 0, 1, 14, this.init_order)) {
            ret_val = false;
        }
        tc.commit();
        this.progress("Ending t_testqual");
        return ret_val;
    }

    private static boolean fail(String msg) throws T_Fail {
        throw T_Fail.testFailMsg("T_QualifierTest failure: " + msg);
    }

    private void progress(String msg) {
        this.init_out.println("T_QualifierTest progress: " + msg);
    }
}

