/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.security.AccessController;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RestrictiveFilePermissionsTest
extends BaseJDBCTestCase {
    static final String dbName = "RFPT_db";
    static final String dbName2 = "RFPT_db2";
    static final String exportFileName = "ourExport.txt";
    static final String exportFileName2 = "ourExport2.txt";
    static final String exportLobFileName = "ourExport.lob";
    static final String backupDir = "RFPT_backup";
    static final String derbyDotLog = "RFPT_db.log";
    static String home = null;
    static boolean supportsLaxTesting = false;
    public static final int NEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int UNKNOWN = 2;
    private static final Set<PosixFilePermission> UNWANTED_PERMISSIONS = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_EXECUTE, new PosixFilePermission[]{PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));

    public RestrictiveFilePermissionsTest(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        File file = new File("system/testPermissions");
        RestrictiveFilePermissionsTest.assertTrue((boolean)file.mkdirs());
        supportsLaxTesting = RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, 2);
        if (!supportsLaxTesting) {
            RestrictiveFilePermissionsTest.println("warning: testing of lax file permissions inRestrictiveFilePermissionsTest can not take place, use a more liberal runtime default (umask) for the tests");
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(file);
        BaseTestSuite baseTestSuite = new BaseTestSuite("RestrictiveFilePermissionsTest");
        Properties properties = new Properties();
        properties.put("derby.storage.useDefaultFilePermissions", "false");
        properties.put("derby.stream.error.file", derbyDotLog);
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new SupportFilesSetup((Test)new BaseTestSuite(RestrictiveFilePermissionsTest.class, "haveWeGotAllCreatedFilesSuite"), new String[]{"functionTests/tests/lang/dcl_id.jar"}), dbName), properties, true));
        if (Derby.hasServer()) {
            baseTestSuite.addTest((Test)new NetworkServerTestSetup((Test)new RestrictiveFilePermissionsTest("doTestCliServerIsRestrictive"), new String[0], new String[0], true));
        }
        if (supportsLaxTesting) {
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new RestrictiveFilePermissionsTest("doTestNonCliServerIsLax")));
            properties = new Properties();
            properties.put("derby.stream.error.file", "RFPT_db.log.lax");
            baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)new RestrictiveFilePermissionsTest("dotestEmbeddedIsLax"), properties, true));
        }
        return baseTestSuite;
    }

    public void setUp() throws Exception {
        this.getConnection();
        home = RestrictiveFilePermissionsTest.getSystemProperty("derby.system.home");
    }

    public void testDerbyDotLog() throws Exception {
        File file = new File(home, derbyDotLog);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 1);
    }

    public void testDbDirectory() throws Exception {
        File file = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 1);
    }

    public void testServiceProperties() throws Exception {
        File file = new File(home, "RFPT_db/service.properties");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 1);
    }

    public void testTmpDirectory() throws Exception {
        File file = new File(home, "RFPT_db/tmp");
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void testLockFiles() throws Exception {
        File file = new File(home, "RFPT_db/db.lck");
        File file2 = new File(home, "RFPT_db/dbex.lck");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 1);
        if (PrivilegedFileOpsForTests.exists(file2)) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(file2, 1);
        }
    }

    public void testSeg0AndConglomerates() throws Exception {
        File file = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void testLogDirAndLogFiles() throws Exception {
        File file = new File(home, "RFPT_db/log");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void testExportedFiles() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(    'SYS',    'SYSTABLES',    '" + home + "/RFPT_db/ourExport.txt',    NULL,    NULL,    NULL)");
        File file = new File(home, "RFPT_db/ourExport.txt");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 1);
        statement.executeUpdate("create table lobtable(i int, c clob)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into lobtable values (1,?)");
        preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader(1000L), 1000);
        preparedStatement.executeUpdate();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(    'SYS',    'SYSTABLES',    '" + home + "/RFPT_db/ourExport2.txt',    NULL,    NULL,    NULL,    '" + home + "/RFPT_db/ourExport.lob')");
        File file2 = new File(home, "RFPT_db/ourExport2.txt");
        File file3 = new File(home, "RFPT_db/ourExport.lob");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file2, 1);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file3, 1);
    }

    public void testConglomsAfterCompress() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table comptable(i int primary key, j int)");
        statement.executeUpdate("create index secondary on comptable(j)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into comptable values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 10000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        statement.executeUpdate("delete from comptable where MOD(i, 2) = 0");
        this.commit();
        this.setAutoCommit(true);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'COMPTABLE', 0)");
        File file = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void testTruncateTable() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table trunctable(i int)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into trunctable values (?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        statement.executeUpdate("truncate table trunctable");
        File file = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void testBackupRestoreFiles() throws Exception {
        URL uRL = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)uRL);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, "testBackupFiles");
        callableStatement.executeUpdate();
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String string = home + "/RFPT_backup";
        callableStatement.setString(1, string);
        callableStatement.execute();
        File file = new File(string);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
        File file2 = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file2, true, 1);
        TestConfiguration.getCurrent().shutdownDatabase();
        DataSource dataSource = JDBCDataSource.getDataSource();
        String string2 = home + "/RFPT_backup/RFPT_db";
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "restoreFrom=" + string2);
        Connection connection = dataSource.getConnection();
        RestrictiveFilePermissionsTest.checkAccessToOwner(file2, true, 1);
        connection.close();
        DataSource dataSource2 = JDBCDataSource.getDataSource(dbName2);
        JDBCDataSource.setBeanProperty(dataSource2, "connectionAttributes", "restoreFrom=" + string2);
        Connection connection2 = dataSource2.getConnection();
        File file3 = new File(home, dbName2);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file3, true, 1);
        connection2.close();
        DataSource[] dataSourceArray = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(dbName2)};
        for (int i = 0; i < dataSourceArray.length; ++i) {
            JDBCDataSource.setBeanProperty(dataSourceArray[i], "connectionAttributes", "shutdown=true");
            try {
                dataSourceArray[i].getConnection();
                RestrictiveFilePermissionsTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException sQLException) {
                RestrictiveFilePermissionsTest.assertSQLState("database shutdown", "08006", sQLException);
            }
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(file3);
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(new File(home + "/RFPT_backup"));
    }

    public void testJarFiles() throws Exception {
        URL uRL = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)uRL);
        CallableStatement callableStatement = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        callableStatement.setString(1, uRL.toExternalForm());
        callableStatement.setString(2, "anyName");
        callableStatement.executeUpdate();
        File file = new File(home, "RFPT_db/jar");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
    }

    public void doTestCliServerIsRestrictive() throws Exception {
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        String string = home + "/RFPT_db_tracefiles_restr";
        networkServerControl.setTraceDirectory(string);
        networkServerControl.trace(true);
        networkServerControl.ping();
        networkServerControl.trace(false);
        File file = new File(string);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 1);
        networkServerControl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(file);
    }

    public void doTestNonCliServerIsLax() throws Exception {
        NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl();
        String string = home + "/RFPT_db_tracefiles_lax";
        networkServerControl.setTraceDirectory(string);
        networkServerControl.trace(true);
        networkServerControl.ping();
        networkServerControl.trace(false);
        File file = new File(string);
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, true, 0);
        networkServerControl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(file);
    }

    public void dotestEmbeddedIsLax() throws Exception {
        File file = new File(home, "RFPT_db.log.lax");
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, 0);
    }

    public static void checkAccessToOwner(File file, int n) throws Exception {
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, n);
    }

    private static boolean checkAccessToOwner(File file, boolean bl, int n) throws Exception {
        if (bl) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, n);
            for (File file2 : PrivilegedFileOpsForTests.listFiles(file)) {
                RestrictiveFilePermissionsTest.checkAccessToOwner(file2, false, n);
            }
        }
        return AccessController.doPrivileged(() -> {
            boolean bl = false;
            Path path = Paths.get(file.getPath(), new String[0]);
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                for (PosixFilePermission posixFilePermission : posixFileAttributeView.readAttributes().permissions()) {
                    if (!UNWANTED_PERMISSIONS.contains((Object)posixFilePermission)) continue;
                    if (n == 1) {
                        RestrictiveFilePermissionsTest.fail((String)("unwanted permission " + posixFilePermission + " for file " + file));
                    }
                    bl = true;
                    break;
                }
            } else if (aclFileAttributeView != null) {
                UserPrincipal userPrincipal = Files.getOwner(path, new LinkOption[0]);
                for (AclEntry aclEntry : aclFileAttributeView.getAcl()) {
                    UserPrincipal userPrincipal2 = aclEntry.principal();
                    if (userPrincipal2.equals(userPrincipal)) continue;
                    if (n == 1) {
                        RestrictiveFilePermissionsTest.fail((String)("unexpected uid " + userPrincipal2.getName() + " can access file " + file));
                    }
                    bl = true;
                    break;
                }
            } else {
                RestrictiveFilePermissionsTest.fail();
            }
            if (n == 0 && !bl) {
                RestrictiveFilePermissionsTest.fail((String)("unexpected restrictive access: " + file));
            }
            if (n != 2) {
                RestrictiveFilePermissionsTest.println("checked perms on: " + file);
            }
            return n == 2 && bl;
        });
    }
}

