/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BatchUpdateTest
extends BaseJDBCTestCase {
    public BatchUpdateTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("delete from t1");
        statement.close();
        this.commit();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BatchUpdateTest");
        baseTestSuite.addTest(BatchUpdateTest.baseSuite("BatchUpdateTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(BatchUpdateTest.baseSuite("BatchUpdateTest:client")));
        return baseTestSuite;
    }

    public static Test embeddedSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BatchUpdateTest");
        baseTestSuite.addTest(BatchUpdateTest.baseSuite("BatchUpdateTest:embedded"));
        return baseTestSuite;
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(BatchUpdateTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t1(c1 int)");
                statement.execute("create table datetab(c1 date)");
                statement.execute("create table timetab(c1 time)");
                statement.execute("create table timestamptab(c1 timestamp)");
                statement.execute("create table usertypetab(c1 DATE)");
                statement.execute("create table assoc(x char(10) not null primary key, y char(100))");
                statement.execute("create table assocout(x char(10))");
            }
        };
    }

    public static void assertBatchUpdateCounts(long[] lArray, BatchUpdateException batchUpdateException) {
        BatchUpdateTest.assertBatchUpdateCounts(BatchUpdateTest.squashLongs(lArray), batchUpdateException.getUpdateCounts());
        if (JDBC.vmSupportsJDBC42()) {
            BatchUpdateExceptionWrapper batchUpdateExceptionWrapper = new BatchUpdateExceptionWrapper(batchUpdateException);
            BatchUpdateTest.assertEquals(lArray, batchUpdateExceptionWrapper.getLargeUpdateCounts());
        }
    }

    public static int[] squashLongs(long[] lArray) {
        int n = lArray == null ? 0 : lArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    private static void assertBatchUpdateCounts(int[] nArray, int[] nArray2) {
        BatchUpdateTest.assertEquals((String)"length of array should be identical", (int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string = "mismatch for array index [" + i + "] ; ";
            BatchUpdateTest.assertEquals((String)string, (int)nArray[i], (int)nArray2[i]);
            BatchUpdateTest.println("expectedUpdate result #" + i + " : " + nArray[i]);
            BatchUpdateTest.println("actual result #" + i + " : " + nArray2[i]);
        }
    }

    public static void assertBatchExecuteError(String string, Statement statement, long[] lArray) throws SQLException {
        try {
            statement.executeBatch();
            BatchUpdateTest.fail((String)"Expected batchExecute to fail");
        }
        catch (BatchUpdateException batchUpdateException) {
            BatchUpdateTest.assertSQLState(string, batchUpdateException);
            BatchUpdateTest.assertBatchUpdateCounts(lArray, batchUpdateException);
        }
    }

    public void testMinimalDDLInBatch() throws SQLException {
        Statement statement = this.createStatement();
        statement.addBatch("create table ddltsttable1(c1 int)");
        statement.addBatch("create procedure ddlinteg() language java parameter style java external name 'java.lang.Integer'");
        statement.addBatch("create table ddltable2(c1 date)");
        int[] nArray = new int[]{0, 0, 0};
        BatchUpdateTest.assertBatchUpdateCounts(nArray, statement.executeBatch());
        ResultSet resultSet = statement.executeQuery("select count(*) from SYS.SYSTABLES where CAST(tablename AS VARCHAR(128)) like 'DDL%'");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet = statement.executeQuery("select count(*) from SYS.SYSALIASES where CAST(alias AS VARCHAR(128)) like 'DDL%'");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        statement.close();
        this.commit();
    }

    public void testEmptyStatementBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: clear the batch and run the empty batch");
        statement.clearBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[0], statement.executeBatch());
        statement.close();
        this.commit();
    }

    public void testSingleStatementBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing 1 statement batch");
        statement.addBatch("insert into t1 values(2)");
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1}, statement.executeBatch());
        statement.close();
        this.commit();
    }

    public void testMultipleStatementsBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing 2 inserts and 1 update batch");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("update t1 set c1=4");
        statement.addBatch("insert into t1 values(3)");
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, statement.executeBatch());
        ResultSet resultSet = statement.executeQuery("select count(*) from t1 where c1=2");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"expect 0 rows with c1 = 2", (int)0, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from t1 where c1=4");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"expect 1 row with c1 = 4", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count(*) from t1 where c1=3");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"expect 1 row with c1 = 3", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        this.assertTableRowCount("T1", 2);
        statement.close();
        this.commit();
    }

    public void testMultipleStatementsBatchWithWarnings() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("insert into t1 values 1");
        statement.addBatch("delete from t1 where c1 in (select 0 from t1)");
        statement.addBatch("delete from t1 where c1 in (select 0 from t1)");
        statement.addBatch("delete from t1 where c1 in (select 0 from t1)");
        statement.executeBatch();
        SQLWarning sQLWarning = statement.getWarnings();
        BatchUpdateTest.assertSQLState("02000", sQLWarning);
        sQLWarning = sQLWarning.getNextWarning();
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertNull((Object)sQLWarning);
        } else {
            BatchUpdateTest.assertSQLState("02000", sQLWarning);
            sQLWarning = sQLWarning.getNextWarning();
            BatchUpdateTest.assertSQLState("02000", sQLWarning);
            sQLWarning = sQLWarning.getNextWarning();
            BatchUpdateTest.assertNull((Object)sQLWarning);
        }
    }

    public void test1000StatementsBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: 1000 statements batch");
        for (int i = 0; i < 1000; ++i) {
            statement.addBatch("insert into t1 values(1)");
        }
        int[] nArray = statement.executeBatch();
        int[] nArray2 = new int[1000];
        Arrays.fill(nArray2, 1);
        BatchUpdateTest.assertBatchUpdateCounts(nArray2, nArray);
        this.assertTableRowCount("T1", 1000);
        statement.close();
        this.commit();
    }

    public void testAutoCommitTrueBatch() throws SQLException {
        this.getConnection().setAutoCommit(true);
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: stmt testing with autocommit true");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("delete from t1");
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 2}, statement.executeBatch());
        this.assertTableRowCount("T1", 0);
        statement.close();
    }

    public void testCombinationsOfClearBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: add 3 statements, clear and execute batch");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        statement.clearBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[0], statement.executeBatch());
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Positive Statement: add 3 statements, clear batch, add 3 more statements and execute batch");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        statement.clearBatch();
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        statement.addBatch("insert into t1 values(2)");
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, statement.executeBatch());
        this.assertTableRowCount("T1", 3);
        statement.close();
        this.commit();
    }

    public void testAssociatedParams() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing associated parameters");
        PreparedStatement preparedStatement = this.prepareStatement("select x from assocout order by x");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into assoc values (?, 'hello')");
        for (n = 10; n < 60; ++n) {
            preparedStatement2.setString(1, Integer.toString(n));
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
        preparedStatement2 = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        preparedStatement2.setString(1, "33%");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "21%");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "49%");
        preparedStatement2.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, preparedStatement2.executeBatch());
        preparedStatement2.close();
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"21"}, {"33"}, {"49"}}, true);
        statement.executeUpdate("delete from assocout");
        preparedStatement2 = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        preparedStatement2.setString(1, "3%");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "2%");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "1%");
        preparedStatement2.addBatch();
        Object[][] objectArray = new String[30][1];
        for (n = 10; n < 40; ++n) {
            objectArray[n - 10][0] = String.valueOf(n);
        }
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{10, 10, 10}, preparedStatement2.executeBatch());
        preparedStatement2.close();
        preparedStatement.execute();
        resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("delete from assocout");
        preparedStatement2 = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        preparedStatement2.setString(1, "%");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "666666");
        preparedStatement2.addBatch();
        preparedStatement2.setString(1, "%");
        preparedStatement2.addBatch();
        Object[][] objectArray2 = new String[100][1];
        int n2 = 0;
        for (n = 10; n < 60; ++n) {
            for (int i = 0; i < 2; ++i) {
                objectArray2[n2][0] = String.valueOf(n);
                ++n2;
            }
        }
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{50, 0, 50}, preparedStatement2.executeBatch());
        preparedStatement2.close();
        preparedStatement.execute();
        resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, objectArray2, true);
        preparedStatement.close();
        statement.close();
    }

    public void testStatementWithResultSetBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Negative Statement: statement testing select as first statement in the batch");
        statement.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        statement.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("X0Y79", statement, new long[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{-3L, 1L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 0 : 1);
        BatchUpdateTest.println("Negative Statement: statement testing select as nth stat in the batch");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        statement.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("X0Y79", statement, new long[]{1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{1L, -3L, 1L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 1 : 3);
        BatchUpdateTest.println("Negative Statement: statement testing select as last stat in the batch");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("X0Y79", statement, new long[]{1L, 1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{1L, 1L, -3L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 3 : 5);
        this.rollback();
        this.assertTableRowCount("T1", 0);
        statement.close();
        this.commit();
    }

    public void testStatementNonBatchStuffInBatch() throws SQLException {
        Statement statement = this.createStatement();
        int[] nArray = null;
        BatchUpdateTest.println("Negative Statement: statement testing execute in the middle of batch");
        statement.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertStatementError("XJ068", statement, "insert into t1 values(1)");
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            statement.addBatch("insert into t1 values(1)");
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{-3L, 1L});
            this.rollback();
        }
        statement.clearBatch();
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Negative Statement: statement testing executeQuery in the middle of batch");
        statement.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            try {
                statement.executeQuery("SELECT * FROM SYS.SYSTABLES");
                BatchUpdateTest.fail((String)"Expected executeQuerywith embedded");
            }
            catch (SQLException sQLException) {
                BatchUpdateTest.assertSQLState("XJ068", sQLException);
                statement.clearBatch();
            }
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            statement.executeQuery("SELECT * FROM SYS.SYSTABLES");
            nArray = statement.executeBatch();
            BatchUpdateTest.assertBatchUpdateCounts(new int[]{1}, nArray);
            this.rollback();
        }
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Negative Statement: statement testing executeUpdate in the middle of batch");
        BatchUpdateTest.println("Negative Statement: statement testing executeUpdate in the middle of batch");
        statement.addBatch("insert into t1 values(1)");
        try {
            statement.executeUpdate("insert into t1 values(1)");
            statement.addBatch("insert into t1 values(1)");
            statement.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
            if (BatchUpdateTest.usingDerbyNetClient()) {
                BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{1L, 1L, -3L});
            } else if (BatchUpdateTest.usingEmbedded()) {
                nArray = statement.executeBatch();
                BatchUpdateTest.fail((String)"Expected executeBatch to fail");
            }
        }
        catch (SQLException sQLException) {
            if (BatchUpdateTest.usingEmbedded()) {
                BatchUpdateTest.assertSQLState("XJ068", sQLException);
            } else if (BatchUpdateTest.usingDerbyNetClient()) {
                BatchUpdateTest.assertSQLState("XJ208", sQLException);
            }
            statement.clearBatch();
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 0 : 3);
        this.rollback();
        this.assertTableRowCount("T1", 0);
        statement.close();
        this.commit();
    }

    public void testStatementWithErrorsBatch() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t1 values(1)");
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as first statement in the batch");
        statement.addBatch("update t1 set c1=2147483647 + 1");
        statement.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", statement, new long[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{-3L, 1L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 1 : 2);
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as nth statement in the batch");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("update t1 set c1=2147483647 + 1");
        statement.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", statement, new long[]{1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{1L, -3L, 1L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 2 : 4);
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as last stat in the batch");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("insert into t1 values(1)");
        statement.addBatch("update t1 set c1=2147483647 + 1");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", statement, new long[]{1L, 1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", statement, new long[]{1L, 1L, -3L});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 4 : 6);
        statement.close();
        this.commit();
    }

    public void testTransactionErrorBatch() throws SQLException {
        Statement statement;
        Statement statement2;
        Connection connection;
        Connection connection2;
        block6: {
            connection2 = this.getConnection();
            connection = this.openDefaultConnection();
            connection2.setAutoCommit(false);
            connection.setAutoCommit(false);
            statement2 = connection2.createStatement();
            statement = connection.createStatement();
            int[] nArray = null;
            BatchUpdateTest.println("Negative Statement: statement testing time out while getting the lock in the batch");
            statement2.execute("insert into t1 values(1)");
            statement.execute("insert into t1 values(2)");
            statement2.addBatch("update t1 set c1=3 where c1=2");
            statement.addBatch("update t1 set c1=4 where c1=1");
            try {
                statement2.executeBatch();
                BatchUpdateTest.fail((String)"Batch is expected to fail");
                nArray = statement.executeBatch();
            }
            catch (BatchUpdateException batchUpdateException) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("40XL1", batchUpdateException);
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    BatchUpdateTest.assertSQLState("XJ208", batchUpdateException);
                }
                nArray = batchUpdateException.getUpdateCounts();
                if (nArray == null) break block6;
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertEquals((String)"first statement in the batch caused time out while getting the lock, there should be no update count", (int)0, (int)nArray.length);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block6;
                BatchUpdateTest.assertBatchUpdateCounts(new int[]{-3}, nArray);
            }
        }
        connection2.rollback();
        connection.rollback();
        statement2.clearBatch();
        statement.clearBatch();
        statement2.close();
        statement.close();
        this.commit();
        connection.close();
    }

    public void testCallableStatementBatch() throws SQLException {
        BatchUpdateTest.println("Positive Callable Statement: statement testing callable statement batch");
        CallableStatement callableStatement = this.prepareCall("insert into t1 values(?)");
        callableStatement.setInt(1, 1);
        callableStatement.addBatch();
        callableStatement.setInt(1, 2);
        callableStatement.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(callableStatement);
        this.cleanUpCallableStatement(callableStatement, "t1");
        callableStatement = this.prepareCall("insert into datetab values(?)");
        callableStatement.setDate(1, Date.valueOf("1990-05-05"));
        callableStatement.addBatch();
        callableStatement.setDate(1, Date.valueOf("1990-06-06"));
        callableStatement.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(callableStatement);
        this.cleanUpCallableStatement(callableStatement, "datetab");
        callableStatement = this.prepareCall("insert into timetab values(?)");
        callableStatement.setTime(1, Time.valueOf("11:11:11"));
        callableStatement.addBatch();
        callableStatement.setTime(1, Time.valueOf("12:12:12"));
        callableStatement.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(callableStatement);
        this.cleanUpCallableStatement(callableStatement, "timestamptab");
        callableStatement = this.prepareCall("insert into timestamptab values(?)");
        callableStatement.setTimestamp(1, Timestamp.valueOf("1990-05-05 11:11:11.1"));
        callableStatement.addBatch();
        callableStatement.setTimestamp(1, Timestamp.valueOf("1992-07-07 12:12:12.2"));
        callableStatement.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(callableStatement);
        this.cleanUpCallableStatement(callableStatement, "timestamptab");
        callableStatement = this.prepareCall("insert into usertypetab values(?)");
        callableStatement.setObject(1, (Object)Date.valueOf("1990-05-05"));
        callableStatement.addBatch();
        callableStatement.setObject(1, (Object)Date.valueOf("1990-06-06"));
        callableStatement.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(callableStatement);
        this.cleanUpCallableStatement(callableStatement, "usertypetab");
    }

    private static void executeBatchCallableStatement(CallableStatement callableStatement) throws SQLException {
        int[] nArray = callableStatement.executeBatch();
        BatchUpdateTest.assertEquals((String)"there were 2 statements in the batch", (int)2, (int)nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            BatchUpdateTest.assertEquals((String)"update count should be 1", (int)1, (int)nArray[i]);
        }
    }

    protected void cleanUpCallableStatement(CallableStatement callableStatement, String string) throws SQLException {
        callableStatement.close();
        this.rollback();
        callableStatement = this.prepareCall("delete from " + string);
        callableStatement.executeUpdate();
        callableStatement.close();
        this.commit();
    }

    public void testCallableStatementWithOutputParamBatch() throws SQLException {
        BatchUpdateTest.println("Negative Callable Statement: callable statement with output parameters in the batch");
        Statement statement = this.createStatement();
        statement.execute("CREATE PROCEDURE takesString(OUT P1 VARCHAR(40), IN P2 INT) EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".takesString' NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement callableStatement = this.prepareCall("call takesString(?,?)");
        callableStatement.registerOutParameter(1, 1);
        callableStatement.setInt(2, 4);
        try {
            callableStatement.addBatch();
            if (BatchUpdateTest.usingEmbedded()) {
                BatchUpdateTest.fail((String)"Expected to see error XJ04C");
            } else if (BatchUpdateTest.usingDerbyNetClient()) {
                BatchUpdateTest.executeBatchCallableStatement(callableStatement);
            }
        }
        catch (SQLException sQLException) {
            BatchUpdateTest.assertSQLState("XJ04C", sQLException);
        }
        callableStatement.close();
        statement.execute("drop procedure takesString");
        statement.close();
        this.rollback();
    }

    public static void takesString(String[] stringArray, int n) throws Throwable {
        stringArray[0] = "3";
    }

    public void testEmptyValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: set no parameter values and run the batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        BatchUpdateTest.assertBatchUpdateCounts(new int[0], preparedStatement.executeBatch());
        preparedStatement.close();
        this.commit();
    }

    public void testNoParametersPreparedBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: no settable parameters");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(5)");
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, preparedStatement.executeBatch());
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select count(*) from t1 where c1=5");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"There should be 3 rows with c1 = 5", (int)3, (int)resultSet.getInt(1));
        resultSet.close();
        this.assertTableRowCount("T1", 3);
        statement.close();
        this.commit();
    }

    public void testSingleValueSetPreparedBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: set one set of parameter values and run the batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1}, preparedStatement.executeBatch());
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select count(*) from t1 where c1=1");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"There should be 1 row with c1=1", (int)1, (int)resultSet.getInt(1));
        resultSet.close();
        this.assertTableRowCount("T1", 1);
        statement.close();
        this.commit();
    }

    public void testMultipleValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: set 3 set of parameter values and run the batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 2);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 3);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, preparedStatement.executeBatch());
        preparedStatement.close();
        this.assertTableRowCount("T1", 3);
        this.commit();
    }

    public void testMultipleValueSetNullPreparedBatch() throws SQLException {
        Statement statement = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: set one set of parameter values to null and run the batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setNull(1, 4);
        preparedStatement.addBatch();
        preparedStatement.setNull(1, 4);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select count(*) from t1 where c1 is null");
        resultSet.next();
        BatchUpdateTest.assertEquals((String)"There should be 2 rows with c1 is null", (int)2, (int)resultSet.getInt(1));
        resultSet.close();
        this.assertTableRowCount("T1", 2);
        statement.close();
        this.commit();
    }

    public void test1000ValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: 1000 parameter set batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, 1);
            preparedStatement.addBatch();
        }
        int[] nArray = preparedStatement.executeBatch();
        int[] nArray2 = new int[1000];
        Arrays.fill(nArray2, 1);
        BatchUpdateTest.assertBatchUpdateCounts(nArray2, nArray);
        this.assertTableRowCount("T1", 1000);
        preparedStatement.close();
        this.commit();
    }

    public void testPreparedStatRollbackAndCommitCombinations() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: batch, rollback, batch and commit combinations");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        this.rollback();
        this.assertTableRowCount("T1", 0);
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 2);
        BatchUpdateTest.println("Positive Prepared Stat: batch and commit combinations");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 4);
        BatchUpdateTest.println("Positive Prepared Stat: batch, batch and rollback combinations");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        this.rollback();
        this.assertTableRowCount("T1", 4);
        BatchUpdateTest.println("Positive Prepared Stat: batch, batch and commit combinations");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1}, preparedStatement.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 8);
        preparedStatement.close();
        this.commit();
    }

    public void testAutoCommitTruePreparedStatBatch() throws SQLException {
        this.getConnection().setAutoCommit(true);
        BatchUpdateTest.println("Positive Prepared Stat: testing batch with autocommit true");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, preparedStatement.executeBatch());
        this.assertTableRowCount("T1", 3);
        preparedStatement.close();
    }

    public void testCombinationsOfClearPreparedStatBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: add 3 statements, clear batch and execute batch");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 2);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 3);
        preparedStatement.addBatch();
        preparedStatement.clearBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[0], preparedStatement.executeBatch());
        BatchUpdateTest.println("Positive Prepared Stat: add 3 statements, clear batch, add 3 and execute batch");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 2);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 3);
        preparedStatement.addBatch();
        preparedStatement.clearBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 2);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 3);
        preparedStatement.addBatch();
        BatchUpdateTest.assertBatchUpdateCounts(new int[]{1, 1, 1}, preparedStatement.executeBatch());
        this.assertTableRowCount("T1", 3);
        preparedStatement.close();
        this.commit();
    }

    public void testPreparedStmtWithResultSetBatch() throws SQLException {
        BatchUpdateTest.println("Negative Prepared Stat: testing select in the batch");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where c1=?");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("X0Y79", preparedStatement, new long[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ117", preparedStatement, new long[]{-3L});
        }
        preparedStatement.close();
        this.assertTableRowCount("T1", 0);
        this.commit();
    }

    public void testPreparedStmtNonBatchStuffInBatch() throws SQLException {
        PreparedStatement preparedStatement;
        block20: {
            int[] nArray;
            block19: {
                block18: {
                    nArray = null;
                    BatchUpdateTest.println("Negative Prepared Stat: testing execute in the middle of batch");
                    preparedStatement = this.prepareStatement("select * from t1 where c1=?");
                    preparedStatement.setInt(1, 1);
                    preparedStatement.addBatch();
                    try {
                        preparedStatement.execute();
                        if (BatchUpdateTest.usingEmbedded()) {
                            BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                        } else if (BatchUpdateTest.usingDerbyNetClient()) {
                            nArray = preparedStatement.executeBatch();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (BatchUpdateTest.usingEmbedded()) {
                            BatchUpdateTest.assertSQLState("XJ068", sQLException);
                        }
                        if (!BatchUpdateTest.usingDerbyNetClient()) break block18;
                        BatchUpdateTest.assertSQLState("XJ117", sQLException);
                    }
                }
                preparedStatement.close();
                this.assertTableRowCount("T1", 0);
                BatchUpdateTest.println("Negative Prepared Statement: testing executeQuery in the middle of batch");
                preparedStatement = this.prepareStatement("select * from t1 where c1=?");
                preparedStatement.setInt(1, 1);
                preparedStatement.addBatch();
                try {
                    preparedStatement.executeQuery();
                    if (BatchUpdateTest.usingEmbedded()) {
                        BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                    } else if (BatchUpdateTest.usingDerbyNetClient()) {
                        nArray = preparedStatement.executeBatch();
                    }
                }
                catch (SQLException sQLException) {
                    if (BatchUpdateTest.usingEmbedded()) {
                        BatchUpdateTest.assertSQLState("XJ068", sQLException);
                    }
                    if (!BatchUpdateTest.usingDerbyNetClient()) break block19;
                    BatchUpdateTest.assertSQLState("XJ117", sQLException);
                }
            }
            preparedStatement.close();
            this.assertTableRowCount("T1", 0);
            BatchUpdateTest.println("Negative Prepared Stat: testing executeUpdate in the middle of batch");
            preparedStatement = this.prepareStatement("select * from t1 where c1=?");
            preparedStatement.setInt(1, 1);
            preparedStatement.addBatch();
            try {
                preparedStatement.executeUpdate();
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    nArray = preparedStatement.executeBatch();
                }
            }
            catch (SQLException sQLException) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("XJ068", sQLException);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block20;
                BatchUpdateTest.assertSQLState("X0Y79", sQLException);
            }
        }
        preparedStatement.close();
        this.assertTableRowCount("T1", 0);
        this.commit();
    }

    public void testPreparedStmtWithErrorsBatch() throws SQLException {
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = null;
        statement.executeUpdate("insert into t1 values(1)");
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as first set of values");
        preparedStatement = this.prepareStatement("update t1 set c1=(? + 1)");
        preparedStatement.setInt(1, Integer.MAX_VALUE);
        preparedStatement.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", preparedStatement, new long[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", preparedStatement, new long[]{-3L});
        }
        preparedStatement.close();
        this.assertTableRowCount("T1", 1);
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as nth set of values");
        preparedStatement = this.prepareStatement("update t1 set c1=(? + 1)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, Integer.MAX_VALUE);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", preparedStatement, new long[]{1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", preparedStatement, new long[]{1L, -3L, 1L});
        }
        preparedStatement.close();
        this.assertTableRowCount("T1", 1);
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as last set of values");
        preparedStatement = this.prepareStatement("update t1 set c1=(? + 1)");
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, 1);
        preparedStatement.addBatch();
        preparedStatement.setInt(1, Integer.MAX_VALUE);
        preparedStatement.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertBatchExecuteError("22003", preparedStatement, new long[]{1L, 1L});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            BatchUpdateTest.assertBatchExecuteError("XJ208", preparedStatement, new long[]{1L, 1L, -3L});
        }
        this.assertTableRowCount("T1", 1);
        preparedStatement.close();
        statement.close();
        this.commit();
    }

    public void testTransactionErrorPreparedStmtBatch() throws SQLException {
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2;
        Statement statement;
        Statement statement2;
        Connection connection;
        block6: {
            Connection connection2 = this.getConnection();
            connection = this.openDefaultConnection();
            connection2.setAutoCommit(false);
            connection.setAutoCommit(false);
            statement2 = this.createStatement();
            statement = connection.createStatement();
            int[] nArray = null;
            BatchUpdateTest.println("Negative Prepared Statement: testing transaction error, time out while getting the lock");
            statement2.execute("insert into t1 values(1)");
            statement.execute("insert into t1 values(2)");
            preparedStatement2 = this.prepareStatement("update t1 set c1=3 where c1=?");
            preparedStatement2.setInt(1, 2);
            preparedStatement2.addBatch();
            preparedStatement = connection2.prepareStatement("update t1 set c1=4 where c1=?");
            preparedStatement.setInt(1, 1);
            preparedStatement.addBatch();
            try {
                preparedStatement2.executeBatch();
                nArray = preparedStatement.executeBatch();
                BatchUpdateTest.fail((String)"Batch is expected to fail");
            }
            catch (BatchUpdateException batchUpdateException) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("40XL1", batchUpdateException);
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    BatchUpdateTest.assertSQLState("XJ208", batchUpdateException);
                }
                nArray = batchUpdateException.getUpdateCounts();
                if (nArray == null) break block6;
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertEquals((String)"first statement in the batch caused time out while getting the lock, there should be no update count", (int)0, (int)nArray.length);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block6;
                BatchUpdateTest.assertBatchUpdateCounts(new int[]{-3}, nArray);
            }
        }
        preparedStatement2.close();
        preparedStatement.close();
        statement2.close();
        statement.close();
        this.rollback();
        connection.rollback();
        connection.close();
    }

    public void testUnderlyingExceptionIsVisible() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.addBatch("create table t(x int unique not null)");
        for (int i = 0; i < 3; ++i) {
            statement.addBatch("insert into t values 1");
        }
        BatchUpdateException batchUpdateException = null;
        try {
            statement.executeBatch();
        }
        catch (BatchUpdateException batchUpdateException2) {
            batchUpdateException = batchUpdateException2;
        }
        BatchUpdateTest.assertNotNull((String)"Did not get duplicate key exception", (Object)batchUpdateException);
        StringWriter stringWriter = new StringWriter();
        batchUpdateException.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        String string = stringWriter.toString();
        if (string.indexOf("duplicate key") == -1) {
            BatchUpdateTest.fail("Could not see 'duplicate key' in printStackTrace()", batchUpdateException);
        }
    }

    public void testContinueAfterError() throws SQLException {
        long[] lArray;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table a(x int)");
        statement.execute("create table b(x int primary key)");
        statement.execute("create table c(x int references b(x))");
        statement.addBatch("drop table a");
        statement.addBatch("drop table b");
        statement.addBatch("drop table c");
        if (BatchUpdateTest.usingEmbedded()) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = 0L;
        } else {
            long[] lArray3 = new long[3];
            lArray3[0] = 0L;
            lArray3[1] = -3L;
            lArray = lArray3;
            lArray3[2] = 0L;
        }
        long[] lArray4 = lArray;
        BatchUpdateTest.assertBatchExecuteError("X0Y25", statement, lArray4);
        BatchUpdateTest.assertStatementError("42X05", statement, "select * from a");
        this.assertTableRowCount("B", 0);
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertTableRowCount("C", 0);
        } else {
            BatchUpdateTest.assertStatementError("42X05", statement, "select * from c");
        }
    }

    public static class BatchUpdateExceptionWrapper {
        private BatchUpdateException _wrappedException;

        public BatchUpdateExceptionWrapper(BatchUpdateException batchUpdateException) {
            this._wrappedException = batchUpdateException;
        }

        public BatchUpdateException getWrappedException() {
            return this._wrappedException;
        }

        public long[] getLargeUpdateCounts() {
            return (long[])this.invoke("getLargeUpdateCounts", new Class[0], new Object[0]);
        }

        protected Object invoke(String string, Class[] classArray, Object[] objectArray) {
            try {
                Method method = this._wrappedException.getClass().getMethod(string, classArray);
                return method.invoke((Object)this._wrappedException, objectArray);
            }
            catch (Exception exception) {
                this.printException(exception);
                return null;
            }
        }

        private void printException(Throwable throwable) {
            BaseJDBCTestCase.println(throwable.getMessage());
        }
    }
}

