/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LDAPAuthenticationTest
extends BaseJDBCTestCase {
    private static String ldapServer;
    private static String ldapPort;
    private static String dnString;
    private static String ldapUser;
    private static String ldapPassword;
    private static String ldapContextFactory;
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/jdbcapi/LDAPTests.policy";

    public LDAPAuthenticationTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("cannot run with JSR169 - missing functionality for org.apache.derby.iapi.jdbc.AuthenticationService");
        }
        ldapUser = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapUser");
        if (ldapUser == null || ldapUser.length() < 1) {
            return new BaseTestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapUser set to a valid user set up on the ldapServer, eg: -DderbyTesting.ldapUser=CharliesPwd. In addition,test requires a user 'kathy', pwd 'kathyS' to be set up");
        }
        ldapPassword = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapPassword");
        if (ldapPassword == null || ldapPassword.length() < 1) {
            return new BaseTestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapPassword set the password of a valid user set up on the ldapServer, eg: -DderbyTesting.ldapPassword=Charlie");
        }
        ldapServer = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapServer");
        if (ldapServer == null || ldapServer.length() < 1) {
            return new BaseTestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapServer set, eg: -DderbyTesting.ldapServer=myldapserver.myorg.org");
        }
        ldapPort = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapPort");
        if (ldapPort == null || ldapPort.length() < 1) {
            return new BaseTestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapPort set, eg: -DderbyTesting.ldapPort=333");
        }
        dnString = LDAPAuthenticationTest.getSystemProperty("derbyTesting.dnString");
        if (dnString == null || dnString.length() < 1) {
            return new BaseTestSuite("LDAPAuthenticationTest requires property derbyTesting.dnString for setting o=, eg: -DderbyTesting.dnString=myJNDIstring");
        }
        ldapContextFactory = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapContextFactory");
        BaseTestSuite baseTestSuite = new BaseTestSuite("LDAPAuthenticationTest");
        baseTestSuite.addTest(LDAPAuthenticationTest.baseSuite("LDAPAuthenticationTest:embedded", "testLDAPConnection"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(LDAPAuthenticationTest.baseSuite("LDAPAuthenticationTest:client", "testLDAPConnection")));
        return new SecurityManagerSetup((Test)baseTestSuite, POLICY_FILE_NAME);
    }

    public static Test baseSuite(String string, String string2) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        LDAPAuthenticationTest lDAPAuthenticationTest = new LDAPAuthenticationTest(string2);
        LDAPAuthenticationTest.setBaseProps(baseTestSuite, (Test)lDAPAuthenticationTest);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    protected static void setBaseProps(BaseTestSuite baseTestSuite, Test test) {
        Properties properties = new Properties();
        properties.setProperty("derby.infolog.append", "true");
        properties.setProperty("derby.debug.true", "AuthenticationTrace");
        properties.setProperty("derby.user.system", "manager");
        properties.setProperty("derby.user.Jamie", "theHooligan");
        baseTestSuite.addTest((Test)new DatabasePropertyTestSetup(test, properties, true));
    }

    @Override
    protected void tearDown() throws Exception {
        LDAPAuthenticationTest.removeSystemProperty("derby.connection.requireAuthentication");
        super.tearDown();
    }

    protected void setDatabaseProperty(String string, String string2, Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        callableStatement.close();
    }

    protected String getDatabaseProperty(String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        return string2;
    }

    public void testLDAPConnection() throws SQLException {
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        DataSource dataSource = JDBCDataSource.getDataSource();
        Connection connection = dataSource.getConnection("system", "admin");
        this.setDatabaseProperty("derby.connection.requireAuthentication", "true", connection);
        this.setDatabaseProperty("derby.authentication.provider", "LDAP", connection);
        this.setDatabaseProperty("derby.authentication.server", ldapServer, connection);
        this.setDatabaseProperty("derby.authentication.ldap.searchBase", "o=" + dnString, connection);
        this.setDatabaseProperty("derby.authentication.ldap.searchFilter", "(&(objectClass=inetOrgPerson)(uid=%USERNAME%))", connection);
        if (ldapContextFactory != null && ldapContextFactory.length() > 0) {
            this.setDatabaseProperty("java.naming.factory.initial", ldapContextFactory, connection);
        }
        this.commit();
        TestConfiguration.getCurrent().shutdownDatabase();
        connection.close();
        dataSource = JDBCDataSource.getDataSource(string);
        this.assertLDAPDSConnectionOK(dataSource, ldapUser, ldapPassword);
        this.assertLDAPDrvMgrConnectionOK(string, ldapUser, ldapPassword);
        this.assertInvalidLDAPDSConnectionFails(dataSource, "Jamie", "theHooligan");
        this.assertInvalidLDAPDrvMgrConnectionFails(string, "Jamie", "thHooligan");
        this.assertInvalidLDAPDSConnectionFails(dataSource, ldapUser, ldapPassword + "ish");
        this.assertInvalidLDAPDrvMgrConnectionFails(string, ldapUser, ldapPassword + "ish");
        Connection connection2 = dataSource.getConnection(ldapUser, ldapPassword);
        String string2 = "derby.user." + ldapUser;
        String string3 = "uid=" + ldapUser + ",ou=People,o=" + dnString;
        this.setDatabaseProperty(string2, string3, connection2);
        connection2.commit();
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(ldapUser, ldapPassword);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in 08006 error.");
        }
        catch (SQLException sQLException) {
            LDAPAuthenticationTest.assertSQLState("08006", sQLException);
        }
        connection2.close();
        string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        dataSource = JDBCDataSource.getDataSource(string);
        this.assertLDAPDSConnectionOK(dataSource, ldapUser, ldapPassword);
        this.assertLDAPDrvMgrConnectionOK(string, ldapUser, ldapPassword);
        this.assertLDAPDSConnectionOK(dataSource, "kathy", "kathyS");
        this.assertLDAPDrvMgrConnectionOK(string, "kathy", "kathyS");
        this.assertInvalidLDAPDSConnectionFails(dataSource, "Jamie", "theHooligan");
        this.assertInvalidLDAPDrvMgrConnectionFails(string, "Jamie", "theHooligan");
        this.assertInvalidLDAPDSConnectionFails(dataSource, ldapUser, ldapPassword + "ish");
        this.assertInvalidLDAPDrvMgrConnectionFails(string, ldapUser, ldapPassword + "ish");
        this.assertLDAPDSConnectionOK(dataSource, ldapUser, ldapPassword);
        this.assertDSSystemShutdownOK("someuser", "somestring");
        this.cleanup(dataSource);
    }

    protected void cleanup(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection(ldapUser, ldapPassword);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", connection);
        connection.commit();
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(ldapUser, ldapPassword);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in 08006 error.");
        }
        catch (SQLException sQLException) {
            LDAPAuthenticationTest.assertSQLState("08006", sQLException);
        }
        connection.close();
    }

    public void assertLDAPDSConnectionOK(DataSource dataSource, String string, String string2) throws SQLException {
        Connection connection = dataSource.getConnection(string, string2);
        LDAPAuthenticationTest.assertNotNull((Object)connection);
        connection.close();
    }

    protected void assertLDAPDrvMgrConnectionOK(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string);
        Connection connection = DriverManager.getConnection(string4, string2, string3);
        LDAPAuthenticationTest.assertNotNull((Object)connection);
        connection.close();
    }

    public void assertInvalidLDAPDSConnectionFails(DataSource dataSource, String string, String string2) throws SQLException {
        try {
            dataSource.getConnection(string, string2);
            LDAPAuthenticationTest.fail((String)"expected invalid connection error (for DataSource)");
        }
        catch (SQLException sQLException) {
            LDAPAuthenticationTest.assertSQLState("08004", sQLException);
        }
    }

    protected void assertInvalidLDAPDrvMgrConnectionFails(String string, String string2, String string3) throws SQLException {
        String string4 = TestConfiguration.getCurrent().getJDBCUrl(string);
        try {
            DriverManager.getConnection(string4, string2, string3).close();
            LDAPAuthenticationTest.fail((String)"expected invalid connection error (for DataSource)");
        }
        catch (SQLException sQLException) {
            LDAPAuthenticationTest.assertSQLState("08004", sQLException);
        }
    }

    protected void assertDSSystemShutdownOK(String string, String string2) throws SQLException {
        DataSource dataSource;
        if (LDAPAuthenticationTest.usingEmbedded()) {
            dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(dataSource, "databaseName");
        } else {
            dataSource = JDBCDataSource.getDataSource("");
        }
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection(string, string2);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException sQLException) {
            LDAPAuthenticationTest.assertSQLState("XJ015", sQLException);
        }
    }
}

