/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OffsetFetchNextTest
extends BaseJDBCTestCase {
    private static final String LANG_FORMAT_EXCEPTION = "22018";
    private static final String LANG_INTEGER_LITERAL_EXPECTED = "42X20";
    private static final String LANG_INVALID_ROW_COUNT_FIRST = "2201W";
    private static final String LANG_INVALID_ROW_COUNT_OFFSET = "2201X";
    private static final String LANG_MISSING_PARMS = "07000";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL = "2201Z";
    private static final String PERCENT_TOKEN = "%";
    private static final String FIRST_ROWS_ONLY = "fetch first % rows only";
    private static final String FIRST_ROW_ONLY = "fetch first % row only";
    private static final String NEXT_ROWS_ONLY = "fetch next % rows only";
    private static final int SQL_STANDARD_VARIANT = 0;
    private static final int JDBC_VARIANT = 1;
    private static final int VARIANT_COUNT = 2;

    public OffsetFetchNextTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OffsetFetchNextTest");
        baseTestSuite.addTest(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(OffsetFetchNextTest.class, string)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                OffsetFetchNextTest.createSchemaObjects(statement);
            }
        };
    }

    private static void createSchemaObjects(Statement statement) throws SQLException {
        statement.executeUpdate("create table t1 (a int, b bigint)");
        statement.executeUpdate("insert into t1 (a, b) values (1,1), (1,2), (1,3), (1,4), (1,5)");
        statement.executeUpdate("create table t2 (a int primary key, b bigint)");
        statement.executeUpdate("insert into t2 (a, b) values (1,1), (2,1), (3,1), (4,1), (5,1)");
        statement.executeUpdate("create table t3 (a int primary key,                  b bigint unique)");
        statement.executeUpdate("insert into t3 (a, b) values (1,1), (2,2), (3,3), (4,4), (5,5)");
    }

    public void testErrors() throws SQLException {
        Statement statement = this.createStatement();
        String string = "select * from t1 %";
        this.vetStatement(statement, LANG_INVALID_ROW_COUNT_OFFSET, string, FIRST_ROWS_ONLY, "-1", null, null);
        this.vetStatement(statement, LANG_SYNTAX_ERROR, string, FIRST_ROWS_ONLY, "-?", null, null);
        OffsetFetchNextTest.assertStatementError(LANG_INVALID_ROW_COUNT_FIRST, statement, "select * from t1 fetch first 0 rows only");
        this.vetStatement(statement, LANG_INVALID_ROW_COUNT_FIRST, string, FIRST_ROWS_ONLY, null, "-1", null);
        this.vetStatement(statement, LANG_INTEGER_LITERAL_EXPECTED, string, FIRST_ROWS_ONLY, null, "3.14", null);
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select * from t1 fetch first 0 rows only offset 0 rows");
        OffsetFetchNextTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select * from t1 { offset 0 limit 0 }");
    }

    public void testNewKeywordNonReserved() throws SQLException {
        this.setAutoCommit(false);
        this.prepareStatement("select a,b as offset from t1 offset 0 rows");
        this.prepareStatement("select a,b as limit from t1 offset 0 rows");
        this.prepareStatement("select a,b from t1 as offset");
        this.prepareStatement("select a,b from t1 as limit");
        this.prepareStatement("select a,b offset from t1 offset");
        this.prepareStatement("select a,b limit from t1 limit");
        this.prepareStatement("select a,b offset from t1 offset +2 rows");
        this.prepareStatement("select a offset,b from t1 offset ? rows");
        this.prepareStatement("select offset.a, offset.b offset from t1 as offset offset ? rows");
        this.prepareStatement("select limit.a, limit.b offset from t1 as limit offset ? rows");
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t4562(i int, offset int)");
        ResultSet resultSet = statement.executeQuery("select * from t4562 where i > 0 and offset + i < 0 offset 2 rows");
        resultSet.next();
        resultSet = statement.executeQuery("select * from t4562 where i > 0 and offset - i < 0 offset 2 rows");
        resultSet.next();
        resultSet = statement.executeQuery("select * from t4562 where i > 0 and offset * i < 0 offset 2 rows");
        resultSet.next();
        resultSet.close();
        this.rollback();
    }

    public void testOffsetFetchFirstReadOnlyForwardOnlyRS() throws SQLException {
        Statement statement = this.createStatement();
        this.vetStatement(statement, null, "select a, b from t1%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROWS_ONLY, "0", null, new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(statement, null, "select a,b from t1%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROWS_ONLY, "1", null, new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(statement, null, "select a,b from t1%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"1", "5"}});
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"5", "1"}});
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROWS_ONLY, "4", null, new String[][]{{"5", "5"}});
        this.vetStatement(statement, null, "select a,b from t1%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"1", "2"}});
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"2", "1"}});
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROWS_ONLY, "1", "1", new String[][]{{"2", "2"}});
        this.vetStatement(statement, null, "select a,b from t1%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROW_ONLY, "1", "10", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.vetStatement(statement, null, "select a,b from t1%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.vetStatement(statement, null, "select a,b from t2%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.vetStatement(statement, null, "select a,b from t3%", FIRST_ROW_ONLY, "10", null, new String[0][]);
        this.queryAndCheck(statement, "select a,b from t1 fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t2 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t3 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t1 order by b asc fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t2 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t3 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(statement, "select a,b from t1 order by b desc fetch first row only", new String[][]{{"1", "5"}});
        this.queryAndCheck(statement, "select a,b from t2 order by a desc fetch next row only", new String[][]{{"5", "1"}});
        this.queryAndCheck(statement, "select a,b from t3 order by a desc fetch next row only", new String[][]{{"5", "5"}});
        this.queryAndCheck(statement, "select max(a) from t1 group by b fetch first row only", new String[][]{{"1"}});
        this.vetStatement(statement, null, "select max(a) from t2 group by b %", FIRST_ROW_ONLY, "0", null, new String[][]{{"5"}});
        this.vetStatement(statement, null, "select max(a) from t3 group by b order by max(a) %", NEXT_ROWS_ONLY, null, "2", new String[][]{{"1"}, {"2"}});
        this.vetStatement(statement, null, "select * from t1 union all select * from t1 %", FIRST_ROW_ONLY, null, "2", new String[][]{{"1", "1"}, {"1", "2"}});
        this.vetStatement(statement, null, "select t2.b, t3.b from t2,t3 where t2.a=t3.a %", FIRST_ROW_ONLY, null, "2", new String[][]{{"1", "1"}, {"1", "2"}});
        statement.close();
    }

    public void testOffsetFetchFirstUpdatableForwardOnlyRS() throws SQLException {
        ResultSet resultSet;
        String[] stringArray;
        Statement statement = this.createStatement(1003, 1008);
        this.setAutoCommit(false);
        for (String string : stringArray = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "0", null)) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.next();
            resultSet.updateInt(1, -resultSet.getInt(1));
            resultSet.updateRow();
            resultSet.close();
            this.queryAndCheck(statement, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        for (String string : stringArray = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "1", null)) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.updateInt(1, -resultSet.getInt(1));
            resultSet.updateRow();
            resultSet.close();
            this.queryAndCheck(statement, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        statement.close();
    }

    public void testOffsetFetchFirstReadOnlyScrollableRS() throws SQLException {
        ResultSet resultSet;
        String[] stringArray;
        Statement statement = this.createStatement(1004, 1007);
        for (String string : stringArray = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "0", null)) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.next();
            OffsetFetchNextTest.assertTrue((resultSet.getInt(2) == 2 ? 1 : 0) != 0);
            resultSet.close();
        }
        for (String string : stringArray = this.makeVariants("select * from t1 %", FIRST_ROWS_ONLY, "1", "3")) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.next();
            OffsetFetchNextTest.assertTrue((resultSet.getInt(2) == 3 ? 1 : 0) != 0);
            resultSet.previous();
            OffsetFetchNextTest.assertTrue((resultSet.getInt(2) == 2 ? 1 : 0) != 0);
            resultSet.previous();
            OffsetFetchNextTest.assertTrue((boolean)resultSet.isBeforeFirst());
            resultSet.next();
            resultSet.next();
            resultSet.next();
            resultSet.next();
            OffsetFetchNextTest.assertTrue((boolean)resultSet.isAfterLast());
        }
        statement.close();
    }

    public void testOffsetFetchFirstUpdatableScrollableRS() throws SQLException {
        ResultSet resultSet;
        String[] stringArray;
        Statement statement = this.createStatement(1004, 1008);
        this.setAutoCommit(false);
        for (String string : stringArray = this.makeVariants("select * from t1 % for update", FIRST_ROWS_ONLY, "0", null)) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.next();
            resultSet.updateInt(1, -resultSet.getInt(1));
            resultSet.updateRow();
            resultSet.close();
            this.queryAndCheck(statement, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
            this.rollback();
        }
        for (String string : stringArray = this.makeVariants("select * from t1 %", NEXT_ROWS_ONLY, "1", "3")) {
            resultSet = statement.executeQuery(string);
            resultSet.next();
            resultSet.next();
            resultSet.updateInt(1, -resultSet.getInt(1));
            resultSet.updateRow();
            resultSet.previous();
            resultSet.updateInt(1, -resultSet.getInt(1));
            resultSet.updateRow();
            resultSet.previous();
            OffsetFetchNextTest.assertTrue((boolean)resultSet.isBeforeFirst());
            resultSet.next();
            resultSet.next();
            resultSet.next();
            resultSet.next();
            OffsetFetchNextTest.assertTrue((boolean)resultSet.isAfterLast());
            resultSet.moveToInsertRow();
            resultSet.updateInt(1, 42);
            resultSet.updateInt(2, 42);
            resultSet.insertRow();
            resultSet.previous();
            resultSet.deleteRow();
            resultSet.previous();
            resultSet.next();
            OffsetFetchNextTest.assertTrue((boolean)resultSet.rowDeleted());
            resultSet.close();
            this.queryAndCheck(statement, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"-1", "3"}, {"1", "5"}, {"42", "42"}});
            this.rollback();
        }
        for (String string : stringArray = this.makeVariants("select * from t1 where a + 1 < b%", NEXT_ROWS_ONLY, "1", null)) {
            resultSet = statement.executeQuery(string);
            resultSet.absolute(2);
            OffsetFetchNextTest.assertTrue((resultSet.getInt(2) == 5 ? 1 : 0) != 0);
            resultSet.updateInt(2, -5);
            resultSet.updateRow();
            resultSet.close();
            this.queryAndCheck(statement, "select a,b from t1", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "-5"}});
            this.rollback();
        }
        statement.close();
    }

    public void testValues() throws SQLException {
        Statement statement = this.createStatement();
        this.vetStatement(statement, null, "values 4%", FIRST_ROW_ONLY, null, "2", new String[][]{{"4"}});
        this.vetStatement(statement, null, "values 4%", FIRST_ROW_ONLY, "1", null, new String[0][]);
        statement.close();
    }

    public void testMetadata() throws SQLException {
        String[] stringArray;
        Statement statement = this.createStatement();
        for (String string : stringArray = this.makeVariants("select * from t1%", NEXT_ROWS_ONLY, "1", null)) {
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray2 = new String[]{"A", "B"};
            int[] nArray = new int[]{4, -5};
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSetMetaData.getColumnName(i);
                int n2 = resultSetMetaData.getColumnType(i);
                OffsetFetchNextTest.assertTrue((boolean)string2.equals(stringArray2[i - 1]));
                OffsetFetchNextTest.assertTrue((n2 == nArray[i - 1] ? 1 : 0) != 0);
            }
            resultSet.close();
        }
        statement.close();
    }

    public void testRunTimeStatistics() throws SQLException {
        String[] stringArray;
        Statement statement = this.createStatement();
        for (String string : stringArray = this.makeVariants("select a,b from t1%", NEXT_ROWS_ONLY, "2", null)) {
            statement.executeUpdate("call syscs_util.syscs_set_runtimestatistics(1)");
            this.queryAndCheck(statement, string, new String[][]{{"1", "3"}, {"1", "4"}, {"1", "5"}});
            statement.executeUpdate("call syscs_util.syscs_set_runtimestatistics(0)");
            ResultSet resultSet = statement.executeQuery("values syscs_util.syscs_get_runtimestatistics()");
            resultSet.next();
            String string2 = resultSet.getString(1);
            OffsetFetchNextTest.assertTrue((string2.indexOf("Row Count (1):\nNumber of opens = 1\nRows seen = 3\nRows filtered = 2") != -1 ? 1 : 0) != 0);
            resultSet.close();
        }
        statement.close();
    }

    public void testBigTable() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("declare global temporary table session.t (i int) on commit preserve rows not logged");
        PreparedStatement preparedStatement = this.prepareStatement("insert into session.t values ?");
        for (int i = 1; i <= 100000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
            if (i % 10000 != 0) continue;
            this.commit();
        }
        this.queryAndCheck(statement, "select count(*) from session.t", new String[][]{{"100000"}});
        this.vetStatement(statement, null, "select i from session.t%", FIRST_ROWS_ONLY, "99999", null, new String[][]{{"100000"}});
        statement.executeUpdate("drop table session.t");
        statement.close();
    }

    public void testRepeatedExecution() throws SQLException {
        String[] stringArray;
        for (String string : stringArray = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "2", "2")) {
            PreparedStatement preparedStatement = this.prepareStatement(string);
            String[][] stringArray2 = new String[][]{{"1", "3"}, {"1", "4"}};
            for (int i = 0; i < 10; ++i) {
                JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
            }
        }
    }

    public void testDynamicArgs() throws SQLException {
        int n;
        int n2;
        PreparedStatement preparedStatement;
        String[] stringArray;
        String[][] stringArray2 = null;
        for (String string : stringArray = this.makeVariants("select * from t1%", NEXT_ROWS_ONLY, "?", null)) {
            preparedStatement = this.prepareStatement(string);
        }
        stringArray = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "?");
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = i == 0 ? 1 : 2;
            n = i == 0 ? 2 : 1;
            stringArray2 = new String[][]{{"1", "3"}, {"1", "4"}};
            preparedStatement = this.prepareStatement(stringArray[i]);
            preparedStatement.setInt(n2, 0);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_MISSING_PARMS, preparedStatement);
            preparedStatement.setInt(n2, -1);
            preparedStatement.setInt(n, 2);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_OFFSET, preparedStatement);
            preparedStatement.setInt(n2, 0);
            preparedStatement.setInt(n, i == 0 ? 0 : -1);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_INVALID_ROW_COUNT_FIRST, preparedStatement);
            try {
                preparedStatement.setString(n2, "aaa");
            }
            catch (SQLException sQLException) {
                OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, sQLException);
            }
            try {
                preparedStatement.setString(n, "aaa");
            }
            catch (SQLException sQLException) {
                OffsetFetchNextTest.assertSQLState(LANG_FORMAT_EXCEPTION, sQLException);
            }
            for (int j = 0; j < 2; ++j) {
                preparedStatement.setInt(n2, 2);
                preparedStatement.setInt(n, 2);
                JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
            }
            preparedStatement.setLong(n2, 1L);
            preparedStatement.setInt(n, 3);
            stringArray2 = new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}};
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
            preparedStatement.setLong(n2, 0xFFFFFFFEL);
            preparedStatement.setInt(n, 5);
            JDBC.assertEmpty(preparedStatement.executeQuery());
        }
        for (String string : stringArray = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "3")) {
            preparedStatement = this.prepareStatement(string);
            preparedStatement.setLong(1, 1L);
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
        }
        for (String string : stringArray = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "4", "?")) {
            preparedStatement = this.prepareStatement(string);
            preparedStatement.setLong(1, 1L);
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1", "5"}});
        }
        for (String string : stringArray = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "?", "3")) {
            preparedStatement = this.prepareStatement(string);
            preparedStatement.setInt(1, 1);
            preparedStatement.setLong(2, 1L);
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
        }
        for (String string : stringArray = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "1", "?")) {
            preparedStatement = this.prepareStatement(string);
            preparedStatement.setInt(1, 1);
            preparedStatement.setLong(2, 2L);
            stringArray2 = new String[][]{{"1", "2"}, {"1", "3"}};
            JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
        }
        stringArray = this.makeVariants("select * from t1 order by b%", NEXT_ROWS_ONLY, "?", "?");
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement = this.prepareStatement(stringArray[i]);
            n2 = i == 0 ? 1 : 2;
            n = i == 0 ? 2 : 1;
            preparedStatement.setNull(n2, -5);
            preparedStatement.setInt(n, 2);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, preparedStatement);
            preparedStatement.setInt(n2, 1);
            preparedStatement.setNull(n, -5);
            OffsetFetchNextTest.assertPreparedStatementError(LANG_ROW_COUNT_OFFSET_FIRST_IS_NULL, preparedStatement);
            preparedStatement.close();
        }
    }

    public void testDynamicArgsMetaData() throws SQLException {
        String[] stringArray;
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        for (String string : stringArray = this.makeVariants("select * from t1 where a = ? order by b%", NEXT_ROWS_ONLY, "?", "?")) {
            PreparedStatement preparedStatement = this.prepareStatement(string);
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            int[] nArray = new int[]{4, -5, -5};
            for (int i = 0; i < 3; ++i) {
                OffsetFetchNextTest.assertEquals((String)"Unexpected parameter type", (int)nArray[i], (int)parameterMetaData.getParameterType(i + 1));
                OffsetFetchNextTest.assertEquals((String)"Derby ? args are nullable", (int)1, (int)parameterMetaData.isNullable(i + 1));
            }
            preparedStatement.close();
        }
    }

    public void testJDBCLimitOffset() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select a from t2 order by a { limit ? }");
        preparedStatement.setInt(1, 0);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select a from t2 order by a { limit ? offset 3 }");
        preparedStatement.setInt(1, 0);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"4"}, {"5"}});
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select t.a from\n( select * from t2 order by a { limit 3 offset 1 } ) t,\n( select * from t3 order by a offset 2 rows fetch next 10 rows only ) s\nwhere t.a = s.a order by t.a");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"3"}, {"4"}});
        preparedStatement.close();
    }

    private void vetStatement(Statement statement, String string, String string2, String string3, String string4, String string5, String[][] stringArray) throws SQLException {
        String[] stringArray2;
        for (String string6 : stringArray2 = this.makeVariants(string2, string3, string4, string5)) {
            if (string != null) {
                OffsetFetchNextTest.assertStatementError(string, statement, string6);
                continue;
            }
            this.queryAndCheck(statement, string6, stringArray);
        }
    }

    private String[] makeVariants(String string, String string2, String string3, String string4) {
        String[] stringArray = new String[]{this.makeSQLStandardText(string, string2, string3, string4), this.makeJDBCText(string, string3, string4)};
        return stringArray;
    }

    private String makeSQLStandardText(String string, String string2, String string3, String string4) {
        Object object = "";
        if (string3 != null) {
            object = " offset " + string3 + " rows ";
        }
        if (string4 != null) {
            object = (String)object + this.substitute(string2, PERCENT_TOKEN, string4);
        }
        object = this.substitute(string, PERCENT_TOKEN, (String)object);
        OffsetFetchNextTest.println((String)object);
        return object;
    }

    private String makeJDBCText(String string, String string2, String string3) {
        Object object = "";
        if (string2 != null) {
            object = " offset " + string2;
        }
        object = string3 != null ? " limit " + string3 + " " + (String)object : "limit 0 " + (String)object;
        object = this.substitute(string, PERCENT_TOKEN, " { " + (String)object + " } ");
        OffsetFetchNextTest.println((String)object);
        return object;
    }

    private String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            OffsetFetchNextTest.fail((String)("Bad stub: " + string + ". Can't find token: " + string2));
        }
        String string4 = string.substring(0, n);
        String string5 = n == string.length() - 1 ? "" : string.substring(n + 1, string.length());
        return string4 + string3 + string5;
    }

    private void queryAndCheck(Statement statement, String string, String[][] stringArray) throws SQLException {
        ResultSet resultSet = statement.executeQuery(string);
        JDBC.assertFullResultSet(resultSet, stringArray);
    }
}

