/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OfflineBackupTest
extends BaseJDBCTestCase {
    public OfflineBackupTest(String string) {
        super(string);
    }

    public void testCreateFromRestoreFrom() throws SQLException, IOException {
        this.getConnection();
        TestConfiguration.getCurrent().shutdownDatabase();
        File file = new File("system", "wombat");
        File file2 = new File("system", "wombatbackup");
        PrivilegedFileOpsForTests.copy(file, file2);
        Connection connection = DriverManager.getConnection("jdbc:derby:wombatCreateFrom;createFrom=system/wombatbackup");
        this.checkAllConsistency(connection);
        try {
            DriverManager.getConnection("jdbc:derby:wombatCreateFrom;shutdown=true");
        }
        catch (SQLException sQLException) {
            OfflineBackupTest.assertSQLState("Database shutdown", "08006", sQLException);
        }
        Connection connection2 = DriverManager.getConnection("jdbc:derby:wombatRestoreFrom;restoreFrom=system/wombatbackup");
        this.checkAllConsistency(connection2);
        try {
            DriverManager.getConnection("jdbc:derby:wombatRestoreFrom;shutdown=true");
        }
        catch (SQLException sQLException) {
            OfflineBackupTest.assertSQLState("Database shutdown", "08006", sQLException);
        }
        OfflineBackupTest.removeDirectory(file2);
        OfflineBackupTest.removeDirectory(new File("system", "wombatCreateFrom"));
        OfflineBackupTest.removeDirectory(new File("system", "wombatRestoreFrom"));
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Empty OfflineBackupTest (uses DriverManager)");
        }
        return TestConfiguration.embeddedSuite(OfflineBackupTest.class);
    }
}

