/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.corruptio;

import java.io.File;

public class CorruptibleIo {
    private static CorruptibleIo instance = new CorruptibleIo();
    private boolean corruptLog = false;
    private boolean corruptData = false;
    private int corruptLength;
    private int corruptOffset;

    private CorruptibleIo() {
    }

    public static CorruptibleIo getInstance() {
        return instance;
    }

    public void setLogCorruption(boolean bl) {
        this.corruptLog = bl;
    }

    public void setDataCorruption(boolean bl) {
        this.corruptData = bl;
    }

    public void setOffset(int n) {
        this.corruptOffset = n;
    }

    public void setLength(int n) {
        this.corruptLength = n;
    }

    public int getOffset() {
        return this.corruptOffset;
    }

    public int getLength() {
        return this.corruptLength;
    }

    public boolean isCorruptibleFile(File file) {
        String string = file.getName();
        String string2 = file.getParent();
        if (string2.endsWith("log") && string.endsWith("dat")) {
            return this.corruptLog;
        }
        if (string2.endsWith("seg0")) {
            return this.corruptData;
        }
        return false;
    }

    public byte[] corrupt(byte[] byArray, int n, int n2) {
        if (this.corruptOffset >= n && this.corruptOffset + this.corruptLength < n + n2) {
            for (int i = this.corruptOffset; i < this.corruptOffset + this.corruptLength; ++i) {
                byArray[i] = ~byArray[i];
            }
        } else {
            System.out.println("Not valid corrupt request :Write RequestOff=" + n + "size = " + n2 + "Corrupt RequestOff=" + this.corruptOffset + "size = " + this.corruptLength);
        }
        return byArray;
    }
}

