/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DerbyDistribution;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.Utilities;

public class ReleaseRepository {
    private static final String OVERRIDE_HOME_PROP = "derbyTesting.oldReleasePath";
    private static final File DEFAULT_HOME;
    private static ReleaseRepository repos;
    private final File reposLocation;
    private List<DerbyDistribution> dists;

    public static synchronized ReleaseRepository getInstance() throws IOException {
        if (repos == null) {
            File file = DEFAULT_HOME;
            String string = BaseTestCase.getSystemProperty(OVERRIDE_HOME_PROP);
            if (string != null && !PrivilegedFileOpsForTests.exists(file = new File(string))) {
                throw new IOException("the specified Derby release repository doesn't exist: " + file.getPath());
            }
            repos = new ReleaseRepository(file);
            repos.buildDistributionList();
        }
        return repos;
    }

    private ReleaseRepository(File file) {
        this.reposLocation = file;
    }

    public DerbyDistribution[] getDistributions() {
        DerbyDistribution[] derbyDistributionArray = new DerbyDistribution[this.dists.size()];
        this.dists.toArray(derbyDistributionArray);
        return derbyDistributionArray;
    }

    private void buildDistributionList() {
        if (this.dists != null) {
            throw new IllegalStateException("repository already initialized");
        }
        File[] fileArray = this.reposLocation.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                String string = file.getName();
                int n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '.') {
                        ++n;
                        continue;
                    }
                    if (Character.isDigit(c)) continue;
                    return false;
                }
                return n == 3;
            }
        });
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        ReleaseRepository.traceit("{ReleaseRepository} " + fileArray.length + " candidate releases at " + this.reposLocation);
        this.dists = new ArrayList<DerbyDistribution>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            DerbyVersion derbyVersion;
            File file = fileArray[i];
            String[] stringArray = Utilities.split(file.getName(), '.');
            try {
                derbyVersion = new DerbyVersion(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
            }
            catch (NumberFormatException numberFormatException) {
                ReleaseRepository.traceit("skipped distribution, invalid version: " + file.getAbsolutePath());
                continue;
            }
            DerbyDistribution derbyDistribution = DerbyDistribution.newInstance(derbyVersion, file);
            if (derbyDistribution == null) {
                ReleaseRepository.traceit("skipped invalid distribution: " + file.getAbsolutePath());
                continue;
            }
            this.dists.add(derbyDistribution);
        }
        this.filterDistributions(this.dists);
        Collections.sort(this.dists);
        this.dists = Collections.unmodifiableList(this.dists);
    }

    private void filterDistributions(List list) {
        DerbyVersion derbyVersion = DerbyVersion._10_1;
        DerbyVersion derbyVersion2 = DerbyVersion._10_3_1_4;
        for (int i = list.size() - 1; i >= 0; --i) {
            DerbyDistribution derbyDistribution = (DerbyDistribution)list.get(i);
            DerbyVersion derbyVersion3 = derbyDistribution.getVersion();
            if (JDBC.vmSupportsJSR169() && derbyVersion3.lessThan(derbyVersion)) {
                ReleaseRepository.println("skipping " + derbyVersion3.toString() + " on JSR169");
                list.remove(i);
                continue;
            }
            if (!BaseTestCase.isPhoneME() || !derbyVersion2.equals(derbyVersion3)) continue;
            ReleaseRepository.println("skipping " + derbyVersion2.toString() + " on CVM/phoneme");
            list.remove(i);
        }
    }

    private static void traceit(String string) {
        BaseTestCase.traceit(string);
    }

    private static void println(String string) {
        BaseTestCase.println(string);
    }

    static {
        String string = BaseTestCase.getSystemProperty("user.home");
        DEFAULT_HOME = new File(string, ".derbyTestingReleases");
    }
}

