/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.SQLException;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.LoadGenerator;

public class BackToBackLoadGenerator
implements LoadGenerator {
    private ClientThread[] threads;
    private volatile boolean stop;
    private volatile boolean collect;
    private long startTime;
    private long stopTime;

    @Override
    public void init(Client[] clientArray) {
        this.threads = new ClientThread[clientArray.length];
        for (int i = 0; i < clientArray.length; ++i) {
            this.threads[i] = new ClientThread(clientArray[i]);
        }
    }

    @Override
    public void startWarmup() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
    }

    @Override
    public void startSteadyState() {
        this.startTime = System.currentTimeMillis();
        this.collect = true;
    }

    @Override
    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.collect = false;
        this.stop = true;
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                this.threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    public void printReport(PrintStream printStream) {
        long l = this.stopTime - this.startTime;
        long l2 = 0L;
        for (int i = 0; i < this.threads.length; ++i) {
            l2 += this.threads[i].count;
        }
        double d = (double)l2 * 1000.0 / (double)l;
        printStream.println("Number of threads:\t" + this.threads.length);
        printStream.println("Test duration (s):\t" + (double)l / 1000.0);
        printStream.println("Number of transactions:\t" + l2);
        printStream.println("Average throughput (tx/s):\t" + d);
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].getClient().printReport(printStream);
        }
    }

    private class ClientThread
    extends Thread {
        private final Client client;
        private long count;

        ClientThread(Client client) {
            this.client = client;
        }

        public Client getClient() {
            return this.client;
        }

        @Override
        public void run() {
            try {
                while (!BackToBackLoadGenerator.this.stop) {
                    this.client.doWork();
                    if (!BackToBackLoadGenerator.this.collect) continue;
                    ++this.count;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }
}

