/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.util.io.ASCII85OutputStream;
import org.apache.xmlgraphics.util.io.Finalizable;
import org.apache.xmlgraphics.util.io.FlateEncodeOutputStream;
import org.apache.xmlgraphics.util.io.RunLengthEncodeOutputStream;

public class PSImageUtils {
    public static void writeImage(byte[] img, Dimension imgDim, String imgName, Rectangle2D targetRect, boolean isJPEG, ColorSpace colorSpace, PSGenerator gen) throws IOException {
        boolean iscolor = colorSpace.getType() != 1003;
        gen.saveGraphicsState();
        gen.writeln(gen.formatDouble(targetRect.getX()) + " " + gen.formatDouble(targetRect.getY()) + " translate");
        gen.writeln(gen.formatDouble(targetRect.getWidth()) + " " + gen.formatDouble(targetRect.getHeight()) + " scale");
        gen.commentln("%FOPBeginBitmap: " + imgName);
        if (colorSpace.getType() == 9) {
            gen.writeln("/DeviceCMYK setcolorspace");
        } else if (colorSpace.getType() == 1003) {
            gen.writeln("/DeviceGray setcolorspace");
        } else {
            gen.writeln("/DeviceRGB setcolorspace");
        }
        gen.writeln("{{");
        if (isJPEG) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData << >> /DCTDecode filter def");
        } else if (gen.getPSLevel() >= 3) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /FlateDecode filter def");
        } else {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /RunLengthDecode filter def");
        }
        gen.writeln("<<");
        gen.writeln("  /ImageType 1");
        gen.writeln("  /Width " + imgDim.width);
        gen.writeln("  /Height " + imgDim.height);
        gen.writeln("  /BitsPerComponent 8");
        if (colorSpace.getType() == 9) {
            gen.writeln("  /Decode [0 1 0 1 0 1 0 1]");
        } else if (iscolor) {
            gen.writeln("  /Decode [0 1 0 1 0 1]");
        } else {
            gen.writeln("  /Decode [0 1]");
        }
        gen.writeln("  /ImageMatrix [" + imgDim.width + " 0 0 " + imgDim.height + " 0 0]");
        gen.writeln("  /DataSource Data");
        gen.writeln(">>");
        gen.writeln("image");
        gen.writeln("} stopped {handleerror} if");
        gen.writeln("  RawData flushfile");
        gen.writeln("} exec");
        OutputStream out = gen.getOutputStream();
        out = new ASCII85OutputStream(out);
        if (!isJPEG) {
            out = gen.getPSLevel() >= 3 ? new FlateEncodeOutputStream(out) : new RunLengthEncodeOutputStream(out);
        }
        out.write(img);
        if (out instanceof Finalizable) {
            ((Finalizable)((Object)out)).finalizeStream();
        } else {
            out.flush();
        }
        gen.writeln("");
        gen.commentln("%FOPEndBitmap");
        gen.restoreGraphicsState();
    }

    public static void renderBitmapImage(RenderedImage img, float x, float y, float w, float h, PSGenerator gen) throws IOException {
        byte[] imgmap = PSImageUtils.getBitmapBytes(img);
        String imgName = img.getClass().getName();
        Dimension imgDim = new Dimension(img.getWidth(), img.getHeight());
        Rectangle2D.Double targetRect = new Rectangle2D.Double(x, y, w, h);
        boolean isJPEG = false;
        PSImageUtils.writeImage(imgmap, imgDim, imgName, targetRect, isJPEG, img.getColorModel().getColorSpace(), gen);
    }

    private static byte[] getBitmapBytes(RenderedImage img) {
        int[] tmpMap = PSImageUtils.getRGB(img, 0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        byte[] bitmaps = new byte[img.getWidth() * img.getHeight() * 3];
        int my = img.getHeight();
        for (int y = 0; y < my; ++y) {
            int mx = img.getWidth();
            for (int x = 0; x < mx; ++x) {
                int p = tmpMap[y * mx + x];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                bitmaps[3 * (y * mx + x)] = (byte)(r & 0xFF);
                bitmaps[3 * (y * mx + x) + 1] = (byte)(g & 0xFF);
                bitmaps[3 * (y * mx + x) + 2] = (byte)(b & 0xFF);
            }
        }
        return bitmaps;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getRGB(RenderedImage img, int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        Raster raster = img.getData();
        int yoff = offset;
        int nbands = raster.getNumBands();
        int dataType = raster.getDataBuffer().getDataType();
        switch (dataType) {
            case 0: {
                Object[] data = new byte[nbands];
                break;
            }
            case 1: {
                Object[] data = new short[nbands];
                break;
            }
            case 3: {
                Object[] data = new int[nbands];
                break;
            }
            case 4: {
                Object[] data = new float[nbands];
                break;
            }
            case 5: {
                Object[] data = new double[nbands];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + dataType);
            }
        }
        if (rgbArray == null) {
            rgbArray = new int[offset + h * scansize];
        }
        ColorModel colorModel = img.getColorModel();
        int y = startY;
        while (y < startY + h) {
            int off = yoff;
            for (int x = startX; x < startX + w; ++x) {
                void var11_12;
                rgbArray[off++] = colorModel.getRGB(raster.getDataElements(x, y, var11_12));
            }
            ++y;
            yoff += scansize;
        }
        return rgbArray;
    }

    public static void renderEPS(byte[] rawEPS, String name, float x, float y, float w, float h, float bboxx, float bboxy, float bboxw, float bboxh, PSGenerator gen) throws IOException {
        gen.notifyResourceUsage(PSProcSets.EPS_PROCSET, false);
        gen.writeln("%FOPBeginEPS: " + name);
        gen.writeln("BeginEPSF");
        gen.writeln(gen.formatDouble(x) + " " + gen.formatDouble(y) + " translate");
        gen.writeln("0 " + gen.formatDouble(h) + " translate");
        gen.writeln("1 -1 scale");
        float sx = w / bboxw;
        float sy = h / bboxh;
        if (sx != 1.0f || sy != 1.0f) {
            gen.writeln(gen.formatDouble(sx) + " " + gen.formatDouble(sy) + " scale");
        }
        if (bboxx != 0.0f || bboxy != 0.0f) {
            gen.writeln(gen.formatDouble(-bboxx) + " " + gen.formatDouble(-bboxy) + " translate");
        }
        gen.writeln(gen.formatDouble(bboxy) + " " + gen.formatDouble(bboxy) + " " + gen.formatDouble(bboxw) + " " + gen.formatDouble(bboxh) + " re clip");
        gen.writeln("newpath");
        PSResource res = new PSResource("file", name);
        gen.notifyResourceUsage(res, false);
        gen.writeDSCComment("BeginDocument", res.getName());
        gen.writeByteArr(rawEPS);
        gen.writeDSCComment("EndDocument");
        gen.writeln("EndEPSF");
        gen.writeln("%FOPEndEPS");
    }
}

