/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlClientCommandTest
extends BaseJDBCTestCase {
    public NetworkServerControlClientCommandTest(String string) {
        super(string);
    }

    public void testPingWithoutArgs() throws InterruptedException, IOException {
        if (!this.hasDefaultDerbyPortUsing()) {
            return;
        }
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping"};
        stringArray = this.decorateCmdWithEnglishLocale(stringArray);
        this.assertSuccessfulPing(stringArray);
    }

    private boolean hasDefaultDerbyPortUsing() {
        return TestConfiguration.getCurrent().getPort() == 1527;
    }

    private String[] decorateCmdWithEnglishLocale(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "-Dderby.ui.locale=en_US";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public void testPingWithDefinedHost() throws InterruptedException, IOException {
        if (!this.hasDefaultDerbyPortUsing()) {
            return;
        }
        String string = TestConfiguration.getCurrent().getHostName();
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", string};
        stringArray = this.decorateCmdWithEnglishLocale(stringArray);
        this.assertSuccessfulPing(stringArray);
    }

    public void testPingWithDefinedHostAndPort() throws InterruptedException, IOException {
        String string = Integer.toString(TestConfiguration.getCurrent().getPort());
        String string2 = TestConfiguration.getCurrent().getHostName();
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", string2, "-p", string};
        stringArray = this.decorateCmdWithEnglishLocale(stringArray);
        this.assertSuccessfulPing(stringArray);
    }

    public void testPingWithWrongHost() throws InterruptedException, IOException {
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", "nothere.invalid"};
        stringArray = this.decorateCmdWithEnglishLocale(stringArray);
        this.assertFailedPing(stringArray, "Unable to find host");
    }

    public void testPingWithBogusPort() throws InterruptedException, IOException {
        String string = TestConfiguration.getCurrent().getHostName();
        String string2 = Integer.toString(TestConfiguration.getCurrent().getBogusPort());
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", string, "-p", string2};
        stringArray = this.decorateCmdWithEnglishLocale(stringArray);
        this.assertFailedPing(stringArray, "Could not connect to Derby Network Server");
    }

    private void assertSuccessfulPing(String[] stringArray) throws InterruptedException, IOException {
        NetworkServerControlClientCommandTest.assertExecJavaCmdAsExpected(new String[]{"Connection obtained"}, stringArray, 0);
    }

    private void assertFailedPing(String[] stringArray, String string) throws InterruptedException, IOException {
        NetworkServerControlClientCommandTest.assertExecJavaCmdAsExpected(new String[]{string}, stringArray, 1);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NetworkServerControlClientCommandTest");
        if (!Derby.hasServer() || JDBC.vmSupportsJSR169()) {
            return baseTestSuite;
        }
        Test test = TestConfiguration.clientServerSuite(NetworkServerControlClientCommandTest.class);
        baseTestSuite.addTest(test);
        return baseTestSuite;
    }
}

