/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class AggregateClassLoadingTest
extends BaseJDBCTestCase {
    public AggregateClassLoadingTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(AggregateClassLoadingTest.class, "AggregateClassLoadingTest")){
            private ClassLoader originalLoader;

            @Override
            protected void setUp() throws Exception {
                this.originalLoader = Thread.currentThread().getContextClassLoader();
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                Thread.currentThread().setContextClassLoader(this.originalLoader);
                super.tearDown();
            }

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t (i int)");
                statement.execute("insert into t values 1,2,3,4,5,6,null,4,5,456,2,4,6,7,2144,44,2,-2,4");
                URL uRL = statement.getConnection().getClass().getProtectionDomain().getCodeSource().getLocation();
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, null);
                Thread.currentThread().setContextClassLoader(uRLClassLoader);
                super.decorateSQL(statement);
            }
        };
    }

    public void testAggregateMAX() throws SQLException {
        this.testAggregate("select MAX(i) from t");
    }

    public void testAggregateMIN() throws SQLException {
        this.testAggregate("select MIN(i) from t");
    }

    public void testAggregateAVG() throws SQLException {
        this.testAggregate("select AVG(i) from t");
    }

    public void testAggregateCOUNT() throws SQLException {
        this.testAggregate("select COUNT(i) from t");
    }

    public void testAggregateCOUNT2() throws SQLException {
        this.testAggregate("select COUNT(*) from t");
    }

    private void testAggregate(String string) throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertDrainResults(statement.executeQuery(string), 1);
        statement.close();
    }
}

