/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OLAPTest
extends BaseJDBCTestCase {
    private static final String LANG_WINDOW_FUNCTION_CONTEXT_ERROR = "42ZC2";
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String LANG_COLUMN_NOT_FOUND = "42X04";

    public OLAPTest(String string) {
        super(string);
    }

    public static Test makeSuite() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)new BaseTestSuite(OLAPTest.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                this.getConnection().setAutoCommit(false);
                statement.executeUpdate("create table t1 (a int, b int)");
                statement.executeUpdate("create table t2 (x int)");
                statement.executeUpdate("create table t3 (y int)");
                statement.executeUpdate("create table t4 (a int, b int)");
                statement.executeUpdate("create table t5 (a int, b int)");
                statement.executeUpdate("insert into t1 values (10,100),(20,200),                      (30,300),(40,400),                      (50,500)");
                statement.executeUpdate("insert into t2 values (1),(2),(3),(4),(5)");
                statement.executeUpdate("insert into t3 values (4),(5),(6),(7),(8)");
                statement.executeUpdate("insert into t4 values (10,100),(20,200)");
                statement.executeUpdate("insert into t5 values (1,1),(2,4),(3,4),(4,4),(5,9)");
                this.getConnection().commit();
            }
        };
        return cleanDatabaseTestSetup;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("OLAPTest");
        baseTestSuite.addTest(OLAPTest.makeSuite());
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(OLAPTest.makeSuite()));
        return baseTestSuite;
    }

    public void testBasicOperations() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select row_number() over (), t1.* from t1");
        String[][] stringArray = new String[][]{{"1", "10", "100"}, {"2", "20", "200"}, {"3", "30", "300"}, {"4", "40", "400"}, {"5", "50", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over (), t1.* from t1 where a > 30");
        stringArray = new String[][]{{"1", "40", "400"}, {"2", "50", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over (), a from t1 where b > 300");
        stringArray = new String[][]{{"1", "40"}, {"2", "50"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () as r, a from t1 where b > 300");
        stringArray = new String[][]{{"1", "40"}, {"2", "50"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over (), row_number() over (), b from t1 where b <= 300");
        stringArray = new String[][]{{"1", "1", "100"}, {"2", "2", "200"}, {"3", "3", "300"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over (), b, row_number() over (), a from t1 where b < 300 ");
        stringArray = new String[][]{{"1", "100", "1", "10"}, {"2", "200", "2", "20"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over(),x from t2,t3 where x=y");
        stringArray = new String[][]{{"1", "4"}, {"2", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () as r, t1.* from t1 order by b desc");
        stringArray = new String[][]{{"5", "50", "500"}, {"4", "40", "400"}, {"3", "30", "300"}, {"2", "20", "200"}, {"1", "10", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () as r, t1.a from t1 order by b desc");
        stringArray = new String[][]{{"5", "50"}, {"4", "40"}, {"3", "30"}, {"2", "20"}, {"1", "10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over (), row_number() over (), 2*t1.a from t1");
        stringArray = new String[][]{{"1", "1", "20"}, {"2", "2", "40"}, {"3", "3", "60"}, {"4", "4", "80"}, {"5", "5", "100"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select row_number() over () as r,x from t2,t3 where x=y) s(r,x) where r < 3");
        stringArray = new String[][]{{"1", "4"}, {"2", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select row_number() over () as r, t1.* from t1) as tr where r < 3");
        stringArray = new String[][]{{"1", "10", "100"}, {"2", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select row_number() over () as r, t1.* from t1) as tr where r > 3");
        stringArray = new String[][]{{"4", "40", "400"}, {"5", "50", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over(), tr.* from (select row_number() over () as r, t1.* from t1) as tr where r > 2 and r < 5");
        stringArray = new String[][]{{"1", "3", "30", "300"}, {"2", "4", "40", "400"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over(), tr.b from (select row_number() over () as r, t1.* from t1) as tr where r > 2 and r < 5");
        stringArray = new String[][]{{"1", "300"}, {"2", "400"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select t1.b, row_number() over () as r from t1) as tr where r > 3");
        stringArray = new String[][]{{"400", "4"}, {"500", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select b from (select t1.b, row_number() over () as r from t1) as tr where r > 3");
        stringArray = new String[][]{{"400"}, {"500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select count(*) from (select row_number() over() from t1) x");
        stringArray = new String[][]{{"5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select count(*) from (select row_number() over () as r from t1) as t(r) where r <=3");
        stringArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () from t1 union all select row_number() over () from t1");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select 2 * r from (select row_number() over () from t1) x(r)");
        stringArray = new String[][]{{"2"}, {"4"}, {"6"}, {"8"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t4) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t4) x2 (r2, c3, c4)");
        stringArray = new String[][]{{"100", "10", "100"}, {"200", "10", "100"}, {"100", "20", "200"}, {"200", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t4) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t4) x2 (r2, c3, c4), t4");
        stringArray = new String[][]{{"100", "10", "100"}, {"100", "10", "100"}, {"200", "10", "100"}, {"200", "10", "100"}, {"100", "20", "200"}, {"100", "20", "200"}, {"200", "20", "200"}, {"200", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t4) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t4) x2 (r2, c3, c4), t4 where x1.r1 = 2 * x2.r2");
        stringArray = new String[][]{{"100", "20", "200"}, {"100", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t4) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t4) x2 (r2, c3, c4), t4 where x1.r1 = 2 * x2.r2");
        stringArray = new String[][]{{"100", "20", "200"}, {"100", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t4) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t4) x2 (r2, c3, c4), t4 where x2.c4 = t4.a");
        stringArray = new String[][]{{"100", "10", "100"}, {"100", "20", "200"}, {"200", "10", "100"}, {"200", "20", "200"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select c3, c1, c2 from (select a, b, row_number() over() as r from t1) x1 (c1, c2, r1), (select row_number() over() as r, b, a from t1) x2 (r2, c3, c4), t1 where x1.r1 = 2 * x2.r2 and x2.c4 = t1.a");
        stringArray = new String[][]{{"100", "20", "200"}, {"200", "40", "400"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from t5 o where o.a in (select x + row_number() over () from t2)");
        stringArray = new String[][]{{"2", "4"}, {"4", "4"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("SELECT rn_t1, (     SELECT rn_t2 FROM (         SELECT row_number() over() as rn_t2 FROM t2)          as T_2         where T_2.rn_t2 = T_1.rn_t1 + 1  )      as rn_outer     FROM (SELECT row_number() over() as rn_t1 from t2) as T_1");
        stringArray = new String[][]{{"1", "2"}, {"2", "3"}, {"3", "4"}, {"4", "5"}, {"5", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select r from (select a, row_number() over() as r, b from t1) x group by r");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by a, b, r");
        stringArray = new String[][]{{"10", "1", "100"}, {"20", "2", "200"}, {"30", "3", "300"}, {"40", "4", "400"}, {"50", "5", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by b, r, a");
        stringArray = new String[][]{{"10", "1", "100"}, {"20", "2", "200"}, {"30", "3", "300"}, {"40", "4", "400"}, {"50", "5", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by b, r, a having r > 2");
        stringArray = new String[][]{{"30", "3", "300"}, {"40", "4", "400"}, {"50", "5", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by b, r, a having r > 2 and a >=30 order by a desc");
        stringArray = new String[][]{{"50", "5", "500"}, {"40", "4", "400"}, {"30", "3", "300"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by b, r, a having r > 2 and a >=30 order by r desc");
        stringArray = new String[][]{{"50", "5", "500"}, {"40", "4", "400"}, {"30", "3", "300"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select a, row_number() over() as r, b from t1) x group by b, r, a having r > 2 and a >=30 order by a asc, r desc");
        stringArray = new String[][]{{"30", "3", "300"}, {"40", "4", "400"}, {"50", "5", "500"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select distinct row_number() over (), 'ABC' from t1");
        stringArray = new String[][]{{"1", "ABC"}, {"2", "ABC"}, {"3", "ABC"}, {"4", "ABC"}, {"5", "ABC"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select distinct row_number() over (),                                'ABC' from t1) tmp");
        stringArray = new String[][]{{"1", "ABC"}, {"2", "ABC"}, {"3", "ABC"}, {"4", "ABC"}, {"5", "ABC"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select * from (select distinct row_number() over w, 'ABC' from t1 window w as ()) tmp");
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () r, a from t1 order by r desc");
        stringArray = new String[][]{{"5", "50"}, {"4", "40"}, {"3", "30"}, {"2", "20"}, {"1", "10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a from t1 order by row_number() over () desc");
        stringArray = new String[][]{{"50"}, {"40"}, {"30"}, {"20"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a, row_number() over () from t1 except select a, row_number() over () from t1");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("select abs(a), row_number() over () c from t1 where a > 30 and a <= 50 order by c desc");
        stringArray = new String[][]{{"50", "2"}, {"40", "1"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over () + 10, a from t1 order by row_number() over () desc");
        stringArray = new String[][]{{"15", "50"}, {"14", "40"}, {"13", "30"}, {"12", "20"}, {"11", "10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select a from t1 window r as () order by a desc");
        stringArray = new String[][]{{"50"}, {"40"}, {"30"}, {"20"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over r, b, sum(a) from t5 group by b window r as ()");
        stringArray = new String[][]{{"1", "1", "1"}, {"2", "4", "9"}, {"3", "9", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select row_number() over r, b, sum(a) from t5 group by b window r as ()");
        stringArray = new String[][]{{"1", "1", "1"}, {"2", "4", "9"}, {"3", "9", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("select b, sum(a) from t5 group by b window r as ()");
        stringArray = new String[][]{{"1", "1"}, {"4", "9"}, {"9", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = statement.executeQuery("SELECT * FROM t2 WHERE EXISTS (SELECT ROW_NUMBER() OVER () FROM t5)");
        stringArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        OLAPTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select row_number() as r, * from t1 where t1.a > 2");
        OLAPTest.assertStatementError(LANG_COLUMN_NOT_FOUND, statement, "select row_number() over () as r, a from t1 where r < 3");
        OLAPTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select row_number() over () as r, * from t1 where t1.a > 2");
        OLAPTest.assertStatementError(NOT_IMPLEMENTED, statement, "select row_number() over (order by i) as r from t1");
        OLAPTest.assertStatementError(NOT_IMPLEMENTED, statement, "select max(i) over () from t1");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "select * from t4 where row_number() over () > 3");
        resultSet = statement.executeQuery("select * from t2 where x in      (select row_number() over () from t4)");
        stringArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "select * from t4 group by row_number() over ()");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "select * from t4 group by a having b = row_number() over ()");
        resultSet = statement.executeQuery("select sum(a) from t5 group by b    having b = (select row_number() over () + 3                    from t5 where a=1)");
        stringArray = new String[][]{{"9"}};
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "values row_number() over ()");
        resultSet = statement.executeQuery("values 3 + (select row_number() over () from t2 where x=1)");
        stringArray = new String[][]{{"4"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "select sum(row_number() over ()) from t4");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "select * from t4 t_1 join t4 t_2 on                      t_1.a = row_number() over () + t_2.a");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "update t3 set y = y - row_number() over ()");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3"), new String[][]{{"4"}, {"5"}, {"6"}, {"7"}, {"8"}});
        statement.executeUpdate("update t3 set y = y -     (select y from t3 order by row_number() over ()      fetch first 1 row only)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3"), new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}});
        JDBC.assertFullResultSet(statement.executeQuery("select * from      (select y from t3 order by row_number() over ()      fetch first 1 row only) tt"), new String[][]{{"0"}});
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 where y =     (select y from t3 order by row_number() over ()      fetch first row only)"), new String[][]{{"0"}});
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "merge into t2 using t3 on (t2.x=t3.y) when not matched then     insert values (row_number() over ())");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "call syscs_util.syscs_compress_table(    'APP', 'T2', row_number() over ())");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "create table t (x int generated always as     (row_number() over ()))");
        OLAPTest.assertStatementError(LANG_WINDOW_FUNCTION_CONTEXT_ERROR, statement, "alter table t2 add column foo int generated always as     (row_number() over ())");
    }

    public void testMetaData() throws SQLException {
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select row_number() over () from sys.systables");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        OLAPTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(1));
    }

    private String makeString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('a');
        }
        return stringBuffer.toString();
    }

    public void testGroupByRollup() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table ru (a int, b int, c int, d int)");
        statement.executeUpdate("insert into ru values (1,1,1,1), (1,2,3,4),(1,1,2,2), (4,3,2,1), (4,4,4,4)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select a,b,c,sum(d) from ru group by rollup(a,b,c)"), new String[][]{{"1", "1", "1", "1"}, {"1", "1", "2", "2"}, {"1", "2", "3", "4"}, {"4", "3", "2", "1"}, {"4", "4", "4", "4"}, {"1", "1", null, "3"}, {"1", "2", null, "4"}, {"4", "3", null, "1"}, {"4", "4", null, "4"}, {"1", null, null, "7"}, {"4", null, null, "5"}, {null, null, null, "12"}});
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from ru group by mod(a,b)"), new String[][]{{"3"}, {"2"}});
        OLAPTest.assertStatementError(LANG_COLUMN_NOT_FOUND, statement, "select a,b,c,sum(d) from ru group by rollup");
        OLAPTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select a,b,c,sum(d) from ru group by rollup(");
        OLAPTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select a,b,c,sum(d) from ru group by rollup)");
        OLAPTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "select a,b,c,sum(d) from ru group by rollup()");
        statement.executeUpdate("drop table ru");
        statement.close();
    }

    public void testRollupReservedWord() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t_roll(rollup int, x int)");
        JDBC.assertEmpty(statement.executeQuery("select rollup, sum(x) from t_roll group by rollup"));
        JDBC.assertEmpty(statement.executeQuery("select count(*) from t_roll group by mod(rollup,x)"));
        JDBC.assertEmpty(statement.executeQuery("select count(*) from t_roll group by mod(x,rollup)"));
        statement.executeUpdate("create table rollup(a int, x int)");
        JDBC.assertEmpty(statement.executeQuery("select a, x from rollup"));
        statement.executeUpdate("insert into rollup(a,x) values(1,2)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select a,sum(x) from rollup group by rollup(a)"), new String[][]{{"1", "2"}, {null, "2"}});
        statement.executeUpdate("drop table rollup");
        statement.executeUpdate("drop table t_roll");
        statement.close();
    }

    public void testRollupColumnNullability() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t_notnull(a int not null, b int,                       c int not null, d int)");
        ResultSet resultSet = statement.executeQuery("select a,b,c,sum(d) from t_notnull group by rollup(a,b,c)");
        JDBC.assertNullability(resultSet, new boolean[]{true, true, true, true});
        resultSet.close();
        resultSet = statement.executeQuery("select 1,2,3,sum(d) from t_notnull group by rollup(1,2,3)");
        JDBC.assertNullability(resultSet, new boolean[]{true, true, true, true});
        resultSet.close();
        statement.executeUpdate("drop table t_notnull");
        statement.close();
    }

    public void testRollupEmptyTables() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table ru (a int, b int, c int, d int)");
        JDBC.assertEmpty(statement.executeQuery("select sum(a) from ru group by b"));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select sum(a) from ru"), null);
        statement.executeUpdate("insert into ru values (1,1,1,1), (1,2,3,4),(1,1,2,2), (4,3,2,1), (4,4,4,4)");
        JDBC.assertEmpty(statement.executeQuery("select b, sum(a) from ru where 1<>1 group by rollup(b)"));
        statement.executeUpdate("drop table ru");
        statement.close();
    }

    public void testRollupNullabilityCasts() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(c varchar(2) not null,c2 varchar(2), i integer)");
        statement.executeUpdate("insert into t values('aa',null,null)");
        statement.executeUpdate("insert into t values('bb',null,null)");
        String[][] stringArray = new String[][]{{"aa", null, null}, {"aa", null, null}, {null, null, null}, {"bb", null, null}, {"bb", null, null}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c,c2,sum(i) from t group by rollup(c,c2)"), stringArray);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select cast(c as varchar(2)),c2,sum(i) from t group by rollup(c,c2)"), stringArray);
        statement.executeUpdate("drop table t");
        statement.close();
    }

    public void testRollupOfCoveringIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table ru (a int,b int,c int,d varchar(1000))");
        statement.executeUpdate("create index ru_idx on ru(a,b,c)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into ru (a,b,c,d) values (?,?,?,?)");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, i % 5);
            preparedStatement.setInt(2, 2 * i);
            preparedStatement.setInt(3, 100 + i);
            preparedStatement.setString(4, this.makeString(900));
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        statement.executeUpdate("drop table ru");
        statement.close();
    }

    private void dumpIt(Statement statement, int n, String string) throws SQLException {
        System.out.println(string);
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(resultSet.getString(i));
            }
            System.out.println(stringBuffer.toString());
        }
        resultSet.close();
    }

    public void testGroupByWithAndWithoutRollup() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table orders(order_id int primary key,   customer varchar(10),   order_date date,    shipping int)");
        statement.executeUpdate("create table order_items(item_id int primary key,   order_id int,   order_item varchar(10),    cost int)");
        statement.executeUpdate("create table customers(customer varchar(10) primary key,   name varchar(100), city varchar(100), state varchar(2))");
        statement.executeUpdate("insert into customers values ('ABC','ABC Corporation','ABC City', 'AB'),('DEF','DEF, Inc.', 'DEFburg', 'DE')");
        statement.executeUpdate("insert into orders values(1,'ABC','2009-01-01',40)");
        statement.executeUpdate("insert into orders values(2,'ABC','2009-01-02',30)");
        statement.executeUpdate("insert into orders values(3,'ABC','2009-01-03',25)");
        statement.executeUpdate("insert into orders values(4,'DEF','2009-01-02',10)");
        statement.executeUpdate("insert into order_items values(1,1,'Item A',100)");
        statement.executeUpdate("insert into order_items values(2,1,'Item B',150)");
        statement.executeUpdate("insert into order_items values(3,2,'Item C',125)");
        statement.executeUpdate("insert into order_items values(4,2,'Item B',50)");
        statement.executeUpdate("insert into order_items values(5,2,'Item H',200)");
        statement.executeUpdate("insert into order_items values(6,3,'Item X',100)");
        statement.executeUpdate("insert into order_items values(7,4,'Item Y',50)");
        statement.executeUpdate("insert into order_items values(8,4,'Item Z',300)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.order_id, o.customer, o.order_date, o.shipping, od.item_id, od.order_item, od.cost  from orders o inner join order_items od  on o.order_id = od.order_id"), new String[][]{{"1", "ABC", "2009-01-01", "40", "1", "Item A", "100"}, {"1", "ABC", "2009-01-01", "40", "2", "Item B", "150"}, {"2", "ABC", "2009-01-02", "30", "3", "Item C", "125"}, {"2", "ABC", "2009-01-02", "30", "4", "Item B", "50"}, {"2", "ABC", "2009-01-02", "30", "5", "Item H", "200"}, {"3", "ABC", "2009-01-03", "25", "6", "Item X", "100"}, {"4", "DEF", "2009-01-02", "10", "7", "Item Y", "50"}, {"4", "DEF", "2009-01-02", "10", "8", "Item Z", "300"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6"}, {"DEF", "2"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6", "725"}, {"DEF", "2", "350"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total  from orders o inner join order_items od       on o.order_id = od.order_id  group by ROLLUP(o.customer)"), new String[][]{{"ABC", "6", "725"}, {"DEF", "2", "350"}, {null, "8", "1075"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        count(distinct o.order_id) as orders_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6", "3"}, {"DEF", "2", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        count(distinct o.order_id) as orders_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by ROLLUP(o.customer)"), new String[][]{{"ABC", "6", "3"}, {"DEF", "2", "1"}, {null, "8", "4"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total,        count(distinct o.order_id) as orders_per_customer,        sum(o.shipping) as shipping_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6", "725", "3", "195"}, {"DEF", "2", "350", "1", "20"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total,        count(distinct o.order_id) as orders_per_customer,        sum(o.shipping) as shipping_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by ROLLUP(o.customer)"), new String[][]{{"ABC", "6", "725", "3", "195"}, {"DEF", "2", "350", "1", "20"}, {null, "8", "1075", "4", "215"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total,        count(distinct o.order_id) as orders_per_customer,        sum(distinct o.shipping) as shipping_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6", "725", "3", "95"}, {"DEF", "2", "350", "1", "10"}});
        statement.executeUpdate("insert into orders values(5,'DEF','2009-01-04',10)");
        statement.executeUpdate("insert into order_items values(9,5,'Item J',125)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total,        count(distinct o.order_id) as orders_per_customer,        sum(distinct o.shipping) as shipping_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by o.customer"), new String[][]{{"ABC", "6", "725", "3", "95"}, {"DEF", "3", "475", "2", "10"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.Customer, count(*) as items_per_customer,        sum(od.cost) as order_total,        count(distinct o.order_id) as orders_per_customer,        sum(distinct o.shipping) as shipping_per_customer  from orders o inner join order_items od       on o.order_id = od.order_id  group by ROLLUP(o.customer)"), new String[][]{{"ABC", "6", "725", "3", "95"}, {"DEF", "3", "475", "2", "10"}, {null, "9", "1200", "5", "105"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select order_id, count(*) as Items_per_order,        sum(cost) as Order_total  from order_items  group by order_id"), new String[][]{{"1", "2", "250"}, {"2", "3", "375"}, {"3", "1", "100"}, {"4", "2", "350"}, {"5", "1", "125"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select order_id, count(*) as Items_per_order,        sum(cost) as Order_total  from order_items  group by ROLLUP(order_id)"), new String[][]{{"1", "2", "250"}, {"2", "3", "375"}, {"3", "1", "100"}, {"4", "2", "350"}, {"5", "1", "125"}, {null, "9", "1200"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.order_id, o.Customer, o.Shipping,        d.items_per_order, d.order_total  from orders o inner join (   select order_id, count(*) as Items_per_order,           sum(cost) as Order_total     from order_items     group by order_id    ) d on o.order_id = d.order_id"), new String[][]{{"1", "ABC", "40", "2", "250"}, {"2", "ABC", "30", "3", "375"}, {"3", "ABC", "25", "1", "100"}, {"4", "DEF", "10", "2", "350"}, {"5", "DEF", "10", "1", "125"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.customer, count(*) as orders_per_customer,        sum(o.shipping) as shipping_per_customer,        sum(d.items_per_order) as items_per_customer,        sum(d.order_total) as total_per_customer  from orders o inner join (   select order_id, count(*) as Items_per_order,           sum(cost) as Order_total     from order_items     group by order_id    ) d on o.order_id = d.order_id  group by o.customer"), new String[][]{{"ABC", "3", "95", "6", "725"}, {"DEF", "2", "20", "3", "475"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.customer, count(*) as orders_per_customer,        sum(o.shipping) as shipping_per_customer,        sum(d.items_per_order) as items_per_customer,        sum(d.order_total) as total_per_customer  from orders o inner join (   select order_id, count(*) as Items_per_order,           sum(cost) as Order_total     from order_items     group by order_id    ) d on o.order_id = d.order_id  group by ROLLUP(o.customer)"), new String[][]{{"ABC", "3", "95", "6", "725"}, {"DEF", "2", "20", "3", "475"}, {null, "5", "115", "9", "1200"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select o.customer, c.name, c.city, c.state,        count(*) as orders_per_customer,        sum(o.shipping) as shipping_per_customer,        sum(d.items_per_order) as items_per_customer,        sum(d.order_total) as total_per_customer  from orders o inner join (   select order_id, count(*) as Items_per_order,           sum(cost) as Order_total     from order_items     group by order_id    ) d on o.order_id = d.order_id    inner join customers c on o.customer = c.customer  group by ROLLUP(o.customer,c.name, c.city,c.state)"), new String[][]{{"ABC", "ABC Corporation", "ABC City", "AB", "3", "95", "6", "725"}, {"DEF", "DEF, Inc.", "DEFburg", "DE", "2", "20", "3", "475"}, {"ABC", "ABC Corporation", "ABC City", null, "3", "95", "6", "725"}, {"DEF", "DEF, Inc.", "DEFburg", null, "2", "20", "3", "475"}, {"ABC", "ABC Corporation", null, null, "3", "95", "6", "725"}, {"DEF", "DEF, Inc.", null, null, "2", "20", "3", "475"}, {"ABC", null, null, null, "3", "95", "6", "725"}, {"DEF", null, null, null, "2", "20", "3", "475"}, {null, null, null, null, "5", "115", "9", "1200"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c.customer, c.name, c.city, c.state,        o.orders_per_customer, o.shipping_per_customer,        o.items_per_customer, o.total_per_customer  from (    select o.customer, count(*) as orders_per_customer,           sum(o.shipping) as shipping_per_customer,           sum(d.items_per_order) as items_per_customer,           sum(d.order_total) as total_per_customer     from orders o inner join (      select order_id, count(*) as Items_per_order,              sum(cost) as Order_total        from order_items        group by order_id       ) d on o.order_id = d.order_id     group by o.customer) o   inner join customers c on o.customer = c.customer"), new String[][]{{"ABC", "ABC Corporation", "ABC City", "AB", "3", "95", "6", "725"}, {"DEF", "DEF, Inc.", "DEFburg", "DE", "2", "20", "3", "475"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c.customer, c.name, c.city, c.state,        o.orders_per_customer, o.shipping_per_customer,        o.items_per_customer, o.total_per_customer  from (    select o.customer, count(*) as orders_per_customer,           sum(o.shipping) as shipping_per_customer,           sum(d.items_per_order) as items_per_customer,           sum(d.order_total) as total_per_customer     from orders o inner join (      select order_id, count(*) as Items_per_order,              sum(cost) as Order_total        from order_items        group by order_id       ) d on o.order_id = d.order_id     group by ROLLUP(o.customer)) o   left outer join customers c on o.customer = c.customer"), new String[][]{{"ABC", "ABC Corporation", "ABC City", "AB", "3", "95", "6", "725"}, {"DEF", "DEF, Inc.", "DEFburg", "DE", "2", "20", "3", "475"}, {null, null, null, null, "5", "115", "9", "1200"}});
        statement.close();
    }
}

