/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RawDBReaderTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO"};
    private static final String MEMORY_DB = "jdbc:derby:memory:rrt";
    private static final String RECOVERY_SCRIPT = "extinout/recovery.sql";
    private static final String BOOT_PASSWORD = "fooBarWibble";
    private static final String LIST_USER_SCHEMAS = "select schemaname from sys.sysschemas\nwhere schemaname not like 'SYS%'\nand schemaname != 'APP'\nand schemaname != 'NULLID'\nand schemaname != 'SQLJ'\norder by schemaname\n";
    private static final String LIST_USER_TABLES = "select tablename from sys.systables\nwhere tablename not like 'SYS%'\norder by tablename\n";
    private static final String[][] NO_ROWS = new String[0][];
    private static final String[][] EXPECTED_SCHEMAS = new String[][]{{"CONTROL11"}, {"RAW11_APP"}, {"RAW11_SCHEMA1"}, {"RAW11_SCHEMA2"}};
    private static final String[][] EXPECTED_TABLES = new String[][]{{"T1"}, {"T1"}, {"T2"}, {"T2"}};
    private File _dbDir;

    public RawDBReaderTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test;
        Test test2 = test = TestConfiguration.embeddedSuite(RawDBReaderTest.class);
        Test test3 = DatabasePropertyTestSetup.builtinAuthenticationNoTeardown(test2, LEGAL_USERS, "RRT");
        Test test4 = TestConfiguration.sqlAuthorizationDecorator(test3);
        Test test5 = Decorator.encryptedDatabaseBpw(test4, "DES/CBC/NoPadding", BOOT_PASSWORD);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup(test5);
        return supportFilesSetup;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._dbDir != null) {
            RawDBReaderTest.assertDirectoryDeleted(this._dbDir);
            this._dbDir = null;
        }
    }

    public void test_001_rawDBReader() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.populateCorruptDB(connection);
        TestConfiguration testConfiguration = this.getTestConfiguration();
        testConfiguration.shutdownDatabase();
        String string = testConfiguration.getDefaultDatabaseName();
        File file = new File("system");
        this._dbDir = new File(file, string);
        String string2 = this._dbDir.getPath();
        Connection connection2 = DriverManager.getConnection("jdbc:derby:memory:rrt;create=true");
        this.vetUnloaded(connection2);
        String string3 = testConfiguration.getPassword(TEST_DBO);
        this.goodStatement(connection2, "call syscs_util.syscs_register_tool\n(\n  'rawDBReader',\n  true,\n  'extinout/recovery.sql',\n  'CONTROL11',\n  'RAW11_',\n  '" + string2 + "',\n  'bootPassword=fooBarWibble',\n  'TEST_DBO',\n  '" + string3 + "'\n)\n");
        this.vetLoaded(connection2);
        this.runRecoveryScript(connection2);
        this.vetSiphoning(connection2);
        this.dropSiphonedData(connection2);
        this.goodStatement(connection2, "call syscs_util.syscs_register_tool\n(\n  'rawDBReader',\n  false,\n  'CONTROL11',\n  'RAW11_'\n)\n");
        this.vetUnloaded(connection2);
        this.shutdownInMemoryDB();
    }

    private void populateCorruptDB(Connection connection) throws Exception {
        this.goodStatement(connection, "create schema schema1");
        this.goodStatement(connection, "create schema schema2");
        this.goodStatement(connection, "create table schema1.t1( id int, tag varchar( 20 ) )");
        this.goodStatement(connection, "insert into schema1.t1 values ( 1, 'schema1.t1:1' ), ( 2, 'schema1.t1:2' )");
        this.goodStatement(connection, "create table schema1.t2( id int, tag varchar( 20 ) )");
        this.goodStatement(connection, "insert into schema1.t2 values ( 1, 'schema1.t2:1' ), ( 2, 'schema1.t2:2' )");
        this.goodStatement(connection, "create table schema2.t1( id int, tag varchar( 20 ) )");
        this.goodStatement(connection, "insert into schema2.t1 values ( 1, 'schema2.t1:1' ), ( 2, 'schema2.t1:2' )");
        this.goodStatement(connection, "create table schema2.t2( id int, tag varchar( 20 ) )");
        this.goodStatement(connection, "insert into schema2.t2 values ( 1, 'schema2.t2:1' ), ( 2, 'schema2.t2:2' )");
    }

    private void shutdownInMemoryDB() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:memory:rrt;shutdown=true");
        }
        catch (SQLException sQLException) {
            RawDBReaderTest.assertSQLState("08006", sQLException);
        }
        try {
            DriverManager.getConnection("jdbc:derby:memory:rrt;drop=true");
        }
        catch (SQLException sQLException) {
            RawDBReaderTest.assertSQLState("08006", sQLException);
        }
    }

    private void runRecoveryScript(Connection connection) throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(RECOVERY_SCRIPT));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || string.startsWith("connect") || string.startsWith("--")) continue;
                string = string.substring(0, string.indexOf(59));
                this.goodStatement(connection, string);
            }
        }
    }

    private void vetSiphoning(Connection connection) throws Exception {
        this.assertResults(connection, "select * from schema1.t1 order by id", new String[][]{{"1", "schema1.t1:1"}, {"2", "schema1.t1:2"}}, false);
        this.assertResults(connection, "select * from schema1.t2 order by id", new String[][]{{"1", "schema1.t2:1"}, {"2", "schema1.t2:2"}}, false);
        this.assertResults(connection, "select * from schema2.t1 order by id", new String[][]{{"1", "schema2.t1:1"}, {"2", "schema2.t1:2"}}, false);
        this.assertResults(connection, "select * from schema2.t2 order by id", new String[][]{{"1", "schema2.t2:1"}, {"2", "schema2.t2:2"}}, false);
    }

    private void vetUnloaded(Connection connection) throws Exception {
        this.assertResults(connection, LIST_USER_SCHEMAS, NO_ROWS, false);
        this.assertResults(connection, LIST_USER_TABLES, NO_ROWS, false);
    }

    private void vetLoaded(Connection connection) throws Exception {
        this.assertResults(connection, LIST_USER_SCHEMAS, EXPECTED_SCHEMAS, false);
        this.assertResults(connection, LIST_USER_TABLES, EXPECTED_TABLES, false);
    }

    private void dropSiphonedData(Connection connection) throws Exception {
        this.goodStatement(connection, "drop table schema1.t1");
        this.goodStatement(connection, "drop table schema1.t2");
        this.goodStatement(connection, "drop table schema2.t1");
        this.goodStatement(connection, "drop table schema2.t2");
        this.goodStatement(connection, "drop schema schema1 restrict");
        this.goodStatement(connection, "drop schema schema2 restrict");
    }
}

