/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class SpillHashTest
extends BaseJDBCTestCase {
    private static final String[] prep = new String[]{"create table ta (ca1 integer, ca2 char(200))", "create table tb (cb1 integer, cb2 char(200))", "insert into ta(ca1,ca2) values(null, 'Anull')", "insert into tb(cb1,cb2) values(null, 'Bnull')"};
    private static final String[][] initDupVals = new String[][]{{"0a", "0b"}, {"1a", "1b"}, {"2a"}};
    private static final String[][] spillDupVals = new String[][]{new String[0], {"1c"}, {"2b"}, {"3a", "3b", "3c"}};
    private static final int LOTS_OF_ROWS = 10000;
    private PreparedStatement joinStmt;
    private PreparedStatement distinctStmt;

    public SpillHashTest(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        BaseTestSuite baseTestSuite2 = new BaseTestSuite();
        baseTestSuite.addTest((Test)new SpillHashTest("testJoinLight"));
        baseTestSuite.addTest((Test)new SpillHashTest("testDistinctLight"));
        baseTestSuite.addTest((Test)new SpillHashTest("testCursorLight"));
        baseTestSuite2.addTest((Test)new SpillHashTest("testJoinHeavy"));
        baseTestSuite2.addTest((Test)new SpillHashTest("testDistinctHeavy"));
        baseTestSuite2.addTest((Test)new SpillHashTest("testCursorHeavy"));
        BaseJDBCTestSetup baseJDBCTestSetup = new BaseJDBCTestSetup((Test)baseTestSuite){

            protected void setUp() throws Exception {
                super.setUp();
                Statement statement = this.getConnection().createStatement();
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into ta(ca1,ca2) values(?,?)");
                PreparedStatement preparedStatement2 = statement.getConnection().prepareStatement("insert into tb(cb1,cb2) values(?,?)");
                SpillHashTest.insertDups(preparedStatement, preparedStatement2, initDupVals);
                this.getConnection().commit();
                statement.close();
            }
        };
        BaseJDBCTestSetup baseJDBCTestSetup2 = new BaseJDBCTestSetup((Test)baseTestSuite2){

            protected void setUp() throws Exception {
                super.setUp();
                Statement statement = this.getConnection().createStatement();
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into ta(ca1,ca2) values(?,?)");
                PreparedStatement preparedStatement2 = statement.getConnection().prepareStatement("insert into tb(cb1,cb2) values(?,?)");
                for (int i = 1; i <= 10000; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.setString(2, SpillHashTest.ca2Val(i));
                    preparedStatement.executeUpdate();
                    preparedStatement2.setInt(1, i);
                    preparedStatement2.setString(2, SpillHashTest.cb2Val(i));
                    preparedStatement2.executeUpdate();
                    if ((i & 0xFF) != 0) continue;
                    statement.getConnection().commit();
                }
                SpillHashTest.insertDups(preparedStatement, preparedStatement2, spillDupVals);
                this.getConnection().commit();
                statement.close();
            }
        };
        BaseTestSuite baseTestSuite3 = new BaseTestSuite();
        baseTestSuite3.addTest((Test)baseJDBCTestSetup);
        baseTestSuite3.addTest((Test)baseJDBCTestSetup2);
        return new CleanDatabaseTestSetup((Test)baseTestSuite3){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                for (int i = 0; i < prep.length; ++i) {
                    statement.executeUpdate(prep[i]);
                }
            }
        };
    }

    protected void setUp() throws Exception {
        this.joinStmt = this.getConnection().prepareStatement("select ta.ca1, ta.ca2, tb.cb2 from ta, tb where ca1 = cb1");
        this.distinctStmt = this.getConnection().prepareStatement("select distinct ca1 from ta");
    }

    @Override
    protected void tearDown() throws Exception {
        this.joinStmt.close();
        this.distinctStmt.close();
        this.joinStmt = null;
        this.distinctStmt = null;
        super.tearDown();
    }

    public void testJoinLight() throws SQLException {
        this.runJoin(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testDistinctLight() throws SQLException {
        this.runDistinct(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testCursorLight() throws SQLException {
        SpillHashTest.runCursor(this.getConnection(), 0, new String[][][]{initDupVals});
    }

    public void testJoinHeavy() throws SQLException {
        this.runJoin(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    public void testDistinctHeavy() throws SQLException {
        this.runDistinct(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    public void testCursorHeavy() throws SQLException {
        SpillHashTest.runCursor(this.getConnection(), 10000, new String[][][]{initDupVals, spillDupVals});
    }

    private static void insertDups(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, String[][] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setInt(1, -i);
            preparedStatement2.setInt(1, -i);
            String[] stringArray2 = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                preparedStatement.setString(2, "A" + stringArray2[j]);
                preparedStatement.executeUpdate();
                preparedStatement2.setString(2, "B" + stringArray2[j]);
                preparedStatement2.executeUpdate();
            }
        }
    }

    private static String ca2Val(int n) {
        return "A" + n;
    }

    private static String cb2Val(int n) {
        return "B" + n;
    }

    private void runJoin(Connection connection, int n, String[][][] stringArray) throws SQLException {
        int n2;
        int n3;
        int n4 = n;
        ResultSet resultSet = this.joinStmt.executeQuery();
        BitSet bitSet = new BitSet(n);
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length <= n5) continue;
            n5 = stringArray[i].length;
        }
        BitSet[] bitSetArray = new BitSet[n5];
        int[] nArray = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (n3 >= stringArray[n2].length) continue;
                int n6 = n3;
                nArray[n6] = nArray[n6] + stringArray[n2][n3].length;
            }
            bitSetArray[n3] = new BitSet(nArray[n3] * nArray[n3]);
            n4 += nArray[n3] * nArray[n3];
        }
        n3 = 0;
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            SpillHashTest.assertFalse((String)"Null in join column.", (boolean)resultSet.wasNull());
            SpillHashTest.assertFalse((String)"Invalid value in first join column.", (n2 > n ? 1 : 0) != 0);
            if (n2 > 0) {
                SpillHashTest.assertFalse((String)("Multiple rows for value " + n2), (boolean)bitSet.get(n2 - 1));
                bitSet.set(n2 - 1);
                String string = SpillHashTest.trim(resultSet.getString(2));
                String string2 = SpillHashTest.trim(resultSet.getString(3));
                SpillHashTest.assertFalse((String)"Incorrect value in column 2 or 3 of join.", (!SpillHashTest.ca2Val(n2).equals(string) || !SpillHashTest.cb2Val(n2).equals(string2) ? 1 : 0) != 0);
            } else {
                int n7 = -n2;
                int n8 = SpillHashTest.findDupVal(resultSet, 2, 'A', n7, stringArray);
                int n9 = SpillHashTest.findDupVal(resultSet, 3, 'B', n7, stringArray);
                if (n8 >= 0 && n9 >= 0) {
                    int n10 = n8 + nArray[n7] * n9;
                    SpillHashTest.assertFalse((String)"Repeat of row with key value 0", (boolean)bitSetArray[n7].get(n10));
                    bitSetArray[n7].set(n10);
                }
            }
            ++n3;
        }
        SpillHashTest.assertEquals((String)"Incorrect number of rows in join.", (int)n4, (int)n3);
        resultSet.close();
    }

    private static int findDupVal(ResultSet resultSet, int n, char c, int n2, String[][][] stringArray) throws SQLException {
        String string = resultSet.getString(n);
        if (string != null && string.length() > 1 || string.charAt(0) == c) {
            string = SpillHashTest.trim(string.substring(1));
            int n3 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (n2 >= stringArray[i].length) continue;
                int n4 = 0;
                while (n4 < stringArray[i][n2].length) {
                    if (string.equals(stringArray[i][n2][n4])) {
                        return n3;
                    }
                    ++n4;
                    ++n3;
                }
            }
        }
        SpillHashTest.fail((String)("Incorrect value in column " + n + " of join with duplicate keys."));
        return -1;
    }

    private static String trim(String string) {
        if (string == null) {
            return string;
        }
        return string.trim();
    }

    private void runDistinct(Connection connection, int n, String[][][] stringArray) throws SQLException {
        ResultSet resultSet = this.distinctStmt.executeQuery();
        SpillHashTest.checkAllCa1(resultSet, false, false, n, stringArray, "DISTINCT");
        resultSet.close();
    }

    private static void runCursor(Connection connection, int n, String[][][] stringArray) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        boolean bl = databaseMetaData.supportsOpenCursorsAcrossCommit();
        Statement statement = bl ? connection.createStatement(1004, 1007, 1) : connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT ca1 FROM ta");
        SpillHashTest.checkAllCa1(resultSet, true, bl, n, stringArray, "scroll insensitive cursor");
        resultSet.close();
    }

    private static void checkAllCa1(ResultSet resultSet, boolean bl, boolean bl2, int n, String[][][] stringArray, String string) throws SQLException {
        int n2;
        int n3;
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length <= n4) continue;
            n4 = stringArray[i].length;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = 0;
            if (!bl) {
                nArray[i] = 1;
                continue;
            }
            nArray[i] = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (i >= stringArray[n3].length) continue;
                int n5 = i;
                nArray[n5] = nArray[n5] + stringArray[n3][i].length;
            }
        }
        BitSet bitSet = new BitSet(n);
        n3 = 0;
        boolean bl3 = false;
        n3 = 0;
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            if (resultSet.wasNull()) {
                if (bl3) {
                    SpillHashTest.fail((String)("Too many nulls returned by " + string));
                }
                bl3 = true;
                continue;
            }
            SpillHashTest.assertFalse((String)("Invalid value returned by " + string), (n2 <= -n4 || n2 > n ? 1 : 0) != 0);
            if (n2 <= 0) {
                int n6 = -n2;
                nArray2[n6] = nArray2[n6] + 1;
                if (!bl) {
                    SpillHashTest.assertFalse((String)(string + " returned a duplicate."), (nArray2[-n2] > 1 ? 1 : 0) != 0);
                } else {
                    SpillHashTest.assertFalse((String)(string + " returned too many duplicates."), (nArray2[-n2] > nArray[-n2] ? 1 : 0) != 0);
                }
            } else {
                SpillHashTest.assertFalse((String)(string + " returned a duplicate."), (boolean)bitSet.get(n2));
                bitSet.set(n2);
                ++n3;
            }
            if (!bl2) continue;
            resultSet.getStatement().getConnection().commit();
            bl2 = false;
        }
        SpillHashTest.assertFalse((String)("Incorrect number of rows in " + string), (n3 != n ? 1 : 0) != 0);
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            SpillHashTest.assertFalse((String)("A duplicate key row is missing in " + string), (nArray2[n2] != nArray[n2] ? 1 : 0) != 0);
        }
    }
}

