/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5937SlaveShutdownTest
extends BaseJDBCTestCase {
    private static final String MASTER_DB = "d5937-master-db";
    private static final String SLAVE_DB = "d5937-slave-db";
    private static final String FAILOVER_SUCCESS = "XRE20";
    private static final String DB_SHUTDOWN_SUCCESS = "08006";
    private static final long RETRY_INTERVAL = 50L;

    public Derby5937SlaveShutdownTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (BaseTestCase.isJ9Platform()) {
            BaseTestSuite baseTestSuite = new BaseTestSuite("Derby5937SlaveShutdownTest");
            return baseTestSuite;
        }
        Class<Derby5937SlaveShutdownTest> clazz = Derby5937SlaveShutdownTest.class;
        return TestConfiguration.singleUseDatabaseDecorator(TestConfiguration.embeddedSuite(clazz), MASTER_DB);
    }

    public void testSlaveFailoverLeak() throws Exception {
        this.getConnection().close();
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        testConfiguration.shutdownDatabase();
        String string = testConfiguration.getDatabasePath(MASTER_DB);
        String string2 = testConfiguration.getDatabasePath(SLAVE_DB);
        PrivilegedFileOpsForTests.copy(new File(string), new File(string2));
        DataSource dataSource = JDBCDataSource.getDataSource(SLAVE_DB);
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "startSlave=true;slaveHost=" + testConfiguration.getHostName() + ";slavePort=" + testConfiguration.getPort());
        SlaveThread slaveThread = new SlaveThread(this, dataSource);
        slaveThread.start();
        DataSource dataSource2 = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource2, "connectionAttributes", "startMaster=true;slaveHost=" + testConfiguration.getHostName() + ";slavePort=" + testConfiguration.getPort());
        long l = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        Connection connection = null;
        while (connection == null) {
            try {
                connection = dataSource2.getConnection();
            }
            catch (SQLException sQLException) {
                slaveThread.checkError();
                if (System.currentTimeMillis() > l) {
                    Derby5937SlaveShutdownTest.fail("Master won't start", sQLException);
                    continue;
                }
                Derby5937SlaveShutdownTest.println("Retrying after startMaster failed with: " + String.valueOf(sQLException));
                Thread.sleep(50L);
            }
        }
        connection.close();
        slaveThread.join();
        slaveThread.checkError();
        DataSource dataSource3 = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource3, "connectionAttributes", "failover=true");
        try {
            dataSource3.getConnection();
            Derby5937SlaveShutdownTest.fail((String)"failover should receive exception");
        }
        catch (SQLException sQLException) {
            Derby5937SlaveShutdownTest.assertSQLState(FAILOVER_SUCCESS, sQLException);
        }
        l = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        DataSource dataSource4 = JDBCDataSource.getDataSource(SLAVE_DB);
        JDBCDataSource.setBeanProperty(dataSource4, "shutdownDatabase", "shutdown");
        while (true) {
            try {
                while (true) {
                    dataSource4.getConnection();
                    Derby5937SlaveShutdownTest.fail((String)"Shutdown of slave database didn't throw an exception");
                }
            }
            catch (SQLException sQLException) {
                if (!DB_SHUTDOWN_SUCCESS.equals(sQLException.getSQLState())) {
                    if (System.currentTimeMillis() > l) {
                        Derby5937SlaveShutdownTest.fail("Could not shut down slave database", sQLException);
                        continue;
                    }
                    Derby5937SlaveShutdownTest.println("Retrying after failover failed with: " + String.valueOf(sQLException));
                    Thread.sleep(50L);
                    continue;
                }
                Derby5937SlaveShutdownTest.assertDirectoryDeleted(new File(string2));
                return;
            }
            break;
        }
    }

    private class SlaveThread
    extends Thread {
        private final DataSource ds;
        private volatile Throwable error;

        SlaveThread(Derby5937SlaveShutdownTest derby5937SlaveShutdownTest, DataSource dataSource) {
            this.ds = dataSource;
        }

        @Override
        public void run() {
            try {
                this.run_();
            }
            catch (Throwable throwable) {
                this.error = throwable;
            }
        }

        private void run_() throws Exception {
            BaseTestCase.println("Slave thread started.");
            try {
                this.ds.getConnection();
                Assert.fail((String)"startSlave should throw exception");
            }
            catch (SQLException sQLException) {
                BaseJDBCTestCase.assertSQLState("XRE08", sQLException);
            }
        }

        void checkError() {
            if (this.error != null) {
                BaseTestCase.fail("Slave thread failed", this.error);
            }
        }
    }
}

