/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.Runner;

public class SequenceGeneratorConcurrency {
    public static String makeSequenceName(int n) {
        return "seq_" + n;
    }

    public static String makeTableName(int n, int n2) {
        return "t_" + n + "_" + n2;
    }

    public static PreparedStatement prepareStatement(Connection connection, boolean bl, String string) throws SQLException {
        if (bl) {
            SequenceGeneratorConcurrency.debugPrint(string);
        }
        return connection.prepareStatement(string);
    }

    public static void debugPrint(String string) {
        SequenceGeneratorConcurrency.print("DEBUG: " + string);
    }

    public static void print(String string) {
        System.out.println(string);
    }

    public static final class SGClient
    implements Client {
        private LoadOptions _loadOptions;
        private Connection _conn;
        private PreparedStatement[][] _psArray;
        private Random _randomNumberGenerator;
        private int _clientNumber = _clientCount++;
        private int _transactionCount = 0;
        private int _errorCount = 0;
        private HashMap<String, int[]> _errorLog = new HashMap();
        private static int _clientCount = 0;
        private static int _totalErrorCount = 0;
        private static int _totalTransactionCount = 0;

        public SGClient() {
            this._loadOptions = new LoadOptions();
            this._psArray = new PreparedStatement[this._loadOptions.getNumberOfGenerators()][this._loadOptions.getTablesPerGenerator() + 1];
            this._randomNumberGenerator = new Random();
            if (this._loadOptions.debugging()) {
                SequenceGeneratorConcurrency.debugPrint("Creating client " + this._clientNumber + " with " + this._loadOptions.toString());
            }
        }

        @Override
        public void init(Connection connection) throws SQLException {
            this._conn = connection;
            int n = this._loadOptions.getNumberOfGenerators();
            int n2 = this._loadOptions.getTablesPerGenerator();
            boolean bl = this._loadOptions.debugging();
            boolean bl2 = this._loadOptions.runIdentityTest();
            for (int i = 0; i < n; ++i) {
                String string = SequenceGeneratorConcurrency.makeSequenceName(i);
                for (int j = 0; j <= n2; ++j) {
                    String string2 = SequenceGeneratorConcurrency.makeTableName(i, j);
                    String string3 = "values ( next value for " + string + " )";
                    PreparedStatement preparedStatement = j == 0 ? (!bl2 ? SequenceGeneratorConcurrency.prepareStatement(this._conn, bl, string3) : SequenceGeneratorConcurrency.prepareStatement(this._conn, bl, "values (1)")) : (!bl2 ? SequenceGeneratorConcurrency.prepareStatement(this._conn, bl, "insert into " + string2 + "( a ) " + string3) : SequenceGeneratorConcurrency.prepareStatement(this._conn, bl, "insert into " + string2 + "( a ) values(1)"));
                    this._psArray[i][j] = preparedStatement;
                }
            }
            this._conn.setAutoCommit(false);
        }

        @Override
        public void doWork() throws SQLException {
            int n;
            int n2 = this.getPositiveRandomNumber() % this._loadOptions.getNumberOfGenerators();
            int n3 = this._loadOptions.getTablesPerGenerator();
            int n4 = n3 == 0 ? 0 : this.getPositiveRandomNumber() % n3 + 1;
            int n5 = this._loadOptions.getInsertsPerTransaction();
            boolean bl = this._loadOptions.debugging();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                for (n = 0; n < n5; ++n) {
                    resultSet = null;
                    preparedStatement = null;
                    preparedStatement = this._psArray[n2][n4];
                    if (n4 == 0) {
                        resultSet = preparedStatement.executeQuery();
                        resultSet.next();
                        resultSet = this.close(resultSet, bl);
                        continue;
                    }
                    preparedStatement.executeUpdate();
                }
            }
            catch (Throwable throwable) {
                SequenceGeneratorConcurrency.debugPrint("Error on client " + this._clientNumber + " on sequence " + n2 + " in transaction " + this._transactionCount + " on row " + n + ": " + throwable.getMessage());
                this.addError(throwable);
                resultSet = this.close(resultSet, bl);
                this._conn.rollback();
                return;
            }
            this._conn.commit();
            ++this._transactionCount;
        }

        private ResultSet close(ResultSet resultSet, boolean bl) {
            block3: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!bl) break block3;
                    SequenceGeneratorConcurrency.debugPrint("Oops! " + sQLException.getMessage());
                }
            }
            return null;
        }

        private PreparedStatement close(PreparedStatement preparedStatement, boolean bl) {
            block3: {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!bl) break block3;
                    SequenceGeneratorConcurrency.debugPrint("Oops! " + sQLException.getMessage());
                }
            }
            return null;
        }

        private int getPositiveRandomNumber() {
            int n = this._randomNumberGenerator.nextInt();
            if (n < 0) {
                return -n;
            }
            return n;
        }

        @Override
        public void printReport(PrintStream printStream) {
            for (String string : this._errorLog.keySet()) {
                int[] nArray = this._errorLog.get(string);
                String string2 = "    Client " + this._clientNumber + " saw " + nArray[0] + " instances of this error: " + string;
                printStream.println(string2);
            }
            _totalErrorCount += this._errorCount;
            _totalTransactionCount += this._transactionCount;
            if (this._clientNumber == _clientCount - 1) {
                printStream.println("\n");
                printStream.println(this._loadOptions.toString());
                printStream.println(_totalErrorCount + " errors, including warmup phase.");
                printStream.println(_totalTransactionCount + " successful transactions, including warmup phase.");
            }
        }

        private void addError(Throwable throwable) {
            ++this._errorCount;
            String string = throwable.getClass().getName() + ": " + throwable.getMessage();
            int[] nArray = this._errorLog.get(string);
            if (nArray != null) {
                nArray[0] = nArray[0] + 1;
            } else {
                this._errorLog.put(string, new int[]{1});
            }
        }
    }

    public static final class Filler
    implements DBFiller {
        private LoadOptions _loadOptions = new LoadOptions();

        @Override
        public void fill(Connection connection) throws SQLException {
            int n = this._loadOptions.getNumberOfGenerators();
            int n2 = this._loadOptions.getTablesPerGenerator();
            boolean bl = this._loadOptions.runIdentityTest();
            for (int i = 0; i < n; ++i) {
                if (!bl) {
                    this.runDDL(connection, "create sequence " + SequenceGeneratorConcurrency.makeSequenceName(i));
                }
                for (int j = 1; j <= n2; ++j) {
                    if (bl) {
                        this.runDDL(connection, "create table " + SequenceGeneratorConcurrency.makeTableName(i, j) + "( a int, b int generated always as identity)");
                        continue;
                    }
                    this.runDDL(connection, "create table " + SequenceGeneratorConcurrency.makeTableName(i, j) + "( a int )");
                }
            }
        }

        private void runDDL(Connection connection, String string) throws SQLException {
            PreparedStatement preparedStatement = SequenceGeneratorConcurrency.prepareStatement(connection, this._loadOptions.debugging(), string);
            preparedStatement.execute();
            preparedStatement.close();
        }
    }

    public static final class LoadOptions {
        private int _numberOfGenerators = Runner.getLoadOpt("numberOfGenerators", 1);
        private int _tablesPerGenerator = Runner.getLoadOpt("tablesPerGenerator", 1);
        private int _insertsPerTransaction = Runner.getLoadOpt("insertsPerTransaction", 1);
        private boolean _runIdentityTest = Runner.getLoadOpt("identityTest", 0) == 1;
        private boolean _debugging = Runner.getLoadOpt("debugging", 0) == 1;

        public int getNumberOfGenerators() {
            return this._numberOfGenerators;
        }

        public int getTablesPerGenerator() {
            return this._tablesPerGenerator;
        }

        public int getInsertsPerTransaction() {
            return this._insertsPerTransaction;
        }

        public boolean debugging() {
            return this._debugging;
        }

        public boolean runIdentityTest() {
            return this._runIdentityTest;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LoadOptions( ");
            stringBuffer.append(" generators = " + this._numberOfGenerators);
            stringBuffer.append(", tablesPerGenerator = " + this._tablesPerGenerator);
            stringBuffer.append(", insertsPerTransaction = " + this._insertsPerTransaction);
            stringBuffer.append(", identityTest = " + this._runIdentityTest);
            stringBuffer.append(", debugging = " + this._debugging);
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }
    }
}

